using System;
using System.Collections;
using System.Diagnostics;
using System.Drawing;
using System.IO;
using System.Windows.Forms;
using System.Xml;
using System.Threading;
using centrafuse;
using centrafuse.Plugins;
using System.Runtime.InteropServices;
using System.Collections.Generic;
using System.Text.RegularExpressions;


namespace MultiAppLoader
{
	/// <summary>
	///   
	/// </summary>
	public class MultiAppLoader : CFPlugin
	{
        #region  

        private DragForm minimize_button;
        private CFControls.CFPanel button_panel;
        private static MouseHookClass mouse_hook;
        private List<SmartPanel> panels;
        private SmartPanel fullscr_panel = null;
        private const int visible_panel_count = 2;
        private const int total_panel_count = 4;
        private DragForm block_button;

		private const string ConfigurationFile = "config.xml";
        private string ConfigurationFileDir = Path.GetDirectoryName(System.Reflection.Assembly.GetExecutingAssembly().Location) + @"\";
		private const string ConfigSection = "/APPCONFIG/";
        
        private string PluginName = "";
        private string PluginPath = "";
		private string PluginPathSkins = "";
		private string PluginPathLanguages = "";
		private string PluginPathIcons = "";
		private string LanguageSection = "";
        private string LogFile = "";

        //   
        public string LogFilePath = "";
		
        private const int ImageFolderIndex = 0;
		private const int ImageEmptyIndex = 1;

        //private System.Windows.Forms.Timer timer;
        //private int tmr_cnt = 0;
        #endregion

        #region 

		/// <summary>
		/// 
		/// </summary>
        public MultiAppLoader()
		{
            //  
            string dir = Path.GetDirectoryName(System.Reflection.Assembly.GetExecutingAssembly().Location);
            int pos = dir.LastIndexOf("\\");
            if (pos != 0)
                dir = dir.Substring(pos + 1);

            PluginName = dir;
            PluginPath = @"plugins\" + PluginName + @"\";
            PluginPathSkins = PluginPath + @"Skins\";
            PluginPathLanguages = PluginPath + @"Languages\";
            PluginPathIcons = PluginPath + @"Icons\";
            LanguageSection = @"/APPLANG/MULTIAPPLOADER/";
            LogFile = "Log.txt";


            /*//  
            timer = new System.Windows.Forms.Timer();
            timer.Interval = 10;
            timer.Tick += new EventHandler(OnTimer);
             * */

            //   
            LogFilePath = ConfigurationFileDir + "\\" + LogFile;

            /*
            //    ,    .
            this.CF_params.pauseAudio = false;

            //    (  )    skin.xml
            this.CF_params.pluginName = PluginName;

            //   ? !
            this.CF_params.isGUI = true;

            //       
            this.CF_params.hasSettings = true;
            this.CF_params.hasBasicSettings = true;

            //  XML   ,   
            AddConfigXml();
            */
        }

        #endregion

        #region  

        /// <summary>
		///  .  
        ///           .
		/// </summary>
		public override void CF_pluginInit()
		{
			try
			{
                this.CF3_initPlugin(PluginName, true);
                this.CF_localskinsetup();

                //  
                int top_offset = Int32.Parse(this.pluginConfig.ReadField("/APPCONFIG/TOP_OFFSET"));
                int bottom_offset = Int32.Parse(this.pluginConfig.ReadField("/APPCONFIG/BOTTOM_OFFSET"));
                this.Top = centrafuse.Plugins.SkinReader.CFDimensions.yPosition + top_offset;
                this.Height = centrafuse.Plugins.SkinReader.CFDimensions.height - bottom_offset - top_offset;
                this.Left = centrafuse.Plugins.SkinReader.CFDimensions.xPosition;
                this.Width = centrafuse.Plugins.SkinReader.CFDimensions.width;

                //  
				LoadSettings();

                //     
                mouse_hook = new MouseHookClass(OnClick);

                //    
                button_panel = new CFControls.CFPanel();
                button_panel.Parent = this;
                button_panel.BackColor = HexStringToColor(pluginConfig.ReadField("/APPCONFIG/BUTTON_PANEL_COLOR"));
                button_panel.Dock = DockStyle.Left;
                button_panel.Width = 92;
                button_panel.Visible = true;

                //  
                block_button = new DragForm(pluginConfig, CF_params, "button_lock_up.png", "button_lock_down.png");
                block_button.MouseUp += new MouseEventHandler(BlockButtonUp);
                block_button.lockable = true;
                block_button.Visible = false;

                //  
                minimize_button = new DragForm(pluginConfig, CF_params, "btn_up.png", "btn_down.png");
                minimize_button.MouseUp += new MouseEventHandler(OnFulscrUp);

                //   
                panels = new List<SmartPanel>();
                for (int i = 0; i < total_panel_count; i++)
                {
                    panels.Add(new SmartPanel());
                    panels[i].Parent = this;
                    panels[i].BackColor = Color.White;
                    panels[i].Top = 0;
                    panels[i].Left = 0;
                    panels[i].Width = 0;
                    panels[i].Height = 0;
                    panels[i].Visible = false;
                    string file_name = this.CF_params.pluginSkinPath + "\\button" + (i+1).ToString();
                    Image img1 = null, img2 = null, img3 = null;
                    if (File.Exists(file_name + ".png"))
                        img1 = Image.FromFile(file_name + ".png");
                    if (File.Exists(file_name + "_run.png"))
                        img2 = Image.FromFile(file_name + "_run.png");
                    if (File.Exists(file_name + "_idle.png"))
                        img3 = Image.FromFile(file_name + "_idle.png");
                    else
                        img3 = img1;
                    panels[i].SetButton(img1, img2, img3, button_panel);
                }
                SmartPanel.max_panel_count = visible_panel_count;
                SmartPanel.minimize_button = minimize_button;
                SmartPanel.dialog = CF_systemDisplayDialog;
                SmartPanel.block_button = block_button;
			}
			catch(Exception errmsg)
            {
                CFTools.writeError(errmsg.ToString());
            }
		}

        /// <summary>
        ///   
        /// </summary>
        private void OnFulscrUp(object sender, MouseEventArgs e)
        {
            if (!minimize_button.IsWasDrag())
            {
                if (fullscr_panel != null)
                {
                    MouseHookClass.SetHook();

                    minimize_button.Visible = false;
                    block_button.Show();
                    fullscr_panel.RestoreSize();
                    fullscr_panel = null;
                }
            }
        }

        /// <summary>
        ///  
        /// </summary>
        private void BlockButtonUp(object sender, MouseEventArgs e)
        {
            if (!block_button.IsWasDrag())
            {

            }
        }


		/// <summary>
		///  .
        ///    CF_pluginInit    .
		/// </summary>
		public override void CF_localskinsetup()
		{
            this.CF3_initSection(PluginName);
		}

		/// <summary>
		/// - ...
		/// </summary>
		public override void CF_pluginClose()
		{
            //  
            for (int i = 0; i < total_panel_count; i++)
                panels[i].Free();

            //  
			//this.Dispose();
            base.CF_pluginClose(); // calls form Dispose() method
		}

        /// <summary>
		/// ,     
		/// </summary>
		public override void CF_pluginShow()
		{
            //  
            int top_offset = Int32.Parse(this.pluginConfig.ReadField("/APPCONFIG/TOP_OFFSET"));
            int bottom_offset = Int32.Parse(this.pluginConfig.ReadField("/APPCONFIG/BOTTOM_OFFSET"));
            this.Top = centrafuse.Plugins.SkinReader.CFDimensions.yPosition + top_offset;
            this.Height = centrafuse.Plugins.SkinReader.CFDimensions.height - bottom_offset - top_offset;
            this.Left = centrafuse.Plugins.SkinReader.CFDimensions.xPosition;
            this.Width = centrafuse.Plugins.SkinReader.CFDimensions.width;
            base.Invalidate(true);

            //   
            int top = centrafuse.Plugins.SkinReader.CFDimensions.yPosition + Int32.Parse(pluginConfig.ReadField("/APPCONFIG/BTN_TOP0"));
            int left = centrafuse.Plugins.SkinReader.CFDimensions.xPosition + Int32.Parse(pluginConfig.ReadField("/APPCONFIG/BTN_LEFT0"));
            block_button.ShowButton(-1, top, left);

            for (int i = 0; i < total_panel_count; i++)
            {
                int wait = 0;
                try
                {
                    wait = Convert.ToInt32(this.pluginConfig.ReadField("/APPCONFIG/WAIT" + (i + 1).ToString()));
                }
                catch
                {
                    wait = 0;
                }
                panels[i].SetExecutablePath(
                        this.pluginConfig.ReadField("/APPCONFIG/EXE" + (i + 1).ToString()),
                        this.pluginConfig.ReadField("/APPCONFIG/CMD" + (i + 1).ToString()),
                        wait
                        );
            }

            this.Refresh();
            this.Visible = true;

            //      
            MouseHookClass.SetHook();

            base.CF_pluginShow(); // sets form Visible property
        }

        /// <summary>
        ///  
        /// </summary>
        public override void CF_pluginHide()
        {
            //      
            MouseHookClass.UnsetHook();

            //   "  "
            minimize_button.Hide();
            block_button.Hide();

            base.CF_pluginHide();
        }

        /// <summary>
        ///  
        /// </summary>
        /// <param name="coord_obj"></param>
        /// <param name="unused"></param>
        public bool OnClick(int[] coord_obj, bool check)
        {
            int[] coord = (int[])coord_obj;

            //     
            if (coord[0] >= block_button.Left &&
                coord[0] <= block_button.Right &&
                coord[1] >= block_button.Top &&
                coord[1] <= block_button.Bottom)
                return false;

            if (!block_button.is_pressed)
                for (int i = 0; i < panels.Count; i++)
                    if (panels[i].Visible && panels[i].IsMouseInMe(coord[0], coord[1]))
                    {
                        if (!check)
                        {

                            //    
                            MouseHookClass.UnsetHook();

                            panels[i].FullScreen();
                            fullscr_panel = panels[i];

                            //   "  "
                            int top = centrafuse.Plugins.SkinReader.CFDimensions.yPosition + Int32.Parse(pluginConfig.ReadField("/APPCONFIG/BTN_TOP" + (i + 1).ToString()));
                            int left = centrafuse.Plugins.SkinReader.CFDimensions.xPosition + Int32.Parse(pluginConfig.ReadField("/APPCONFIG/BTN_LEFT" + (i + 1).ToString()));
                            minimize_button.ShowButton(i, top, left);
                            block_button.Hide();
                        }

                        return true;
                    }

            return false;
        }

		/// <summary>
		///     
		/// </summary>
		/// <returns> .</returns>
		public override DialogResult CF_pluginShowSetup()
		{
            #if DEBUG
            WriteLog("CF_pluginShowSetup");
            #endif
			
            DialogResult returnvalue = DialogResult.Cancel;

			try
			{
				//    .   CFDialog  CFSetup
				//    - MainForm     - MainForm  .
                Setup setup = new Setup(this.MainForm, this.pluginConfig, this.pluginLang);
				setup.MainForm = this.MainForm;
				returnvalue = setup.ShowDialog();
				if (returnvalue == DialogResult.OK)
				{
					//  
					LoadSettings();
				}
				setup.Close();
				setup = null;
			}
			catch(Exception errmsg)
            {
                CFTools.writeError(errmsg.ToString());
            }

			return returnvalue;
		}

        #endregion

        #region  

        /// <summary>
        ///  
        /// </summary>
        /// <param name="msg"></param>
        private void WriteLog(string msg)
        {
            try
            {
                if (Boolean.Parse(this.pluginConfig.ReadField("/APPCONFIG/LOGEVENTS")))
                    CFTools.writeModuleLog(msg, LogFilePath);
            }
            catch
            {
            }
        }
        
        /// <summary>
		///   
		/// </summary>
		public void LoadSettings()
		{
            CF_params.displayName = TranslateText("DISPLAYNAME");
		}

		/// <summary>
		///     
		/// </summary>
		/// <param name="text"></param>
		/// <returns>      </returns>
		private string TranslateText(string text)
		{
			string langread = this.pluginLang.ReadField(LanguageSection + text);

			if(langread == "")
				return text;
			else
				return langread.Replace("\\n", "\n");
		}

		/// <summary>
		///   
		/// </summary>
		private void ScalePlugin( )
		{
            #if DEBUG
            WriteLog("ScalePlugin");
            #endif
		}

        /// <summary>
        /// Convert a hex string to a .NET Color object.
        /// </summary>
        /// <param name="hexColor">a hex string: "FFFFFF", "#000000"</param>
        public static Color HexStringToColor(string hexColor)
        {
            string hc = ExtractHexDigits(hexColor);
            if (hc.Length != 6)
            {
                // you can choose whether to throw an exception
                //throw new ArgumentException("hexColor is not exactly 6 digits.");
                return Color.Empty;
            }
            string r = hc.Substring(0, 2);
            string g = hc.Substring(2, 2);
            string b = hc.Substring(4, 2);
            Color color = Color.Empty;
            try
            {
                int ri = Int32.Parse(r, System.Globalization.NumberStyles.HexNumber);
                int gi = Int32.Parse(g, System.Globalization.NumberStyles.HexNumber);
                int bi = Int32.Parse(b, System.Globalization.NumberStyles.HexNumber);
                color = Color.FromArgb(ri, gi, bi);
            }
            catch
            {
                // you can choose whether to throw an exception
                //throw new ArgumentException("Conversion failed.");
                return Color.Empty;
            }
            return color;
        }

        /// <summary>
        /// Extract only the hex digits from a string.
        /// </summary>
        public static string ExtractHexDigits(string input)
        {
            // remove any characters that are not digits (like #)
            Regex isHexDigit = new Regex("[abcdefABCDEF\\d]+", RegexOptions.Compiled);
            string newnum = "";
            foreach (char c in input)
            {
                if (isHexDigit.IsMatch(c.ToString()))
                    newnum += c.ToString();
            }
            return newnum;
        }

        #endregion
    }
}
