using System;
using System.Windows.Forms;
using System.Xml;
using System.Web;
using centrafuse.Plugins;
using System.IO;

namespace MultiAppLoader
{
    public class Setup : CFSetup
    {
        private XmlDocument configxml = new XmlDocument();
        private XmlDocument languagexml = new XmlDocument();

        private const string ConfigurationFile = "config.xml";
        private string ConfigurationFileDir = Path.GetDirectoryName(System.Reflection.Assembly.GetExecutingAssembly().Location) + @"\";
        private const string ConfigSection = "/APPCONFIG/";

        private string PluginName = "";
        private string PluginPath = "";
        private string PluginPathSkins = "";
        private string PluginPathLanguages = "";
        private string PluginPathIcons = "";
        private string LanguageSection = "";
        private string LogFile = "";

        //   
        public string LogFilePath = "";

        #region  

        /// <summary>
        ///    XML
        /// </summary>
        private void SetStringParam(string param, ref object value)
        {
            try
            {
                object tempobject;
                string resultvalue, resulttext;
                if (this.CF_systemDisplayDialog(CF_Dialogs.OSK, this.pluginConfig.ReadField("/APPCONFIG/" + param), ButtonValue[(int)value], null, out resultvalue, out resulttext, out tempobject, null, true, true, true, true, false, false, 1) == DialogResult.OK)
                {
                    this.pluginConfig.WriteField("/APPCONFIG/" + param, HttpUtility.HtmlEncode(resultvalue));
                    ButtonValue[(int)value] = resultvalue;
                }
            }
            catch (Exception errmsg) { CFTools.writeError(errmsg.Message, errmsg.StackTrace); }
        }

        /// <summary>
        ///  
        /// </summary>
        private void SetFileParam(string param, ref object value)
        {
            try
            {
                object tempobject;
                string resultvalue, resulttext;
                if (this.CF_systemDisplayDialog(CF_Dialogs.FileBrowser, this.pluginConfig.ReadField("/APPCONFIG/" + param), ButtonValue[(int)value], null, out resultvalue, out resulttext, out tempobject, null, true, true, true, true, false, false, 1) == DialogResult.OK)
                {
                    this.pluginConfig.WriteField("/APPCONFIG/" + param, HttpUtility.HtmlEncode(resultvalue));
                    ButtonValue[(int)value] = resultvalue;
                }
            }
            catch (Exception errmsg) { CFTools.writeError(errmsg.Message, errmsg.StackTrace); }
        }

        /// <summary>
        ///    XML
        /// </summary>
        private void SetIntegerParam(string param, ref object value)
        {
            try
            {
                object tempobject;
                string resultvalue, resulttext;
                if (this.CF_systemDisplayDialog(CF_Dialogs.NumberPad, this.pluginConfig.ReadField("/APPCONFIG/" + param), ButtonValue[(int)value], null, out resultvalue, out resulttext, out tempobject, null, true, true, true, true, false, false, 1) == DialogResult.OK)
                {
                    this.pluginConfig.WriteField("/APPCONFIG/" + param, HttpUtility.HtmlEncode(resultvalue));
                    ButtonValue[(int)value] = resultvalue;
                }
            }
            catch (Exception errmsg) { CFTools.writeError(errmsg.Message, errmsg.StackTrace); }
        }
        #endregion

        // The setup constructor will be called each time this plugin's setup is opened from the CF Setting Page
        // This setup is opened as a dialog from the CF_pluginShowSetup() call into the main plugin application form.
        public Setup(ICFMain mForm, ConfigReader config, LanguageReader lang)
        {
            // MainForm must be set before calling any Centrafuse API functions
            this.MainForm = mForm;

            this.pluginConfig = config;
            this.pluginLang = lang;

            CF_initSetup(5, 0);

            //  
            string dir = Path.GetDirectoryName(System.Reflection.Assembly.GetExecutingAssembly().Location);
            int pos = dir.LastIndexOf("\\");
            if (pos != 0)
                dir = dir.Substring(pos + 1);

            PluginName = dir;
            PluginPath = @"plugins\" + PluginName + @"\";
            PluginPathSkins = PluginPath + @"Skins\";
            PluginPathLanguages = PluginPath + @"Languages\";
            PluginPathIcons = PluginPath + @"Icons\";
            LanguageSection = @"/APPLANG/" + PluginName.ToUpper() + @"/";
            LogFile = "Log.txt";

            //   
            LogFilePath = ConfigurationFileDir + "\\" + LogFile;

            CF_updateText("TITLE", this.pluginLang.ReadField("/APPLANG/SETUP/TITLE"));
        }

        public override void CF_setupReadSettings(int currentpage, bool advanced)
        {
            try
            {
                int i = SetupButton.One;

                if (currentpage == 1)
                {
                    //  
                    ButtonHandler[i] = new CFSetupHandler(SetDisplayName);
                    ButtonText[i] = this.pluginLang.ReadField("APPLANG/SETUP/DISPLAYNAME");
                    ButtonValue[i++] = this.pluginLang.ReadField("APPLANG/MULTIAPPLOADER/DISPLAYNAME");

                    ButtonHandler[i] = new CFSetupHandler(SetTopOffset);
                    ButtonText[i] = this.pluginLang.ReadField("APPLANG/SETUP/TOP_OFFSET");
                    ButtonValue[i++] = this.pluginConfig.ReadField("APPCONFIG/TOP_OFFSET");

                    ButtonHandler[i] = new CFSetupHandler(SetBottomOffset);
                    ButtonText[i] = this.pluginLang.ReadField("APPLANG/SETUP/BOTTOM_OFFSET");
                    ButtonValue[i++] = this.pluginConfig.ReadField("APPCONFIG/BOTTOM_OFFSET");

                    // BOOL BUTTONS (4-8)
                    ButtonHandler[i] = null; ButtonText[i] = ""; ButtonValue[i++] = "";
                    ButtonHandler[i] = null; ButtonText[i] = ""; ButtonValue[i++] = "";
                    ButtonHandler[i] = null; ButtonText[i] = ""; ButtonValue[i++] = "";
                    ButtonHandler[i] = null; ButtonText[i] = ""; ButtonValue[i++] = "";
                    ButtonHandler[i] = null; ButtonText[i] = ""; ButtonValue[i++] = "";
                }

                //-----------------  2 ----------------------
                if (currentpage == 2)
                {
                    ButtonHandler[i] = new CFSetupHandler(SetExe1);
                    ButtonText[i] = this.pluginLang.ReadField("APPLANG/SETUP/EXE") + " #1";
                    ButtonValue[i++] = this.pluginConfig.ReadField("APPCONFIG/EXE1");

                    ButtonHandler[i] = new CFSetupHandler(SetCmd1);
                    ButtonText[i] = this.pluginLang.ReadField("APPLANG/SETUP/CMD") + " #1";
                    ButtonValue[i++] = this.pluginConfig.ReadField("APPCONFIG/CMD1");

                    ButtonHandler[i] = new CFSetupHandler(SetBtnTop1);
                    ButtonText[i] = this.pluginLang.ReadField("APPLANG/SETUP/TOP_BTN_OFFSET") + " #1";
                    ButtonValue[i++] = this.pluginConfig.ReadField("APPCONFIG/BTN_TOP1");

                    ButtonHandler[i] = new CFSetupHandler(SetBtnLeft1);
                    ButtonText[i] = this.pluginLang.ReadField("APPLANG/SETUP/LEFT_BTN_OFFSET") + " #1";
                    ButtonValue[i++] = this.pluginConfig.ReadField("APPCONFIG/BTN_LEFT1");

                    // BOOL BUTTONS (5-8)
                    ButtonHandler[i] = null; ButtonText[i] = ""; ButtonValue[i++] = "";
                    ButtonHandler[i] = null; ButtonText[i] = ""; ButtonValue[i++] = "";
                    ButtonHandler[i] = null; ButtonText[i] = ""; ButtonValue[i++] = "";
                    ButtonHandler[i] = null; ButtonText[i] = ""; ButtonValue[i++] = "";
                }

                //-----------------  3 ----------------------

                if (currentpage == 3)
                {
                    ButtonHandler[i] = new CFSetupHandler(SetExe2);
                    ButtonText[i] = this.pluginLang.ReadField("APPLANG/SETUP/EXE") + " #2";
                    ButtonValue[i++] = this.pluginConfig.ReadField("APPCONFIG/EXE2");

                    ButtonHandler[i] = new CFSetupHandler(SetCmd2);
                    ButtonText[i] = this.pluginLang.ReadField("APPLANG/SETUP/CMD") + " #2";
                    ButtonValue[i++] = this.pluginConfig.ReadField("APPCONFIG/CMD2");

                    ButtonHandler[i] = new CFSetupHandler(SetBtnTop2);
                    ButtonText[i] = this.pluginLang.ReadField("APPLANG/SETUP/TOP_BTN_OFFSET") + " #2";
                    ButtonValue[i++] = this.pluginConfig.ReadField("APPCONFIG/BTN_TOP2");

                    ButtonHandler[i] = new CFSetupHandler(SetBtnLeft2);
                    ButtonText[i] = this.pluginLang.ReadField("APPLANG/SETUP/LEFT_BTN_OFFSET") + " #2";
                    ButtonValue[i++] = this.pluginConfig.ReadField("APPCONFIG/BTN_LEFT2");

                    // BOOL BUTTONS (5-8)
                    ButtonHandler[i] = null; ButtonText[i] = ""; ButtonValue[i++] = "";
                    ButtonHandler[i] = null; ButtonText[i] = ""; ButtonValue[i++] = "";
                    ButtonHandler[i] = null; ButtonText[i] = ""; ButtonValue[i++] = "";
                    ButtonHandler[i] = null; ButtonText[i] = ""; ButtonValue[i++] = "";
                }

                //-----------------  4 ----------------------

                if (currentpage == 4)
                {
                    ButtonHandler[i] = new CFSetupHandler(SetExe3);
                    ButtonText[i] = this.pluginLang.ReadField("APPLANG/SETUP/EXE") + " #3";
                    ButtonValue[i++] = this.pluginConfig.ReadField("APPCONFIG/EXE3");

                    ButtonHandler[i] = new CFSetupHandler(SetCmd3);
                    ButtonText[i] = this.pluginLang.ReadField("APPLANG/SETUP/CMD") + " #3";
                    ButtonValue[i++] = this.pluginConfig.ReadField("APPCONFIG/CMD3");

                    ButtonHandler[i] = new CFSetupHandler(SetBtnTop3);
                    ButtonText[i] = this.pluginLang.ReadField("APPLANG/SETUP/TOP_BTN_OFFSET") + " #3";
                    ButtonValue[i++] = this.pluginConfig.ReadField("APPCONFIG/BTN_TOP3");

                    ButtonHandler[i] = new CFSetupHandler(SetBtnLeft3);
                    ButtonText[i] = this.pluginLang.ReadField("APPLANG/SETUP/LEFT_BTN_OFFSET") + " #3";
                    ButtonValue[i++] = this.pluginConfig.ReadField("APPCONFIG/BTN_LEFT3");

                    // BOOL BUTTONS (5-8)
                    ButtonHandler[i] = null; ButtonText[i] = ""; ButtonValue[i++] = "";
                    ButtonHandler[i] = null; ButtonText[i] = ""; ButtonValue[i++] = "";
                    ButtonHandler[i] = null; ButtonText[i] = ""; ButtonValue[i++] = "";
                    ButtonHandler[i] = null; ButtonText[i] = ""; ButtonValue[i++] = "";
                }

                //-----------------  5 ----------------------

                if (currentpage == 5)
                {
                    ButtonHandler[i] = new CFSetupHandler(SetExe4);
                    ButtonText[i] = this.pluginLang.ReadField("APPLANG/SETUP/EXE") + " #4";
                    ButtonValue[i++] = this.pluginConfig.ReadField("APPCONFIG/EXE4");

                    ButtonHandler[i] = new CFSetupHandler(SetCmd4);
                    ButtonText[i] = this.pluginLang.ReadField("APPLANG/SETUP/CMD") + " #4";
                    ButtonValue[i++] = this.pluginConfig.ReadField("APPCONFIG/CMD4");

                    ButtonHandler[i] = new CFSetupHandler(SetBtnTop4);
                    ButtonText[i] = this.pluginLang.ReadField("APPLANG/SETUP/TOP_BTN_OFFSET") + " #4";
                    ButtonValue[i++] = this.pluginConfig.ReadField("APPCONFIG/BTN_TOP4");

                    ButtonHandler[i] = new CFSetupHandler(SetBtnLeft4);
                    ButtonText[i] = this.pluginLang.ReadField("APPLANG/SETUP/LEFT_BTN_OFFSET") + " #4";
                    ButtonValue[i++] = this.pluginConfig.ReadField("APPCONFIG/BTN_LEFT4");

                    // BOOL BUTTONS (5-8)
                    ButtonHandler[i] = null; ButtonText[i] = ""; ButtonValue[i++] = "";
                    ButtonHandler[i] = null; ButtonText[i] = ""; ButtonValue[i++] = "";
                    ButtonHandler[i] = null; ButtonText[i] = ""; ButtonValue[i++] = "";
                    ButtonHandler[i] = null; ButtonText[i] = ""; ButtonValue[i++] = "";
                }
            }
            catch (Exception errmsg)
            {
                CFTools.writeError(errmsg.Message, errmsg.StackTrace);
            }
        }

        /// <summary>
        ///   
        /// </summary>
        private void SetDisplayName(ref object value)
        {
            try
            {
                object tempobject;
                string resultvalue, resulttext;
                if (this.CF_systemDisplayDialog(CF_Dialogs.OSK, this.pluginLang.ReadField("/APPLANG/MULTIAPPLOADER/DISPLAYNAME"), ButtonValue[(int)value], null, out resultvalue, out resulttext, out tempobject, null, true, true, true, true, false, false, 1) == DialogResult.OK)
                {
                    this.pluginLang.WriteField("/APPLANG/MULTIAPPLOADER/DISPLAYNAME", resultvalue);
                    ButtonValue[(int)value] = resultvalue;
                }
            }
            catch (Exception errmsg) { CFTools.writeError(errmsg.Message, errmsg.StackTrace); }
        }

        /// <summary>
        ///   
        /// </summary>
        private void SetTopOffset(ref object value) { SetIntegerParam("TOP_OFFSET", ref value); }

        /// <summary>
        ///   
        /// </summary>
        private void SetBottomOffset(ref object value) { SetIntegerParam("BOTTOM_OFFSET", ref value); }

        /// <summary>
        ///       
        /// </summary>
        private void SetExe1(ref object value) { SetFileParam("EXE1", ref value); }
        private void SetCmd1(ref object value) { SetStringParam("CMD1", ref value); }
        private void SetBtnTop1(ref object value) { SetIntegerParam("BTN_TOP1", ref value); }
        private void SetBtnLeft1(ref object value) { SetIntegerParam("BTN_LEFT1", ref value); }

        /// <summary>
        ///       
        /// </summary>
        private void SetExe2(ref object value) { SetFileParam("EXE2", ref value); }
        private void SetCmd2(ref object value) { SetStringParam("CMD2", ref value); }
        private void SetBtnTop2(ref object value) { SetIntegerParam("BTN_TOP2", ref value); }
        private void SetBtnLeft2(ref object value) { SetIntegerParam("BTN_LEFT2", ref value); }

        /// <summary>
        ///       
        /// </summary>
        private void SetExe3(ref object value) { SetFileParam("EXE3", ref value); }
        private void SetCmd3(ref object value) { SetStringParam("CMD3", ref value); }
        private void SetBtnTop3(ref object value) { SetIntegerParam("BTN_TOP3", ref value); }
        private void SetBtnLeft3(ref object value) { SetIntegerParam("BTN_LEFT3", ref value); }

        /// <summary>
        ///       
        /// </summary>
        private void SetExe4(ref object value) { SetFileParam("EXE4", ref value); }
        private void SetCmd4(ref object value) { SetStringParam("CMD4", ref value); }
        private void SetBtnTop4(ref object value) { SetIntegerParam("BTN_TOP4", ref value); }
        private void SetBtnLeft4(ref object value) { SetIntegerParam("BTN_LEFT4", ref value); }
    }
}
