using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;
using System.Drawing;
using centrafuse.Plugins;
using System.IO;

namespace MultiAppLoader
{
    /// <summary>
    ///  
    /// </summary>
    public class DragForm : Form
    {
        private MouseEventHandler moveDelegate;
        private int oldX;
        private int oldY;
        private int startX;
        private int startY;
        private bool wasMove = false;
        private Image img_up;
        private Image img_down;
        private ConfigReader plugin_config;
        public int button_num = 0;
        public bool lockable = false;
        private bool pressed = false;

        /// <summary>
        /// 
        /// </summary>
        public DragForm(ConfigReader pluginConfig, centrafuse.Plugins.CFPlugin.CFParams CF_params, string img_up_path, string img_down_path)
        {
            //  
            TopMost = true;
            ShowIcon = false;
            ShowInTaskbar = false;
            FormBorderStyle = FormBorderStyle.None;
            StartPosition = FormStartPosition.Manual;
            plugin_config = pluginConfig;

            double opacity = 0.8;
            try
            {
                opacity = Double.Parse(pluginConfig.ReadField("/APPCONFIG/BTN_OPACITY")) / 100;
            }
            catch
            {
            }
            Opacity = opacity < 0 || opacity > 1 ? 0.8 : opacity;
            /*
            if (File.Exists(CF_params.pluginSkinPath + "\\btn_up.png"))
                img_up = Image.FromFile(CF_params.pluginSkinPath + "\\btn_up.png");
            if (File.Exists(CF_params.pluginSkinPath + "\\btn_down.png"))
                img_down = Image.FromFile(CF_params.pluginSkinPath + "\\btn_down.png");
            */
            if (File.Exists(CF_params.pluginSkinPath + "\\" + img_up_path))
                img_up = Image.FromFile(CF_params.pluginSkinPath + "\\" + img_up_path);
            if (File.Exists(CF_params.pluginSkinPath + "\\" + img_down_path))
                img_down = Image.FromFile(CF_params.pluginSkinPath + "\\" + img_down_path);
            BackgroundImage = img_up;
            Width = img_up.Width;
            Height = img_up.Height;
            BackColor = Color.FromArgb(100, 100, 100);
            TransparencyKey = Color.FromArgb(100, 100, 100);

            FormClosing += OnCloseButton;
            MouseDown += new System.Windows.Forms.MouseEventHandler(this.DragForm_MouseDown);
            MouseUp += new System.Windows.Forms.MouseEventHandler(this.DragForm_MouseUp);
            moveDelegate += new MouseEventHandler(this.DragForm_MouseMove);
        }

        /// <summary>
        ///  
        /// </summary>
        private void DragForm_MouseDown(object sender, System.Windows.Forms.MouseEventArgs e)
        {
            if (!lockable)
                BackgroundImage = img_down;
            this.MouseMove += moveDelegate;
            oldX = Cursor.Position.X;
            oldY = Cursor.Position.Y;
            startX = Cursor.Position.X;
            startY = Cursor.Position.Y;
        }

        /// <summary>
        ///   
        /// </summary>
        private void OnCloseButton(object sender, FormClosingEventArgs e)
        {
            e.Cancel = true;
        }

        /// <summary>
        ///  
        /// </summary>
        private void DragForm_MouseMove(object sender, System.Windows.Forms.MouseEventArgs e)
        {
            this.MouseMove -= moveDelegate;
            if ((Cursor.Position.X - oldX) != 0 || (Cursor.Position.Y - oldY) != 0)
                wasMove = true;
            this.Location = new Point(this.Location.X + Cursor.Position.X - oldX, this.Location.Y + Cursor.Position.Y - oldY);
            oldX = Cursor.Position.X;
            oldY = Cursor.Position.Y;
            this.MouseMove += moveDelegate;
        }

        /// <summary>
        ///  
        /// </summary>
        private void DragForm_MouseUp(object sender, System.Windows.Forms.MouseEventArgs e)
        {
            if (Math.Abs(Cursor.Position.X - startX) > 10 || Math.Abs(Cursor.Position.Y - startY) > 10)
            {
                if (wasMove)
                {
                    plugin_config.WriteField("/APPCONFIG/BTN_TOP" + (button_num + 1).ToString(), Top.ToString());
                    plugin_config.WriteField("/APPCONFIG/BTN_LEFT" + (button_num + 1).ToString(), Left.ToString());
                    plugin_config.Save();
                }
            }
            else
            {
                Top = centrafuse.Plugins.SkinReader.CFDimensions.yPosition + Int32.Parse(plugin_config.ReadField("/APPCONFIG/BTN_TOP" + (button_num + 1).ToString()));
                Left = centrafuse.Plugins.SkinReader.CFDimensions.xPosition + Int32.Parse(plugin_config.ReadField("/APPCONFIG/BTN_LEFT" + (button_num + 1).ToString()));
                wasMove = false;
            }

            if (lockable)
            {
                if (!wasMove)
                {
                    if (pressed)
                        BackgroundImage = img_up;
                    else
                        BackgroundImage = img_down;
                    pressed = !pressed;
                }
                else
                {
                    if (pressed)
                        BackgroundImage = img_down;
                    else
                        BackgroundImage = img_up;
                }
            }
            else
            {
                BackgroundImage = img_up;
            }
            this.MouseMove -= moveDelegate;
        }

        /// <summary>
        ///    ?
        /// </summary>
        /// <returns></returns>
        public bool IsWasDrag()
        {
            bool wasDrag2 = wasMove;
            wasMove = false;

            return wasDrag2;
        }

        /// <summary>
        ///  
        /// </summary>
        /// <param name="but_num"> </param>
        /// <param name="top"></param>
        /// <param name="left"></param>
        public void ShowButton(int but_num, int top, int left)
        {
            button_num = but_num;
            Top = top;
            Left = left;
            Show();
            Width = BackgroundImage.Width;
            Height = BackgroundImage.Height;
        }

        public bool is_pressed
        {
            get
            {
                return pressed;
            }
        }
    }
}
