using System;
using System.Runtime.InteropServices;
using System.Diagnostics;

namespace MultiAppLoader
{
    public delegate bool HookEventHandler(int[] coord, bool check);

    /// <summary>
    ///    
    /// </summary>
    class MouseHookClass
    {
        #region 

        private const int WH_KEYBOARD_LL = 13;
        private const int WH_MOUSE_LL = 14;
        private const int WM_KEYDOWN = 0x0100;
        private const int WM_MOUSEDOWN = 0x0201;
        private const int WM_LBUTTONUP = 0x0202;
        private static LowLevelKeyboardProc _proc = HookCallback;
        private static IntPtr _hookID = IntPtr.Zero;

        [StructLayout(LayoutKind.Sequential)]
        public struct CWPSTRUCT
        {
            public IntPtr lparam;
            public IntPtr wparam;
            public int message;
            public IntPtr hwnd;
        }
        
        private delegate IntPtr LowLevelKeyboardProc(int nCode, IntPtr wParam, IntPtr lParam);

        [DllImport("user32.dll", CharSet = CharSet.Auto, SetLastError = true)]
        private static extern IntPtr SetWindowsHookEx(int idHook, LowLevelKeyboardProc lpfn, IntPtr hMod, uint dwThreadId);

        [DllImport("user32.dll", CharSet = CharSet.Auto, SetLastError = true)]
        private static extern bool UnhookWindowsHookEx(IntPtr hhk);

        [DllImport("user32.dll", CharSet = CharSet.Auto, SetLastError = true)]
        private static extern IntPtr CallNextHookEx(IntPtr hhk, int nCode, IntPtr wParam, IntPtr lParam);

        [DllImport("kernel32.dll", CharSet = CharSet.Auto, SetLastError = true)]
        private static extern IntPtr GetModuleHandle(string lpModuleName);

        private static HookEventHandler callback = null;
        
        #endregion

        #region  

        /// <summary>
        /// 
        /// </summary>
        /// <param name="callback_"></param>
        public MouseHookClass(HookEventHandler callback_)
        {
            callback = callback_;
        }

        /// <summary>
        ///  
        /// </summary>
        /// <returns></returns>
        public static IntPtr SetHook()
        {
            if (_hookID == IntPtr.Zero)
            {
                using (Process curProcess = Process.GetCurrentProcess())
                    using (ProcessModule curModule = curProcess.MainModule)
                        _hookID = SetWindowsHookEx(WH_MOUSE_LL, _proc, GetModuleHandle(curModule.ModuleName), 0);
            }
            return _hookID;
        }

        /// <summary>
        ///  
        /// </summary>
        public static void UnsetHook()
        {
            if (_hookID != IntPtr.Zero)
            {
                UnhookWindowsHookEx(_hookID);
                _hookID = IntPtr.Zero;
            }
        }

        #endregion

        #region  

        private static IntPtr HookCallback(int nCode, IntPtr wParam, IntPtr lParam)
        {
            //  
            if ((nCode >= 0) && (wParam == (IntPtr)WM_MOUSEDOWN))
            {
                CWPSTRUCT cwp = (CWPSTRUCT)Marshal.PtrToStructure(lParam, typeof(CWPSTRUCT));
                if (callback != null)
                {
                    int[] coord = new int[] { cwp.lparam.ToInt32(), cwp.wparam.ToInt32() };
                    if (callback(coord, true))
                        return new IntPtr(-1);
                }
            }

            //  
            if ((nCode >= 0) && (wParam == (IntPtr)WM_LBUTTONUP))
            {
                CWPSTRUCT cwp = (CWPSTRUCT)Marshal.PtrToStructure(lParam, typeof(CWPSTRUCT));
                if (callback != null)
                {
                    int[] coord = new int[] {cwp.lparam.ToInt32(), cwp.wparam.ToInt32()};
                    callback(coord, false);
                }
            }

            return CallNextHookEx(_hookID, nCode, wParam, lParam);
        }

        #endregion
    }
}