using System;
using System.Collections.Generic;
using System.Text;
using centrafuse.Plugins;
using System.Diagnostics;
using System.IO;
using System.Threading;
using System.Windows.Forms;
using System.Drawing;

namespace MultiAppLoader
{
    public class SmartPanel : CFControls.CFPanel
    {
        public delegate DialogResult DialogForm(CF_Dialogs dialog, string text);

        private Process process = null;
        private string process_exe = "";
        private string process_cmd = "";
        private string new_exe = "";
        private string new_cmd = "";
        private int wait = 0;
        private IntPtr process_wnd_handle = IntPtr.Zero;
        private bool[] visible_panels = null;
        private int parent_top;
        private int parent_left;
        private int parent_height;
        private int this_width;
        private int this_height;
        private int this_left;
        private PictureBox button = null;
        private Image btn_regular_image = null;
        private Image btn_idle_image = null;
        private Image btn_selected_image = null;
        private System.Windows.Forms.Timer close_timer;
        private System.Windows.Forms.Timer process_timer;
        public static DialogForm dialog = null;
        public static int max_panel_count = 0;
        public static Form minimize_button = null;
        public static DragForm block_button = null;

        #region /

        /// <summary>
        /// 
        /// </summary>
        public SmartPanel()
        {
            close_timer = new System.Windows.Forms.Timer();
            close_timer.Interval = 2000;
            close_timer.Tick += new EventHandler(OnCloseTimer);

            process_timer = new System.Windows.Forms.Timer();
            process_timer.Interval = 1000;
            process_timer.Tick += new EventHandler(OnProcTimer);
        }

        /// <summary>
        ///  
        /// </summary>
        public void Free()
        {
            close_timer.Stop();
            process_timer.Stop();

            //    
            if (IsProcessRunning())
            {
                if (process.CloseMainWindow())
                    process.WaitForExit(2000);
                if (!process.HasExited)
                    process.Kill();
            }
        }

        #endregion

        #region  

        /// <summary>
        ///    
        /// </summary>
        private void OnCloseTimer(object sender, EventArgs e)
        {
            close_timer.Stop();

            if (IsProcessRunning())
            {
                MouseHookClass.UnsetHook();
                if (dialog(CF_Dialogs.YesNo, " " + Path.GetFileName(process_exe) + "?") == DialogResult.OK)
                {
                    if (process.CloseMainWindow())
                        process.WaitForExit(2000);
                    if (!process.HasExited)
                        process.Kill();
                    process = null;

                    if (this.Visible)
                        ButtonClick(null, null);
                    else
                        button.Image = btn_regular_image;
                }
                MouseHookClass.SetHook();
            }
        }

        /// <summary>
        ///  
        /// </summary>
        /// <param name="regular_image"> </param>
        /// <param name="selected_image">    </param>
        /// <param name="btn_panel">   </param>
        public void SetButton(Image regular_image, Image selected_image, Image idle_image, CFControls.CFPanel btn_panel)
        {
            btn_regular_image = regular_image;
            btn_selected_image = selected_image;
            btn_idle_image = idle_image;
            button = new PictureBox();
            button.Parent = btn_panel;
            button.Image = regular_image;
            button.Visible = true;
            button.Top = (btn_panel.Controls.Count - 1) * 68 + (btn_panel.Controls.Count) * 6;
            button.Left = 6;
            button.Width = 80;
            button.Height = 68;
            button.Click += new EventHandler(ButtonClick);
            button.MouseDown += new MouseEventHandler(ButtonDown);
            button.MouseUp += new MouseEventHandler(ButtonUp);
        }

        /// <summary>
        ///   
        /// </summary>
        private void ButtonUp(object sender, MouseEventArgs e)
        {
            close_timer.Stop();
        }

        /// <summary>
        ///   
        /// </summary>
        private void ButtonDown(object sender, MouseEventArgs e)
        {
            close_timer.Start();
        }

        /// <summary>
        ///    
        /// </summary>
        private void ButtonClick(object sender, EventArgs e)
        {
            if (new_exe == "")
                return;

            int panels_opened = 0;
            SmartPanel visible_panel = null;
            foreach (Control ctrl in Parent.Controls)
                if (ctrl is SmartPanel && ctrl.Visible)
                {
                    if ((SmartPanel)ctrl != this)
                        visible_panel = (SmartPanel)ctrl;
                    panels_opened++;
                }
            
            if (this.Visible)
            {
                this.Visible = false;
                if (IsProcessRunning())
                    button.Image = btn_idle_image;
                else
                    button.Image = btn_regular_image;
                if (visible_panel != null)
                    visible_panel.PanelResize(false);
            }
            else
            {
                if (panels_opened >= max_panel_count)
                    return;

                if (panels_opened == 0)
                    Width = centrafuse.Plugins.SkinReader.CFDimensions.width - 92;
                else
                    Width = (centrafuse.Plugins.SkinReader.CFDimensions.width - 92) / max_panel_count;
                Left = Width * panels_opened + 92;
                Top = 0;
                Height = Parent.Height;

                this.Visible = true;
                button.Image = btn_selected_image;

                //Win32.ShowWindow(process_wnd_handle, 5);
                Win32.SetWindowPos(process_wnd_handle, IntPtr.Zero, 0, 0, this.Width, this.Height, 0);

                RunProcess();
                
                if (visible_panel != null)
                    visible_panel.PanelResize(true);
            }
        }
        
        #endregion


        private void PanelResize(bool add)
        {
            if (!add)
            {
                Left = 92;
                Width = centrafuse.Plugins.SkinReader.CFDimensions.width - 92;
            }
            else
            {
                Width = (centrafuse.Plugins.SkinReader.CFDimensions.width - 92) / max_panel_count;
            }

            if (IsProcessRunning())
                Win32.SetWindowPos(process_wnd_handle, IntPtr.Zero, 0, 0, this.Width, this.Height, 0);
        }

        #region  

        /// <summary>
        ///  
        /// </summary>
        private void OnProcTimer(object sender, EventArgs e)
        {
            if (!IsProcessRunning())
            {
                process_timer.Stop();
                process = null;
                minimize_button.Visible = false;
                block_button.Show();

                if (this.Visible)
                {
                    if (Height == Parent.Height && Width == Parent.Width)
                        MouseHookClass.SetHook();

                    RestoreSize();
                    ButtonClick(null, null);
                }
                else
                    button.Image = btn_regular_image;
            }
        }

        /// <summary>
        ///   
        /// </summary>
        /// <param name="exe">  exe</param>
        /// <param name="cmd"> </param>
        public void SetExecutablePath(string exe, string cmd, int wait_)
        {
            new_exe = exe;
            new_cmd = cmd;
            wait = wait_;

            if (exe == "")
                button.Visible = false;
            else
                button.Visible = true;
        }

        /// <summary>
        ///  
        /// </summary>
        /// <param name="exe">   </param>
        /// <param name="cmd"> </param>
        /// <returns></returns>
        private bool RunProcess()
        {
            //    
            if (process != null)
                process.Refresh();

            //     - 
            if (process != null && process.HasExited == false && process_exe == new_exe && process_cmd == new_cmd)
            {
                Win32.SetWindowPos(process.MainWindowHandle, IntPtr.Zero, 0, 0, this.Width, this.Height, 0);
                return true;
            }

            try
            {
                //   
                if (process != null && !process.HasExited && (process_exe != new_exe || process_cmd != new_cmd))
                {
                    if (process.CloseMainWindow())
                    {
                        process.WaitForExit(2000);
                    }
                    if (!process.HasExited)
                    {
                        process.Kill();
                    }
                    process = null;
                }

                //  
                ProcessStartInfo process_info = new ProcessStartInfo();
                process_info.FileName = new_exe;
                process_info.Arguments = new_cmd;
                process_info.WorkingDirectory = Path.GetDirectoryName(new_exe);
                process_info.WindowStyle = ProcessWindowStyle.Maximized;
                process = Process.Start(process_info);
                process.WaitForInputIdle();
                process_timer.Start();
                int num = 2000;
                while (!Win32.IsWindow(process.MainWindowHandle) && (num > 0))
                {
                    num--;
                    Thread.Sleep(50);
                    process.Refresh();
                }

                process_wnd_handle = process.MainWindowHandle;
                Win32.SetWindowLong(process_wnd_handle, -16, 0x10000000);
                Win32.SetParent(process_wnd_handle, this.Handle);
                Win32.ShowWindow(process_wnd_handle, 5);
                Win32.SetWindowPos(process_wnd_handle, IntPtr.Zero, 0, 0, this.Width, this.Height, 0);
                if (wait > 0)
                {
                    Thread.Sleep(wait);
                    Win32.SetWindowPos(process_wnd_handle, IntPtr.Zero, 0, 0, this.Width, this.Height, 0);
                }
                button.Image = btn_selected_image;

                process_exe = new_exe;
                process_cmd = new_cmd;

                base.Invalidate(true);
                this.Refresh();
            }
            catch
            {
                return false;
            }

            return true;
        }

        #endregion

        /// <summary>
        ///       
        /// </summary>
        /// <param name="x">  </param>
        /// <param name="y">  Y</param>
        /// <returns></returns>
        public bool IsMouseInMe(int x, int y)
        {
            int top = Parent.Top + this.Top;
            int left = Parent.Left + this.Left;
            int bottom = top + this.Height;
            int right = left + this.Width;

            return (x >= left) && (x <= right) && (y >= top) && (y <= bottom);
        }

        /// <summary>
        ///     
        /// </summary>
        public void FullScreen()
        {
            //   
            visible_panels = new bool[Parent.Controls.Count];
            for (int i = 0; i < Parent.Controls.Count; i++)
            {
                if (Parent.Controls[i] == this)
                    continue;
                visible_panels[i] = Parent.Controls[i].Visible;
                Parent.Controls[i].Visible = false;
            }

            this_width = this.Width;
            this_height = this.Height;
            this_left = this.Left;

            //       
            parent_top = Parent.Top;
            Parent.Top = 0;
            parent_left = Parent.Left;
            Parent.Left = 0;
            parent_height = Parent.Height;
            Parent.Height = centrafuse.Plugins.SkinReader.CFDimensions.height;

            this.Left = 0;
            this.Width = Parent.Width;
            this.Height = Parent.Height;
            if (IsProcessRunning())
                Win32.SetWindowPos(process_wnd_handle, IntPtr.Zero, 0, 0, this.Width, this.Height, 0);

            base.Invalidate(true);
            Parent.Refresh();
        }

        /// <summary>
        ///  
        /// </summary>
        public void RestoreSize()
        {
            Parent.Top = parent_top;
            Parent.Left = parent_left;
            Parent.Height = parent_height;

            this.Left = this_left;
            this.Width = this_width;
            this.Height = this_height;
            if (IsProcessRunning())
                Win32.SetWindowPos(process_wnd_handle, IntPtr.Zero, 0, 0, this.Width, this.Height, 0);

            for (int i = 0; i < Parent.Controls.Count; i++)
            {
                if (Parent.Controls[i] == this)
                    continue;
                if (visible_panels != null && visible_panels.Length > i)
                    Parent.Controls[i].Visible = visible_panels[i];
            }
        }

        /// <summary>
        ///  ?
        /// </summary>
        /// <returns></returns>
        public bool IsProcessRunning()
        {
            if (process != null)
            {
                process.Refresh();
                if (!process.HasExited)
                    return true;
            }

            return false;
        }
    }
}