/* ==================================================================================================
 * PDC plugin																						*
 * File: message.cs																					*
 * Author: Dipl.-Ing. Wolfgang Otto																	*
 * eMail: Wolfgang@exner-otto.de																	*
 * Date: August 2008																				    *
 *																									*
 * This file is subject to the condition of GNU GENERAL PUBLIC LICENSE								*
 * Therefore you are free to use this software for your own requirements and use the				*
 * source code for any modification.																*
 * The only wish is to inform the author about any kind of development.								*
 * =================================================================================================*/

using System;
using System.Drawing;
using System.Windows.Forms;
using System.Text;
using System.IO;
using System.Diagnostics;
using centrafuse.Plugins;

namespace pdc
{	
	public class message : CFDialog
	{
		public string MESSAGETEXT;
		protected System.Windows.Forms.Timer hideTimer;

        public message(ICFMain mForm, ConfigReader config, LanguageReader lang)
        {
            pdc.WriteLog("Message.Start");
            this.MainForm = mForm;
            this.pluginConfig = config;            
            this.pluginLang = lang;
            this.CF_params.isGUI = true;
            this.CF_params.pluginName = pdc.PluginName; // very very important to use the name of MAIN plugin, do NOT use dialog name specifier
            pdc.WriteLog("Message.Stop");
        }
        public override void CF_pluginInit()
        {
            pdc.WriteLog("Message.CF_pluginInit.Start");
            this.CF3_initDialog("MESSAGE");
            this.CF_localskinsetup();
            this.CF_events.applicationLoaded += new EventHandler(MESSAGE_Loaded);
            pdc.WriteLog("Message.CF_pluginInit.Stop");
        }
        public override void CF_localskinsetup()
        {
           pdc.WriteLog("Message.CF_localskinsetup.Start");
           this.CF_updateText("MESSAGE", MESSAGETEXT);
           pdc.WriteLog("Message.CF_localskinsetup.Stop");
        }
        public override bool CF_pluginCMLCommand(string id, string[] strparams, CF_ButtonState state, bool rear)
        {
            if (state != CF_ButtonState.Click)
                return false;

            pdc.WriteLog("CF_pluginCMLCommand: " + id);
            // the id is not not the ID but the ACTION property of button control
            switch (id.ToUpper())
            {
                case "CLOSE": 
                    this.DialogResult = DialogResult.OK; 
                    return true;
            }
            return false;
        }
    	protected void hideTimer_Tick(object sender, EventArgs e)
		{
			//===========================================================
			// close this information dialog after a predefined time
			//===========================================================
			hideTimer.Stop();
			this.DialogResult = DialogResult.OK;
		}
		private void MESSAGE_Loaded(object sender, EventArgs e)
		{
			//===========================================================
			// Event that fires when the aplication is loaded.
			//===========================================================

            pdc.WriteLog("Message_Loaded:Start");
			
			try
			{
				//----------------------------------------------------------------------------------
				// checkTimer: Timer for detecting a pressure or temperature fault by on of the tires
				//----------------------------------------------------------------------------------
				hideTimer = new System.Windows.Forms.Timer();
				try { hideTimer.Interval = Convert.ToInt16(this.pluginConfig.ReadField("/APPCONFIG/HIDETIMEMS")); } 
				catch {hideTimer.Interval = 5000;} // standard value is 5 seconds
				hideTimer.Tick += new EventHandler(hideTimer_Tick);

				hideTimer.Enabled= true;
			}
			catch(Exception errmsg) { CFTools.writeError(errmsg.Message, errmsg.StackTrace); }
            pdc.WriteLog("Message_Loaded:Stop");
		}

		public override void CF_pluginShow()
		{
			//  This is called by the system when a button with this plugin action has been clicked.
			this.Visible = true;
		}

		public override void CF_pluginClose()
		{	
			this.Dispose();		// Disposes the plugin.
		}
			
	}
}

	

	

	
