/* ==================================================================================================
 * info diplay class																				*
 * File: infodisplay.cs																				*
 * Author: Dipl.-Ing. Wolfgang Otto																	*
 * eMail: Wolfgang@exner-otto.de																	*
 * Date: February 2008																				*
 *																									*
 * This file is subject to the condition of GNU GENERAL PUBLIC LICENSE								*
 * Therefore you are free to use this software for your own requirements and use the				*
 * source code for any modification.																*
 * The only wish is to inform the author about any kind of development.								*
 * =================================================================================================*/

using System;
using System.Drawing;
using System.Windows.Forms;
using System.Text;
using System.IO;
using centrafuse.Plugins;

namespace info
{	
	public class Infodisplay : CFDialog
	{
		protected static int _timetoshow = 1000;
		protected static string _skin = "Onyx WS Night";

		public string CurrentSkin
		{
			get { return _skin;}
			set 
			{
				if (Directory.Exists(Application.StartupPath + @"\Skins\" + value))
					_skin = value;
			}
		}

		public int WaitingTime
		{
			get { return _timetoshow; }
			set	{ _timetoshow = value; }
		}

		public Infodisplay(string skin)
		{
			this.CF_pluginName = "INFODISPLAY";
			this.CF_pluginIsGUI = true;
			CurrentSkin = skin;
			//=========================================================
			// important to identify which part of the skin file to use
			//=========================================================
			this.screenpath = "/SKIN/DIALOGS/INFODISPLAY";
			this.whichscreen = "INFODISPLAY";
		}
	
		#region CFPlugin methods
		//==========================================================================================

		public void ShowInfo(string msg)
		{
			this.CF_localskinsetup();

			this.CF_updateText("MAINTITLE", msg);		
			this.Visible = true;
		}

		public void ShowInfo(string msg, int TimeToShow)
		{
			this.CF_localskinsetup();
			if (TimeToShow < 500) // ms
				WaitingTime = 500;
			else
				WaitingTime = TimeToShow;
			this.CF_updateText("MAINTITLE", msg);		
			this.Visible = true;
			while (WaitingTime > 0)
			{
				Application.DoEvents();
				WaitingTime = WaitingTime - 100;
				System.Threading.Thread.Sleep(100);
			}
			HideInfo();
		}

		public void HideInfo()
		{
			this.Visible = false;
		}

		public override void CF_pluginShow()
		{
			//  This is called by the system when a button with this plugin action has been clicked.
			this.Visible = true;
		}
		
		public override void CF_pluginPause()
		{
			// This is called by the system when it pauses all audio.

		}

		public override void CF_pluginResume()
		{
			// This is called by the system when it resumes all audio.
		}

		public override void CF_pluginCommand(string command, string param1, string param2)
		{
			// Used for plugin to plugin communication.  Parameters can be passed into CF_Main_systemCommands with CF_Actions.PLUGIN, plugin name, plugin command, and a command parameter.
		}

		public override string CF_pluginData(string command, string param)
		{
			// Used for retrieving information from plugins. You can run CF_getPluginData with a plugin name, command, and parameter to retrieve information from other plugins running on the system.
			string retvalue = "";
			return retvalue;
		}
		
		public override void CF_pluginInit() {}
		public override void CF_pluginClose()
		{	
			this.Dispose();		// Disposes the plugin.
		}
		
		public override void CF_pluginUpdateLanguageSkin(string language, string skin) 
		{
			// This is called by the system when the language has changed.
			this.CF_localskinsetup();
		}
		
		///  This is called to setup the skin.  This will usually be called  in CF_pluginInit.  It will also called by the system when
		///  the resolution has been changed.
		public override void CF_localskinsetup()
		{
			string skinPath = Application.StartupPath + @"\Skins\" + CurrentSkin;
			this.CF_clearControls();
			
			// Load a part of the complete CF skin file. I need here only 
			// the SKIN/DIALOGS/INFODISPLAY object.
			this.CF_loadSkinReader(skinPath + @"\skin.xml","DIALOGS/INFODISPLAY");
			

			//  Loads the skin images and define the reduced size of this dialog box
			//
			this.CF_loadImages(skinPath + @"\dialogs\infodisplay.png",
							   skinPath + @"\dialogs\infodisplay.png");

			this.Bounds = this.CF_createRect(
				(int)(Int32.Parse(pluginSkinReader.readPluginField("/SKIN/APPCONFIG/WIDTH")) - Int32.Parse(pluginSkinReader.readPluginField("/SKIN/DIALOGS/INFODISPLAY/WIDTH")))/2, 
				(int)(Int32.Parse(pluginSkinReader.readPluginField("/SKIN/APPCONFIG/HEIGHT")) - Int32.Parse(pluginSkinReader.readPluginField("/SKIN/DIALOGS/INFODISPLAY/HEIGHT")))/2,
				Int32.Parse(pluginSkinReader.readPluginField("/SKIN/DIALOGS/INFODISPLAY/WIDTH")),
				Int32.Parse(pluginSkinReader.readPluginField("/SKIN/DIALOGS/INFODISPLAY/HEIGHT")));

			//  Creates plugin labels.
			this.CF_createLabel("MAINTITLE");								
		}


		#endregion

	}
}

	

	

	
