﻿using System;
using System.Collections.Generic;
using System.Text;
using pdc;
using System.Windows.Forms;
using System.IO.Ports;

namespace PDC
{
    public class ParkingDCDevice : IDisposable //: HIDDevice
    {
        #region IDisposable Members

       
        public void Dispose()
        {
            // Dispose method
            Dispose(true);
            GC.SuppressFinalize(this);
        }
        protected virtual void Dispose(bool bDisposing)
        {
            // Disposer called by both dispose and finalise
            // <param name="bDisposing">True if disposing</param>

            if (bDisposing)	// if we are disposing, need to close the managed resources
            {
                if (serialPort.IsOpen)
                    serialPort.Close();
            }
        }

        #endregion

        private PDCInputReport inputReport;
        private static object lObjInputBuffer = new object();

        public PDCInputReport InputReport
        {
            get
            {
                lock (lObjInputBuffer)
                    return inputReport; 
            }
            private set { inputReport = value; }
        }

        private string _comPort;
        private System.IO.Ports.SerialPort serialPort;

        public string ComPort
        {
            get { return _comPort; }
            set { _comPort = value; }
        }

        public ParkingDCDevice(string comPort)
        {
            _comPort = comPort;
            serialPort = new System.IO.Ports.SerialPort(_comPort);
            serialPort.BaudRate = 115200;
            serialPort.DataReceived += new System.IO.Ports.SerialDataReceivedEventHandler(serialPort_DataReceived);
            InputReport = new PDCInputReport(this);
        }

        void serialPort_DataReceived(object sender, System.IO.Ports.SerialDataReceivedEventArgs e)
        {
            try
            {
                SerialPort port = (SerialPort)sender;
                int bytesToRead = port.BytesToRead;
                byte[] buffer = new byte[bytesToRead];
                port.Read(buffer, 0, bytesToRead);
                ParceArray(buffer);

                //if (buffer.Length >=2)
                //{
                //    for (int i = 0; i < bytesToRead; )
                //    {
                //        i = SetBuffer(buffer, i);
                //        if (i < 0)
                //            break;
                //    }
                //}
            }
            catch(Exception ex) 
            {
                MessageBox.Show(ex.ToString(), ex.Message);
            }
        }
        private void ParceArray(byte[] array)
        {
            if (array == null || array.Length < 7)
                return;

            int pos = 0;
            int start = 0;
            byte b1 = 0;
            while (pos < array.Length)
            {
                if (start < 5 && array[pos] == 0xff)
                {
                    start++;
                    pos++;
                    continue;
                }

                // получен стартовый массив, читаем первый байт
                if (start == 5)
                {
                    b1 = array[pos];
                    pos++;
                    start++;
                    continue;
                }
                if (start == 6)
                {

                    SetValueSensor(b1, array[pos]);
                    pos++;
                    start = 0;
                    continue;
                }
                pos++;
            }
        }
        
        private void SetValueSensor(byte b1, byte value)
        {

            
            int number = b1 & 3;
            int detect = b1 & 8;

            lock (lObjInputBuffer)
            {
                InputReport.Buffer[number+1] = value;

                inputReport.Buffer[5] = Convert.ToByte(detect);
            }
        }

        public void Open()
        {
            if (!serialPort.IsOpen)
                serialPort.Open();
        }
        public void Close()
        {
            if (serialPort.IsOpen)
                serialPort.Close();
        }

        public PDCInputReport ReadReport()
        {
            return InputReport;
        }

        [Flags]
        public enum PDCSensor
        {
            Sensor_1 = 0, //0000
            Sensor_2 = 1, //0001
            Sensor_3 = 2, //0010
            Sensor_4 = 3, //0011
            SensorNotDetected = 8,
        }
    }
}
