/* ==================================================================================================
 * Park Distance Control (PDC) plugin
 * File: setup.cs
 * Author: Dipl.-Ing. Wolfgang Otto
 * eMail: Wolfgang@exner-otto.de
 * Date: September 2008

 * THIS PLUGIN IS A CONVERSION OF THE MARVELESS TOOL OF
 * **************************************************************************************************
 * Roberto Montanari, RoadRunner PDC Plugin															*
 * His VB sources are converted to C# and modified to be used as a CENTRAFUSE plugin				*
 * Thanks for his great work!																		*
 * **************************************************************************************************
 
 * This file is subject to the condition of GNU GENERAL PUBLIC LICENSE								*
 * Therefore you are free to use this software for your own requirements and use the				*
 * source code for any modification.																*	
 * The only wish is to inform the author about any kind of development.								*
 * =================================================================================================*/
using System;
using System.Xml;
using System.Web;
using System.IO; 
using System.Windows.Forms;
using System.Collections;
using System.Diagnostics;
using DirectShowLib;

using System.Drawing;
using System.ComponentModel;
using System.Data;
using System.Runtime.InteropServices;

using centrafuse.Plugins;

namespace pdc
{
	/// Setup class inherits from CFSetup  so that it will not show up as a seperate plugin, but a dialog within a plugin.  It uses the standard setup screens from the main application
	
	public class setup : CFSetup
	{
        const int pagetotal = 3;
        const int advpages = 3;
        
        public setup(ICFMain mForm, ConfigReader config, LanguageReader lang)
        {
            pdc.WriteLog("setup:Start");
            this.MainForm = mForm;
            this.pluginConfig = config;
            this.pluginLang = lang;

            // When CF_initSetup() is called, the CFPlugin layer will call back into CF_setupReadSettings() to read the page
            // Note that this.pluginConfig and this.pluginLang must be set before making this call
            
            CF_initSetup(3, 3);

            this.CF_updateText("TITLE", this.pluginLang.ReadField("/APPLANG/PDC/DISPLAYNAME"));
            this.CF_updateButtonText("OK", LanguageReader.GetText("APPLANG/BUTTONS/SAVE"));
            this.CF_updateButtonText("CANCEL", LanguageReader.GetText("APPLANG/BUTTONS/CANCEL"));
            pdc.WriteLog("setup:Stop");
        }
        public override void CF_setupReadSettings(int currentpage, bool advanced)
		{
            string dummy = string.Empty;
            #region PAGE 1
            if (currentpage == 1)
				{
                    /*******************************************************************************************/
                    /*****  SETUP PAGE 1 ALWAYS VISIBLE ********************************************************/
                    /*******************************************************************************************/                   
                    //DISPLAY NAME
                    ButtonHandler[SetupButton.One] = new CFSetupHandler(SetDisplayName);
                    ButtonText[SetupButton.One] = this.pluginLang.ReadField("/APPLANG/SETUP/LABELS/LABEL1");
                    ButtonValue[SetupButton.One] = this.pluginLang.ReadField("/APPLANG/PDC/DISPLAYNAME");
                    //--------------------------------------------------------------------------------------------------
                    //FRONT DETECTING DEVICE NAME
                    ButtonHandler[SetupButton.Two] = new CFSetupHandler(SetFrontDevice);
                    ButtonText[SetupButton.Two] = this.pluginLang.ReadField("/APPLANG/SETUP/LABELS/LABEL2");
                    if (this.pluginConfig.ReadField("/APPCONFIG/SETTINGS/DEVICEFRONT") == "")
                        dummy = this.pluginLang.ReadField("/APPLANG/PDC/NONE");
                    else
                        dummy = this.pluginConfig.ReadField("/APPCONFIG/SETTINGS/DEVICEFRONT");
                    ButtonValue[SetupButton.Two] = dummy;
                    //--------------------------------------------------------------------------------------------------
                    //REAR DETECTING DEVICE NAME
                    ButtonHandler[SetupButton.Three] = new CFSetupHandler(SetRearDevice);
                    ButtonText[SetupButton.Three] = this.pluginLang.ReadField("/APPLANG/SETUP/LABELS/LABEL3");
                    if (this.pluginConfig.ReadField("/APPCONFIG/SETTINGS/DEVICEREAR") == "")
                        dummy = this.pluginLang.ReadField("/APPLANG/PDC/NONE");
                    else
                        dummy = this.pluginConfig.ReadField("/APPCONFIG/SETTINGS/DEVICEREAR");
                    ButtonValue[SetupButton.Three] = dummy;
                    //--------------------------------------------------------------------------------------------------
                     //DISTANCE DETECTION START
                    ButtonHandler[SetupButton.Four] = new CFSetupHandler(SetDistDetectionStart);
                    ButtonText[SetupButton.Four] = this.pluginLang.ReadField("/APPLANG/SETUP/LABELS/LABEL4");
                    ButtonValue[SetupButton.Four] = this.pluginConfig.ReadField("/APPCONFIG/SETTINGS/DISTSHOWREAR");
                    //--------------------------------------------------------------------------------------------------
                    //BOOL: USE DEBUG
                    ButtonHandler[SetupButton.Five] = new CFSetupHandler(SetDebug);
                    ButtonText[SetupButton.Five] = this.pluginLang.ReadField("/APPLANG/SETUP/LABELS/LABEL5");
                    ButtonValue[SetupButton.Five] = this.pluginConfig.ReadField("/APPCONFIG/SETTINGS/USEDEBUG");
                    //--------------------------------------------------------------------------------------------------
                    //BOOL: USE FRONT DETECTION
                    ButtonHandler[SetupButton.Six] = new CFSetupHandler(SetFrontOn);
                    ButtonText[SetupButton.Six] = this.pluginLang.ReadField("/APPLANG/SETUP/LABELS/LABEL6");
                    ButtonValue[SetupButton.Six] = this.pluginConfig.ReadField("/APPCONFIG/SETTINGS/DETECTFRONT");
                    //--------------------------------------------------------------------------------------------------
                    //BOOL: USE REAR DETECTION
                    ButtonHandler[SetupButton.Seven] = new CFSetupHandler(SetRearOn);
                    ButtonText[SetupButton.Seven] = this.pluginLang.ReadField("/APPLANG/SETUP/LABELS/LABEL7");
                    ButtonValue[SetupButton.Seven] = this.pluginConfig.ReadField("/APPCONFIG/SETTINGS/DETECTREAR");
                    //--------------------------------------------------------------------------------------------------
                    //BOOL: DISPLAY VERTICAL ORIENTATION
                    ButtonHandler[SetupButton.Eight] = new CFSetupHandler(SetVerticalOn);
                    ButtonText[SetupButton.Eight] = this.pluginLang.ReadField("/APPLANG/SETUP/LABELS/LABEL8");
                    try
                    {
                        dummy = this.pluginConfig.ReadField("/APPCONFIG/SETTINGS/USEVERTICAL");
                    }
                    catch(Exception errmsg) 
                    { 
                        CFTools.writeError(errmsg.Message, errmsg.StackTrace);
                        dummy = "FALSE";
                    }
                    ButtonValue[SetupButton.Eight] = dummy;
                    CheckBothSensorsOff();
                }
            #endregion
            #region PAGE 2
                if (currentpage == 2)
                {
                    //1: everythin else ...
                    ButtonHandler[SetupButton.One] = new CFSetupHandler(SetVideoDevice);
                    ButtonText[SetupButton.One] = this.pluginLang.ReadField("/APPLANG/SETUP/LABELS/S2LABEL1");
                    ButtonValue[SetupButton.One] = this.pluginConfig.ReadField("/APPCONFIG/SETTINGS/VIDEODEVICE");
                                        
                    //2:
                    ButtonHandler[SetupButton.Two] = new CFSetupHandler(SetCameraProperties);
                    ButtonText[SetupButton.Two] = this.pluginLang.ReadField("/APPLANG/SETUP/LABELS/S2LABEL3");
                    ButtonValue[SetupButton.Two] = this.pluginLang.ReadField("/APPLANG/SETUP/BUTTONS/S2BUTTON3");

                    // Defition der Entfernung fr die letzte rote Warnschwelle
                    // aktuell 2,54m / 6 = 42cm
                    //3:
                    ButtonHandler[SetupButton.Three] = new CFSetupHandler(SetDimension);
                    ButtonText[SetupButton.Three] = this.pluginLang.ReadField("/APPLANG/SETUP/LABELS/S2LABEL2");
                    string t = this.pluginConfig.ReadField("/APPCONFIG/SETTINGS/DIMENSION");
                    switch (t)
                    {
                        case "m": ButtonValue[SetupButton.Three] = this.pluginLang.ReadField("/APPLANG/PDC/DIMENSION/METER").Split(';')[0]; break;
                        case "inch": ButtonValue[SetupButton.Three] = this.pluginLang.ReadField("/APPLANG/PDC/DIMENSION/INCH").Split(';')[0]; break;
                        case "ft": ButtonValue[SetupButton.Three] = this.pluginLang.ReadField("/APPLANG/PDC/DIMENSION/FEED").Split(';')[0]; break;
                    }

                    //5:
                    ButtonHandler[SetupButton.Five] = new CFSetupHandler(SetEnableCAM);
                    ButtonText[SetupButton.Five] = this.pluginLang.ReadField("/APPLANG/SETUP/LABELS/S2LABEL5");
                    ButtonValue[SetupButton.Five] = this.pluginConfig.ReadField("/APPCONFIG/SETTINGS/ENABLECAM");
                    
                    //6:
                    ButtonHandler[SetupButton.Six] = null;
                    ButtonText[SetupButton.Six] = "";
                    ButtonValue[SetupButton.Six] = "";

                    //7:
                    ButtonHandler[SetupButton.Seven] = new CFSetupHandler(SetSelfBeep);
                    ButtonText[SetupButton.Seven] = this.pluginLang.ReadField("/APPLANG/SETUP/LABELS/S2LABEL7");
                    ButtonValue[SetupButton.Seven] = this.pluginConfig.ReadField("/APPCONFIG/SETTINGS/USEHARDWAREBEEP");
                    if (ButtonValue[SetupButton.Seven].ToUpper() == "FALSE")
                    {
                        //4:MAINVOLLEVEL
                        ButtonHandler[SetupButton.Four] = new CFSetupHandler(SetLowerVolume);
                        ButtonText[SetupButton.Four] = this.pluginLang.ReadField("/APPLANG/SETUP/LABELS/S2LABEL4");
                        ButtonValue[SetupButton.Four] = this.pluginConfig.ReadField("/APPCONFIG/SETTINGS/MAINVOLLEVEL");

                        //8: PAUSE AUDIO
                        ButtonHandler[SetupButton.Eight] = new CFSetupHandler(SetLowerAudio);
                        ButtonText[SetupButton.Eight] = this.pluginLang.ReadField("/APPLANG/SETUP/LABELS/S2LABEL8");
                        ButtonValue[SetupButton.Eight] = this.pluginConfig.ReadField("/APPCONFIG/SETTINGS/PAUSEAUDIO");
                    }
                    else
                    {
                        ButtonHandler[SetupButton.Four] = null;
                        ButtonText[SetupButton.Four] = "";
                        ButtonValue[SetupButton.Four] = "";

                        ButtonHandler[SetupButton.Eight] = null;
                        ButtonText[SetupButton.Eight] = "";
                        ButtonValue[SetupButton.Eight] = "";
                    }

                }
            #endregion
            #region PAGE 3
            if (currentpage == 3)
			{
			    //1: Display Delay Time
                ButtonHandler[SetupButton.One] = new CFSetupHandler(SetHoldOpenTime);
                ButtonText[SetupButton.One] = this.pluginLang.ReadField("/APPLANG/SETUP/LABELS/S3LABEL1");
                ButtonValue[SetupButton.One] = this.pluginConfig.ReadField("/APPCONFIG/SETTINGS/HOLDOPENTIME");
    			
			    //2:
                ButtonHandler[SetupButton.Two] = null;
                ButtonText[SetupButton.Two] = "";
                ButtonValue[SetupButton.Two] = "";
					
				//3:
                ButtonHandler[SetupButton.Three] = null;
                ButtonText[SetupButton.Three] = "";
                ButtonValue[SetupButton.Three] = "";
				
				//4:
                ButtonHandler[SetupButton.Four] = null;
                ButtonText[SetupButton.Four] = "";
                ButtonValue[SetupButton.Four] = "";
    			
			    //5:
                ButtonHandler[SetupButton.Five] = null;
                ButtonText[SetupButton.Five] = "";
                ButtonValue[SetupButton.Five] = "";
    			
			    //6:
                ButtonHandler[SetupButton.Six] = null;
                ButtonText[SetupButton.Six] = "";
                ButtonValue[SetupButton.Six] = "";
    			
				//7:
                ButtonHandler[SetupButton.Seven] = null;
                ButtonText[SetupButton.Seven] = "";
                ButtonValue[SetupButton.Seven] = "";
				
				//8:
                ButtonHandler[SetupButton.Eight] = null;
                ButtonText[SetupButton.Eight] = "";
                ButtonValue[SetupButton.Eight] = "";
            }
            #endregion
            //catch(Exception errmsg) { CFTools.writeError(errmsg.Message, errmsg.StackTrace); }
            int pg = pagetotal;
            if (advancedSettingsOn) pg = advpages;
            this.CF_updateText("PAGE", LanguageReader.GetText("APPLANG/GENERIC/PAGE") + " " + currentpage + "/" + pg);
		}

		#region Application specific Button Clicks
		
        private void SetDisplayName(ref object value)
        {
            //======================================================================================================
            // Set the displayname of this plugin
            //======================================================================================================
            string resultvalue, resulttext;
            if (this.CF_systemDisplayDialog(CF_Dialogs.OSK,
                this.pluginLang.ReadField("/APPLANG/SETUP/BUTTONS/BUTTON1TEXT"),
                ButtonValue[(int)value],
                out resultvalue,
                out resulttext) == DialogResult.OK)
            {
                ButtonValue[(int)value] = resultvalue;
                this.pluginLang.WriteField("/APPLANG/PDC/DISPLAYNAME", HttpUtility.HtmlEncode(resultvalue));
            }
        }
        private void SetFrontDevice(ref object value)
        {
            //======================================================================================================
            // Select the PDC front device name
            //======================================================================================================
            object tempobject;
            string resultvalue, resulttext;
            string devname = this.pluginLang.ReadField("/APPLANG/PDC/DEVICENAME");

            // set the number of entries + 1 for the NONE entry 
            CFControls.CFListViewItem[] textoptions = new CFControls.CFListViewItem[3];
            textoptions[0] = new CFControls.CFListViewItem(devname + "2", "2", -1, false);
            textoptions[1] = new CFControls.CFListViewItem(devname + "3", "3", -1, false);
            textoptions[2] = new CFControls.CFListViewItem(this.pluginLang.ReadField("/APPLANG/PDC/NONE"), "", -1, false);

            if (this.CF_systemDisplayDialog(CF_Dialogs.FileBrowser,
                this.pluginLang.ReadField("/APPLANG/SETUP/BUTTONS/BUTTON2TEXT"), // Fensterberschrift
                this.pluginLang.ReadField("/APPLANG/SETUP/LABELS/LABEL2"),	     // Name des aufrufenden Textfeldes
                ButtonValue[(int)value],							                     // bernahme des bisherigen Textes				
                out resultvalue,
                out resulttext,
                out tempobject,
                textoptions,
                true, true, true, true, false, false, 1) == DialogResult.OK)
            {
                if (resultvalue == "")
                    ButtonValue[(int)value] = this.pluginLang.ReadField("/APPLANG/PDC/NONE");
                else
                    ButtonValue[(int)value] = resultvalue;

                this.pluginConfig.WriteField("/APPCONFIG/SETTINGS/DEVICEFRONT",HttpUtility.HtmlEncode(resultvalue));
            }
        }
        private void SetRearDevice(ref object value)
        {
            //======================================================================================================
            // Select the PDC front device name
            //======================================================================================================
            object tempobject;
            string resultvalue, resulttext;
            string devname = this.pluginLang.ReadField("/APPLANG/PDC/DEVICENAME");

            // set the number of entries + 1 for the NONE entry 
            CFControls.CFListViewItem[] textoptions = new CFControls.CFListViewItem[3];
            textoptions[0] = new CFControls.CFListViewItem(devname + "2", "2", -1, false);
            textoptions[1] = new CFControls.CFListViewItem(devname + "3", "3", -1, false);
            textoptions[2] = new CFControls.CFListViewItem(this.pluginLang.ReadField("/APPLANG/PDC/NONE"), "", -1, false);

            if (this.CF_systemDisplayDialog(CF_Dialogs.FileBrowser,
                this.pluginLang.ReadField("/APPLANG/SETUP/BUTTONS/BUTTON3TEXT"), // Fensterberschrift
                this.pluginLang.ReadField("/APPLANG/SETUP/LABELS/LABEL3"),	     // Name des aufrufenden Textfeldes
                ButtonValue[(int)value],							                     // bernahme des bisherigen Textes				
                out resultvalue,
                out resulttext,
                out tempobject,
                textoptions,
                true, true, true, true, false, false, 1) == DialogResult.OK)
            {
                if (resultvalue == "")
                    ButtonValue[(int)value] = this.pluginLang.ReadField("/APPLANG/PDC/NONE");
                else
                    ButtonValue[(int)value] = resultvalue;
                this.pluginConfig.WriteField("/APPCONFIG/SETTINGS/DEVICEREAR", HttpUtility.HtmlEncode(resultvalue));
            }
        }
        private void SetDistDetectionStart(ref object value)
        {
            string resultvalue, resulttext;
            bool result;
            int percentage = 0;

            if (this.CF_systemDisplayDialog(CF_Dialogs.NumberPad,
                this.pluginLang.ReadField("/APPLANG/SETUP/BUTTONS/BUTTON4TEXT"),
                ButtonValue[(int)value], out resultvalue, out resulttext) == DialogResult.OK)
                {
                    result = int.TryParse(resultvalue, out percentage);
                    if (result)
                    {
                        if (percentage > 254) resultvalue = "254";
                        ButtonValue[(int)value] = resultvalue;
                    }
                    this.pluginConfig.WriteField("/APPCONFIG/SETTINGS/DISTSHOWREAR", ButtonValue[(int)value]);
                    this.pluginConfig.WriteField("/APPCONFIG/SETTINGS/DISTSHOWFRONT", ButtonValue[(int)value]);
                }
        
        }
		private void SetHoldOpenTime(ref object value)
		{
			string resultvalue, resulttext;
            bool result;
			int times;

            if (this.CF_systemDisplayDialog(CF_Dialogs.NumberPad,
                this.pluginLang.ReadField("/APPLANG/SETUP/BUTTONS/S3BUTTON1TEXT"),
                ButtonValue[(int)value], out resultvalue, out resulttext) == DialogResult.OK)
            {
                result = int.TryParse(resultvalue, out times);
                if (result)
                {
                    if (times > 60) resultvalue = "60";
                    ButtonValue[(int)value] = resultvalue;
                }                
                this.pluginConfig.WriteField("/APPCONFIG/SETTINGS/HOLDOPENTIME", ButtonValue[(int)value]);
                if (times == 0)
                    pdc.GHoldOpenTime = 0;
                else
				    pdc.GHoldOpenTime = (int)(times * 1000);
            }
		}
        private void SetLowerVolume(ref object value)
        {
            // set the % volume lowering factor 0-100%
            string resultvalue, resulttext;
            bool result;
            int percentage = 0;

            if (this.CF_systemDisplayDialog(CF_Dialogs.NumberPad,
                this.pluginLang.ReadField("/APPLANG/SETUP/BUTTONS/S2BUTTON4TEXT"),            
                ButtonValue[(int)value], out resultvalue, out resulttext) == DialogResult.OK)
            {
                result = int.TryParse(resultvalue, out percentage);
                if (result)
                {
                    if (percentage > 100) resultvalue = "100";
                    ButtonValue[(int)value] = resultvalue;
                }                
                this.pluginConfig.WriteField("/APPCONFIG/SETTINGS/MAINVOLLEVEL", ButtonValue[(int)value]);
            }
        }
        private IBaseFilter CreateFilter(Guid category, string friendlyname)
        {
            object source = null;
            Guid iid = typeof(IBaseFilter).GUID;
            foreach (DsDevice device in DsDevice.GetDevicesOfCat(category))
            {
                if (device.Name.CompareTo(friendlyname) == 0)
                {
                    device.Mon.BindToObject(null, null, ref iid, out source);
                    break;
                }
            }
            return (IBaseFilter)source;
        }
        private void SetVideoDevice(ref object value)
        {
            //enumerate Video Input filters and add them to S2BUTTON1
            object tempobject;
            string resultvalue, resulttext;
            int i = 0;
            int cnt = 0;
           
            // set the number of video devices + 1 for the NONE entry 
            foreach (DsDevice ds in DsDevice.GetDevicesOfCat(FilterCategory.VideoInputDevice)) cnt++;
            CFControls.CFListViewItem[] vDevices = new CFControls.CFListViewItem[cnt];
            foreach (DsDevice ds in DsDevice.GetDevicesOfCat(FilterCategory.VideoInputDevice))
            {
                vDevices[i++] = new CFControls.CFListViewItem(ds.Name,ds.Name,-1,false);
            }
            ButtonText[i] = this.pluginLang.ReadField("/APPLANG/SETUP/LABELS/S2LABEL1");
            ButtonValue[i] = this.pluginConfig.ReadField("/APPCONFIG/SETTINGS/VIDEODEVICE");

            if (this.CF_systemDisplayDialog(CF_Dialogs.FileBrowser,
                this.pluginLang.ReadField("/APPLANG/SETUP/BUTTONS/S2BUTTON1TEXT"), // Fensterberschrift
                this.pluginLang.ReadField("/APPLANG/SETUP/LABELS/S2LABEL1"),	   // Name des aufrufenden Textfeldes
                ButtonValue[(int)value],							   // bernahme des bisherigen Textes				
                out resultvalue,
                out resulttext,
                out tempobject,
                vDevices,
                true, true, true, true, false, false, 1) == DialogResult.OK)
            {
                ButtonValue[(int)value] = HttpUtility.HtmlEncode(resultvalue);
                if (pdc.VideoDevice != null)
                {
                    Marshal.ReleaseComObject(pdc.VideoDevice);
                    pdc.VideoDevice = null;
                }
                //Create the filter for the selected video input device
                string devicepath = HttpUtility.HtmlEncode(resultvalue);
                pdc.VideoDevice = CreateFilter(FilterCategory.VideoInputDevice, devicepath);
                this.pluginConfig.WriteField("/APPCONFIG/SETTINGS/VIDEODEVICE", HttpUtility.HtmlEncode(resultvalue));
            }   
        }
        private void SetDimension(ref object value)
        {
            object tempobject;
            string resultvalue, resulttext;
            
            CFControls.CFListViewItem[] ListDimensions = new CFControls.CFListViewItem[3];
            ListDimensions[0] = new CFControls.CFListViewItem(this.pluginLang.ReadField("/APPLANG/PDC/DIMENSION/METER").Split(';')[0], "m", -1, false);
            ListDimensions[1] = new CFControls.CFListViewItem(this.pluginLang.ReadField("/APPLANG/PDC/DIMENSION/INCH").Split(';')[0], "inch", -1, false);
            ListDimensions[2] = new CFControls.CFListViewItem(this.pluginLang.ReadField("/APPLANG/PDC/DIMENSION/FEED").Split(';')[0], "ft", -1, false);

            if (this.CF_systemDisplayDialog(CF_Dialogs.FileBrowser,
                this.pluginLang.ReadField("/APPLANG/SETUP/BUTTONS/S2BUTTON2TEXT"),
                this.pluginLang.ReadField("/APPLANG/SETUP/LABELS/S2LABEL2"),	   
                ButtonValue[(int)value],							   
                out resultvalue,
                out resulttext,
                out tempobject,
                ListDimensions,
                true, false, false, false, false, false, 1) == DialogResult.OK)
            {
                ButtonValue[(int)value] = HttpUtility.HtmlEncode(resulttext);
                this.pluginConfig.WriteField("/APPCONFIG/SETTINGS/DIMENSION",HttpUtility.HtmlEncode(resultvalue));
            }   
        }
        private void SetDebug(ref object value)
        {
            // Define the bool debug parameter to enable enhanced log output to file
            this.pluginConfig.WriteField("/APPCONFIG/SETTINGS/USEDEBUG", value.ToString()); 
        }
        private void SetFrontOn(ref object value)
        {
            this.pluginConfig.WriteField("/APPCONFIG/SETTINGS/DETECTFRONT", value.ToString());
            CheckBothSensorsOff();
        }
        private void SetRearOn(ref object value)
        {
            this.pluginConfig.WriteField("/APPCONFIG/SETTINGS/DETECTREAR", value.ToString());
            CheckBothSensorsOff();
        }
        private void SetVerticalOn(ref object value)
        {
            this.pluginConfig.WriteField("/APPCONFIG/SETTINGS/USEVERTICAL", value.ToString());
        }
        private void SetLowerAudio(ref object value)
        {
           this.pluginConfig.WriteField("/APPCONFIG/SETTINGS/PAUSEAUDIO", value.ToString());
        }
        private void SetEnableCAM(ref object value)
        {
            this.pluginConfig.WriteField("/APPCONFIG/SETTINGS/ENABLECAM", value.ToString());
        }     
        private void SetSelfBeep(ref object value)
        {
            this.pluginConfig.WriteField("/APPCONFIG/SETTINGS/USEHARDWAREBEEP", value.ToString());
        }
        private void SetCameraProperties(ref object value)
        {
            string devicepath = this.pluginConfig.ReadField("/APPCONFIG/SETTINGS/VIDEODEVICE");
            if (pdc.VideoDevice == null)
            {
                // Refresh video device
                pdc.VideoDevice = CreateFilter(FilterCategory.VideoInputDevice, devicepath);
            }
            if (pdc.VideoDevice != null)
                DisplayPropertyPage((IBaseFilter)pdc.VideoDevice);
            else
                ShowLargeMessage(this.pluginLang.ReadField("/APPLANG/PDC/TXTNOPROPERTY"));
        }

        #endregion

        #region NON changed function (CF2 -->CF3)
        public void CheckBothSensorsOff()
        {
            pdc.bFullScreen = ((this.pluginConfig.ReadField("/APPCONFIG/SETTINGS/DETECTFRONT").ToUpper() == "FALSE") &
                               (this.pluginConfig.ReadField("/APPCONFIG/SETTINGS/DETECTREAR").ToUpper() == "FALSE"));
        }
        [DllImport(@"oleaut32.dll")]
        public static extern int OleCreatePropertyFrame(
            IntPtr hwndOwner,
            int x,
            int y,
            [MarshalAs(UnmanagedType.LPWStr)] string lpszCaption,
            int cObjects,
            [MarshalAs(UnmanagedType.Interface, ArraySubType = UnmanagedType.IUnknown)] 
			ref object ppUnk,
            int cPages,
            IntPtr lpPageClsID,
            int lcid,
            int dwReserved,
            IntPtr lpvReserved);

        public void ShowLargeMessage(string txt)
        {
            pdc.WriteLog("ShowLargeMessage:Start");
            DialogResult returnvalue = DialogResult.Cancel;
            try
            {
                // Creates a new plugin setup instance. If you create a CFDialog  or CFSetup you must set 
                // its MainForm property to the main plugins MainForm property.
                message Msg = new message(this.MainForm, this.pluginConfig, this.pluginLang);
                Msg.MESSAGETEXT = txt;
                Msg.CF_pluginInit();
                returnvalue = Msg.ShowDialog();
                Msg.Close();
                Msg = null;
            }
            catch (Exception errmsg) { CFTools.writeError(errmsg.Message, errmsg.StackTrace); }
            pdc.WriteLog("ShowLargeMessage:Stop");
        }     
        public void DisplayPropertyPage(IBaseFilter dev)
		{
            //Get the ISpecifyPropertyPages for the filter
            ISpecifyPropertyPages pProp = dev as ISpecifyPropertyPages;
   
            int hr = 0;

            if (pProp == null)
            {
                //If the filter doesn't implement ISpecifyPropertyPages, try displaying IAMVfwCompressDialogs instead!
                IAMVfwCompressDialogs compressDialog = dev as IAMVfwCompressDialogs;
                if (compressDialog != null)
                {
                    hr = compressDialog.ShowDialog(VfwCompressDialogs.Config, IntPtr.Zero);
                    DsError.ThrowExceptionForHR(hr);
                }
            }
            //Get the name of the filter from the FilterInfo struct
            FilterInfo filterInfo;
            hr = dev.QueryFilterInfo(out filterInfo); 
            DsError.ThrowExceptionForHR(hr);

            // Get the propertypages from the property bag
            DsCAUUID caGUID;
            hr = pProp.GetPages(out caGUID);
            DsError.ThrowExceptionForHR(hr);

            //Create and display the OlePropertyFrame
            object oDevice = (object)dev;
            hr = OleCreatePropertyFrame(this.Handle, 0, 0, filterInfo.achName, 1, ref oDevice, caGUID.cElems, caGUID.pElems, 0, 0, IntPtr.Zero);
            DsError.ThrowExceptionForHR(hr);

            Marshal.ReleaseComObject(oDevice);

            if (filterInfo.pGraph != null)
            {
                Marshal.ReleaseComObject(filterInfo.pGraph);
            }

            // Release COM objects
            Marshal.FreeCoTaskMem(caGUID.pElems);
        }
        #endregion
    }
	}