unit ComMainForm;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, CPort, CPortCtl, RXClock, Gauges, ComCtrls;

type
  TForm1 = class(TForm)
    ComPort: TComPort;
    Button_Open: TButton;
    Button_Settings: TButton;
    TimerIni: TTimer;
    Temperature: TLabel;
    TimerProcessing: TTimer;
    RPMLabel: TLabel;
    TimerSend: TTimer;
    Start: TButton;
    Speed: TLabel;
    Pressure: TLabel;
    Distance: TLabel;
    LabelConnect: TLabel;
    Memo1: TMemo;
    Edit1: TEdit;
    Button2: TButton;
    LabelTime: TLabel;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    airTemp: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    MPGLabel: TLabel;
    Label9: TLabel;
    Gauge1: TGauge;
    Label10: TLabel;
    MPG1: TLabel;
    Kor: TEdit;
    VD: TEdit;
    Label1Topl: TLabel;
    Label11: TLabel;
    Label12: TLabel;
    Label13: TLabel;
    Label14: TLabel;
    Label15: TLabel;
    Label16: TLabel;
    Rashod: TLabel;
    Label17: TLabel;
    LabelSHFT: TLabel;
    Label25: TLabel;
    LabelLFT: TLabel;
    procedure Button_OpenClick(Sender: TObject);
    procedure Button_SettingsClick(Sender: TObject);
    procedure ComPortOpen(Sender: TObject);
    procedure ComPortClose(Sender: TObject);
    procedure ComPortRxChar(Sender: TObject; Count: Integer);
    procedure FormCreate(Sender: TObject);
    procedure TimerIniTimer(Sender: TObject);
    procedure TimerProcessingTimer(Sender: TObject);
    procedure TimerSendTimer(Sender: TObject);
    procedure StartClick(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Processing;
    procedure MPGcalc;
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;
  Status, Send, MAP, IAT, VSS: integer;
  Reply: Bool;
  StrOut: String;
  Dist, RPM, MPG, MPG_, Topl, SHFT, LFT: real;
  timeOld, TimeReal, deltaTime, I: LongInt;

implementation

{$R *.DFM}

procedure TForm1.MPGcalc;
var
  MAF : real;
begin
  MAF := (StrToInt(Kor.text)/100)*(RPM/60)*MAP*(StrToInt(VD.text)/2000)*28.98/(8.31441*(IAT+273.15));
  MPGLabel.Caption := Format('%0.1f /',[MAF]);
  MPG_ := 10*(1+0.001*(IAT-20))*3600*MAF*(1+(LFT+SHFT)/100)/122.22;
  MPG1.Caption := Format('%0.0f /',[MPG_]);
  if deltaTime < 5000 then //    
  begin
    Topl := Topl + MPG_/1000 * deltaTime/1000/3600;
    Label1Topl.Caption := Format('%0.1f .',[Topl]);
  end;
   if VSS <> 0 then
   begin
     if MPG <> 0 then
       MPG := (MPG + (100*((1+0.001*(IAT-20))*3600*MAF)/(14.7*760)/VSS))/2
     else
       MPG := 100*((1+0.001*(IAT-20))*3600*MAF)/(14.7*760)/VSS;
     Label9.Caption := Format('%0.1f /100 ',[MPG]);
     Gauge1.Progress := Round(MPG);
     Rashod.Caption := Format('%0.1f /100 ',[Topl/dist*100]);
   end;
end;

function del_space (st:String):String;
var
  i: integer;
  st1: string;
begin
  for i:=1 to length(st) do
   if st[i]<>' ' then
     st1:=st1+st[i];
  del_space := st1;
end;

function HEX_DEC(x:string):longint;
const digits:array [0..15] of char =
      ('0','1','2','3','4','5','6','7','8','9','A','B','C','D','E','F');
var res,ves:longint; i,j:byte;
begin
   res:=0; ves:=1;
   for i:=length(x) downto 1 do begin
      j:=0;
      x[i]:=UpCase(x[i]);
      while (digits[j]<>x[i]) do inc(j);
      res:=res+ves*j;
      ves:=ves*16;
   end;
   HEX_DEC:=res;
end;

procedure TForm1.Button_OpenClick(Sender: TObject);
begin
  if ComPort.Connected then
    ComPort.Close
  else
    ComPort.Open;
end;

procedure TForm1.Button_SettingsClick(Sender: TObject);
begin
  ComPort.ShowSetupDialog;
end;

procedure TForm1.ComPortOpen(Sender: TObject);
begin
  Status := 1;
  ComPort.WriteStr('atz'+#13);
  Send := 0;
  TimeOld :=0;
  MPG := 0;
end;

procedure TForm1.ComPortClose(Sender: TObject);
begin
  if Button_Open <> nil then
    Button_Open.Caption := 'Open';
end;

procedure TForm1.ComPortRxChar(Sender: TObject; Count: Integer);
var
  Str: String;
  i: integer;
begin
  if Reply = True then
   begin
    StrOut := '';             //  
    Reply := False;
   end;
  ComPort.ReadStr(Str, Count); //    Count  

  For i:=1 to Count do
  begin
    if (Str[i] <> #10) and (Str[i] <> #13) then //  LF  CR
      StrOut := StrOut + Str[i];
  end;

  If (Pos('>',StrOut) > 0) then //   
    Begin
      Reply := True;
      Memo1.Lines.Add(StrOut);
    end;

  If (Status = 1) and (Pos('ELM327',StrOut) > 0) then
   begin
    Status := 2; //  
   end;

  If (Status = 2) and (Pos('9141',StrOut) > 0) then
   begin
    Status := 3; //  ...
    Delete(StrOut,1,5);
   end;

  If (Status = 3) and (Pos('41 00',StrOut) > 0) then
   begin
    Status := 4; //    
    Delete(StrOut,1,5);
    Send := 1;          //     1
    LabelConnect.Font.Color := clGreen;
    TimerProcessing.Enabled := True;   // .  
   end;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  Status := 0;
end;

procedure TForm1.TimerIniTimer(Sender: TObject);
begin
  If Status = 2 then
    begin
      ComPort.WriteStr('at dp'+#13); // 
    end;
  If Status = 3 then
    begin
      ComPort.WriteStr('01 00'+#13); // OBD PID 00
      TimerIni.Enabled := False;     // .  
    end;
end;

procedure TForm1.TimerProcessingTimer(Sender: TObject);
begin
  Processing;
end;

procedure TForm1.TimerSendTimer(Sender: TObject); //  
begin
 Case Send of
  1: ComPort.WriteStr('01 05'+#13); //  . .
  2: ComPort.WriteStr('01 0C'+#13); // 
  3: ComPort.WriteStr('01 0D'+#13); // 
  4: ComPort.WriteStr('01 0B'+#13); //   
  5: ComPort.WriteStr('01 06'+#13); //  
  6: ComPort.WriteStr('01 07'+#13); //  
  7: ComPort.WriteStr('01 0F'+#13); //   
 end;
end;

procedure TForm1.Processing;
begin
if (Reply = True) and (Status = 4) then
 begin
  if pos('STOP', StrOut) > 0 then
    begin
     TimerSend.Enabled := False;
     LabelConnect.Font.Color := clRed;
    end;
  if pos('01 05', StrOut) > 0 then
    begin
      StrOut := del_space(StrOut);
      Delete(StrOut,1,8);
      Delete(StrOut,length(StrOut),1);
      Temperature.Caption := IntToStr(HEX_DEC(StrOut)-40)+'  C';
      Reply := False;
      StrOut := '';
      Send := 2;//  .. 
    end;

  if pos('01 0C', StrOut) > 0 then
    begin
      StrOut := del_space(StrOut);
      Delete(StrOut,1,8);
      Delete(StrOut,length(StrOut),1);
      RPM := HEX_DEC(StrOut)/4;
      RPMLabel.Caption := Format('%0.0f /',[RPM]);
      Reply := False;
      StrOut := '';
      Send := 3; //  
    end;

  if pos('01 0D', StrOut) > 0 then
    begin
      TimeReal := GetTickCount;
      StrOut := del_space(StrOut);
      Delete(StrOut,1,8);
      Delete(StrOut,length(StrOut),1);
      VSS := HEX_DEC(StrOut);
      Speed.Caption := IntToStr(VSS)+' /';
      deltaTime := timeReal-TimeOld;
      if TimeOld <> 0 then
        dist := dist + VSS *((deltaTime)/3600000);
      LabelTime.Caption := inttostr(deltaTime);
      TimeOld := TimeReal;
      Reply := False;
      StrOut := '';
      Send := 4; //  
      Distance.Caption := Format('%0.1f ',[dist]);
    end;

  if pos('01 0B', StrOut) > 0 then
    begin
      StrOut := del_space(StrOut);
      Delete(StrOut,1,8);
      Delete(StrOut,length(StrOut),1);
      MAP := HEX_DEC(StrOut);
      Pressure.Caption := IntToStr(MAP)+' kPa';
      Reply := False;
      StrOut := '';
      Send := 5; //  
    end;

  if pos('01 06', StrOut) > 0 then
    begin
      StrOut := del_space(StrOut);
      Delete(StrOut,1,8);
      Delete(StrOut,length(StrOut),1);
      SHFT := (HEX_DEC(StrOut)-128)*100/128;
      LabelSHFT.Caption := Format('%0.1f',[SHFT]);
      Reply := False;
      StrOut := '';
      Send := 6;// .  
    end;

  if pos('01 07', StrOut) > 0 then
    begin
      StrOut := del_space(StrOut);
      Delete(StrOut,1,8);
      Delete(StrOut,length(StrOut),1);
      LFT := (HEX_DEC(StrOut)-128)*100/128;
      LabelLFT.Caption := Format('%0.1f',[LFT]);
      Reply := False;
      StrOut := '';
      Send := 7;// .  
    end;

  if pos('01 0F', StrOut) > 0 then
    begin
      StrOut := del_space(StrOut);
      Delete(StrOut,1,8);
      Delete(StrOut,length(StrOut),1);
      IAT := HEX_DEC(StrOut)-40;
      airTemp.Caption := IntToStr(IAT)+'  C';
      Reply := False;
      StrOut := '';
      Send := 1;//  
      MPGcalc;
    end;
 end;
end;

procedure TForm1.StartClick(Sender: TObject);
begin
   TimerSend.Enabled := true;
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
   ComPort.WriteStr(Edit1.Text+#13);
end;

end.
