;       
;   

LIST	p=16F84
	#include "P16F84.INC"
            __CONFIG 3FFFH
 
;=======================================================
; RA0-RA1 -  
; RA2 -   
; RA3 -   
; RA4 -  
; RB0 -  
;=======================================================
;   .
;=======================================================
SProg	EQU	20h	; 
Wtemp	EQU	21h	; 
Stemp	EQU	22h
temp	EQU	23h
;-------------------------------------------------------
Speed	EQU	24h	;    
P1	EQU	25h	;   
P2	EQU	26h
P3	EQU	27h
cnt	EQU	28h	;
cnt1	EQU	29h	;  
Sp1	EQU	2Ah	; 
chek0	EQU	2Bh	;    
chek1	EQU	2Ch	;    
chek2	EQU	2Dh	;    
chek3	EQU	2Eh	;    
chek4	EQU	2Fh	;    
chek5	EQU	30h	;    
;********************************************************
;****** 1. . ****************************************
;********************************************************
	org	0
	call	init		;  
	goto	Main
	org	4
	goto	int		;   
	org	0x8
;********************************************************
;***    ******************************
;********************************************************
int	movwf	Wtemp		; 
	swapf	STATUS,W	; 
	movwf	Stemp		;

	btfsc	INTCON,2	;    TMR0
	goto	Rezult		;   

	btfsc	INTCON,1	;      
	incf	Speed,1		;    
	bcf	INTCON,1	;   RB0
	bcf	INTCON,2	;   TMR0

	swapf	Stemp,W	; 
	movwf	STATUS
	swapf	Wtemp,1
	swapf	Wtemp,0
	retfie
;********************************************************
;***    *****************************
;********************************************************
init	clrwdt
	clrf	TMR0             ;
	clrf	PORTA
	clrf	PORTB
	bsf	STATUS,5	;  1.
	movlw   B'00011100'	; RA0-RA1- 
	movwf	TRISA		; RA2-RA4 - 
	movlw   B'00000001'	; RB0 - 
	movwf	TRISB        	;  - 
	movlw   B'10111111'	;   0
	movwf   OPTION_REG	;   ,  TMR0
	clrf	INTCON		;  
	bcf	STATUS,5	;  0.
;------------------------------------------------------
;--    ---------------------------------
;------------------------------------------------------
	btfsc	PORTA,2		;   
	goto	rddat		;   EEPROM
;-------------------------------------------------------
	clrf	EEADR		;  
	movlw	4
	movwf	chek0
	call	saved		;   chek0
	clrf	chek1		;  
	clrf	chek2		; 
	clrf	chek3		; 
	clrf	chek4
	clrf	chek5
	clrf	cnt
	clrf	Sp1
;-----------   ------------------------
opr	clrf	PORTB		;   
	call	Paus		; 	
	return
;===============================================
;==    EEPROM ==============
;===============================================
rddat	clrwdt
	clrf    EEADR		;
	call    reads		;
	movwf	chek0		;
	incf	EEADR,1
	call    reads		;
	movwf	chek1		;
	incf	EEADR,1
	call    reads		;
	movwf	chek2		;
	incf	EEADR,1
	call    reads		;
	movwf   chek3		;
	incf	EEADR,1
	call    reads		;
	movwf   chek4		;
	incf	EEADR,1
	call    reads		;
	movwf	chek5		;
	goto	opr
;----------------------------------------------------
reads	clrw
	bsf     STATUS,5	;  1
	bcf	EECON1,7	;   
	bsf	EECON1,RD	; 
	btfsc	EECON1,RD	;  
	goto	$-1		; 
	bcf     STATUS,5	;  0
	movf	EEDATA,0	; EEDATA -> W
	return
;=============================================
;====   . =======================
;=============================================
Zap1	clrwdt		;   
	movlw   1		;
	movwf	EEADR		;
	call    reads		; 
	subwf	chek1,0		;
	btfsc	STATUS,2	;  
	return			; 
	movf	chek1,0		; 
	call	saved		;   
	return
;--------------------------------
Zap2	clrwdt		;   
	movlw   2		;
	movwf	EEADR		;
	call    reads		; 
	subwf	chek2,0		;
	btfsc	STATUS,2	;  
	return			; 
	movf	chek2,0		; 
	call	saved		;   
	return
;--------------------------------
Zap3	clrwdt		;   
	movlw   3		;
	movwf	EEADR		;
	call    reads		; 
	subwf	chek3,0		;
	btfsc	STATUS,2	;  
	return			; 
	movf	chek3,0		; 
	call	saved		;   
	return
;--------------------------------
Zap4	clrwdt		;   
	movlw   4		;
	movwf	EEADR		;
	call    reads		; 
	subwf	chek4,0		;
	btfsc	STATUS,2	;  
	return			; 
	movf	chek4,0		; 
	call	saved		;   
	return
;--------------------------------
Zap5	clrwdt		;   
	movlw   5		;
	movwf	EEADR		;
	call    reads		; 
	subwf	chek5,0		;
	btfsc	STATUS,2	;  
	return			; 
	movf	chek5,0		; 
	call	saved		;   
	return
;================================================
saved	clrwdt
	movwf	EEDATA
	bsf     STATUS,5	;  1
	bcf	INTCON,GIE	;  
	bsf     EECON1,WREN	;  
	movlw   55H		;
	movwf   EECON2		;
	movlw   0AA		;
	movwf   EECON2		;
	bsf     EECON1,WR	;  
	btfsc   EECON1,WR	;  
	goto	$-1		; 
	nop
	bcf     EECON1,WREN	;  
	bcf     STATUS,5	;  0
	return			;
;*******************************************
;***   *********************
;*******************************************
Main	clrwdt
	bsf	STATUS,5	;  1.
	movlw   B'10110000'	;     TMR0
	movwf   INTCON		;   ,  .
	bcf	STATUS,5	;  0.
	movlw	.236		; 
	movwf	TMR0		; TMR0 = 236
	clrf	Speed		;
	btfsc	PORTA,3		;    
	goto	nh		; "H"  
;-----------------------------------------------------------
	call	Paus		; 
;-----------------------------------------------------------
				;    
	goto	n7		;  "-"
;*********************************************************
;    Speed      ****
;*********************************************************
Rezult	clrwdt
	bsf	STATUS,5	;    1.
	clrf	INTCON		;  
	bcf	STATUS,5	;  0  RAM.
;----------    -----------------------
	movf	chek0,0		; 
	subwf	Speed,0		;   Speed-chek0
	btfss	STATUS,C	;  Speed < chek0
	goto	n0		; "0" -  
;----------    -----------------------
	movf	chek1,0		; 
	subwf	Speed,0		;   Speed-chek1
	btfss	STATUS,C	;  Speed < chek1
	goto	n1		; "1" -  
;----------    -----------------------
	movf	chek2,0
	subwf	Speed,0		;   Speed-chek2
	btfss	STATUS,C	;  Speed < chek2
	goto	n2		; "2" -  
;----------    -----------------------
	movf	chek3,0
	subwf	Speed,0		;   Speed-chek3
	btfss	STATUS,C	;  Speed < chek3
	goto	n3		; "3" -  
;----------    -----------------------
	movf	chek4,0
	subwf	Speed,0		;   Speed-chek4
	btfss	STATUS,C	;  Speed < chek4
	goto	n4		; "4" -  
;----------    -----------------------
	movf	chek5,0
	subwf	Speed,0		;   Speed-chek5
	btfss	STATUS,C	;  Speed < chek5
	goto	n5		; "5" -  
;----------    ----------------------
	btfsc	PORTA,2		;  
	goto	n6		; "6" -  
;*******************************************************
;****   *************************
;*******************************************************
Auto	clrwdt
;-----    --------------
	subwf	Sp1,0		; Sp1 - Speed
	btfsc	STATUS,Z	; 
	incf	cnt,1
	movf	Speed,0
	movwf	Sp1		; Speed->Sp1
;--------------------------------
	movlw	6
	subwf	cnt,0		;  Sp1 = Speed >6 
	btfsc	STATUS,Z	; 
	goto	Korek		;   EEPROM
	goto	n7		; -  
;========================================================
Korek	clrwdt			; 
	clrf	cnt		;  
;----     --------------------------
	clrw
	subwf	chek5,0
	btfss	STATUS,2
	goto	Main		; 
	clrw
	subwf	chek4,0
	btfss	STATUS,2
	goto	Zsk5
	clrw
	subwf	chek3,0
	btfss	STATUS,2
	goto	Zsk4
	clrw
	subwf	chek2,0
	btfss	STATUS,2
	goto	Zsk3
	clrw
	subwf	chek1,0
	btfss	STATUS,2
	goto	Zsk2
;=========================================
Zsk1	movf	Speed,0
	addlw	3
	movwf	chek1	;  
	call	prv1	;  
	call	Zap1	; 
	goto	Main
;---------------------------------
Zsk2	movf	Speed,0
	addlw	3	; 
	movwf	chek2
	call	prv2	;  
	call	Zap2	; 
	goto	Main
;---------------------------------
Zsk3	movf	Speed,0
	addlw	3
	movwf	chek3
	call	prv3	;  
	call	Zap3	; 
	goto	Main
;---------------------------------
Zsk4	movf	Speed,0
	addlw	3
	movwf	chek4
	call	prv4	;  
	call	Zap4	; 
	goto	Main
;---------------------------------
Zsk5	movf	Speed,0
	addlw	3
	movwf	chek5
	call	prv5	;  
	call	Zap5	; 
	goto	Main
;-------------------------------------------------
;----    -----------------------
;-------------------------------------------------
prv1	clrwdt
	movf	chek0,0
	addlw	3		; chek0 +3
	subwf	chek1,0		; chek1-(chek0+3)
	btfsc	STATUS,0	;  chek1 > chek0+3
	return			; 
	clrf	chek1		;  
	clrf	chek2		; 
	clrf	chek3		; 
	clrf	chek4		; 
	clrf	chek5		;
	return
;-------------------------------
prv2	movf	chek1,0
	addlw	3		; chek1 +3
	subwf	chek2,0		; chek2-chek1
	btfsc	STATUS,0	;  chek2 > chek1+3
	return			; 
	clrf	chek2		;  
	clrf	chek3		; 
	clrf	chek4		; 
	clrf	chek5		; 
	return
;-------------------------------
prv3	movf	chek2,0
	addlw	3		; chek2 +3
	subwf	chek3,0		; chek3-chek2
	btfsc	STATUS,0	;  chek1 > chek0+3
	return			; 
	clrf	chek3		; 
	clrf	chek4		; 
	clrf	chek5		; 
	return
;-------------------------------
prv4	movf	chek3,0
	addlw	3		; chek3 +3
	subwf	chek4,0		; chek4-chek3
	btfsc	STATUS,0	;  chek1 > chek0+3
	return			; 
	clrf	chek4		; 
	clrf	chek5		; 
	return
;-------------------------------
prv5	movf	chek4,0
	addlw	3		; chek4 +3
	subwf	chek5,0		; chek5-chek4
	btfss	STATUS,0	;  chek5 > chek4+3
	clrf	chek5		; 
	return
;******   *********************************
n0	clrwdt			; 
	movlw	80		;
	movwf	PORTB		;   - 0 
	goto	Main
;-----------------------------------------------
n1	clrwdt			; 
	movlw	0F2		;
	movwf	PORTB		;   - "1"
	goto	Main
;-----------------------------------------------
n2	clrwdt			; 
	movlw	48		;
	movwf	PORTB		;  - "2" 
	goto	Main
;-----------------------------------------------
n3	clrwdt			;
	movlw	60		;
	movwf	PORTB		;   - "3"
	goto	Main
;-----------------------------------------------
n4	clrwdt			;
	movlw	32		;
	movwf	PORTB		;   - "4"
	goto	Main
;-----------------------------------------------
n5	clrwdt			; 
	movlw	24		;
	movwf	PORTB		;   - "5"
	goto	Main
;-----------------------------------------------
n6	clrwdt			; 
	movlw	4		;  
	movwf	PORTB		;   - "6"
	goto	Main
;-----------------------------------------------
n7	clrwdt			; 
	movlw	7E		;
	movwf	PORTB		;   - "-"
	goto	Main		; 
;-----------------------------------------------
nh	clrwdt			; 
	movlw	12		;
	movwf	PORTB		;   - "H"
	call	zvuk		;   
	goto	Main
;********************************************************
Paus	movlw	.6		; 
	movwf	P3		; 
	clrf	P2		;  
	clrf	P1		;
	clrwdt			; 
	decfsz	P1		;
	goto	$-1		; 
	decfsz	P2		; 
	goto	$-4		;
	clrwdt
	decfsz	P3		;
	goto	$-6		; 
 return
;**********************************************************
zvuk	clrwdt
	clrf	cnt1
sign	bcf	PORTA,1
	nop
	bsf	PORTA,0
	call	psm
	bcf	PORTA,0
	nop
	bsf	PORTA,1
	call	psm
	decfsz	cnt1		;
	goto	sign
	bcf	PORTA,0
	bcf	PORTA,1
	call	psm
	return
;--------------------------------------------------
psm	movlw   .124		;  
        addlw   -1		; 
        btfss   STATUS,2	; 
        goto    $-2
	return
;==============================================================
;===    EEPROM ==========================
;==============================================================
	ORG 0x2100
	retlw	04h		; chek0 = 4
	retlw	0Ah		; chek1 = 10
	retlw	14h		; chek2 = 20
	retlw	1Ch		; chek3 = 28
	retlw	21h		; chek4 = 33
	retlw	26h		; chek5 = 38
;***************************************************************
end



