#include "GraphLCD.h"

#ifndef WIN32
    #include <avr/io.h>
#endif
#include <util/delay.h>

#include "GraphBitMaps.h"

#include "ProjectSettings.h"
#ifdef OPTION_LCD_ENABLED

//    
void WriteByte(uint8_t b, uint8_t cd, uint8_t lr) {
//       
	if (cd) 
		LCD_A0_Pin :: Set();
	else
		LCD_A0_Pin :: Clear();

	if (lr) 
		LCD_CS_Pin :: Set();
	else
		LCD_CS_Pin :: Clear();
	GraphLCD_WriteByte(b);	
	LCD_E_Pin :: Clear();
	LCD_E_Pin :: Set();


/*	if (cd) 
		GRAPHLCD_A0_PORT |= (1<<GRAPHLCD_A0_PIN);
	else
		GRAPHLCD_A0_PORT &= ~(1<<GRAPHLCD_A0_PIN);
		//       
	if (lr) 
		GRAPHLCD_CS_PORT |= (1<<GRAPHLCD_CS_PIN);
	else
		GRAPHLCD_CS_PORT &= ~(1<<GRAPHLCD_CS_PIN);
//	LCD.CS=lr;
	GraphLCD_WriteByte(b);	
//	LCD.D=b;	//         
	
//	Delay(>40ns);		//    (tAW)
	GRAPHLCD_E_PORT &= ~(1<<GRAPHLCD_E_PIN);
	GRAPHLCD_E_PORT |= (1<<GRAPHLCD_E_PIN);*/
//	LCD.E=0; Delay(>160ns);	//  E=0 (     (tDS))
//	LCD.E=1; Delay(>(2000ns-40ns-160ns));	//     E=0
}

void WriteCodeL(uint8_t b) { WriteByte(b,0,1); }//    
void WriteCodeR(uint8_t b) { WriteByte(b,0,0); }//    

void WriteDataL(uint8_t b) { WriteByte(b,1,1); }//    
void WriteDataR(uint8_t b) { WriteByte(b,1,0); }//    


//   
void LCDinit(void) {


//	GRAPHLCD_E_PORT |= (1<<GRAPHLCD_E_PIN);
	LCD_E_Pin :: Set();
//	LCD.E=1;//   
//	GRAPHLCD_RES_PORT &= ~(1<<GRAPHLCD_RES_PIN);
//	LCD.RES=0;//  RES=0 
	LCD_RES_Pin :: Clear();

	_delay_us(10);//    10 
//	GRAPHLCD_RES_PORT |= (1<<GRAPHLCD_RES_PIN);
	LCD_RES_Pin :: Set();
//	LCD.RES=1;//  RES
	_delay_ms(1);
//	Delay(>1ms);//    1 
	WriteCodeL(0xE2);//Reset
	WriteCodeR(0xE2);//Reset
	WriteCodeL(0xEE);//ReadModifyWrite off
	WriteCodeR(0xEE);//ReadModifyWrite off
	WriteCodeL(0xA4);//  
	WriteCodeR(0xA4);//  
	WriteCodeL(0xA9);// 1/32
	WriteCodeR(0xA9);// 1/32
	WriteCodeL(0xC0);//   0
	WriteCodeR(0xC0);//   0
	WriteCodeL(0xA1);//Invert scan RAM
	WriteCodeR(0xA0);//NonInvert scan RAM
	WriteCodeL(0xAF);//Display on
	WriteCodeR(0xAF);//Display on
}

void OutData(uint8_t Count,uint8_t Data, uint8_t * Outed)
{
	for (;Count!=0;Count--)
	{
		if ((*Outed)<61)
			WriteDataL(Data);
		else
			WriteDataR(Data);
		(*Outed)++;
	}
}


void OutRowOfDigit(uint8_t Digit,uint8_t Row, uint8_t * Outed)
{
	uint8_t counts[3]={2,6,2};

	uint8_t PartOfDigit,BitMap;

		for (PartOfDigit=0;PartOfDigit<3;PartOfDigit++)
		{
			if (Digit>12)
				BitMap=0;
			else
				BitMap=pgm_read_byte(&LCD_Digits_Bitmap[Digit][PartOfDigit][3-Row]);
			OutData(counts[PartOfDigit],BitMap,Outed);
		}
}

void GraphLCD_ClrScr(void)
{
	uint8_t Row,Col;
	for(Row=0; Row<4; Row++) //   4-  
	{
		WriteCodeL((Row)|0xB8);//      
		WriteCodeL(0x13);//            
		WriteCodeR((Row)|0xB8);//      
		WriteCodeR(0x0);//            

		for (Col=0;Col<62;Col++)
			WriteDataL(0);
		for (Col=0;Col<62;Col++)
			WriteDataR(0);
}
}


void LCD_Out_BitMap(uint16_t BitMapP,uint8_t Left,uint8_t Top,uint8_t CopyData)
{
	uint8_t Width,Height;
	uint16_t BitMapPCur;
	Width = pgm_read_byte(BitMapP);
	BitMapP++;
	Height = pgm_read_byte(BitMapP);
	BitMapP++;

	uint8_t Row,i,Outed,BitMap;
	for(Row=0; Row<Height; Row++) //   4-  
	{
		Outed=Left;
		if (Left<61)
		{
			WriteCodeL((Row+Top)|0xB8);//      
			WriteCodeL(0x13+Left);//            
			WriteCodeR((Row+Top)|0xB8);//      
			WriteCodeR(0x0);//            
		}
		else
		{
			WriteCodeR((Row+Top)|0xB8);//      
			WriteCodeR(Left-61);//            
		}
		BitMapPCur=BitMapP+Height-Row-1;

		for (i=Width;i>0;i--)
		{
			if (CopyData)
			{
				BitMap=pgm_read_byte(BitMapPCur);
				BitMapPCur=BitMapPCur+Height;
			}
			else
			{
				BitMap=0;
			}
			OutData(1,BitMap,&Outed);
		}
	}
}

void LCD_Out_Man(void)
{
	LCD_Out_BitMap((uint16_t) &LCD_Man_Bitmap, 75, 0,1);
}

void LCD_Out_Recycling(uint8_t Visible)
{
	LCD_Out_BitMap((uint16_t) &LCD_Recycling_Bitmap,100,2,Visible);
}

void LCD_Out_AC(uint8_t Visible)
{
	LCD_Out_BitMap((uint16_t) &LCD_AC_Bitmap,8,3,Visible);
}

void LCD_Out_Arrows(uint8_t TopArrow, uint8_t MiddleArrow, uint8_t BottomArrow)
{
	LCD_Out_BitMap((uint16_t) &LCD_Arrow_Top_Bitmap, 99, 0,TopArrow);
	LCD_Out_BitMap((uint16_t) &LCD_Arrow_Middle_Bitmap, 85, 0,MiddleArrow);
	LCD_Out_BitMap((uint16_t) &LCD_Arrow_Bottom_Bitmap, 92, 2,BottomArrow);
}

void LCD_Out_Vent(uint8_t Visible,uint8_t Speed)
{
	uint8_t Left=45;
	LCD_Out_BitMap((uint16_t) &LCD_Vent_Bitmap, Left, 0,Visible);

	if (Speed==255)
		LCD_Out_BitMap((uint16_t) &LCD_Vent_Auto_Bitmap, Left, 3,1);
	else
	{
		uint8_t i,Row,Outed;
		Row=3;
		WriteCodeL(Row|0xB8);//      
		WriteCodeL(0x13+Left);//            
		WriteCodeR(Row|0xB8);//      
		WriteCodeR(0x0);//            
		Outed=Left;

		for(i=0;i<Speed;i++)
		{
			OutData(2,0xFF,&Outed);
			OutData(1,0,&Outed);
		}
		OutData(Left+24-Outed,0,&Outed);
	}
}

void LCD_Out_Digits(uint8_t d1,uint8_t d2,uint8_t d3)
{
	uint8_t PointBitMap[4]={0,0b00011000,0,0};
//	PointBitMap[0

	uint8_t Row,Outed;
	for(Row=0; Row<4; Row++) //   4-  
	{
		WriteCodeL(Row|0xB8);//      
		WriteCodeL(0x13);//            
		Outed=0;

		OutRowOfDigit(d1,Row,&Outed);
		OutData(2,0,&Outed);
		OutRowOfDigit(d2,Row,&Outed);
		OutData(1,0,&Outed);
		OutData(2,PointBitMap[3-Row],&Outed);
		OutData(1,0,&Outed);
		OutRowOfDigit(d3,Row,&Outed);

/*
		for (;Outed<61;Outed++)
		{
			WriteDataL(0);
		}*/
	}
}


void LCD_TEST(void)
{

	uint8_t p,c;
	for(p=0; p<4; p++) {//   4-  
		WriteCodeL(p|0xB8);//      
		WriteCodeL(0x13);//            
		for(c=61; c<122; c++) {//      
			WriteDataL(0);//    
		}

		WriteCodeR(p|0xB8);//      
		WriteCodeR(0x00);//            
		for(c=61; c<122; c++) {//      
			WriteDataR(0);//    
		}
	}
}

void GraphLCD_Init(void)
{
	LCDDataReg :: InitPins();
	LCD_A0_Pin :: SetDirWrite();
	LCD_A0_Pin :: Clear();
	LCD_E_Pin :: SetDirWrite();
	LCD_E_Pin :: Clear();
	LCD_CS_Pin :: SetDirWrite();
	LCD_CS_Pin :: Clear();
	LCD_RES_Pin :: SetDirWrite();
	LCD_RES_Pin :: Clear();



	LCDinit();
	LCD_TEST();
}

void GraphLCD_WriteByte(uint8_t i1)
{
	LCDDataReg :: Write(i1); 
}
#endif // OPTION_LCD_ENABLED
