#include "TempSensors.h"


uint8_t SensorCount;
uint8_t gSensorIDs[MAXSENSORS][OW_ROMCODE_SIZE];

int16_t Temperatures[MAXSENSORS];
uint8_t search_sensors(void);

void ClearTempSensorInfo(void)
{
	uint8_t i;
	for (i=0;i<MAXSENSORS;i++)
		Temperatures[i]=0;
	
	for (i=0;i<OW_ROMCODE_SIZE*MAXSENSORS;i++)
		*(&gSensorIDs[0][0]+i)=0;
}

uint8_t search_sensors(void)
{
	uint8_t i;
	uint8_t id[OW_ROMCODE_SIZE];
	uint8_t diff;

	ClearTempSensorInfo();

	SensorCount = 0;
	
	for( diff = OW_SEARCH_FIRST; 
		diff != OW_LAST_DEVICE && SensorCount < MAXSENSORS ; )
	{
		DS18X20_find_sensor( &diff, &id[0] );
		
		if( diff == OW_PRESENCE_ERR ) {
//			uart_puts_P( "No Sensor found\r" );
			break;
		}
		
		if( diff == OW_DATA_ERR ) {
//			uart_puts_P( "Bus Error\r" );
			break;
		}
		
		for (i=0;i<OW_ROMCODE_SIZE;i++)
			gSensorIDs[SensorCount][i]=id[i];
		
		SensorCount++;
	}
	
	return SensorCount;
};

void ReadTemperatures(void)
{
	uint8_t subzero, cel, cel_frac_bits;
	uint8_t i;
	int16_t *Temp;
//	DS18X20_read_meas( &gSensorIDs[i][0], &subzero,
//				&cel, &cel_frac_bits);
	for ( i=0; i<SensorCount; i++)
	{
		if ( DS18X20_read_meas( &gSensorIDs[i][0], &subzero,
				&cel, &cel_frac_bits) == DS18X20_OK )
			{
				Temp = &Temperatures[i];
				*Temp = cel*TEMP_MULTIPLIER+cel_frac_bits*TEMP_MULTIPLIER/16;
				if (subzero==1)
				{
					*Temp = - *Temp;
				}
			}

	}
}

void MesureTemperatures(void)
{
	DS18X20_start_meas( DS18X20_POWER_PARASITE, NULL );
}

void RescanTemperatures(void)
{
	 ReadTemperatures();
	 MesureTemperatures();
}

void SaveIdsToEeprom(void)
{
	eeprom_write_block(&gSensorIDs[0][0],(uint8_t *)EEPROM_ADDRESS_IDS,MAXSENSORS*OW_ROMCODE_SIZE);
}

void LoadIdsFromEeprom(void)
{
	ClearTempSensorInfo();

	eeprom_read_block(&gSensorIDs[0][0],(uint8_t *)EEPROM_ADDRESS_IDS,MAXSENSORS*OW_ROMCODE_SIZE);

	uint8_t i;

	for (i=0;(i<MAXSENSORS)&&(gSensorIDs[i][0]!=0)&&(gSensorIDs[i][0]!=0xff);i++);
	if (i>0)
	{	
		SensorCount = i;
	}

}

