#include "conditions.h"
#include <avr/eeprom.h>

#include "TempSensors.h"

uint16_t ActionIndexes[30];

uint8_t GetClimatFilterInfo(int BeginAction , uint8_t FilterNumber , uint8_t DataShift)
{
  return GetClimatData(BeginAction, CLIMAT_MAIN_DATA_SIZE+FilterNumber*CONDITION_DATA_SIZE+DataShift);
}

uint8_t GetActionSize(int BeginAction)
{
   return CLIMAT_MAIN_DATA_SIZE+GetActionFilterCount(BeginAction)*CONDITION_DATA_SIZE;
}

uint8_t GetClimatData(int BeginAction,uint8_t DataType)
{
	int j;
	j=EEPROM_ADDRESS_CLIMAT_DATA+BeginAction+DataType;
	return eeprom_read_byte((uint8_t*)j);
}

uint8_t GetActionFilterCount(int BeginAction)
{
  int i=GetClimatData(BeginAction,CONDITION_COUNT_SHIFT);
  return i;
}


uint8_t GetActionCount(void)
{
	return eeprom_read_byte((uint8_t*)EEPROM_ADDRESS_CLIMAT_DATA);
}

void FillActionIndexes(void)
{
	uint8_t i;
	uint8_t j;
	uint16_t EepromAddr;
	EepromAddr = 1; // ,    0  ActionCount
	i = GetActionCount();
	if (i!=0xFF)
	{
		for (j=0;j<i;j++)
		{
			 ActionIndexes[j] = EepromAddr;
			 EepromAddr += GetActionSize(EepromAddr);
		}
	}
}

bool CheckClimatAction(uint8_t ActionIndex, int16_t * L_Temperatures, int16_t CurrTemp)
{
	if (CalcClimatActionError(ActionIndex,L_Temperatures,CurrTemp)==0)
		return true;
	else
		return false;
}

uint8_t CalcClimatActionError(uint8_t ActionIndex, int16_t * L_Temperatures, int16_t CurrTemp)
{
	uint8_t FilterCount;
	uint16_t ActionPointer;
	int8_t i;
	int16_t p1,p2;
	int16_t TempRes;
	int16_t Result;


	uint8_t TempIndexes[6]={0,1,0,3,0,2};

    ActionPointer = ActionIndexes[ActionIndex];
	FilterCount = GetActionFilterCount(ActionPointer);
	Result = 0;
	for (i=FilterCount-1;i>=0;i--)
	{
		uint8_t Index;
		Index=GetClimatFilterInfo(ActionPointer,i,CONDITION_FIRST_PARAMETER_SHIFT);
		if (Index==0)
			p1=0;
		else
		if (Index==2)
			p1=CurrTemp;
		else
			p1=L_Temperatures[TempIndexes[Index]];

		Index=GetClimatFilterInfo(ActionPointer,i,CONDITION_SECOND_PARAMETER_SHIFT);
		if (Index==0)
			p2=0;
		else
		if (Index==2)
			p2=CurrTemp;
		else
			p2=L_Temperatures[TempIndexes[Index]];

		p2 = p2+(GetClimatFilterInfo(ActionPointer,i,CONDITION_SUBSTITUTION_SHIFT)-100)*TEMP_MULTIPLIER;

		TempRes = 0;
		switch (GetClimatFilterInfo(ActionPointer,i,CONDITION_SIGN_SHIFT))
		{
			case CONDITION_SIGN_LESS:
				TempRes=p1-p2+1;break;
//					TempRes=p1<p2;break;
			case CONDITION_SIGN_LESS_OR_EQUAL:
				TempRes=p1-p2;break;
//				TempRes=p1<=p2;break;
			case CONDITION_SIGN_EQUAL:
				TempRes=abs(p1-p2);break;
//				TempRes=p1==p2;break;
			case CONDITION_SIGN_MUCH_OR_EQUAL:
				TempRes=p2-p1;break;
//				TempRes=p1>=p2;break;
			case CONDITION_SIGN_MUCH:
				TempRes=p2-p1+1;break;
//				TempRes=p1>p2;break;
		}
		if (TempRes>0)
			Result=Result+TempRes;
//		Result = Result && TempRes;
	}
	if (Result<=0)
		return 0;
	else	
	if (Result>255)
		return 255;
	else
		return (uint8_t) Result;
//	return Result;
}


int8_t GetClimatAction(int16_t * L_Temperatures, int16_t CurrTemp)
{
	int8_t i;
	int8_t j;
	uint8_t found;
	j = GetActionCount();
	for (i=0;i<j;i++)
	{
		found = CheckClimatAction(i, L_Temperatures, CurrTemp);
		if (found)
			return i;
	}
	return -1;
}
