#ifndef GRAPHLCD_H
#define GRAPHLCD_H

#include <stdint.h>
#include <avr/io.h>

#include "ProjectPins.h"

#include "./PinDef/iopins.h"
#include "./PinDef/pinlist.h"
#include "./PinDef/latch.h"

using namespace IO;

typedef ThreePinLatch<LCD_ShiftRegisterClk_Pin, LCD_ShiftRegisterData_Pin, LCD_ShiftRegisterLatch_Pin, 'N'> LCDDataReg; // clk  latch   


void LCD_Out_Digits(uint8_t d1,uint8_t d2,uint8_t d3);
void LCD_Out_Vent(uint8_t Visible,uint8_t Speed);
void LCD_Out_Man(void);
void LCD_Out_BitMap(uint16_t BitMapP,uint8_t Left,uint8_t Top,uint8_t ClearRegion);
void LCD_Out_Arrows(uint8_t TopArrow, uint8_t MiddleArrow, uint8_t BottomArrow);
void LCD_Out_Recycling(uint8_t Visible);
void LCD_Out_AC(uint8_t Visible);


void GraphLCD_WriteByte(uint8_t i1);
void GraphLCD_Init(void);
void GraphLCD_ClrScr(void);

#endif //GRAPHLCD_H
