#include <avr/io.h>
#include <avr/interrupt.h>
#include "a2d.h"

#include "Keys.h"
#include "ProjectPins.h"

uint8_t volatile Keys_CurrentButton;
uint8_t volatile ADCState[ADC_ChannelToScan];

//uint8_t Keys_Enabled;
//uint8_t CurrentChannel;

uint8_t Keys_Intervals[KEYS_COUNT][2] PROGMEM =  //     !
{
	{0x16,0x1A},
	{0x2E,0x32},
	{0x46,0x4A},
	{0x5E,0x62},
	{0x75,0x79},
	{0x8C,0x90},
	{0xA2,0xA6},
	{0xB9,0xBD},
	{0xD0,0xD4},
	{0xE7,0xEB}
};


uint8_t KeysGetCurrentButton(void)
{
	return Keys_CurrentButton;
}

void KeysStart(void)
{
	a2dInit();
	
	Keys_Pin::SetDirRead();
	Keys_Pin::Clear();

	ADC_Pins::Write(0);
	ADC_Pins::SetConfiguration(ADC_Pins::In);
//	ADC_Pins::SetDir(0);

	Keys_CurrentButton=KEYS_NONE_VALUE;

//	CurrentChannel=0;
//	a2dSetChannel(CurrentChannel);

//    sbi(ADCSR, ADIF);                       // clear hardware "conversion complete" flag 
//    sbi(ADCSR, ADSC);                       // start conversion
//	Keys_Enabled = 0xFF;	
}

void KeysRescan(void)
{
	uint8_t Value;
	Value = a2dConvert8bit(Keys_ADC_Channel);
	if (Value==0xFF)
		Keys_CurrentButton=KEYS_NONE_VALUE;
	else
	{
		uint8_t i;
		uint8_t found,bad;

		found = 0;
		bad = 0;

		Keys_CurrentButton=KEYS_NONE_VALUE;

		for (i=0;!found && !bad && (i<KEYS_COUNT);i++)
		{
			uint8_t j;
			j=pgm_read_byte(&Keys_Intervals[i][0]);
			if (Value<j)
				bad=0xFF;
			else
			{
				if (Value<pgm_read_byte(&Keys_Intervals[i][1]))
				{		
					found=0xFF;
					Keys_CurrentButton=i;
				}
			}
		}
	}
}

void ADCChannelsRescan()
{
	uint8_t i;
	for (i=ADC_FirstChannel;i<ADC_FirstChannel+ADC_ChannelToScan;i++)
	{
		uint8_t Value;
		Value = a2dConvert8bit(i);
		ADCState[i-ADC_FirstChannel]=Value;
	}
}

uint8_t ADC_GetState(uint8_t ADC_Channel)
{
	return ADCState[ADC_Channel-ADC_FirstChannel];
}

/*
void Keys_Stop(void)
{
	Keys_Enabled = 0;	
}


SIGNAL(SIG_ADC)
{
	sei();
	uint8_t Value;
	Value=((inb(ADCL) | (inb(ADCH)<<8)))>>2;
	if (CurrentChannel==Keys_ADC_Channel)
	{
		if (Value==0xFF)
			Keys_CurrentButton=0xFF;
		else
		{
			uint8_t i;
			uint8_t found,bad;

			found = 0;
			bad = 0;

	
			for (i=0;!found && !bad && (i<KEYS_COUNT);i++)
			{
				uint8_t j;
				j=pgm_read_byte(&Keys_Intervals[i][0]);
				if (Value<j)
					bad=0xFF;
				else
				{
					if (Value<pgm_read_byte(&Keys_Intervals[i][1]))
					{		
						found=0xFF;
						Keys_CurrentButton=i;
					}
				}
			}

		}
	}
	ADCState[CurrentChannel]=Value;
	if (Keys_Enabled)
	{	
		CurrentChannel++;
		if (CurrentChannel==ADC_ChannelToScan)
			CurrentChannel=0;
		a2dSetChannel(CurrentChannel);
	    sbi(ADCSR, ADIF);                       // clear hardware "conversion complete" flag 
    	sbi(ADCSR, ADSC);                       // start conversion
	}
}
*/
