#ifndef PROJECT_PINS_H
#define PROJECT_PINS_H

#include "./PinDef/iopin.h"
#include "./PinDef/iopins.h"
#include "./PinDef/pinlist.h"

#include "ProjectSettings.h"

using namespace IO;

typedef Pd0 SerialIn_Pin;
typedef Pd1 SerialOut_Pin;

typedef Pd2 AC_Pin;
typedef Pd3 Motor_Pin;
typedef Pd4 TempSensors_Pin;

typedef Pd6 LCD_CS_Pin;
typedef Pd7 LCD_RES_Pin;

typedef Pb0 LCD_E_Pin;
typedef Pb1 LCD_A0_Pin;


typedef Pb2 Servo_ShiftRegisterData_Pin;

typedef Pd3 Servo_ShiftRegisterLatch_Pin;
typedef Pb4 Servo_ShiftRegisterClk_Pin;


typedef Pb2 LCD_ShiftRegisterData_Pin;

typedef Pb4 LCD_ShiftRegisterLatch_Pin;
typedef Pb4 LCD_ShiftRegisterClk_Pin;


typedef Pc0 Keys_Pin;
#define Keys_ADC_Channel 0

typedef Pc1 LightSensor_Pin;
typedef Pc2 ServoRec_Pin;
typedef Pc3 ServoTemp_Pin;
typedef Pc4 ServoDirection_Pin;
typedef Pc5 ServoDirection2_Pin;

#define ADC_ChannelToScan 5
#define ADC_FirstChannel 1

typedef PinList<LightSensor_Pin, ServoRec_Pin, ServoTemp_Pin, ServoDirection_Pin, ServoDirection2_Pin> ADC_Pins;


#define Servo_Delta 1

typedef PinList<ServoRec_Pin, ServoTemp_Pin, ServoDirection_Pin, ServoDirection2_Pin> ServoPins;
#define SERVO_COUNT 4
#define SERVO_FIRST_ADC_CHANNEL 2


#endif //PROJECT_PINS_H
