#ifndef GRAPH_BITMAPS_H
#define GRAPH_BITMAPS_H

#include "ProjectSettings.h"
#ifdef OPTION_LCD_ENABLED

#include <stdint.h>
#include <avr/pgmspace.h>

uint8_t LCD_Digits_Bitmap[13][3][4] PROGMEM = 
{
	{
		{0,0b00011111,0b11111111,0b11111111},
		{0,0b00011000,0b00000000,0b00000011},
		{0,0b00011111,0b11111111,0b11111111},
	},
	{
		{0,0b00000000,0b00000000,0b00000000},
		{0,0b00000000,0b00000000,0b00000000},
		{0,0b00011111,0b11111111,0b11111111},
	},
	{
		{0,0b00011111,0b11111110,0b00000011},
		{0,0b00011000,0b00000110,0b00000011},
		{0,0b00011000,0b00000111,0b11111111},
	},
	{
		{0,0b00011000,0b00000110,0b00000011},
		{0,0b00011000,0b00000110,0b00000011},
		{0,0b00011111,0b11111111,0b11111111},
	},
	{
		{0,0b00000000,0b00000111,0b11111111},
		{0,0b00000000,0b00000110,0b00000000},
		{0,0b00011111,0b11111111,0b11111111},
	},
	{
		{0,0b00011000,0b00000111,0b11111111},
		{0,0b00011000,0b00000110,0b00000011},
		{0,0b00011111,0b11111110,0b00000011},
	},
	{
		{0,0b00011111,0b11111111,0b11111111},
		{0,0b00011000,0b00000110,0b00000011},
		{0,0b00011111,0b11111110,0b00000011},
	},
	{
		{0,0b00000000,0b00000000,0b00000011},
		{0,0b00000000,0b00000000,0b00000011},
		{0,0b00011111,0b11111111,0b11111111},
	},
	{
		{0,0b00011111,0b11111111,0b11111111},
		{0,0b00011000,0b00000110,0b00000011},
		{0,0b00011111,0b11111111,0b11111111},
	},
	{
		{0,0b00011000,0b00000111,0b11111111},
		{0,0b00011000,0b00000110,0b00000011},
		{0,0b00011111,0b11111111,0b11111111},
	},
	{
		{0,0b00011111,0b11111111,0b11111111},
		{0,0b00011000,0b00000000,0b00000000},
		{0,0b00011000,0b00000000,0b00000000},
	},
	{
		{0,0b00011111,0b11111111,0b11111111},
		{0,0b00000000,0b00000110,0b00000000},
		{0,0b00011111,0b11111111,0b11111111},
	},
	{
		{0,0b00000000,0b00000000,0b00000000},
		{0,0b00000000,0b00000000,0b00000000},
		{0,0b00000000,0b00000000,0b00000000},
	}
};

uint8_t LCD_Vent_Bitmap[23*3+2] PROGMEM = 
{
	23,3,
	0b00000000,0b00001110,0b00000000,
	0b00000000,0b00001111,0b00000000,
	0b00000000,0b00001111,0b10000000,
	0b00000000,0b00001111,0b10000000,
	0b00000000,0b00001111,0b10000000,
	0b00000000,0b00001111,0b10000000,
	0b00000000,0b00001111,0b10000000,
	0b00011111,0b00001111,0b00000000,
	0b00111111,0b10001110,0b00000000,
	0b01111111,0b11001100,0b00000000,
	0b01111111,0b11101000,0b00000000,
	0b01111111,0b11110111,0b11111111,
	0b00000000,0b00001011,0b11111111,
	0b00000000,0b00011001,0b11111111,
	0b00000000,0b00111000,0b11111110,
	0b00000000,0b01111000,0b01111100,
	0b00000000,0b11111000,0b00000000,
	0b00000000,0b11111000,0b00000000,
	0b00000000,0b11111000,0b00000000,
	0b00000000,0b11111000,0b00000000,
	0b00000000,0b11111000,0b00000000,
	0b00000000,0b01111000,0b00000000,
	0b00000000,0b00111000,0b00000000
};

uint8_t LCD_Vent_Auto_Bitmap[23*1+2] PROGMEM = 
{
	23,1,
	0b11111110,
	0b00010011,
	0b00010001,
	0b00010011,
	0b11111110,
	0b00000000,
	0b01111111,
	0b11000000,
	0b10000000,
	0b10000000,
	0b11111111,
	0b00000000,
	0b00000001,
	0b00000001,
	0b11111111,
	0b00000001,
	0b00000001,
	0b00000000,
	0b01111110,
	0b10000001,
	0b10000001,
	0b10000001,
	0b01111110,
};

uint8_t LCD_AC_Bitmap[19*1+2] PROGMEM = 
{
	19,1,
	0b11111100,
	0b11111110,
	0b00110011,
	0b00110011,
	0b11111110,
	0b11111100,
	0b00000000,
	0b00000000,
	0b11111000,
	0b11111111,
	0b00001111,
	0b00000000,
	0b00000000,
	0b01111110,
	0b11111111,
	0b11000011,
	0b11000011,
	0b11100111,
	0b01100110
};

uint8_t LCD_Man_Bitmap[17*4+2] PROGMEM = 
{
	17,4,
	0b00000000,0b00000000,0b00000000,0b00001110,
	0b00000000,0b00000000,0b11111111,0b11011111,
	0b00000000,0b00000011,0b11111111,0b11011111,
	0b00000000,0b00000111,0b11111111,0b11011111,
	0b00000000,0b00000111,0b11100000,0b00001110,
	0b00000000,0b00000111,0b10000000,0b00000000,
	0b00000000,0b00000111,0b00000000,0b00000000,
	0b00000000,0b00000111,0b00000000,0b00000000,
	0b00000000,0b00000111,0b00000000,0b00000000,
	0b00000000,0b00000111,0b00000000,0b00000000,
	0b00000000,0b00001111,0b00000000,0b00000000,
	0b00000000,0b00011111,0b00000000,0b00000000,
	0b00001111,0b11111110,0b00000000,0b00000000,
	0b00011111,0b11111100,0b00000000,0b00000000,
	0b00011111,0b11111000,0b00000000,0b00000000,
	0b00011000,0b00000000,0b00000000,0b00000000,
	0b00011000,0b00000000,0b00000000,0b00000000
};

uint8_t LCD_Arrow_Middle_Bitmap[12*2+2] PROGMEM = 
{
	12,2,
	0b00000000,0b10000000,
	0b00000001,0b11000000,
	0b00000011,0b11100000,
	0b00000111,0b11110000,
	0b00001101,0b11011000,
	0b00000001,0b11000000,
	0b00000001,0b11000000,
	0b00000001,0b11000000,
	0b00000001,0b11000000,
	0b00000001,0b11000000,
	0b00000001,0b11000000,
	0b00000001,0b11000000
};

uint8_t LCD_Arrow_Top_Bitmap[9*2+2] PROGMEM = 
{
/*	12,2,
	0b00111110,0b00000000,
	0b00110001,0b11110000,
	0b00110000,0b00001100,
	0b01100000,0b00001100,
	0b01100111,0b11011000,
	0b01100000,0b00011000,
	0b01100000,0b00011000,
	0b01100111,0b11011000,
	0b01100000,0b00001100,
	0b00110000,0b00001100,
	0b00110001,0b11110000,
	0b00111110,0b00000000*/





	9,2,
	0b00000011,0b00000000,
	0b00000011,0b10000000,
	0b00000001,0b11000000,
	0b00000000,0b11100010,
	0b00000000,0b01110010,
	0b00000000,0b00111010,
	0b00000000,0b00011110,
	0b00000000,0b00001110,
	0b00000000,0b01111110
};

uint8_t LCD_Arrow_Bottom_Bitmap[7*1+2] PROGMEM = 
{
	7,1,
	0b11111000,
	0b11100000,
	0b11110000,
	0b10111000,
	0b10011100,
	0b00001110,
	0b00000110,
};

uint8_t LCD_Recycling_Bitmap[17*2+2] PROGMEM = 
{
	17,2,
	0b00001000,0b00000000,
	0b00011100,0b00000000,
	0b01111110,0b00000000,
	0b11111111,0b00000000,
	0b00111000,0b00000000,
	0b00111000,0b01000000,
	0b01110000,0b01100000,
	0b01110000,0b00100000,
	0b01110000,0b00110000,
	0b01110000,0b00110000,
	0b01111000,0b00110000,
	0b00111000,0b00110000,
	0b00111000,0b00110000,
	0b00111000,0b01110000,
	0b00011100,0b11100000,
	0b00001111,0b11000000,
	0b00000111,0b10000000,
};


#endif //OPTION_LCD_ENABLED

#endif // GRAPH_BITMAPS_H
