#ifndef CONDITIONS_H_
#define CONDITIONS_H_
/*
  :

1.  . (1 byte)
2.  - -1 - , 1 - , 0 - . (1 byte)
3.  - 0 - , 1 -  2 - +, 3 - , 4 - +, 5 - , 6 - + (1 byte)
 (2 byte)
  1. 1.10 - .  11..n - . (1 byte)
  2.  (1 byte)
. 
  0 -  
  1 -  
  10..20 -  +10
  30..50 -      .
2.  
  3.  
  4.  
  5.          
*/

#include <inttypes.h>
#include "EepromAddresses.h"


#define TEMPERATURE_SHIFT 0 // 0 - , 1 - , 2 - 
#define DIRECTION_SHIFT 1 //0 - , 1 -  2 - +, 3 - , 4 - +, 5 - , 6 - + 
#define SPEED_SHIFT 2 //1.10 - .  11..n - 
#define MIN_SPEED_SHIFT 3 
#define RECYCLING_SHIFT 4 // 0 -     1 -     10..20 -  +10   30..50 -      .
#define CONDITION_COUNT_SHIFT 5

#define CLIMAT_MAIN_DATA_SIZE 6
#define CONDITION_DATA_SIZE 4

#define CONDITION_FIRST_PARAMETER_SHIFT 0
#define CONDITION_SIGN_SHIFT 1
#define CONDITION_SECOND_PARAMETER_SHIFT 2
#define CONDITION_SUBSTITUTION_SHIFT 3

#define CONDITION_SIGN_LESS 1
#define CONDITION_SIGN_LESS_OR_EQUAL 2
#define CONDITION_SIGN_EQUAL 3
#define CONDITION_SIGN_MUCH_OR_EQUAL 4
#define CONDITION_SIGN_MUCH 5


extern uint16_t ActionIndexes[30];


uint8_t GetClimatFilterInfo(int BeginAction,uint8_t FilterNumber,uint8_t DataShift);
uint8_t GetActionSize(int BeginAction);
uint8_t GetClimatData(int BeginAction , uint8_t DataType);
uint8_t GetActionFilterCount(int BeginAction);
uint8_t GetActionCount(void);

void FillActionIndexes(void);
bool CheckClimatAction(uint8_t ActionIndex, int16_t * L_Temperatures, int16_t CurrTemp);
uint8_t CalcClimatActionError(uint8_t ActionIndex, int16_t * L_Temperatures, int16_t CurrTemp);
int8_t GetClimatAction(int16_t * L_Temperatures, int16_t CurrTemp);




#endif //CONDITIONS_H_
