#ifndef TempSensors_H
#define TempSensors_H

#include <avr/io.h>
#include "onewire.h"
#include "ds18x20.h"
#include <avr/eeprom.h>

#include "EepromAddresses.h"

#define MAXSENSORS 4


#define TS_OUT 0
#define TS_IN 1
#define TS_ENGINE 2
#define TS_AIR 3

extern uint8_t SensorCount;
extern uint8_t gSensorIDs[MAXSENSORS][OW_ROMCODE_SIZE];

#define TEMP_MULTIPLIER 10

extern int16_t Temperatures[MAXSENSORS];
extern uint8_t search_sensors(void);

void RescanTemperatures(void);
void ReadTemperatures(void);
void MesureTemperatures(void);

void SaveIdsToEeprom(void);
void LoadIdsFromEeprom(void);

#endif //TempSensors_H
