#include <TinyGPS.h>

TinyGPS gps;
void gpsdump(TinyGPS &gps);
bool feedgps();
unsigned long time1, time;
void printFloat(double f, int digits = 2);

void setup()
{
  Serial.begin(115200);
  Serial1.begin(4800);
}

void loop()
{
  bool newdata = false;
  unsigned long start = millis();
  time = (start - time1)/1000;
  while (millis() - start < 500)
  {
    if (feedgps())
      newdata = true;
  }
  
  if (newdata)
  {
    Serial.println("-------------");
    gpsdump(gps);
  }
}
//-------------------------------------------------------
void printFloat(double number, int digits)
{
  if (number < 0.0)
  {
     Serial.print('-');
     number = -number;
  }
  double rounding = 0.5;
  for (uint8_t i=0; i<digits; ++i)
    rounding /= 10.0;  
  number += rounding;
  unsigned long int_part = (unsigned long)number;
  double remainder = number - (double)int_part;
  Serial.print(int_part);
  if (digits > 0)
    Serial.print(".");
  while (digits-- > 0)
  {
    remainder *= 10.0;
    int toPrint = int(remainder);
    Serial.print(toPrint);
    remainder -= toPrint; 
  } 
}
//-------------------------------------------------------------------
void gpsdump(TinyGPS &gps)
{
  long lat, lon;
  float flat, flon;
  unsigned long age, date, time, chars;
  int year;
  byte month, day, hour, minute, second, hundredths;
  unsigned short sentences, failed;
  
  feedgps();
  gps.f_get_position(&flat, &flon);   
     printFloat(flat, 5); Serial.print(" N, "); // Latitude  
     printFloat(flon, 5);Serial.println(" E");  // Longitude  
  gps.crack_datetime(&year, &month, &day, &hour, &minute, &second, &hundredths);
     Serial.print(static_cast<int>(day)); Serial.print("-"); Serial.print(static_cast<int>(month)); Serial.print("-"); Serial.print(year); Serial.print(" "); // Data 
     Serial.print(static_cast<int>(hour)); Serial.print(":"); Serial.print(static_cast<int>(minute)); Serial.print(":"); Serial.println(static_cast<int>(second)); // Time
     printFloat(gps.f_course()); Serial.println("''"); // Course
     printFloat(gps.f_speed_mps()); Serial.println(" m/s"); // Speed
}
//---------------------------------------------------------------------  
bool feedgps()
{
  while (Serial1.available())
  {
    if (gps.encode(Serial1.read()))
      return true;
  }
  return false;
}
