#if !defined(__WGASCII_H_INCLUDED__)
#define __WGASCII_H_INCLUDED__

#include "wg12232.h"

/**
 * Simple ASCII sign-generator for WG12232 LCD.
 *
 * Each symbol has 5x8 pixel size with 6x8 pixel sign-space (20x4 display).
 * Top left angle is (1,0), right bottom angle (120x31).
 * Start Display Line shift used for vertical scrolling.
 * It displays ASCII codes from 32 to 127 (127 is smile symbol) and '\n' for new line.
 */
class WgAscii
{
public:
  WgAscii();

  /**
   * To print new line character ('\n').
   */
  void newLine();

  /**
   * To print character.
   * \param ch ASCII code (32..127) or '\n' for new line.
   */
  void printChar(char ch);

  /**
   * To print string.
   * \param str Pointer to string.
   */
  void print(const char* str);

  /**
   * To set cursor at new position pointed by column and row numbers.
   * \param col Column number (0..19).
   * \param row Row number (0..3).
   */
  void setCursor(uint8_t col, uint8_t row);

  /**
   * To scroll display for 1 row up.
   */
  void scrollLineUp();
protected:
  static uint8_t m_xpm[][5];
  static uint8_t m_chip;
  static uint8_t m_col;
  static uint8_t m_page;
  static uint8_t m_sdl;
protected:
  bool isLastPage(uint8_t page);
};

extern WgAscii wgascii;

#endif // __WGASCII_H_INCLUDED__
