#include "wgascii.h"

#if defined(WGARDUINO_DBPINS)
/* 
 * This mode is not tested. And not implemented (see wg12232.cpp).
 * My Arduino Duemilanove has only 14 pins for digital output 
 * and first seven of them are PORTD of ATmega168/ATmega328p.
 * So I simply used PORTD as 8-bit parallel port. At least this is fast.
 */
#undef WGARDUINO_DBPINS 
#endif

/**
 * Arduino <--> WG12232 configuration structure.
 * Names for pins used from WG12232 datasheet.
 */
WgArduinoConf wg_arduino_conf = {
#if defined(WGARDUINO_DBPINS)
  0,					// int db0pin;
  1,					// int db1pin;
  2,					// int db2pin;
  3,					// int db3pin;
  4,					// int db4pin;
  5,					// int db5pin;
  6,					// int db6pin;
  7,					// int db7pin;
#else // WGARDUINO_DBPINS
  &PORTD,				// volatile uint8_t *dbPORT;
  &DDRD,				// volatile uint8_t *dbDDR;
  &PIND,				// volatile uint8_t *dbPIN;
  {					/* 
					 * PWM timers on pins of PORTD
					 * WGARDUINO_DBPINS_PWM_TIMERS defines number of timers
					 */
    { &TCCR2A, COM2B1 },		// PWM on pin 3
    { &TCCR0A, COM0B1 },		// PWM on pin 5 and 6
    { &TCCR0A, COM0A1 }
  },
#endif // WGARDUINO_DBPINS
  13,					// int a0pin;
  8,					// int rwPin;
  9,					// int ePin;
  10,					// int clPin;
  12,					// int cs1pin;
  11					// int cs2pin;
};

void setup()
{
    wglcd.setup();
}

void (*loop_pgm)() = loop_pgm_printAscii;	// Loop program function

/**
 * This program fills screen with white or black pixels.
 */
void loop_pgm_fillColumn()
{
  static uint8_t xn  = -1;			// X counter
  static uint8_t val = 0xFF;			// Data byte value (0 for black, 0xFF for white)
  if(++xn > 121) {
    xn = -1;
    val = val ? 0 : 0xFF;
    delay(500);
    wgascii.newLine();				// Switch to next loop program
    loop_pgm = loop_pgm_printAscii;
  }
  else {
    wglcd.fillColumn(xn, val);			// Fill column with data byte value
    delay(10);
  }
}

/**
 * This program prints hello 4 times, then prints ASCII table from 32 to 127.
 */
void loop_pgm_printAscii()
{
  for(uint8_t n = 0; n < 4; ++n) {
    wgascii.print("Hello! ");			// Print hello
    for(uint8_t sm = 0; sm <= n; ++sm)		// Print smiles
      wgascii.printChar(127);
    delay(250);
    wgascii.newLine();				// Print new line
  }
  for(uint8_t n = 32; n < 128; ++n) {		// Print ASCII table
    wgascii.printChar(n);
    delay(100);
  }
  delay(500);
  loop_pgm = loop_pgm_fillColumn;		// Switch to next loop program
}

void loop()
{
  loop_pgm();					// Call current loop program function
}
