#include "wgascii.h"

WgAscii wgascii;

uint8_t WgAscii::m_xpm[][5] = {
{0b0000000,0b0000000,0b0000000,0b0000000,0b0000000},
{0b0000000,0b0000000,0b1011111,0b0000000,0b0000000},
{0b0000000,0b0000011,0b0000000,0b0000011,0b0000000},
{0b0010100,0b0111110,0b0010100,0b0111110,0b0010100},
{0b0001100,0b0101010,0b1101011,0b0101010,0b0011000},
{0b0100110,0b0010110,0b0001000,0b0110100,0b0110010},
{0b1110110,0b1001001,0b1010110,0b0100000,0b1010000},
{0b0000000,0b0000000,0b0000011,0b0000000,0b0000000},
{0b0000000,0b0000000,0b0111110,0b1000001,0b0000000},
{0b0000000,0b1000001,0b0111110,0b0000000,0b0000000},
{0b0001000,0b0101010,0b0011100,0b0101010,0b0001000},
{0b0001000,0b0001000,0b0111110,0b0001000,0b0001000},
{0b0000000,0b1000000,0b0100000,0b0000000,0b0000000},
{0b0001000,0b0001000,0b0001000,0b0001000,0b0000000},
{0b0000000,0b1000000,0b0000000,0b0000000,0b0000000},
{0b0100000,0b0010000,0b0001000,0b0000100,0b0000010},
{0b0111110,0b1010001,0b1001001,0b1000101,0b0111110},
{0b0000000,0b1000010,0b1111111,0b1000000,0b0000000},
{0b1100010,0b1010001,0b1001001,0b1001001,0b1000110},
{0b0100001,0b1001001,0b1001101,0b1001011,0b0110001},
{0b0011000,0b0010100,0b0010010,0b1111111,0b0010000},
{0b0100111,0b1000101,0b1000101,0b1000101,0b0111001},
{0b0111100,0b1001010,0b1001001,0b1001001,0b0110000},
{0b0000001,0b1110001,0b0001001,0b0000101,0b0000011},
{0b0111010,0b1000101,0b1000101,0b1000101,0b0111010},
{0b0000110,0b1001001,0b1001001,0b0101001,0b0011110},
{0b0000000,0b1000100,0b0000000,0b0000000,0b0000000},
{0b0000000,0b1000000,0b0100100,0b0000000,0b0000000},
{0b0000000,0b0001000,0b0010100,0b0100010,0b0000000},
{0b0010100,0b0010100,0b0010100,0b0010100,0b0000000},
{0b0000000,0b0100010,0b0010100,0b0001000,0b0000000},
{0b0000010,0b0000001,0b1010001,0b0001001,0b0000110},
{0b0111110,0b1000001,0b1011101,0b1010101,0b1011110},
{0b1111100,0b0010010,0b0010001,0b0010010,0b1111100},
{0b1111111,0b1000101,0b1000101,0b1000101,0b0111010},
{0b0111110,0b1000001,0b1000001,0b1000001,0b0100010},
{0b1111111,0b1000001,0b1000001,0b1000001,0b0111110},
{0b1111111,0b1001001,0b1001001,0b1001001,0b1000011},
{0b1111111,0b0001001,0b0001001,0b0001001,0b0000011},
{0b0111110,0b1000001,0b1001001,0b0101001,0b1111010},
{0b1111111,0b0001000,0b0001000,0b0001000,0b1111111},
{0b0000000,0b1000001,0b1111111,0b1000001,0b0000000},
{0b0100000,0b1000001,0b1000001,0b0111111,0b0000001},
{0b1111111,0b0000100,0b0000100,0b0001010,0b1110001},
{0b1111111,0b1000000,0b1000000,0b1000000,0b1100000},
{0b1111111,0b0000010,0b0001100,0b0000010,0b1111111},
{0b1111111,0b0000100,0b0001000,0b0010000,0b1111111},
{0b0111110,0b1000001,0b1000001,0b1000001,0b0111110},
{0b1111111,0b0001001,0b0001001,0b0001001,0b0000110},
{0b0111110,0b1000001,0b1010001,0b0100001,0b1011110},
{0b1111111,0b0001001,0b0011001,0b0101001,0b1000110},
{0b1000110,0b1001001,0b1001001,0b1001011,0b0110000},
{0b0000011,0b0000001,0b1111111,0b0000001,0b0000011},
{0b0111111,0b1000000,0b1000000,0b1000000,0b0111111},
{0b0001111,0b0110000,0b1000000,0b0110000,0b0001111},
{0b0111111,0b1000000,0b0111000,0b1000000,0b0111111},
{0b1100011,0b0010100,0b0001000,0b0010100,0b1100011},
{0b0000111,0b1001000,0b1110000,0b1001000,0b0000111},
{0b1100011,0b1010001,0b1001001,0b1000101,0b1100011},
{0b0000000,0b0000000,0b1111111,0b1000001,0b0000000},
{0b0000010,0b0000100,0b0001000,0b0010000,0b0100000},
{0b0000000,0b1000001,0b1111111,0b0000000,0b0000000},
{0b0000100,0b0000010,0b0000001,0b0000010,0b0000100},
{0b1000000,0b1000000,0b1000000,0b1000000,0b1000000},
{0b0000000,0b0000001,0b0000010,0b0000100,0b0000000},
{0b0110000,0b1001010,0b1001010,0b1001010,0b1111100},
{0b1111111,0b1001000,0b1001000,0b1001000,0b0110000},
{0b0111000,0b1000100,0b1000100,0b1000100,0b0101000},
{0b0110000,0b1001000,0b1001000,0b1001000,0b1111111},
{0b0111000,0b1010100,0b1010100,0b1010100,0b0011000},
{0b0010000,0b1111110,0b0010001,0b0000110,0b0000000},
{0b0100000,0b1010110,0b1011010,0b1010110,0b0100001},
{0b1111111,0b0010000,0b0001000,0b0001000,0b1110000},
{0b0000000,0b1000100,0b1111101,0b1000000,0b0000000},
{0b1000000,0b1000100,0b0111101,0b0000100,0b0000000},
{0b0000001,0b1111111,0b0001000,0b0010100,0b1100010},
{0b0000000,0b1000001,0b1111111,0b1000000,0b0000000},
{0b1111100,0b0000100,0b1111000,0b0000100,0b1111000},
{0b1111100,0b0001000,0b0000100,0b0000100,0b1111000},
{0b0111000,0b1000100,0b1000100,0b1000100,0b0111000},
{0b1111100,0b0100100,0b0100100,0b0100100,0b0011000},
{0b0011000,0b0100100,0b0100100,0b0100100,0b1111100},
{0b1111100,0b0001000,0b0000100,0b0000100,0b0000000},
{0b1001000,0b1010100,0b1010100,0b1010100,0b0100000},
{0b0000100,0b0111111,0b1000100,0b1000000,0b0100000},
{0b0111100,0b1000000,0b1000000,0b0100000,0b1111100},
{0b0001100,0b0110000,0b1000000,0b0110000,0b0001100},
{0b0111100,0b1000000,0b0111000,0b1000000,0b0111100},
{0b1000100,0b0101000,0b0010000,0b0101000,0b1000100},
{0b0001100,0b0010000,0b1010000,0b1010000,0b0111100},
{0b1000100,0b1100100,0b1010100,0b1001100,0b1000100},
{0b0000000,0b0001000,0b1110111,0b1000001,0b0000000},
{0b0000000,0b0000000,0b1111111,0b0000000,0b0000000},
{0b0000000,0b1000001,0b1110111,0b0001000,0b0000000},
{0b0000110,0b0000001,0b0000010,0b0000100,0b0000011},
{0b0111110,0b1101011,0b1101111,0b1101011,0b0101110}
};

uint8_t WgAscii::m_chip   = WGLCD_CHIP1;
uint8_t WgAscii::m_col    = 1;
uint8_t WgAscii::m_page   = 0;
uint8_t WgAscii::m_sdl    = 0;

WgAscii::WgAscii()
{
}

bool WgAscii::isLastPage(uint8_t page)
{
  uint8_t startPage = m_sdl / 8;
  uint8_t endPage   = (startPage + 3) % 4;
  return (page == endPage);
}

void WgAscii::newLine()
{
    if(isLastPage(m_page))
      scrollLineUp();
    else {
      m_chip = WGLCD_CHIP1;
      m_col  = 1;
      if(++m_page > 3)
        m_page = 0;
    }
}

void WgAscii::printChar(char ch)
{
  if(ch == '\n')
    return newLine();
  if(ch < 32 || ch > 127)
    ch = 127;
  wglcd.selectChip(m_chip);
  wglcd.selectPage(m_page); 
  wglcd.selectColumn(m_col);
  wglcd.beginRMW();
  for(uint8_t n = 0; n < 5; ++n) {
    wglcd.dummyRead();
    wglcd.writeChar(m_xpm[ch-32][n]);
  }
  wglcd.dummyRead();
  wglcd.writeChar(0);
  wglcd.endRMW();
  m_col += 6;
  if(m_col >= 60) {
    if(m_chip == WGLCD_CHIP1) {
      m_chip = WGLCD_CHIP2;
      m_col -= 61;
    }
    else 
      newLine();
  }
}

void WgAscii::print(const char* str)
{
  for(uint8_t n = 0; str[n] != 0; ++n)
    printChar(str[n]);
}

void WgAscii::setCursor(uint8_t col, uint8_t row)
{
  uint8_t x = col * 6 + 1;
  if(x > 121)
    x = 0;
  m_page = (row > 3) ? 0 : row;
  m_chip = WgLCD::chipFromX(x);
  m_col  = WgLCD::columnFromX(x);
}

void WgAscii::scrollLineUp()
{
  for(uint8_t n = 0; n < 8; ++n) {
    if(++m_sdl > 31)
      m_sdl = 0;
    wglcd.selectChip(WGLCD_CHIP1);
    wglcd.setSDL(m_sdl);
    wglcd.selectChip(WGLCD_CHIP2);
    wglcd.setSDL(m_sdl);
    wglcd.fillRow(31, 0);
  }
  m_chip = WGLCD_CHIP1;
  if(++m_page > 3)
    m_page = 0;
  m_col  = 1;
}
