/*
  AVCLanDrv.cpp - AVCLan Navi library for 'duino / Wiring
  Created by Kochetkov Aleksey, 06.04.2010
  Version 0.1.1
*/

#include "AVCLanDrv.h"
#include "AVCLanNavi.h"
#include <avr/pgmspace.h>

AvcInMessageTable  mtMain[] PROGMEM = {

  {ACT_ZAPROS3,    		0x04, {0x00, 0x12, 0x58, 0x8F}},
  {ACT_KEY_FM,    		0x04, {0x00, 0x25, 0x5A, 0x80}},
  {ACT_PLAY_REQ1,    	0x04, {0x00, 0x25, 0x63, 0x80}},
  
  {ACT_LANR1,    		0x04, {0x00, 0x31, 0x63, 0xE0}}, // статус
  {ACT_LANR2,    		0x04, {0x00, 0x31, 0x63, 0xE2}},
  {ACT_LANR3,    		0x04, {0x00, 0x31, 0x63, 0xE4}},
  
  {ACT_ZAPROS4,    		0x04, {0x00, 0x32, 0x57, 0xE0}},
  {ACT_ZAPROS2,    		0x04, {0x00, 0x32, 0x58, 0xE0}},
  {ACT_ZAPROS6,    		0x04, {0x00, 0x56, 0x58, 0x8E}},
  
  {ACT_ZAPROS12,    	0x06, {0x00, 0x12, 0x57, 0x42, 0x0A, 0x01}},
  {ACT_ZAPROS_INFO,    	0x06, {0x00, 0x12, 0x57, 0x43, 0x0A, 0x00}}, // 06001257430A00
  {ACT_ZAPROS14,    	0x06, {0x00, 0x12, 0x58, 0x42, 0x02, 0x01}},
  {ACT_ZAPROS15,    	0x06, {0x00, 0x12, 0x58, 0x42, 0xC2, 0x01}},
  {ACT_ZAPROS11,    	0x06, {0x00, 0x12, 0x58, 0x43, 0x02, 0x00}},
  {ACT_ZAPROS7,    		0x06, {0x00, 0x12, 0x63, 0x42, 0x01, 0x01}},
  {ACT_STOP_REQ,    	0x06, {0x00, 0x12, 0x63, 0x43, 0x01, 0x00}},
  {ACT_KEY_TEL,    		0x06, {0x00, 0x25, 0x57, 0x80, 0x00, 0x00}}, // 06002557800000
  {ACT_KEY_G,    		0x06, {0x00, 0x25, 0x57, 0x80, 0x00, 0x04}},
  {ACT_KEY_GR,    		0x06, {0x00, 0x25, 0x57, 0x80, 0x00, 0x0C}},
  {ACT_KEY_MAP,			0x06, {0x00, 0x25, 0x58, 0x84, 0x02, 0x00}},//06 00 25 58 84 02 00
  {ACT_KEY_DEST,		0x06, {0x00, 0x25, 0x58, 0x84, 0x04, 0x00}},//06 00 25 58 84 04 00
  {ACT_KEY_MENU,		0x06, {0x00, 0x25, 0x58, 0x84, 0x01, 0x00}},//06 00 25 58 84 01 00

  {ACT_KEY_TOOL,    	0x07, {0x00, 0x25, 0x58, 0x80, 0x01, 0x00, 0x00}},
  {ACT_KEY_CALENDAR,    0x07, {0x00, 0x25, 0x58, 0x80, 0x08, 0x00, 0x00}}, // 0700255880080000 > 178 110 06005812500201
  {ACT_KEY_BUILD,    	0x07, {0x00, 0x25, 0x58, 0x80, 0x02, 0x00, 0x00}}, // < d 110 178 0700255880020000

// broadcast
  {ACT_LAN_BROAD1,    	0x03, {0x00, 0x01, 0x07}},
  {ACT_LAN_REG,     	0x03, {0x12, 0x01, 0x00}},
  {ACT_LAN_INIT,       	0x03, {0x12, 0x01, 0x01}},
};
const byte mtMainSize = sizeof(mtMain) / sizeof(AvcInMessageTable);

AvcInMaskedMessageTable  mtMaskedMain[] PROGMEM = {
	{ACT_LAN_CHECK,    0x04, {0x12, 0x01, 0x20, 0}, _BV(3)},
	{ACT_LAN_CHECK2,   0x05, {0x00, 0x12, 0x01, 0x20, 0}, _BV(4)},
};
const byte mtMaskedMainSize = sizeof(mtMaskedMain) / sizeof(AvcInMaskedMessageTable);


AvcInMessageTable  mtSearchHead[] PROGMEM = {
  {ACT_LAN_REG,  0x03, {0x12, 0x01, 0x00}},           // AVC LAN register
  {ACT_LAN_REG,  0x03, {0x12, 0x01, 0x01}},           // AVC LAN init
  {ACT_LAN_REG,  0x03, {0x01, 0x01, 0x58}},
};
const byte mtSearchHeadSize = sizeof(mtSearchHead) / sizeof(AvcInMessageTable);

// answers
AvcOutMessage CMD_BROAD1	PROGMEM = {AVC_MSG_DIRECT,	0x04, {0x00, 0x01, 0x00, 0x17}};

AvcOutMessage CMD_PLAY_OK1	PROGMEM = {AVC_MSG_DIRECT,	0x05, {0x00, 0x63, 0x12, 0x50, 0x01}};
AvcOutMessage CMD_STOP1		PROGMEM = {AVC_MSG_DIRECT,	0x05, {0x00, 0x63, 0x12, 0x53, 0x01}};

AvcOutMessage CmdLanCheckOk PROGMEM = {AVC_MSG_DIRECT,	0x06, {0x00, 0x01, 0x12, 0x30, 0, 	 0xFF}}; // Check, device ok
AvcOutMessage CMD_KEY_G		PROGMEM = {AVC_MSG_DIRECT,	0x06, {0x00, 0x57, 0x12, 0x50, 0x0A, 0x01}}; // 06005712500A01
AvcOutMessage CMD_ZAPROS12	PROGMEM = {AVC_MSG_DIRECT,	0x06, {0x00, 0x57, 0x12, 0x52, 0x0A, 0x01}};
AvcOutMessage CMD_ZAPROS_INFO PROGMEM = {AVC_MSG_DIRECT, 0x06, {0x00, 0x57, 0x12, 0x53, 0x0A, 0x00}};

AvcOutMessage CMD_KEY_NAVI	PROGMEM = {AVC_MSG_DIRECT,	0x06, {0x00, 0x58, 0x12, 0x50, 0x02, 0x01}}; // 06005812500201
AvcOutMessage CMD_ZAPROS14	PROGMEM = {AVC_MSG_DIRECT,	0x06, {0x00, 0x58, 0x12, 0x52, 0x02, 0x01}};
AvcOutMessage CMD_ZAPROS11	PROGMEM = {AVC_MSG_DIRECT,	0x06, {0x00, 0x58, 0x12, 0x53, 0x02, 0x00}};
AvcOutMessage CMD_KEY_FM	PROGMEM = {AVC_MSG_DIRECT,	0x06, {0x00, 0x5A, 0x12, 0x50, 0x02, 0x01}};
AvcOutMessage CMD_ZAPROS7	PROGMEM = {AVC_MSG_DIRECT,	0x06, {0x00, 0x63, 0x12, 0x52, 0x01, 0x01}};

AvcOutMessage CMD_KEY_CALENDAR PROGMEM = {AVC_MSG_DIRECT, 0x07, {0x00, 0x25, 0x58, 0x80, 0x08, 0x00, 0x00}};  // 06005812500201
AvcOutMessage CMD_ZAPROS4	PROGMEM = {AVC_MSG_DIRECT,	0x07, {0x00, 0x57, 0x32, 0xF0, 0x00, 0xC1, 0x30}};
AvcOutMessage CMD_R1		PROGMEM = {AVC_MSG_DIRECT,	0x07, {0x00, 0x63, 0x31, 0xF0, 0x63, 0x00, 0x01}};
AvcOutMessage CMD_R2		PROGMEM = {AVC_MSG_DIRECT,	0x07, {0x00, 0x63, 0x31, 0xF2, 0x63, 0x00, 0x01}};
AvcOutMessage CMD_R3		PROGMEM = {AVC_MSG_DIRECT,	0x07, {0x00, 0x63, 0x31, 0xF4, 0x63, 0x00, 0x01}};

AvcOutMessage CMD_ZAPROS2	PROGMEM = {AVC_MSG_DIRECT,	0x08, {0x00, 0x58, 0x32, 0xF0, 0x8F, 0x84, 0x30, 0x01}};
AvcOutMessage CMD_R4		PROGMEM = {AVC_MSG_DIRECT,	0x0A, {0x63, 0x31, 0xF3, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x02}};
AvcOutMessage CMD_ZAPROS6	PROGMEM = {AVC_MSG_DIRECT,	0x0B, {0x00, 0x58, 0x56, 0x9E, 0x00, 0x12, 0x31, 0x09, 0x00, 0x01, 0xFF}};
AvcOutMessage CMD_REG_NAVI	PROGMEM = {AVC_MSG_DIRECT,	0x0E, {0x00, 0x01, 0x12, 0x10, 0x58, 0x24, 0x5A, 0x85, 0x59, 0x6D, 0x57, 0x68, 0xAE, 0x63}};
AvcOutMessage CMD_ZAPROS3	PROGMEM = {AVC_MSG_DIRECT,	0x0E, {0x00, 0x58, 0x12, 0x9F, 0x02, 0xAE, 0x08, 0x9E, 0x07, 0x4D, 0x73, 0x5F, 0x80, 0x86}};

// AVCLan Navi init, 
void AVCLanNavi::begin(){
	avclan.deviceAddress = 0x0178;
	}

// Use the last received message to determine the corresponding action ID, store it in avclan object
void AVCLanNavi::getActionID(){
	if (avclan.headAddress == 0){
		avclan.actionID = avclan.getActionID(mtSearchHead, mtSearchHeadSize);
	}else{
		avclan.actionID = avclan.getActionID(mtMain, mtMainSize);
		if (avclan.actionID == ACT_NONE) avclan.actionID = avclan.getActionID(mtMaskedMain, mtMaskedMainSize);
	}
}; 

// process action
void AVCLanNavi::processAction(AvcActionID ActionID){
	byte r;
	switch (ActionID){
		case ACT_LAN_REG:
			if (avclan.headAddress == 0) avclan.headAddress = avclan.masterAddress;
			avclan.sendMessage(&CMD_REG_NAVI);
			break;
		case ACT_LAN_INIT:
			if (avclan.headAddress == 0) avclan.headAddress = avclan.masterAddress;
			avclan.sendMessage(&CMD_REG_NAVI);
			break;
		case ACT_LAN_BROAD1:
			if (avclan.headAddress == 0) avclan.headAddress = avclan.masterAddress;
			avclan.sendMessage(&CMD_BROAD1);
			break;
		case ACT_ZAPROS6:
			if (avclan.headAddress == 0) avclan.headAddress = avclan.masterAddress;
			avclan.sendMessage(&CMD_ZAPROS6);
			break;
		case ACT_ZAPROS2:
			if (avclan.headAddress == 0) avclan.headAddress = avclan.masterAddress;
			avclan.sendMessage(&CMD_ZAPROS2);
			break;
		case ACT_ZAPROS3:
			if (avclan.headAddress == 0) avclan.headAddress = avclan.masterAddress;
			avclan.sendMessage(&CMD_ZAPROS3);
			break;
		case ACT_ZAPROS4:
			if (avclan.headAddress == 0) avclan.headAddress = avclan.masterAddress;
			avclan.sendMessage(&CMD_ZAPROS4);
			break;
		case ACT_KEY_G:
			if (avclan.headAddress == 0) avclan.headAddress = avclan.masterAddress;
			avclan.sendMessage(&CMD_KEY_G);
			break;
		case ACT_KEY_GR:
			if (avclan.headAddress == 0) avclan.headAddress = avclan.masterAddress;
			avclan.sendMessage(&CMD_KEY_G);
			break;
		case ACT_KEY_FM:
			if (avclan.headAddress == 0) avclan.headAddress = avclan.masterAddress;
			avclan.sendMessage(&CMD_KEY_FM);
			break;
		case ACT_KEY_TEL:
			if (avclan.headAddress == 0) avclan.headAddress = avclan.masterAddress;
			avclan.sendMessage(&CMD_KEY_G);
			break;
		case ACT_KEY_TOOL:
			if (avclan.headAddress == 0) avclan.headAddress = avclan.masterAddress;
			avclan.sendMessage(&CMD_KEY_NAVI);
			break;
		case ACT_KEY_BUILD:
			if (avclan.headAddress == 0) avclan.headAddress = avclan.masterAddress;
			avclan.sendMessage(&CMD_KEY_NAVI);
			break;
		case ACT_KEY_CALENDAR:
			if (avclan.headAddress == 0) avclan.headAddress = avclan.masterAddress;
			avclan.sendMessage(&CMD_KEY_NAVI);
			break;
		case ACT_KEY_MAP:
			if (avclan.headAddress == 0) avclan.headAddress = avclan.masterAddress;
			avclan.sendMessage(&CMD_KEY_NAVI);
			break;
		case ACT_KEY_DEST:
			if (avclan.headAddress == 0) avclan.headAddress = avclan.masterAddress;
			avclan.sendMessage(&CMD_KEY_NAVI);
			break;
		case ACT_KEY_MENU:
			if (avclan.headAddress == 0) avclan.headAddress = avclan.masterAddress;
			avclan.sendMessage(&CMD_KEY_NAVI);
			break;
			case ACT_ZAPROS7:
			if (avclan.headAddress == 0) avclan.headAddress = avclan.masterAddress;
			avclan.sendMessage(&CMD_ZAPROS7);
			break;
		case ACT_ZAPROS11:
			if (avclan.headAddress == 0) avclan.headAddress = avclan.masterAddress;
			avclan.sendMessage(&CMD_ZAPROS11);
			break;
		case ACT_ZAPROS12:
			if (avclan.headAddress == 0) avclan.headAddress = avclan.masterAddress;
			avclan.sendMessage(&CMD_ZAPROS12);
			break;
		case ACT_ZAPROS_INFO:
			if (avclan.headAddress == 0) avclan.headAddress = avclan.masterAddress;
			avclan.sendMessage(&CMD_ZAPROS_INFO);
			break;
		case ACT_ZAPROS14:
			if (avclan.headAddress == 0) avclan.headAddress = avclan.masterAddress;
			avclan.sendMessage(&CMD_ZAPROS14);
			break;
		case ACT_ZAPROS15:
			if (avclan.headAddress == 0) avclan.headAddress = avclan.masterAddress;
			avclan.sendMessage(&CMD_ZAPROS14);
			break;
		case ACT_PLAY_REQ1:
			if (avclan.headAddress == 0) avclan.headAddress = avclan.masterAddress;
			avclan.sendMessage(&CMD_PLAY_OK1);
			avclan.sendMessage(&CMD_R4);
			break;
		case ACT_STOP_REQ:
			if (avclan.headAddress == 0) avclan.headAddress = avclan.masterAddress;
			avclan.sendMessage(&CMD_STOP1);
			break;
		case ACT_LANR1:
			if (avclan.headAddress == 0) avclan.headAddress = avclan.masterAddress;
			avclan.sendMessage(&CMD_R1);
			break;
		case ACT_LANR2:
			if (avclan.headAddress == 0) avclan.headAddress = avclan.masterAddress;
			avclan.sendMessage(&CMD_R2);
			break;
		case ACT_LANR3:
			if (avclan.headAddress == 0) avclan.headAddress = avclan.masterAddress;
			avclan.sendMessage(&CMD_R3);
			break;

		case ACT_LAN_CHECK:                                   // Lan status 5
			r = avclan.message[3];
			avclan.loadMessage(&CmdLanCheckOk);
			avclan.message[4] = r;
			avclan.sendMessage();
			break;
		case ACT_LAN_CHECK2:                                   // Lan status 5
			r = avclan.message[4];
			avclan.loadMessage(&CmdLanCheckOk);
			avclan.message[4] = r;
			avclan.sendMessage();
			break;
	}
};

// process event
void AVCLanNavi::processEvent(AvcEventID EventID){

};

AVCLanNavi avclanDevice;
























