/*
  AVCLanNavi.h - AVCLan Navi library for 'duino / Wiring
  Created by Kochetkov Aleksey, 16.06.2010
  Version 0.0.1
*/

#ifndef AVCLanNavi_h
#define AVCLanNavi_h

#include <avr/pgmspace.h>
#include "AVCLanDrv.h"
#include "WProgram.h"

#define AVCLANDEVICE_NAME    " Navi"
#define AVCLANDEVICE_VERSION "0.0.1"

// timer1 overflow every 1 sec 
#define TI1_H	(((word)-(F_CPU / 1024)) >> 8)
#define TI1_L	(((word)-(F_CPU / 1024)) & 0xff )

#if defined(__AVR_ATmega8__)
#define ENABLE_TIMER1_INT  (sbi(TIMSK, TOIE1));
#define DISABLE_TIMER1_INT (cbi(TIMSK, TOIE1));
#else
#define ENABLE_TIMER1_INT  (sbi(TIMSK1, TOIE1));
#define DISABLE_TIMER1_INT (cbi(TIMSK1, TOIE1));
#endif


extern AvcOutMessage CmdReset; // reset AVCLan. This causes HU to send ACT_REGISTER
extern AvcOutMessage CmdRegister; // register CD changer
// extern AvcOutMessage *CmdTest; // test message



typedef enum{

ACT_KEY_BUILD = 1,
ACT_KEY_CALENDAR,
ACT_KEY_MAP,
ACT_KEY_DEST,
ACT_KEY_MENU,
ACT_KEY_FM,
ACT_KEY_G,
ACT_KEY_GR,
ACT_KEY_TEL,
ACT_KEY_TOOL,
ACT_LANR1,
ACT_LANR2,
ACT_LANR3,
ACT_LAN_BROAD1,
ACT_LAN_CHECK,
ACT_LAN_CHECK2,
ACT_LAN_INIT,
ACT_LAN_REG,
ACT_PLAY_REQ1,
ACT_STOP_REQ,
ACT_ZAPROS11,
ACT_ZAPROS12,
ACT_ZAPROS14,
ACT_ZAPROS15,
ACT_ZAPROS2,
ACT_ZAPROS3,
ACT_ZAPROS4,
ACT_ZAPROS6,
ACT_ZAPROS7,
ACT_ZAPROS_INFO,

} AvcActionID;

typedef enum{
  EV_STATUS = 1,
} AvcEventID;

class AVCLanNavi{
	public:
	
		byte	hexInc(byte data);
	
		void	begin ();  		             // initialisation, obligatory method
		void	getActionID();               // get action id by recieved message, obligatory method
		void	processAction(AvcActionID);  // process action, obligatory method
		void	processEvent(AvcEventID);    // process event, obligatory method
};
#endif

extern AVCLanNavi avclanDevice;
