unit CopyMain;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, Menus, ComCtrls;



type
  TMainForm = class(TForm)
    Button1: TButton;
    Button2: TButton;
    Button3: TButton;
    ScrollBar1: TScrollBar;
    StatusBar1: TStatusBar;

    procedure CopyBtnClick(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
  private
    procedure WMCopyData(var M: TMessage);message WM_COPYDATA;
    procedure WM_CopyDataTX(Leen:byte);
    { Private declarations }
  protected
    procedure WndProc(var Message: TMessage); override;
  public
    { Public declarations }
  end;

var
  MainForm: TMainForm;



implementation

{$R *.DFM}

uses AboutU, RegMsg;
var
  InData : string ;
  OutData : string ;
// The following declaration is necessary because of an error in
// the declaration of BroadcastSystemMessage() in the Windows unit
function BroadcastSystemMessage(Flags: DWORD; Recipients: PDWORD;
  uiMessage: UINT; wParam: WPARAM; lParam: LPARAM): Longint; stdcall;
  external 'user32.dll';

var
  Recipients: DWORD = BSM_APPLICATIONS;
  RegisterDone : boolean = false;
  HandleClient : hWnd;

procedure TMainForm.WndProc(var Message: TMessage);
begin
  if Message.Msg = WM_AVC_Request then
    begin
      HandleClient := Message.wParam ;
      PostMessage(HandleClient, WM_AVC_Answer, Handle,0);
      RegisterDone := true;
      StatusBar1.Panels[0].Text := ' ' ;

    end
    else inherited WndProc(Message);
end;




procedure TMainForm.CopyBtnClick(Sender: TObject);
begin
  { Call for any listening apps }
  BroadcastSystemMessage(BSF_IGNORECURRENTTASK or BSF_POSTMESSAGE,
    @Recipients, WM_AVC_Answer, Handle, 0);
end;

procedure TMainForm.Button1Click(Sender: TObject);
var
 DataBuffer: TCopyDataStruct;
  Buf: array of byte;

   BufSize: Integer;

begin
  if RegisterDone = true then
    begin
      OutData := '03A201';
      WM_CopyDataTX(3);
    end;
end;

Procedure TMainForm.WMCopyData(var M: TMessage);
{ Handler for WM_COPYDATA message }
var
dd: pAnsiChar;
a : integer;
begin
  { Check wParam to ensure we know WHO sent us the WM_COPYDATA message }
   if M.wParam = HandleClient then
    begin
     InData :=  PChar(PCopyDataStruct(M.lParam)^.lpData);
     if Copy(InData,3,2) = 'A1' then
      begin
       a:= StrToInt('$' + Copy(InData,5,2));
       ScrollBar1.Position := a;
      end;
    end;
end;
procedure TMainForm.WM_CopyDataTX(Leen:byte);
var
   DataBuffer: TCopyDataStruct;
begin
      with DataBuffer do
        begin
          { Fill dwData with registered message as safety check }
          dwData := 0;
          cbData := Leen * 2;
          lpData := PChar(OutData);
        end;
      SendMessage(HandleClient, WM_COPYDATA, Handle, Longint(@DataBuffer));
end;


procedure TMainForm.Button2Click(Sender: TObject);
begin
  if RegisterDone = true then
    begin
      OutData := '03A202';
      WM_CopyDataTX(3);
    end;
end;

procedure TMainForm.Button3Click(Sender: TObject);
begin
  if RegisterDone = true then
    begin
      OutData := '03A204';
      WM_CopyDataTX(3);
    end;
end;

end.
