unit Readmain;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, Menus, StdCtrls, ComCtrls, ExtCtrls;

{ The WM_COPYDATA Windows message is not defined in the 16-bit Messages }
{ unit, although it is available to 16-bit applications running under   }
{ Windows 95 or NT.  This message is discussed in the Win32 API online  }
{ help. }


 type
  TMainForm = class(TForm)
    CheckBox1: TCheckBox;
    CheckBox2: TCheckBox;
    CheckBox3: TCheckBox;
    ScrollBar1: TScrollBar;
    StatusBar1: TStatusBar;
    Timer1: TTimer;

    procedure FormCreate(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure ScrollBar1Change(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);

  private
    procedure OnAppMessage(var M: TMsg; var Handled: Boolean);
    procedure WMCopyData(var M: TMessage); message WM_COPYDATA;
    procedure WM_CopyDataTX(Leen:byte);
  end;

var
  MainForm: TMainForm;

implementation

{$R *.DFM}

uses RegMsg, AboutU;
var
  Recipients: DWORD = BSM_APPLICATIONS;
  RegisterDone : boolean = false;
  HandleServer : hWnd;
  InData : string ;
  OutData : string ;


type
  { The TCopyDataStruct record type is not defined in WinTypes unit, }
  { although it is available in the 16-bit Windows API when running  }
  { under Windows 95 and NT. The lParam of the WM_COPYDATA message   }
  { points to one of these. }
  PCopyDataStruct = ^TCopyDataStruct;
  TCopyDataStruct = record
    dwData: DWORD;
    cbData: DWORD;
    lpData: Pointer;
  end;

procedure TMainForm.OnAppMessage(var M: TMsg; var Handled: Boolean);
{ OnMessage handler for Application object. }
begin
  if M.Message = WM_AVC_Answer then
    begin
     RegisterDone := true;
     StatusBar1.Panels[0].Text := ' ' ;
     Timer1.Enabled := false;
     HandleServer := M.wParam;
  end;
end;

Procedure TMainForm.WMCopyData(var M: TMessage);
{ Handler for WM_COPYDATA message }
var
dd: pAnsiChar;
a : integer;
begin
  { Check wParam to ensure we know WHO sent us the WM_COPYDATA message }
   if M.wParam = HandleServer then
    begin
     InData :=  PChar(PCopyDataStruct(M.lParam)^.lpData);
     if Copy(InData,3,2) = 'A2' then
      begin
       if Copy(InData,5,2)= '01' then CheckBox1.Checked := not CheckBox1.Checked;
       if Copy(InData,5,2)= '02' then CheckBox2.Checked := not CheckBox2.Checked;
       if Copy(InData,5,2)= '04' then CheckBox3.Checked := not CheckBox3.Checked;
      end;
    end;
end;


procedure TMainForm.WM_CopyDataTX(Leen:byte);
var
   DataBuffer: TCopyDataStruct;

begin
      with DataBuffer do
        begin
          { Fill dwData with registered message as safety check }
          dwData := 0;
          cbData := Leen * 2 ;
          lpData := PChar(OutData);
        end;
     SendMessage(HandleServer, WM_COPYDATA, Handle, Longint(@DataBuffer));
end;


procedure TMainForm.FormCreate(Sender: TObject);
begin
  Application.OnMessage := OnAppMessage;
   BroadcastSystemMessage(BSF_IGNORECURRENTTASK or BSF_POSTMESSAGE,@Recipients,
   WM_AVC_Request, Handle, 0);
end;



procedure TMainForm.Button1Click(Sender: TObject);
begin
    BroadcastSystemMessage(BSF_IGNORECURRENTTASK or BSF_POSTMESSAGE,@Recipients,
    WM_AVC_Request, Handle, 0);
end;

procedure TMainForm.ScrollBar1Change(Sender: TObject);
begin
  if RegisterDone then
    begin
      OutData := '02A1' + inttohex (ScrollBar1.Position,2);
      WM_CopyDataTX(3);
    end;
end;

procedure TMainForm.Timer1Timer(Sender: TObject);
begin
    BroadcastSystemMessage(BSF_IGNORECURRENTTASK or BSF_POSTMESSAGE,@Recipients,
    WM_AVC_Request, Handle, 0);
end;

end.
