
#include <glcd.h>
#include <OneWire.h>
#include <DallasTemperature.h>
#include <EEPROM.h>


//#include "ks0108_Mega.h"  // include this for the Arduino Mega other ATmega1280 boards
#include "SystemFont5x7.h"//шрифт 5х7 
#include "legs1.h"//значек(воздух вниз)
#include "both1.h"//значек(воздух вверх-вниз)
#include "screen1.h"//значек(воздух вверх)
#include "side1.h"//значек (воздух вперед)
#include "DS1.h"//шрифт крупный(температура)
#include "WProgram.h"
int address = 0;

#define ONE_WIRE_BUS 50 //датчики на 50 ноге
#define TEMPERATURE_PRECISION 9

OneWire oneWire(ONE_WIRE_BUS);
DallasTemperature sensors(&oneWire);

uint8_t  Thermometer2[8], Thermometer3[8];//адреса датчиков
float  temp2, temp3;// t2 - улица, t3-салон
byte bytes[8];
int err2, err3;
int error=0;
int vent_set=2;

#define m1_l  39 //первый влево (ноги)
#define m1_r  40 //первый вправо (ноги)
#define m2_l  41 //второй влево (боковые)
#define m2_r  42 //второй вправо(стекло)
#define m3_l  43 //третий влево(заслонка горячий-холодный)
#define m3_r  44 //третий вправо(заслонка горячий-холодный)
#define m4_l  45 //рециркуляция
#define m4_r  46 //рециркуляция
#define enl  38 //enable
#define JOY 1 //АЦП джойстик
#define val2 5 //АЦП второго мотора
#define val1 6 //АЦП первого мотора
#define var 7 //АЦП третьего мотора
#define DeltaConst 10
int16_t vars[16]={132,144,162,206,275,342,396,451,506,561,620,685,760,805,856,896};
#define vent 31 //ШИМ вентилятора


int res_dt1;//панель кнопок управления
int motor1, motor2, motor3;//АЦП приводов
int min_2 = 185; //боковые
int max_2 = 450; //стекло
int centr_1 = 310; //среднее первый
int min_1 = 310; //ноги
int max_1 = 490; //ноги закрыто
int centr_2 = 370; //среднее второй
int vent_s=3;
int vent_speed=3;
int t=5, f=0;
int flow=5;
int temp_s=17;
unsigned long time;


void setup(void)
{
  pinMode(m1_l,OUTPUT); 
  pinMode(m1_r,OUTPUT);
  pinMode(m2_l,OUTPUT); 
  pinMode(m2_r,OUTPUT);
  pinMode(m3_l,OUTPUT);
  pinMode(m3_r,OUTPUT);
  pinMode(m4_l,OUTPUT);
  pinMode(m4_r,OUTPUT);
  pinMode(enl,OUTPUT);
  pinMode(vent,OUTPUT);
  digitalWrite(m1_l,LOW);
  digitalWrite(m1_r,LOW);
  digitalWrite(m2_l,LOW);
  digitalWrite(m2_r,LOW);
  digitalWrite(m3_l,LOW);
  digitalWrite(m3_r,LOW);
  digitalWrite(enl,HIGH);
  digitalWrite(vent,LOW );
  sensors.begin();
  Serial.begin(115200);
  TCCR2B = TCCR2B & 0b11111000 | 0x04;

  //devices=sensors.getDeviceCount();//считаем сколько датчиков подключено  
  if (!sensors.getAddress(Thermometer2, 2)) err2=1;//ошибка. нет датчика 2 - улица
  if (!sensors.getAddress(Thermometer3, 3)) err3=1;//ошибка. нет датчика 3 - салон

  sensors.setResolution(Thermometer2, 9);
  sensors.setResolution(Thermometer3, 9);

  GLCD.Init(NON_INVERTED);   // initialise the library, non inverted writes pixels onto a clear screen
  GLCD.ClearScreen(); 
  GLCD.SelectFont(System5x7);
  GLCD.CursorTo(0,5);
  GLCD.Puts("OUTSIDE:");
  GLCD.CursorTo(0,6);
  GLCD.Puts("VENT SPEED:");

  /*
  if(analogRead(val1) > max_1-10 && analogRead(val2) < min_2+10) flow=2;
   if(analogRead(val1) > max_1-10 && analogRead(val2) > max_2-10) flow=0;
   if(analogRead(val1) > min_1-10 && analogRead(val1) < min_1+10) flow=1; 
    */

  temp_s = EEPROM.read(address);//читаем заданую температуру из еепром
  bytes[0] = 0xFF; 
  bytes[1] = temp_s;
  bytes[2] = flow;
  bytes[3] = 0;
  Serial.write( bytes,4);//отправляем ее в комп
  Serial.println(analogRead(var)); 
}

void loop(void)
{ 
   res_dt1 = analogRead(JOY); // прочитать данные АЦП
   buttons();
   motor1 = analogRead(val1); // прочитать данные АЦП 
   motor2 = analogRead(val2); // прочитать данные АЦП
   motor3 = analogRead(var); // прочитать данные АЦП 
   
  
  byte a, b;
  if (Serial.available() > 1)
   { 
    a = Serial.read();  
    b = Serial.read();
    if(a==0x64)temp_s=b;
    if(a==0xFF)f=b;
    if(a==0x78)vent_s=b*10;
  }

  analogWrite(vent, vent_s);//вентилятор
  if ((millis()-time)>500 && res_dt1 == 1023) //запуск процедур по таймеру
  {    
    time = millis();
    termometer();
  }
  motors();
  lcd(); 
  vent_speed=vent_s/17; 
}

void termometer()
{
  int m0, m1, m;
  sensors.requestTemperatures();
  temp2 = sensors.getTempC(Thermometer2);
  temp3 = sensors.getTempC(Thermometer3);

  if(temp3<0)
  {
    m0=1;
    temp3=-temp3;
  }
  else m0=0;

  if(temp2<0)
  {
    m1=1;
    temp2=-temp2;
  }
  else m1=0;

  m=m0*10+m1;

  bytes[0] = 0x64; //префикс
  bytes[1] = temp3; //салон
  bytes[2] = m;
  bytes[3] = temp2; //улица
  Serial.write( bytes,4);
}
 
 void motors()
{
  if(temp_s)//
  {
  int8_t TempIndex=(temp_s-10)/2;//при temp_s=10 на выходе 0, при temp_s=40 на выходе 15.
  int16_t var_n=vars[TempIndex]; // получили var_n
  int16_t CurrentInput=analogRead(var); //получили положение 

  if (CurrentInput<var_n+DeltaConst)
    digitalWrite(m3_r,HIGH);
  else
    digitalWrite(m3_r,LOW);
  if (CurrentInput>var_n-DeltaConst)
    digitalWrite(m3_l,HIGH);
  else
    digitalWrite(m3_l,LOW);
  }
  
  if(flow==0)//стекло
  {
    if (analogRead(val2)<max_2)digitalWrite(m2_r,HIGH);
    else digitalWrite(m2_r,LOW);
    if (analogRead(val1)<max_1)digitalWrite(m1_l,HIGH);
    else digitalWrite(m1_l,LOW);
    
  }

  if(flow==1)//в ноги
  {
    if (analogRead(val1)>min_1)digitalWrite(m1_r,HIGH);
    else digitalWrite(m1_r,LOW);
  }
  if(flow==2)//боковые
  {
    if (analogRead(val2)>min_2)digitalWrite(m2_l,HIGH);
    else digitalWrite(m2_l,LOW);
    if (analogRead(val1)<max_1)digitalWrite(m1_l,HIGH);
    else digitalWrite(m1_l,LOW);
  }
  if(flow==3)//стекло и ноги 
  {
    if (analogRead(val2)<max_2)digitalWrite(m2_r,HIGH);
    else digitalWrite(m2_r,LOW);
    if (analogRead(val1)>min_1)digitalWrite(m1_r,HIGH);
    else digitalWrite(m1_r,LOW);
  }
 
}

void buttons()
{
  if(res_dt1>=715 && res_dt1<=725)//temp_s++. кнопка VOL UP
  {
    if(temp_s<40)
    {
     temp_s=temp_s+2;
      delay(30);
    }
    bytes[0] = 0x5A; //префикс
    bytes[1] = temp_s;
    bytes[2] = 0;
    bytes[3] = 0; 
    Serial.write( bytes,4);
    delay(150);
   }
   
  if(res_dt1>=635 && res_dt1<=645)//temp_s--. кнопка VOL DOWN
  {  
     if(temp_s>10)
    {
     temp_s=temp_s-2;
     delay(30);
    }
    bytes[0] = 0x5A; //префикс
    bytes[1] = temp_s;
    bytes[2] = 0;
    bytes[3] = 0; 
    Serial.write( bytes,4);
    delay(150);
  }
  
  if(res_dt1>=176 && res_dt1<=186)//кнопка SOURCE
  {
    EEPROM.write(address, temp_s);//пишем в еепром temp_set
    delay(500);
  }

  if(res_dt1>=556 && res_dt1<=566)//vent_s ++. кнопка TRACK UP
  {
    vent_s=vent_s+10;
    delay(30);
    if(vent_s > 250)vent_s=255;
    bytes[0] = 0xC8; //префикс
    bytes[1] = vent_s/10;
    bytes[2] = 0;
    bytes[3] = 0;
    Serial.write( bytes,4);
    delay(80);
  }

  if(res_dt1>=475 && res_dt1<=485)//vent_s --. кнопка TRACK DOWN
  {
    vent_s=vent_s-10;
    delay(30);
    if(vent_s <=0)vent_s=0;
    bytes[0] = 0xC8; //префикс
    bytes[1] = vent_s/10;
    bytes[2] = 0;
    bytes[3] = 0;
    Serial.write( bytes,4);
    delay(80);
  }

  if((res_dt1>=843 && res_dt1<=853) || f==0)// на стекло. кнопка MODE
  {
    flow=0;
    f=5;
    bytes[0] = 0x4B;
    bytes[1] = flow;
    bytes[2] = 0;
    bytes[3] = 0; 
    Serial.write( bytes,4);
    delay(80);
  }

  if((res_dt1>=401 && res_dt1<=411) || f==1)//в ноги. кнопка FILE
  {
    flow=1;
    f=5;
    bytes[0] = 0x4B;
    bytes[1] = flow;
    bytes[2] = 0;
    bytes[3] = 0; 
    Serial.write( bytes,4);
    delay(80);
  }

  if((res_dt1>=784 && res_dt1<=794) || f==2)//боковые. кнопка SEL
  {
    flow=2;
    f=5;
    bytes[0] = 0x4B;
    bytes[1] = flow;
    bytes[2] = 0;
    bytes[3] = 0; 
    Serial.write( bytes,4);
    delay(80);
  }

  if((res_dt1>=307 && res_dt1<=327) || f==3)//на стекло и в ноги. кнопка ATT
  {
    flow=3;
    f=5;
    bytes[0] = 0x4B;
    bytes[1] = flow; 
    bytes[2] = 0;
    bytes[3] = 0;
    Serial.write( bytes,4);
    delay(80);
  }
}

 void lcd()
{

  GLCD.SelectFont(DS);
  GLCD.CursorTo(0,0);
  GLCD.PrintNumber(temp3);
  GLCD.Puts("/  ");
  if(temp_s>=10)GLCD.CursorTo(5,0);
  else GLCD.CursorTo(6,0);
  GLCD.PrintNumber(temp_s);
  GLCD.Puts("/");
  GLCD.SelectFont(System5x7);
  GLCD.CursorTo(8,5);
  GLCD.PrintNumber(temp2);
  GLCD.Puts(" C");

  int i=0;
  for(i=0;i<vent_speed;i++)
  {
    GLCD.CursorTo(i,7);
    GLCD.Puts("0");
  }
  int j=0;
  for(j=vent_speed;j<15;j++)
  {
    GLCD.CursorTo(j,7);
    GLCD.Puts(" ");
  }

  if(flow==0)GLCD.DrawBitmap(screen, 96,32, BLACK);
  if(flow==1)GLCD.DrawBitmap(legs, 96,32, BLACK);
  if(flow==2)GLCD.DrawBitmap(side, 96,32, BLACK);
  if(flow==3)GLCD.DrawBitmap(both, 96,32, BLACK); 
}

