#include <OneWire.h>
#include <DallasTemperature.h>
#define ONE_WIRE_BUS 12
#define TEMPERATURE_PRECISION 9
#include "WProgram.h"
void setup(void);
void printTemperature(uint8_t deviceAddress[]);
void printData(uint8_t deviceAddress[]);
void loop(void);
OneWire oneWire(ONE_WIRE_BUS);
DallasTemperature sensors(&oneWire);

uint8_t insideThermometer[8], outsideThermometer[8];
int devices=0;

void setup(void)
{
  Serial.begin(115200);
  sensors.begin();
  devices=sensors.getDeviceCount();
  sensors.setResolution(insideThermometer, 9);
  sensors.setResolution(outsideThermometer, 9);
}


void printTemperature(uint8_t deviceAddress[])
{
  float tempC = sensors.getTempC(deviceAddress);
  Serial.print("Temp C: ");
  Serial.print(tempC);
  Serial.print(" Temp F: ");
  Serial.print(DallasTemperature::toFahrenheit(tempC));
}



// main function to print information about a device
void printData(uint8_t deviceAddress[])
{
  printTemperature(deviceAddress);
  Serial.println();
}

void loop(void)
{ 
  sensors.requestTemperatures();

  printData(insideThermometer);
  printData(outsideThermometer);
}


int main(void)
{
	init();

	setup();
    
	for (;;)
		loop();
        
	return 0;
}

