/*
 * Decompiled with CFR 0.152.
 */
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.File;
import java.io.PrintWriter;
import java.util.List;
import processing.core.PApplet;
import processing.core.PFont;
import processing.core.PImage;

public class glcdMakeBitmap
extends PApplet {
    String destinationOffset;
    String aggregateHeader = "allBitmaps.h";
    PImage bitmap;
    PFont aFont;
    DropTarget dt = new DropTarget(this, new DropTargetListener(){

        public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
            dropTargetDragEvent.acceptDrag(1);
        }

        public void dragExit(DropTargetEvent dropTargetEvent) {
        }

        public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
            dropTargetDragEvent.acceptDrag(1);
        }

        public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        }

        public void drop(DropTargetDropEvent dropTargetDropEvent) {
            dropTargetDropEvent.acceptDrop(1);
            Transferable transferable = dropTargetDropEvent.getTransferable();
            DataFlavor[] dataFlavorArray = transferable.getTransferDataFlavors();
            int n = 0;
            while (n < dataFlavorArray.length) {
                try {
                    Object object = transferable.getTransferData(dataFlavorArray[n]);
                    if (object instanceof List) {
                        List list = (List)object;
                        int n2 = 0;
                        while (n2 < list.size()) {
                            Object e = list.get(n2);
                            if (e instanceof File) {
                                File file = (File)e;
                                String string = file.getPath();
                                String string2 = file.getName();
                                glcdMakeBitmap.this.convert(string, string2);
                            }
                            ++n2;
                        }
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                ++n;
            }
        }
    });

    public void setup() {
        this.size(256, 256);
        this.background(255);
        this.noStroke();
        this.aFont = this.createFont("Arial.bold", 12.0f);
        this.textFont(this.aFont);
        this.clearWindow();
        this.destinationOffset = String.valueOf(this.sketchPath("")) + ".." + File.separator + ".." + File.separator;
    }

    public void draw() {
    }

    public void mousePressed() {
        this.listImageHeaderFiles(this.destinationOffset, this.aggregateHeader);
    }

    public void clearWindow() {
        this.fill(255);
        this.rect(0.0f, 0.0f, this.width, this.height);
        this.fill(0);
        this.text("Drop image file (gif, jpg, bmp, tga, png) here", 10.0f, (float)(this.height - 50));
        this.text("Click window to refresh " + this.aggregateHeader, 20.0f, (float)(this.height - 30));
        this.bitmap = null;
    }

    public void convert(String string, String string2) {
        this.clearWindow();
        this.bitmap = this.loadImage(string);
        if (this.bitmap != null) {
            imgData.width = this.bitmap.width;
            imgData.height = this.bitmap.height;
            imgData.pages = (imgData.height + 7) / 8;
            imgData.bytes = imgData.width * imgData.pages;
            imgData.pixels = imgData.width * imgData.height;
            this.image(this.bitmap, 0.0f, 0.0f);
            glcdMakeBitmap.print("Width = ");
            glcdMakeBitmap.println(imgData.width);
            glcdMakeBitmap.print("Height = ");
            glcdMakeBitmap.println(imgData.height);
            glcdMakeBitmap.print("Pages = ");
            glcdMakeBitmap.println(imgData.pages);
            glcdMakeBitmap.print("Image bytes = ");
            glcdMakeBitmap.println(imgData.bytes);
            glcdMakeBitmap.print("Pixels =");
            glcdMakeBitmap.println(imgData.pixels);
            this.bitmap.loadPixels();
            imgData.baseName = this.getBaseName(string);
            imgData.sourceFileName = string2;
            this.writeFile();
            glcdMakeBitmap.println("\nCreated " + imgData.baseName + ".h" + " using " + string2);
            this.text("Created file: " + imgData.baseName + ".h", 20.0f, (float)(this.height - 10));
            this.listImageHeaderFiles(this.destinationOffset, this.aggregateHeader);
        } else {
            glcdMakeBitmap.println("Unable to load image");
            this.text("Unable to load image", 20.0f, (float)(this.height - 10));
        }
    }

    public void writeFile() {
        glcdMakeBitmap.print("Basename = ");
        glcdMakeBitmap.println(imgData.baseName);
        String string = String.valueOf(this.destinationOffset) + imgData.baseName + ".h";
        glcdMakeBitmap.print("Output file name = ");
        glcdMakeBitmap.println(string);
        PrintWriter printWriter = this.createWriter(string);
        printWriter.println("/* " + imgData.baseName + " bitmap file for GLCD library */");
        printWriter.println("/* Bitmap created from " + imgData.sourceFileName + "      */");
        String[] stringArray = new String[]{"", "Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
        printWriter.println("/* Date: " + glcdMakeBitmap.day() + " " + stringArray[glcdMakeBitmap.month()] + " " + glcdMakeBitmap.year() + "      */");
        printWriter.println("/* Image Pixels = " + imgData.pixels + "    */");
        printWriter.println("/* Image Bytes  = " + imgData.bytes + "     */");
        printWriter.println();
        printWriter.println("#include <inttypes.h>");
        printWriter.println("#include <avr/pgmspace.h>");
        printWriter.println();
        printWriter.println("#ifndef " + imgData.baseName + "_H");
        printWriter.println("#define " + imgData.baseName + "_H");
        printWriter.println();
        printWriter.print("static uint8_t ");
        printWriter.print(imgData.baseName);
        printWriter.println("[] PROGMEM = {");
        printWriter.print("  ");
        printWriter.print(imgData.width);
        printWriter.println(", // width");
        printWriter.print("  ");
        printWriter.print(imgData.height);
        printWriter.println(", // height");
        this.stroke(0);
        int n = 0;
        while (n < imgData.pages) {
            printWriter.println("\n  /* page " + n + " (lines " + n * 8 + "-" + (n * 8 + 7) + ") */");
            printWriter.print("  ");
            int n2 = 0;
            while (n2 < imgData.width) {
                printWriter.print("0x" + Integer.toHexString(this.getValue(n2, n)));
                if (n2 == this.width - 1 && n == (this.height + 7) / 8 - 1) {
                    glcdMakeBitmap.println("\n");
                } else {
                    printWriter.print(",");
                }
                if (n2 % 16 == 15) {
                    printWriter.print("\n  ");
                }
                ++n2;
            }
            ++n;
        }
        printWriter.print("\n};\n");
        printWriter.println("#endif");
        printWriter.flush();
        printWriter.close();
    }

    public int getValue(int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        while (n4 < 8) {
            int n5 = n2 * 8 + n4;
            int n6 = n5 * imgData.width + n;
            if (n6 < imgData.width * imgData.height) {
                int n7 = this.bitmap.pixels[n6];
                int n8 = n7 >> 16 & 0xFF;
                int n9 = n7 >> 8 & 0xFF;
                int n10 = n7 & 0xFF;
                if (n8 < 128 || n9 < 128 || n10 < 128) {
                    n3 |= 1 << n4;
                    this.point(n, n5);
                }
            }
            n4 = (byte)(n4 + 1);
        }
        return n3;
    }

    public String getBaseName(String string) {
        File file = new File(string);
        file.getName();
        int n = file.getName().lastIndexOf(46);
        if (n > 0 && n <= file.getName().length() - 2) {
            return file.getName().substring(0, n);
        }
        return "";
    }

    public void listImageHeaderFiles(String string, String string2) {
        String string3 = String.valueOf(string) + string2;
        PrintWriter printWriter = this.createWriter(string3);
        printWriter.println("/* " + string2 + " bitmap header for GLCD library */");
        printWriter.println("/* This file is created automatically by the glcdMakeBitmap utility */");
        printWriter.println("/* Any edits to this file will be lost when glcdMakeBitmap is next run */");
        printWriter.println();
        glcdMakeBitmap.println("\nCreating header file " + string2 + " that includes : ");
        File file = new File(string);
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            int n = 0;
            while (n < fileArray.length) {
                String string4;
                if (!fileArray[n].isDirectory() && (string4 = fileArray[n].getName()).endsWith(".h") && !string4.equals(string2)) {
                    printWriter.println("#include \"" + string4 + '\"');
                    glcdMakeBitmap.println(string4);
                }
                ++n;
            }
        } else {
            glcdMakeBitmap.println(String.valueOf(string) + " is not a directory");
        }
        printWriter.flush();
        printWriter.close();
    }

    public void listImageHeaderFilesX(String string, String string2) {
        File file = new File(string);
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            int n = 0;
            while (n < fileArray.length) {
                String string3;
                File file2 = fileArray[n];
                if (!file2.isDirectory() && (string3 = file2.getName()).endsWith(".h")) {
                    glcdMakeBitmap.println("Name: " + string3);
                }
                ++n;
            }
        } else {
            glcdMakeBitmap.println(String.valueOf(string) + " is not a directory");
        }
    }

    public static void main(String[] stringArray) {
        PApplet.main(new String[]{"--bgcolor=#ece9d8", "glcdMakeBitmap"});
    }

    static class imgData {
        static int width;
        static int height;
        static int pages;
        static int bytes;
        static int pixels;
        static String sourceFileName;
        static String baseName;

        imgData() {
        }
    }
}

