/*
 * Decompiled with CFR 0.152.
 */
package processing.core;

import processing.core.PConstants;
import processing.core.PGraphics3D;
import processing.core.PImage;
import processing.core.PMatrix3D;

public class PSmoothTriangle
implements PConstants {
    private static final boolean EWJORDAN = false;
    private static final boolean FRY = false;
    static final int X = 0;
    static final int Y = 1;
    static final int Z = 2;
    static final int R = 3;
    static final int G = 4;
    static final int B = 5;
    static final int A = 6;
    static final int U = 7;
    static final int V = 8;
    static final int DEFAULT_SIZE = 64;
    float[][] vertices = new float[64][36];
    int vertexCount;
    static final int ZBUFFER_MIN_COVERAGE = 204;
    float[] r = new float[64];
    float[] dr = new float[64];
    float[] l = new float[64];
    float[] dl = new float[64];
    float[] sp = new float[64];
    float[] sdp = new float[64];
    boolean interpX;
    boolean interpZ;
    boolean interpUV;
    boolean interpARGB;
    int rgba;
    int r2;
    int g2;
    int b2;
    int a2;
    int a2orig;
    boolean noDepthTest;
    PGraphics3D parent;
    int[] pixels;
    float[] zbuffer;
    int width;
    int height;
    int width1;
    int height1;
    PImage timage;
    int[] tpixels;
    int theight;
    int twidth;
    int theight1;
    int twidth1;
    int tformat;
    boolean texture_smooth;
    static final int SUBXRES = 8;
    static final int SUBXRES1 = 7;
    static final int SUBYRES = 8;
    static final int SUBYRES1 = 7;
    static final int MAX_COVERAGE = 64;
    boolean smooth;
    int firstModY;
    int lastModY;
    int lastY;
    int[] aaleft = new int[8];
    int[] aaright = new int[8];
    int aaleftmin;
    int aarightmin;
    int aaleftmax;
    int aarightmax;
    int aaleftfull;
    int aarightfull;
    private float[] camX = new float[3];
    private float[] camY = new float[3];
    private float[] camZ = new float[3];
    private float ax;
    private float ay;
    private float az;
    private float bx;
    private float by;
    private float bz;
    private float cx;
    private float cy;
    private float cz;
    private float nearPlaneWidth;
    private float nearPlaneHeight;
    private float nearPlaneDepth;
    private float xmult;
    private float ymult;

    private final int MODYRES(int n) {
        return n & 7;
    }

    public PSmoothTriangle(PGraphics3D pGraphics3D) {
        this.parent = pGraphics3D;
        this.reset(0);
    }

    public void reset(int n) {
        this.vertexCount = n;
        this.interpX = true;
        this.interpZ = true;
        this.interpUV = false;
        this.interpARGB = true;
        this.timage = null;
    }

    public float[] nextVertex() {
        if (this.vertexCount == this.vertices.length) {
            float[][] fArray = new float[this.vertexCount << 1][36];
            System.arraycopy(this.vertices, 0, fArray, 0, this.vertexCount);
            this.vertices = fArray;
            this.r = new float[this.vertices.length];
            this.dr = new float[this.vertices.length];
            this.l = new float[this.vertices.length];
            this.dl = new float[this.vertices.length];
            this.sp = new float[this.vertices.length];
            this.sdp = new float[this.vertices.length];
        }
        return this.vertices[this.vertexCount++];
    }

    public void texture(PImage pImage) {
        this.timage = pImage;
        this.tpixels = pImage.pixels;
        this.twidth = pImage.width;
        this.theight = pImage.height;
        this.tformat = pImage.format;
        this.twidth1 = this.twidth - 1;
        this.theight1 = this.theight - 1;
        this.interpUV = true;
    }

    public void render() {
        int n;
        int n2;
        if (this.vertexCount < 3) {
            return;
        }
        this.smooth = true;
        this.pixels = this.parent.pixels;
        this.zbuffer = this.parent.zbuffer;
        this.noDepthTest = false;
        this.texture_smooth = true;
        this.width = this.smooth ? this.parent.width * 8 : this.parent.width;
        this.height = this.smooth ? this.parent.height * 8 : this.parent.height;
        this.width1 = this.width - 1;
        this.height1 = this.height - 1;
        if (!this.interpARGB) {
            this.r2 = (int)(this.vertices[0][3] * 255.0f);
            this.g2 = (int)(this.vertices[0][4] * 255.0f);
            this.b2 = (int)(this.vertices[0][5] * 255.0f);
            this.a2orig = this.a2 = (int)(this.vertices[0][6] * 255.0f);
            this.rgba = 0xFF000000 | this.r2 << 16 | this.g2 << 8 | this.b2;
        }
        for (n2 = 0; n2 < this.vertexCount; ++n2) {
            this.r[n2] = 0.0f;
            this.dr[n2] = 0.0f;
            this.l[n2] = 0.0f;
            this.dl[n2] = 0.0f;
        }
        if (this.smooth) {
            for (n2 = 0; n2 < this.vertexCount; ++n2) {
                float[] fArray = this.vertices[n2];
                fArray[0] = fArray[0] * 8.0f;
                float[] fArray2 = this.vertices[n2];
                fArray2[1] = fArray2[1] * 8.0f;
            }
            this.firstModY = -1;
        }
        n2 = 0;
        float f = this.vertices[0][1];
        float f2 = this.vertices[0][1];
        for (n = 1; n < this.vertexCount; ++n) {
            if (this.vertices[n][1] < f) {
                f = this.vertices[n][1];
                n2 = n;
            }
            if (!(this.vertices[n][1] > f2)) continue;
            f2 = this.vertices[n][1];
        }
        this.lastY = (int)(f2 - 0.5f);
        n = n2;
        int n3 = n2;
        int n4 = (int)(f + 0.5f);
        int n5 = n4 - 1;
        int n6 = n4 - 1;
        this.interpX = true;
        int n7 = this.vertexCount;
        while (n7 > 0) {
            int n8;
            while (n5 <= n4 && n7 > 0) {
                --n7;
                n8 = n != 0 ? n - 1 : this.vertexCount - 1;
                this.incrementalize_y(this.vertices[n], this.vertices[n8], this.l, this.dl, n4);
                n5 = (int)(this.vertices[n8][1] + 0.5f);
                n = n8;
            }
            while (n6 <= n4 && n7 > 0) {
                --n7;
                n8 = n3 != this.vertexCount - 1 ? n3 + 1 : 0;
                this.incrementalize_y(this.vertices[n3], this.vertices[n8], this.r, this.dr, n4);
                n6 = (int)(this.vertices[n8][1] + 0.5f);
                n3 = n8;
            }
            while (n4 < n5 && n4 < n6) {
                if (n4 >= 0 && n4 < this.height) {
                    if (this.l[0] <= this.r[0]) {
                        this.scanline(n4, this.l, this.r);
                    } else {
                        this.scanline(n4, this.r, this.l);
                    }
                }
                ++n4;
                this.increment(this.l, this.dl);
                this.increment(this.r, this.dr);
            }
        }
    }

    public void unexpand() {
        if (this.smooth) {
            for (int i = 0; i < this.vertexCount; ++i) {
                float[] fArray = this.vertices[i];
                fArray[0] = fArray[0] / 8.0f;
                float[] fArray2 = this.vertices[i];
                fArray2[1] = fArray2[1] / 8.0f;
            }
        }
    }

    private void scanline(int n, float[] fArray, float[] fArray2) {
        int n2;
        int n3;
        int n4;
        for (n4 = 0; n4 < this.vertexCount; ++n4) {
            this.sp[n4] = 0.0f;
            this.sdp[n4] = 0.0f;
        }
        n4 = (int)(fArray[0] + 0.49999f);
        if (n4 < 0) {
            n4 = 0;
        }
        if ((n3 = (int)(fArray2[0] - 0.5f)) > this.width1) {
            n3 = this.width1;
        }
        if (n4 > n3) {
            return;
        }
        if (this.smooth) {
            n2 = this.MODYRES(n);
            this.aaleft[n2] = n4;
            this.aaright[n2] = n3;
            if (this.firstModY == -1) {
                this.firstModY = n2;
                this.aaleftmin = n4;
                this.aaleftmax = n4;
                this.aarightmin = n3;
                this.aarightmax = n3;
            } else {
                if (this.aaleftmin > this.aaleft[n2]) {
                    this.aaleftmin = this.aaleft[n2];
                }
                if (this.aaleftmax < this.aaleft[n2]) {
                    this.aaleftmax = this.aaleft[n2];
                }
                if (this.aarightmin > this.aaright[n2]) {
                    this.aarightmin = this.aaright[n2];
                }
                if (this.aarightmax < this.aaright[n2]) {
                    this.aarightmax = this.aaright[n2];
                }
            }
            this.lastModY = n2;
            if (n2 != 7 && n != this.lastY) {
                return;
            }
            this.aaleftfull = this.aaleftmax / 8 + 1;
            this.aarightfull = this.aarightmin / 8 - 1;
        }
        this.incrementalize_x(fArray, fArray2, this.sp, this.sdp, n4);
        n2 = this.smooth ? this.parent.width * (n / 8) : this.parent.width * n;
        int n5 = 0;
        int n6 = 0;
        if (this.smooth) {
            n5 = n4 / 8;
            n6 = (n3 + 7) / 8;
            n4 = this.aaleftmin / 8;
            n3 = (this.aarightmax + 7) / 8;
            if (n4 < 0) {
                n4 = 0;
            }
            if (n3 > this.parent.width1) {
                n3 = this.parent.width1;
            }
        }
        this.interpX = false;
        for (int i = n4; i <= n3; ++i) {
            if (this.noDepthTest || this.sp[2] <= this.zbuffer[n2 + i]) {
                int n7;
                int n8;
                int n9;
                int n10;
                if (this.interpUV) {
                    int n11;
                    int n12;
                    int n13;
                    int n14;
                    int n15;
                    int n16;
                    int n17;
                    n10 = (int)this.sp[7];
                    n9 = (int)this.sp[8];
                    if (n10 > this.twidth1) {
                        n10 = this.twidth1;
                    }
                    if (n9 > this.theight1) {
                        n9 = this.theight1;
                    }
                    if (n10 < 0) {
                        n10 = 0;
                    }
                    if (n9 < 0) {
                        n9 = 0;
                    }
                    n8 = n9 * this.twidth + n10;
                    float[] fArray3 = new float[2];
                    n8 = this.getTextureIndex(i, (float)n * 1.0f / 8.0f, fArray3);
                    n10 = (int)fArray3[0];
                    n9 = (int)fArray3[1];
                    n8 = this.twidth * n9 + n10;
                    if (this.smooth || this.texture_smooth) {
                        int n18;
                        int n19;
                        int n20;
                        int n21;
                        int n22;
                        int n23;
                        int n24;
                        int n25;
                        n7 = (int)(255.0f * (fArray3[0] - (float)n10));
                        n17 = (int)(255.0f * (fArray3[1] - (float)n9));
                        n16 = 255 - n7;
                        n15 = 255 - n17;
                        int n26 = this.tpixels[n8];
                        int n27 = n9 < this.theight1 ? this.tpixels[n8 + this.twidth] : this.tpixels[n8];
                        int n28 = n10 < this.twidth1 ? this.tpixels[n8 + 1] : this.tpixels[n8];
                        int n29 = n25 = n9 < this.theight1 && n10 < this.twidth1 ? this.tpixels[n8 + this.twidth + 1] : this.tpixels[n8];
                        if (this.tformat == 4) {
                            n24 = n26 * n16 + n28 * n7 >> 8;
                            n23 = n27 * n16 + n25 * n7 >> 8;
                            n14 = (n24 * n15 + n23 * n17 >> 8) * (this.interpARGB ? (int)(this.sp[6] * 255.0f) : this.a2orig) >> 8;
                        } else if (this.tformat == 2) {
                            n22 = n26 >> 24 & 0xFF;
                            n21 = n27 >> 24 & 0xFF;
                            n20 = n28 >> 24 & 0xFF;
                            n19 = n25 >> 24 & 0xFF;
                            n24 = n22 * n16 + n20 * n7 >> 8;
                            n23 = n21 * n16 + n19 * n7 >> 8;
                            n14 = (n24 * n15 + n23 * n17 >> 8) * (this.interpARGB ? (int)(this.sp[6] * 255.0f) : this.a2orig) >> 8;
                        } else {
                            int n30 = n14 = this.interpARGB ? (int)(this.sp[6] * 255.0f) : this.a2orig;
                        }
                        if (this.tformat == 1 || this.tformat == 2) {
                            n22 = n26 >> 16 & 0xFF;
                            n21 = n27 >> 16 & 0xFF;
                            n20 = n28 >> 16 & 0xFF;
                            n19 = n25 >> 16 & 0xFF;
                            n24 = n22 * n16 + n20 * n7 >> 8;
                            n23 = n21 * n16 + n19 * n7 >> 8;
                            n13 = (n24 * n15 + n23 * n17 >> 8) * (this.interpARGB ? (int)(this.sp[3] * 255.0f) : this.r2) >> 8;
                            n22 = n26 >> 8 & 0xFF;
                            n21 = n27 >> 8 & 0xFF;
                            n20 = n28 >> 8 & 0xFF;
                            n19 = n25 >> 8 & 0xFF;
                            n24 = n22 * n16 + n20 * n7 >> 8;
                            n23 = n21 * n16 + n19 * n7 >> 8;
                            n12 = (n24 * n15 + n23 * n17 >> 8) * (this.interpARGB ? (int)(this.sp[4] * 255.0f) : this.g2) >> 8;
                            n22 = n26 & 0xFF;
                            n21 = n27 & 0xFF;
                            n20 = n28 & 0xFF;
                            n19 = n25 & 0xFF;
                            n24 = n22 * n16 + n20 * n7 >> 8;
                            n23 = n21 * n16 + n19 * n7 >> 8;
                            n11 = (n24 * n15 + n23 * n17 >> 8) * (this.interpARGB ? (int)(this.sp[5] * 255.0f) : this.b2) >> 8;
                        } else if (this.interpARGB) {
                            n13 = (int)(this.sp[3] * 255.0f);
                            n12 = (int)(this.sp[4] * 255.0f);
                            n11 = (int)(this.sp[5] * 255.0f);
                        } else {
                            n13 = this.r2;
                            n12 = this.g2;
                            n11 = this.b2;
                        }
                        int n31 = n18 = this.smooth ? this.coverage(i) : 255;
                        if (n18 != 255) {
                            n14 = n14 * n18 >> 8;
                        }
                    } else {
                        n7 = this.tpixels[n8];
                        if (this.tformat == 4) {
                            n14 = n7;
                            if (this.interpARGB) {
                                n13 = (int)(this.sp[3] * 255.0f);
                                n12 = (int)(this.sp[4] * 255.0f);
                                n11 = (int)(this.sp[5] * 255.0f);
                                if (this.sp[6] != 1.0f) {
                                    n14 = (int)(this.sp[6] * 255.0f) * n14 >> 8;
                                }
                            } else {
                                n13 = this.r2;
                                n12 = this.g2;
                                n11 = this.b2;
                                n14 = this.a2orig * n14 >> 8;
                            }
                        } else {
                            int n32 = n14 = this.tformat == 1 ? 255 : n7 >> 24 & 0xFF;
                            if (this.interpARGB) {
                                n13 = (int)(this.sp[3] * 255.0f) * (n7 >> 16 & 0xFF) >> 8;
                                n12 = (int)(this.sp[4] * 255.0f) * (n7 >> 8 & 0xFF) >> 8;
                                n11 = (int)(this.sp[5] * 255.0f) * (n7 & 0xFF) >> 8;
                                n14 = (int)(this.sp[6] * 255.0f) * n14 >> 8;
                            } else {
                                n13 = this.r2 * (n7 >> 16 & 0xFF) >> 8;
                                n12 = this.g2 * (n7 >> 8 & 0xFF) >> 8;
                                n11 = this.b2 * (n7 & 0xFF) >> 8;
                                n14 = this.a2orig * n14 >> 8;
                            }
                        }
                    }
                    if (n14 == 254 || n14 == 255) {
                        this.pixels[n2 + i] = 0xFF000000 | n13 << 16 | n12 << 8 | n11;
                        this.zbuffer[n2 + i] = this.sp[2];
                    } else {
                        n7 = 255 - n14;
                        n17 = this.pixels[n2 + i] >> 16 & 0xFF;
                        n16 = this.pixels[n2 + i] >> 8 & 0xFF;
                        n15 = this.pixels[n2 + i] & 0xFF;
                        this.pixels[n2 + i] = 0xFF000000 | n13 * n14 + n17 * n7 >> 8 << 16 | n12 * n14 + n16 * n7 & 0xFF00 | n11 * n14 + n15 * n7 >> 8;
                        if (n14 > 204) {
                            this.zbuffer[n2 + i] = this.sp[2];
                        }
                    }
                } else {
                    int n33 = n10 = this.smooth ? this.coverage(i) : 255;
                    if (this.interpARGB) {
                        this.r2 = (int)(this.sp[3] * 255.0f);
                        this.g2 = (int)(this.sp[4] * 255.0f);
                        this.b2 = (int)(this.sp[5] * 255.0f);
                        if (this.sp[6] != 1.0f) {
                            n10 = n10 * (int)(this.sp[6] * 255.0f) >> 8;
                        }
                        if (n10 == 255) {
                            this.rgba = 0xFF000000 | this.r2 << 16 | this.g2 << 8 | this.b2;
                        }
                    } else if (this.a2orig != 255) {
                        n10 = n10 * this.a2orig >> 8;
                    }
                    if (n10 == 255) {
                        this.pixels[n2 + i] = this.rgba;
                        this.zbuffer[n2 + i] = this.sp[2];
                    } else {
                        n9 = this.pixels[n2 + i] >> 16 & 0xFF;
                        n8 = this.pixels[n2 + i] >> 8 & 0xFF;
                        int n34 = this.pixels[n2 + i] & 0xFF;
                        this.a2 = n10;
                        n7 = 255 - this.a2;
                        this.pixels[n2 + i] = 0xFF000000 | n9 * n7 + this.r2 * this.a2 >> 8 << 16 | n8 * n7 + this.g2 * this.a2 >> 8 << 8 | n34 * n7 + this.b2 * this.a2 >> 8;
                        if (this.a2 > 204) {
                            this.zbuffer[n2 + i] = this.sp[2];
                        }
                    }
                }
            }
            if (this.smooth && (i < n5 || i > n6)) continue;
            this.increment(this.sp, this.sdp);
        }
        this.firstModY = -1;
        this.interpX = true;
    }

    private int coverage(int n) {
        if (n >= this.aaleftfull && n <= this.aarightfull && this.firstModY == 0 && this.lastModY == 7) {
            return 255;
        }
        int n2 = n * 8;
        int n3 = n2 + 8;
        int n4 = 0;
        for (int i = this.firstModY; i <= this.lastModY; ++i) {
            if (this.aaleft[i] > n3 || this.aaright[i] < n2) continue;
            n4 += (this.aaright[i] < n3 ? this.aaright[i] : n3) - (this.aaleft[i] > n2 ? this.aaleft[i] : n2);
        }
        return (n4 <<= 2) == 256 ? 255 : n4;
    }

    private void incrementalize_y(float[] fArray, float[] fArray2, float[] fArray3, float[] fArray4, int n) {
        float f = fArray2[1] - fArray[1];
        if (f == 0.0f) {
            f = 1.0f;
        }
        float f2 = (float)n + 0.5f - fArray[1];
        if (this.interpX) {
            fArray4[0] = (fArray2[0] - fArray[0]) / f;
            fArray3[0] = fArray[0] + fArray4[0] * f2;
        }
        if (this.interpZ) {
            fArray4[2] = (fArray2[2] - fArray[2]) / f;
            fArray3[2] = fArray[2] + fArray4[2] * f2;
        }
        if (this.interpARGB) {
            fArray4[3] = (fArray2[3] - fArray[3]) / f;
            fArray4[4] = (fArray2[4] - fArray[4]) / f;
            fArray4[5] = (fArray2[5] - fArray[5]) / f;
            fArray4[6] = (fArray2[6] - fArray[6]) / f;
            fArray3[3] = fArray[3] + fArray4[3] * f2;
            fArray3[4] = fArray[4] + fArray4[4] * f2;
            fArray3[5] = fArray[5] + fArray4[5] * f2;
            fArray3[6] = fArray[6] + fArray4[6] * f2;
        }
        if (this.interpUV) {
            fArray4[7] = (fArray2[7] - fArray[7]) / f;
            fArray4[8] = (fArray2[8] - fArray[8]) / f;
            fArray3[7] = fArray[7] + fArray4[7] * f2;
            fArray3[8] = fArray[8] + fArray4[8] * f2;
        }
    }

    private void incrementalize_x(float[] fArray, float[] fArray2, float[] fArray3, float[] fArray4, int n) {
        float f = fArray2[0] - fArray[0];
        if (f == 0.0f) {
            f = 1.0f;
        }
        float f2 = (float)n + 0.5f - fArray[0];
        if (this.smooth) {
            f /= 8.0f;
            f2 /= 8.0f;
        }
        if (this.interpX) {
            fArray4[0] = (fArray2[0] - fArray[0]) / f;
            fArray3[0] = fArray[0] + fArray4[0] * f2;
        }
        if (this.interpZ) {
            fArray4[2] = (fArray2[2] - fArray[2]) / f;
            fArray3[2] = fArray[2] + fArray4[2] * f2;
        }
        if (this.interpARGB) {
            fArray4[3] = (fArray2[3] - fArray[3]) / f;
            fArray4[4] = (fArray2[4] - fArray[4]) / f;
            fArray4[5] = (fArray2[5] - fArray[5]) / f;
            fArray4[6] = (fArray2[6] - fArray[6]) / f;
            fArray3[3] = fArray[3] + fArray4[3] * f2;
            fArray3[4] = fArray[4] + fArray4[4] * f2;
            fArray3[5] = fArray[5] + fArray4[5] * f2;
            fArray3[6] = fArray[6] + fArray4[6] * f2;
        }
        if (this.interpUV) {
            fArray4[7] = (fArray2[7] - fArray[7]) / f;
            fArray4[8] = (fArray2[8] - fArray[8]) / f;
            fArray3[7] = fArray[7] + fArray4[7] * f2;
            fArray3[8] = fArray[8] + fArray4[8] * f2;
        }
    }

    private void increment(float[] fArray, float[] fArray2) {
        if (this.interpX) {
            fArray[0] = fArray[0] + fArray2[0];
        }
        if (this.interpZ) {
            fArray[2] = fArray[2] + fArray2[2];
        }
        if (this.interpARGB) {
            fArray[3] = fArray[3] + fArray2[3];
            fArray[4] = fArray[4] + fArray2[4];
            fArray[5] = fArray[5] + fArray2[5];
            fArray[6] = fArray[6] + fArray2[6];
        }
        if (this.interpUV) {
            fArray[7] = fArray[7] + fArray2[7];
            fArray[8] = fArray[8] + fArray2[8];
        }
    }

    public void setCamVertices(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        this.camX[0] = f;
        this.camX[1] = f4;
        this.camX[2] = f7;
        this.camY[0] = f2;
        this.camY[1] = f5;
        this.camY[2] = f8;
        this.camZ[0] = f3;
        this.camZ[1] = f6;
        this.camZ[2] = f9;
    }

    public void setVertices(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        this.vertices[0][0] = f;
        this.vertices[1][0] = f4;
        this.vertices[2][0] = f7;
        this.vertices[0][1] = f2;
        this.vertices[1][1] = f5;
        this.vertices[2][1] = f8;
        this.vertices[0][2] = f3;
        this.vertices[1][2] = f6;
        this.vertices[2][2] = f9;
    }

    boolean precomputeAccurateTexturing() {
        int n = 0;
        int n2 = 1;
        int n3 = 2;
        PMatrix3D pMatrix3D = new PMatrix3D(this.vertices[n][7], this.vertices[n][8], 1.0f, 0.0f, this.vertices[n2][7], this.vertices[n2][8], 1.0f, 0.0f, this.vertices[n3][7], this.vertices[n3][8], 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
        boolean bl = pMatrix3D.invert();
        if (!bl) {
            return false;
        }
        float f = pMatrix3D.m00 * this.camX[n] + pMatrix3D.m01 * this.camX[n2] + pMatrix3D.m02 * this.camX[n3];
        float f2 = pMatrix3D.m10 * this.camX[n] + pMatrix3D.m11 * this.camX[n2] + pMatrix3D.m12 * this.camX[n3];
        float f3 = pMatrix3D.m20 * this.camX[n] + pMatrix3D.m21 * this.camX[n2] + pMatrix3D.m22 * this.camX[n3];
        float f4 = pMatrix3D.m00 * this.camY[n] + pMatrix3D.m01 * this.camY[n2] + pMatrix3D.m02 * this.camY[n3];
        float f5 = pMatrix3D.m10 * this.camY[n] + pMatrix3D.m11 * this.camY[n2] + pMatrix3D.m12 * this.camY[n3];
        float f6 = pMatrix3D.m20 * this.camY[n] + pMatrix3D.m21 * this.camY[n2] + pMatrix3D.m22 * this.camY[n3];
        float f7 = -(pMatrix3D.m00 * this.camZ[n] + pMatrix3D.m01 * this.camZ[n2] + pMatrix3D.m02 * this.camZ[n3]);
        float f8 = -(pMatrix3D.m10 * this.camZ[n] + pMatrix3D.m11 * this.camZ[n2] + pMatrix3D.m12 * this.camZ[n3]);
        float f9 = -(pMatrix3D.m20 * this.camZ[n] + pMatrix3D.m21 * this.camZ[n2] + pMatrix3D.m22 * this.camZ[n3]);
        float f10 = f3;
        float f11 = f6;
        float f12 = f9;
        float f13 = this.twidth;
        float f14 = this.theight;
        float f15 = f * f13 + f3;
        float f16 = f4 * f13 + f6;
        float f17 = f7 * f13 + f9;
        float f18 = f2 * f14 + f3;
        float f19 = f5 * f14 + f6;
        float f20 = f8 * f14 + f9;
        float f21 = f15 - f3;
        float f22 = f16 - f6;
        float f23 = f17 - f9;
        float f24 = f18 - f3;
        float f25 = f19 - f6;
        float f26 = f20 - f9;
        this.ax = (f11 * f26 - f12 * f25) * f13;
        this.ay = (f12 * f24 - f10 * f26) * f13;
        this.az = (f10 * f25 - f11 * f24) * f13;
        this.bx = (f22 * f12 - f23 * f11) * f14;
        this.by = (f23 * f10 - f21 * f12) * f14;
        this.bz = (f21 * f11 - f22 * f10) * f14;
        this.cx = f25 * f23 - f26 * f22;
        this.cy = f26 * f21 - f24 * f23;
        this.cz = f24 * f22 - f25 * f21;
        this.nearPlaneWidth = this.parent.rightScreen - this.parent.leftScreen;
        this.nearPlaneHeight = this.parent.topScreen - this.parent.bottomScreen;
        this.nearPlaneDepth = this.parent.nearPlane;
        this.xmult = this.nearPlaneWidth / (float)this.parent.width;
        this.ymult = this.nearPlaneHeight / (float)this.parent.height;
        return true;
    }

    private int getTextureIndex(float f, float f2, float[] fArray) {
        f = this.xmult * (f - (float)this.parent.width / 2.0f + 0.5f);
        f2 = this.ymult * (f2 - (float)this.parent.height / 2.0f + 0.5f);
        float f3 = this.nearPlaneDepth;
        float f4 = f * this.ax + f2 * this.ay + f3 * this.az;
        float f5 = f * this.bx + f2 * this.by + f3 * this.bz;
        float f6 = f * this.cx + f2 * this.cy + f3 * this.cz;
        int n = (int)(f4 / f6);
        int n2 = (int)(f5 / f6);
        fArray[0] = f4 / f6;
        fArray[1] = f5 / f6;
        if (fArray[0] < 0.0f) {
            n = 0;
            fArray[0] = 0;
        }
        if (fArray[1] < 0.0f) {
            n2 = 0;
            fArray[1] = 0;
        }
        if (fArray[0] >= (float)this.twidth) {
            fArray[0] = this.twidth - 1;
            n = this.twidth - 1;
        }
        if (fArray[1] >= (float)this.theight) {
            fArray[1] = this.theight - 1;
            n2 = this.theight - 1;
        }
        int n3 = n2 * this.twidth + n;
        return n3;
    }

    public void setIntensities(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12) {
        this.vertices[0][3] = f;
        this.vertices[0][4] = f2;
        this.vertices[0][5] = f3;
        this.vertices[0][6] = f4;
        this.vertices[1][3] = f5;
        this.vertices[1][4] = f6;
        this.vertices[1][5] = f7;
        this.vertices[1][6] = f8;
        this.vertices[2][3] = f9;
        this.vertices[2][4] = f10;
        this.vertices[2][5] = f11;
        this.vertices[2][6] = f12;
    }
}

