#include <OneWire.h>
#include <DallasTemperature.h>
#define ONE_WIRE_BUS 12
#include "WProgram.h"
void setup(void);
void printTemperature(uint8_t deviceAddress[]);
void loop(void);
void printAddress(uint8_t deviceAddress[]);
OneWire oneWire(ONE_WIRE_BUS);
DallasTemperature sensors(&oneWire);
uint8_t insideThermometer[8];

void setup(void)
{
  Serial.begin(115200);
  sensors.begin();
  if (!sensors.getAddress(insideThermometer, 0)) Serial.println("Unable to find address for Device 0"); 
  sensors.setResolution(insideThermometer, 9);
}


// function to print the temperature for a device
void printTemperature(uint8_t deviceAddress[])
{
  float tempC = sensors.getTempC(deviceAddress);
  Serial.print("Temp C: ");
  Serial.print(tempC);
  Serial.print(" Temp F: ");
  Serial.print(DallasTemperature::toFahrenheit(tempC)); // Converts tempC to Fahrenheit
}



void loop(void)
{ 
  sensors.requestTemperatures(); // Send the command to get temperatures
  printTemperature(insideThermometer); // Use a simple function to print out the data
}

// function to print a device address
void printAddress(uint8_t deviceAddress[])
{
  for (uint8_t i = 0; i < 8; i++)
  {
    Serial.print(deviceAddress[i], HEX);
    if (i < 7) Serial.print(" ");
  }
}

int main(void)
{
	init();

	setup();
    
	for (;;)
		loop();
        
	return 0;
}

