

/*
 *
 * Gothic
 *
 * created with FontCreator
 * written by F. Maximilian Thiele
 *
 * http://www.apetech.de/fontCreator
 * me@apetech.de
 *
 * File Name           : Gothic.h
 * Date                : 18.05.2012
 * Font size in bytes  : 33282
 * Font width          : 10
 * Font height         : 28
 * Font first char     : 32
 * Font last char      : 128
 * Font used chars     : 96
 *
 * The font data are defined as
 *
 * struct _FONT_ {
 *     uint16_t   font_Size_in_Bytes_over_all_included_Size_it_self;
 *     uint8_t    font_Width_in_Pixel_for_fixed_drawing;
 *     uint8_t    font_Height_in_Pixel_for_all_characters;
 *     unit8_t    font_First_Char;
 *     uint8_t    font_Char_Count;
 *
 *     uint8_t    font_Char_Widths[font_Last_Char - font_First_Char +1];
 *                  // for each character the separate width in pixels,
 *                  // characters < 128 have an implicit virtual right empty row
 *
 *     uint8_t    font_data[];
 *                  // bit field of all characters
 */

#include <inttypes.h>
#include <avr/pgmspace.h>

#ifndef GOTHIC_H
#define GOTHIC_H

#define GOTHIC_WIDTH 10
#define GOTHIC_HEIGHT 28

static uint8_t Gothic[] PROGMEM = {
    0x82, 0x02, // size
    0x0A, // width
    0x1C, // height
    0x20, // first char
    0x60, // char count
    
    // char widths
    0x00, 0x07, 0x09, 0x0E, 0x0C, 0x11, 0x12, 0x03, 0x06, 0x06, 
    0x09, 0x10, 0x03, 0x0F, 0x04, 0x10, 0x0E, 0x07, 0x0D, 0x0C, 
    0x0D, 0x0E, 0x0E, 0x0D, 0x0E, 0x0E, 0x04, 0x04, 0x0E, 0x0F, 
    0x0E, 0x0A, 0x13, 0x12, 0x12, 0x10, 0x10, 0x11, 0x11, 0x10, 
    0x12, 0x0F, 0x0D, 0x12, 0x11, 0x16, 0x11, 0x11, 0x0F, 0x11, 
    0x12, 0x11, 0x11, 0x12, 0x10, 0x12, 0x11, 0x10, 0x0E, 0x07, 
    0x11, 0x07, 0x0E, 0x11, 0x03, 0x0A, 0x0C, 0x09, 0x0B, 0x09, 
    0x08, 0x0C, 0x0C, 0x06, 0x06, 0x0B, 0x06, 0x13, 0x0C, 0x0C, 
    0x0C, 0x0C, 0x09, 0x0B, 0x06, 0x0C, 0x0B, 0x12, 0x0D, 0x0C, 
    0x0B, 0x05, 0x02, 0x05, 0x0F, 0x0A, 
    
    // font data
    0x40, 0x60, 0xE0, 0xF0, 0xE0, 0x60, 0x40, 0x00, 0x00, 0x03, 0xFF, 0x07, 0x00, 0x00, 0x00, 0x00, 0x10, 0x38, 0x30, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 33
    0x46, 0x2F, 0x1E, 0x00, 0x00, 0x00, 0x44, 0x3F, 0x1C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 34
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xE0, 0x30, 0x00, 0x00, 0x00, 0xE0, 0x30, 0x00, 0x00, 0x10, 0x10, 0x10, 0xF0, 0x3E, 0x13, 0x10, 0x10, 0xF0, 0x3E, 0x13, 0x10, 0x10, 0x04, 0x04, 0xC4, 0x7C, 0x07, 0x04, 0x04, 0xC4, 0x7C, 0x07, 0x04, 0x04, 0x04, 0x00, 0x00, 0xC0, 0x30, 0x00, 0x00, 0x00, 0xC0, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 35
    0xC0, 0xE0, 0x10, 0xFE, 0xFE, 0x10, 0x10, 0xFE, 0x10, 0xA0, 0x60, 0x80, 0x03, 0x0F, 0x1C, 0xFF, 0xFF, 0x18, 0x30, 0xFF, 0x70, 0x61, 0xC2, 0x83, 0x0E, 0x1E, 0x20, 0xFF, 0xFF, 0x40, 0x40, 0xFF, 0x20, 0x20, 0x1F, 0x0F, 0x00, 0x00, 0x00, 0x10, 0x10, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, // 36
    0xE0, 0xE0, 0x10, 0x10, 0x10, 0xE0, 0xE0, 0xC0, 0x40, 0x40, 0x40, 0x40, 0x40, 0xA0, 0x60, 0x30, 0x10, 0x03, 0x03, 0x04, 0x04, 0x02, 0x03, 0x83, 0x40, 0x30, 0x18, 0x0C, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x20, 0x30, 0x18, 0x0C, 0x06, 0x01, 0x00, 0x00, 0x00, 0x00, 0x1E, 0x3F, 0x21, 0x21, 0x21, 0x3B, 0x1F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 37
    0x00, 0x00, 0x00, 0xC0, 0x40, 0x20, 0x70, 0xC0, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x83, 0x46, 0x2C, 0x18, 0x38, 0x64, 0xC3, 0x81, 0x40, 0x20, 0x20, 0x10, 0x38, 0x30, 0x18, 0x04, 0x02, 0x07, 0x1C, 0x38, 0x10, 0x08, 0x04, 0x02, 0x01, 0x03, 0x0E, 0x1C, 0x18, 0x30, 0x30, 0x30, 0x18, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 38
    0x44, 0x2F, 0x1E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 39
    0x00, 0x80, 0xE0, 0x18, 0x04, 0x02, 0xFC, 0xFF, 0x01, 0x00, 0x00, 0x00, 0x07, 0x3F, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x40, 0x80, // 40
    0x02, 0x0C, 0x10, 0xE0, 0x80, 0x00, 0x00, 0x00, 0x00, 0x01, 0xFF, 0xFC, 0x00, 0x00, 0x00, 0xF0, 0x3F, 0x07, 0x80, 0x60, 0x10, 0x00, 0x00, 0x00, // 41
    0x80, 0x80, 0x00, 0x20, 0xF0, 0x20, 0x00, 0x80, 0x80, 0x08, 0x08, 0x05, 0x45, 0x7F, 0x45, 0x05, 0x08, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 42
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xC0, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0xFF, 0xFF, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1F, 0x1F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 43
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0xB8, 0x70, 0x10, 0x00, 0x00, // 44
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 45
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x38, 0x30, 0x20, 0x00, 0x00, 0x00, 0x00, // 46
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xC0, 0x70, 0x18, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x60, 0x38, 0x0C, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xC0, 0x70, 0x1C, 0x06, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0xC0, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 47
    0x00, 0x00, 0xC0, 0xC0, 0x40, 0x20, 0x20, 0x20, 0x30, 0x70, 0xE0, 0xC0, 0x40, 0x40, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x10, 0x08, 0x0F, 0x1F, 0x38, 0x30, 0x20, 0x10, 0x10, 0x10, 0x0F, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 48
    0x40, 0xE0, 0xF0, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x10, 0x08, 0x1F, 0x3F, 0x18, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 49
    0x40, 0x40, 0x40, 0x60, 0x70, 0x30, 0x20, 0x20, 0x20, 0xC0, 0xC0, 0x00, 0x00, 0x80, 0x40, 0x20, 0x20, 0x20, 0x10, 0x10, 0x10, 0x10, 0x1F, 0x1F, 0x00, 0x00, 0x3F, 0x20, 0x10, 0x10, 0x10, 0x18, 0x18, 0x18, 0x18, 0x18, 0x38, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 50
    0x00, 0x40, 0x40, 0x60, 0x60, 0x70, 0x20, 0x20, 0x20, 0x40, 0xC0, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x20, 0x30, 0x50, 0x50, 0xCF, 0xCF, 0x10, 0x10, 0x08, 0x18, 0x18, 0x30, 0x10, 0x20, 0x10, 0x10, 0x0F, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 51
    0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x40, 0x20, 0xF0, 0xE0, 0x40, 0x00, 0x00, 0xF0, 0xFC, 0x04, 0x02, 0x01, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x01, 0x01, 0x02, 0x02, 0x02, 0x02, 0x12, 0x0A, 0x1F, 0x3F, 0x1A, 0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 52
    0x00, 0xC0, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x10, 0x10, 0x00, 0x00, 0x00, 0x07, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x04, 0x0C, 0xFE, 0xFC, 0x08, 0x08, 0x10, 0x10, 0x08, 0x18, 0x18, 0x30, 0x10, 0x20, 0x10, 0x10, 0x0F, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 53
    0x00, 0x00, 0xC0, 0xC0, 0x40, 0x20, 0x20, 0x20, 0x70, 0x60, 0x60, 0x40, 0x40, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x10, 0x10, 0x10, 0x10, 0x08, 0x08, 0xFC, 0xF8, 0x08, 0x10, 0x10, 0x08, 0x0F, 0x1F, 0x38, 0x30, 0x20, 0x10, 0x10, 0x10, 0x0F, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 54
    0x20, 0x70, 0x70, 0x60, 0x60, 0x60, 0x60, 0x60, 0x20, 0x20, 0xA0, 0x60, 0x10, 0x00, 0x00, 0x00, 0x00, 0x80, 0xE0, 0x30, 0x0C, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3F, 0x1F, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 55
    0x00, 0x00, 0x80, 0x80, 0x40, 0x40, 0x40, 0x40, 0x20, 0x60, 0xF0, 0xE0, 0x40, 0x40, 0x00, 0x00, 0xCF, 0xCF, 0x50, 0x30, 0x20, 0x20, 0x30, 0x50, 0xCF, 0xCF, 0x00, 0x00, 0x10, 0x08, 0x0F, 0x1F, 0x38, 0x30, 0x20, 0x10, 0x10, 0x10, 0x0F, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 56
    0x00, 0x00, 0xC0, 0xC0, 0x40, 0x20, 0x20, 0x20, 0x30, 0x70, 0xE0, 0xC0, 0x40, 0x40, 0x40, 0x40, 0x7F, 0xFF, 0x40, 0x40, 0x40, 0x40, 0x40, 0x20, 0xFF, 0xFF, 0x00, 0x00, 0x10, 0x10, 0x08, 0x18, 0x18, 0x30, 0x10, 0x20, 0x10, 0x10, 0x0F, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 57
    0x00, 0x00, 0x00, 0x00, 0x08, 0x1C, 0x18, 0x10, 0x10, 0x38, 0x30, 0x20, 0x00, 0x00, 0x00, 0x00, // 58
    0x00, 0x00, 0x00, 0x00, 0x08, 0x1C, 0x18, 0x10, 0x10, 0xB8, 0x70, 0x00, 0x10, 0x00, 0x00, 0x00, // 59
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x80, 0x40, 0x40, 0x60, 0xF0, 0x90, 0x98, 0x08, 0x0C, 0x04, 0x02, 0x03, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x02, 0x02, 0x04, 0x0C, 0x08, 0x18, 0x10, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 60
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 61
    0xC0, 0x80, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x02, 0x06, 0x04, 0x0C, 0x08, 0x98, 0x90, 0x60, 0x60, 0x40, 0x30, 0x10, 0x18, 0x08, 0x04, 0x06, 0x02, 0x03, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 62
    0xC0, 0xE0, 0x10, 0x10, 0x10, 0x10, 0x10, 0x20, 0xE0, 0xC0, 0x00, 0x01, 0x00, 0x00, 0xE0, 0x60, 0x10, 0x18, 0x0F, 0x03, 0x00, 0x00, 0x20, 0x30, 0x39, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 63
    0x00, 0x00, 0x80, 0xC0, 0xE0, 0xE0, 0x60, 0x70, 0x30, 0x30, 0x30, 0x70, 0x60, 0xE0, 0xE0, 0xC0, 0x80, 0x00, 0x00, 0xFC, 0xFF, 0x0F, 0x03, 0xF0, 0xFC, 0x1E, 0x06, 0x02, 0x02, 0x02, 0x06, 0xFC, 0xFE, 0x0E, 0x03, 0x0F, 0xFF, 0xF8, 0x00, 0x03, 0x06, 0x08, 0x11, 0x23, 0x24, 0x28, 0x28, 0x28, 0x24, 0x22, 0x23, 0x27, 0x18, 0x08, 0x06, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 64
    0x00, 0x00, 0x00, 0x00, 0x40, 0x20, 0x20, 0x10, 0x10, 0x70, 0xF0, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xC2, 0xBB, 0x87, 0x81, 0x81, 0x8F, 0xBF, 0xF8, 0xE0, 0x80, 0x00, 0x00, 0x20, 0x20, 0x10, 0x18, 0x1C, 0x1B, 0x38, 0x18, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x1F, 0x3E, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 65
    0x40, 0x40, 0x20, 0x10, 0x30, 0x30, 0x30, 0x20, 0x10, 0xC8, 0x40, 0x40, 0x20, 0x20, 0x30, 0x30, 0xF0, 0xC0, 0x40, 0x30, 0x30, 0x30, 0xFC, 0xFF, 0x00, 0x00, 0xFF, 0x7F, 0x00, 0x00, 0xF8, 0x48, 0x44, 0x5C, 0xF3, 0xE1, 0x00, 0x00, 0x00, 0x24, 0x23, 0x11, 0x10, 0x18, 0x19, 0x18, 0x18, 0x18, 0x3F, 0x12, 0x12, 0x0A, 0x07, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 66
    0x00, 0x00, 0x80, 0x40, 0x20, 0x10, 0x00, 0x80, 0xC0, 0x40, 0x20, 0x70, 0xF0, 0x60, 0x20, 0x18, 0xFC, 0xFF, 0x01, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x01, 0x07, 0x0F, 0x1E, 0x1C, 0x18, 0x30, 0x33, 0x30, 0x30, 0x30, 0x10, 0x1F, 0x18, 0x0C, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 67
    0x00, 0x10, 0x10, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0xF0, 0x30, 0x30, 0x30, 0x30, 0xE0, 0xC0, 0x00, 0x40, 0x30, 0x30, 0x30, 0xFC, 0xFF, 0x00, 0x00, 0xFF, 0x44, 0x48, 0x48, 0x84, 0xFF, 0xFF, 0x20, 0x20, 0x20, 0x10, 0x10, 0x1B, 0x18, 0x18, 0x18, 0x1F, 0x38, 0x18, 0x10, 0x08, 0x07, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 68
    0x40, 0x40, 0x20, 0x10, 0x30, 0x30, 0x20, 0x10, 0x08, 0x80, 0x60, 0x20, 0x30, 0x30, 0x70, 0x70, 0x20, 0x00, 0x60, 0x30, 0x30, 0xFC, 0xFF, 0x00, 0x00, 0xFF, 0xC0, 0x20, 0x30, 0x70, 0x30, 0x20, 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x47, 0x21, 0x10, 0x10, 0x1F, 0x18, 0x18, 0x18, 0x18, 0x18, 0x38, 0x30, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 69
    0x00, 0x40, 0x40, 0x20, 0x10, 0x30, 0x30, 0x30, 0x20, 0x20, 0x10, 0x88, 0x80, 0x40, 0x60, 0xF0, 0x70, 0x00, 0x00, 0x00, 0x00, 0x60, 0x30, 0x30, 0xFC, 0xFF, 0x00, 0x00, 0xFF, 0xFF, 0x30, 0x30, 0xFF, 0x00, 0x20, 0x20, 0x30, 0x18, 0x18, 0x18, 0x38, 0x33, 0x31, 0x20, 0x10, 0x1F, 0x0F, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 70
    0x00, 0xC0, 0xE0, 0x30, 0x08, 0x08, 0x00, 0x80, 0xC0, 0x40, 0x60, 0x70, 0xE0, 0x60, 0x10, 0x08, 0x7E, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x14, 0xEF, 0xFC, 0xDC, 0xF8, 0xE0, 0x00, 0x03, 0x07, 0x0C, 0x10, 0x20, 0x20, 0x27, 0x21, 0x20, 0x20, 0x3F, 0x23, 0x13, 0x0F, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 71
    0x40, 0x40, 0x20, 0x10, 0x30, 0x30, 0x30, 0x20, 0x10, 0xC8, 0x20, 0x20, 0x10, 0x30, 0x70, 0x30, 0x20, 0x00, 0x40, 0x30, 0x30, 0x30, 0xFC, 0xFF, 0x00, 0x00, 0xFF, 0x7F, 0x00, 0x00, 0xF8, 0x48, 0x44, 0x4E, 0xFE, 0xF8, 0x00, 0x00, 0x40, 0x24, 0x23, 0x11, 0x10, 0x18, 0x19, 0x18, 0x38, 0x38, 0x1F, 0x02, 0x42, 0x32, 0x0F, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 72
    0x00, 0x00, 0x20, 0x20, 0x10, 0x18, 0x18, 0x38, 0x30, 0x30, 0x10, 0x08, 0x08, 0xC0, 0x20, 0x00, 0x00, 0x00, 0x00, 0x40, 0x30, 0x30, 0x30, 0xFC, 0xFF, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x40, 0x20, 0x10, 0x10, 0x18, 0x18, 0x38, 0x30, 0x33, 0x20, 0x20, 0x10, 0x0F, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 73
    0x00, 0x20, 0x20, 0x10, 0x18, 0x18, 0x30, 0x30, 0x30, 0x10, 0x08, 0x88, 0x60, 0x00, 0x00, 0x40, 0x30, 0x30, 0x30, 0xFC, 0xFF, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x0E, 0x16, 0x22, 0x20, 0x20, 0x20, 0x23, 0x20, 0x20, 0x10, 0x0F, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 74
    0x40, 0x40, 0x20, 0x10, 0x30, 0x30, 0x30, 0x20, 0x10, 0xC8, 0x20, 0x20, 0x10, 0x30, 0x70, 0x30, 0x20, 0x00, 0x40, 0x30, 0x30, 0x30, 0xFC, 0xFF, 0x00, 0x00, 0xFF, 0x7F, 0x00, 0x00, 0x78, 0x88, 0x44, 0xA6, 0x14, 0x0C, 0x00, 0x00, 0x00, 0x24, 0x23, 0x11, 0x10, 0x18, 0x19, 0x18, 0x38, 0x38, 0x1F, 0x00, 0x00, 0x03, 0x1F, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 75
    0x40, 0x40, 0x20, 0x10, 0x30, 0x30, 0x30, 0x20, 0x10, 0xC8, 0x20, 0x20, 0xD0, 0x30, 0x70, 0x30, 0x20, 0x40, 0x30, 0x30, 0x30, 0xFC, 0xFF, 0x00, 0x00, 0xFF, 0x7F, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x44, 0x23, 0x11, 0x10, 0x18, 0x19, 0x18, 0x18, 0x18, 0x1F, 0x18, 0x38, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 76
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x40, 0x40, 0xE0, 0x70, 0xC0, 0x80, 0x80, 0x40, 0xE0, 0xF0, 0xE0, 0xC0, 0x80, 0x00, 0x00, 0x00, 0x00, 0x60, 0x30, 0x30, 0xFE, 0xFF, 0x00, 0xC0, 0x3F, 0x30, 0x30, 0xFF, 0xFF, 0x00, 0xFF, 0x3F, 0x30, 0xFF, 0xFF, 0x00, 0x00, 0x40, 0x20, 0x10, 0x18, 0x18, 0x19, 0x38, 0x30, 0x1F, 0x00, 0x00, 0x10, 0x3F, 0x3F, 0x10, 0x0F, 0x00, 0x00, 0x1F, 0x3F, 0x30, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 77
    0x60, 0x20, 0xD0, 0x30, 0x30, 0xF0, 0xE0, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x20, 0x70, 0xF0, 0x60, 0x20, 0x40, 0x30, 0x7F, 0x80, 0x80, 0x80, 0x81, 0x8F, 0xBF, 0xFC, 0xE4, 0x84, 0x04, 0x04, 0xFF, 0x00, 0x00, 0x20, 0x10, 0x1F, 0x18, 0x18, 0x38, 0x10, 0x00, 0x00, 0x00, 0x03, 0x0F, 0x1E, 0x18, 0x3F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 78
    0x00, 0x80, 0xE0, 0x30, 0x10, 0x08, 0x80, 0x80, 0x40, 0x20, 0xE0, 0x18, 0x30, 0x70, 0xE0, 0x80, 0x00, 0xFE, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0xFB, 0x44, 0x44, 0x48, 0x85, 0xFF, 0xFE, 0x00, 0x03, 0x07, 0x08, 0x10, 0x24, 0x23, 0x21, 0x20, 0x20, 0x3F, 0x20, 0x10, 0x08, 0x06, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 79
    0x00, 0x00, 0x08, 0x10, 0xE0, 0xC0, 0x80, 0x80, 0xC0, 0x20, 0x30, 0x78, 0xF0, 0xE0, 0x80, 0x00, 0x30, 0x18, 0x18, 0xFF, 0xFF, 0x00, 0x00, 0xFF, 0x44, 0x48, 0x48, 0x44, 0xFF, 0xFF, 0x40, 0x20, 0x20, 0x10, 0xFF, 0xFF, 0x00, 0x00, 0xFF, 0x18, 0x18, 0x38, 0x10, 0x0F, 0x07, 0x00, 0x00, 0x00, 0x80, 0x70, 0x30, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 80
    0x00, 0x80, 0xE0, 0x30, 0x10, 0x08, 0x80, 0x80, 0x40, 0x20, 0xE0, 0x18, 0x30, 0x70, 0xE0, 0x80, 0x00, 0xFE, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0xFB, 0x44, 0x44, 0x48, 0x85, 0xFF, 0xFE, 0x00, 0x03, 0x07, 0x08, 0x10, 0x24, 0x23, 0x21, 0x60, 0x60, 0xFF, 0xA0, 0x10, 0x08, 0x06, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x70, 0xE0, 0xC0, 0xC0, 0x80, 0x00, // 81
    0x40, 0x40, 0x20, 0x10, 0x30, 0x30, 0x30, 0x20, 0x10, 0xC8, 0x40, 0x20, 0x20, 0x30, 0x70, 0xE0, 0xC0, 0x00, 0x40, 0x30, 0x30, 0x30, 0xFC, 0xFF, 0x00, 0x00, 0xFF, 0xFF, 0x40, 0x20, 0x60, 0xD0, 0x88, 0x0F, 0x03, 0x00, 0x00, 0x00, 0x20, 0x24, 0x13, 0x11, 0x10, 0x18, 0x19, 0x18, 0x38, 0x10, 0x10, 0x00, 0x07, 0x1E, 0x3C, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 82
    0x00, 0x00, 0xC0, 0x20, 0x20, 0x10, 0x10, 0x10, 0x10, 0x10, 0xB0, 0x70, 0x20, 0x20, 0x00, 0x00, 0x00, 0x00, 0x18, 0x30, 0x63, 0x63, 0xE6, 0x66, 0x76, 0x6E, 0x66, 0x67, 0xE6, 0x46, 0x06, 0x0E, 0xDE, 0x7C, 0x20, 0x20, 0x23, 0x12, 0x11, 0x18, 0x18, 0x18, 0x18, 0x18, 0x38, 0x31, 0x18, 0x04, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 83
    0x80, 0x40, 0xA0, 0x10, 0x10, 0x10, 0x10, 0x10, 0x30, 0xB0, 0x60, 0x60, 0x60, 0xE0, 0x20, 0x20, 0x10, 0x00, 0xF8, 0xFF, 0x81, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x01, 0x07, 0x0F, 0x1E, 0x18, 0x18, 0x38, 0x33, 0x30, 0x30, 0x30, 0x10, 0x1F, 0x18, 0x0C, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 84
    0x40, 0x20, 0x10, 0x18, 0xD8, 0x30, 0x30, 0x10, 0x08, 0x88, 0x80, 0x80, 0x80, 0x40, 0x60, 0xF0, 0xF0, 0x60, 0x00, 0x00, 0xF8, 0xFE, 0x81, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0xFF, 0x48, 0x48, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x01, 0x07, 0x0F, 0x1C, 0x18, 0x38, 0x33, 0x30, 0x30, 0x30, 0x1F, 0x18, 0x18, 0x1F, 0x3F, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 85
    0x00, 0x08, 0x10, 0xE0, 0xC0, 0x00, 0x00, 0x00, 0x80, 0x80, 0x40, 0x40, 0x20, 0xF8, 0xF0, 0x20, 0x70, 0x18, 0x18, 0xFF, 0xFF, 0x00, 0x00, 0xFF, 0x84, 0x44, 0x48, 0x48, 0x44, 0xFF, 0xFF, 0x00, 0x00, 0x10, 0x08, 0x0F, 0x0F, 0x18, 0x18, 0x3F, 0x38, 0x10, 0x10, 0x10, 0x08, 0x07, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 86
    0x00, 0x08, 0x30, 0xE0, 0xC0, 0x00, 0x00, 0xE0, 0x30, 0x38, 0xF0, 0xE0, 0x00, 0xE0, 0xF0, 0x38, 0xF0, 0xE0, 0x30, 0x18, 0x18, 0xFF, 0xFF, 0x00, 0x00, 0xFF, 0x46, 0x46, 0xFF, 0xFF, 0x00, 0xFF, 0xFF, 0x46, 0xFF, 0xFF, 0x00, 0x10, 0x08, 0x0F, 0x0F, 0x18, 0x18, 0x3F, 0x18, 0x10, 0x0F, 0x07, 0x08, 0x3F, 0x1F, 0x10, 0x0F, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 87
    0x40, 0x20, 0x20, 0x10, 0x30, 0xF0, 0xE0, 0x80, 0x00, 0x00, 0x00, 0xC0, 0x20, 0x70, 0x70, 0x20, 0x30, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x13, 0x8F, 0x7E, 0xF8, 0xD7, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x60, 0x10, 0x10, 0x38, 0x38, 0x18, 0x07, 0x00, 0x00, 0x01, 0x07, 0x1F, 0x3C, 0x30, 0x20, 0x10, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 88
    0x00, 0x08, 0x10, 0xE0, 0xC0, 0x00, 0x00, 0x00, 0x80, 0x80, 0x40, 0x40, 0x20, 0xF8, 0xF0, 0x20, 0x30, 0x18, 0x18, 0xFF, 0xFF, 0x00, 0x00, 0xFF, 0x84, 0x44, 0x48, 0x48, 0x44, 0xFF, 0xFF, 0x00, 0x00, 0x10, 0x08, 0x0F, 0x0F, 0x18, 0x18, 0x3F, 0x38, 0x10, 0x10, 0x10, 0x08, 0x0F, 0xFF, 0x00, 0x00, 0x00, 0x40, 0x40, 0x20, 0x20, 0x20, 0x20, 0x20, 0x60, 0x60, 0x60, 0xE0, 0x60, 0x10, 0x00, // 89
    0x40, 0x20, 0x70, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x20, 0x20, 0xE0, 0x30, 0x10, 0x00, 0x00, 0x00, 0x10, 0x90, 0xD0, 0x70, 0x38, 0x1C, 0x16, 0x13, 0x10, 0x00, 0x00, 0x20, 0x30, 0x18, 0x16, 0x13, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x38, 0x38, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 90
    0xFE, 0xFE, 0x02, 0x02, 0x02, 0x02, 0x02, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF0, 0xF0, 0x80, 0x80, 0x80, 0x80, 0x80, // 91
    0x02, 0x06, 0x1C, 0x30, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x0E, 0x18, 0x60, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x07, 0x0C, 0x30, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0xE0, 0x80, // 92
    0x02, 0x02, 0x02, 0x02, 0x02, 0xFE, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x80, 0x80, 0x80, 0x80, 0x80, 0xF0, 0xF0, // 93
    0x10, 0x10, 0x08, 0x08, 0x0C, 0x04, 0x06, 0x06, 0x04, 0x0C, 0x08, 0x08, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 94
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 95
    0x3F, 0x4E, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 96
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0xB8, 0xDC, 0x58, 0x90, 0x10, 0x18, 0xFC, 0xFC, 0x08, 0x0E, 0x1F, 0x38, 0x30, 0x10, 0x10, 0x08, 0x1F, 0x3F, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 97
    0x00, 0x40, 0xE0, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x10, 0x10, 0x10, 0x08, 0x0C, 0xFC, 0xF8, 0x10, 0x10, 0x08, 0x0F, 0x1F, 0x38, 0x30, 0x20, 0x10, 0x10, 0x0F, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 98
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF0, 0xF8, 0x08, 0x08, 0x0C, 0x1C, 0x18, 0x10, 0x08, 0x1F, 0x3F, 0x18, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 99
    0x00, 0x00, 0x40, 0x60, 0xF0, 0xC0, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF8, 0xF8, 0x08, 0x05, 0x03, 0x07, 0x0E, 0xFC, 0xF8, 0x10, 0x08, 0x0F, 0x1F, 0x38, 0x30, 0x20, 0x10, 0x10, 0x0F, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 100
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF0, 0xF8, 0x08, 0x08, 0x9C, 0x7C, 0x30, 0x10, 0x08, 0x1F, 0x3F, 0x19, 0x11, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 101
    0x00, 0x00, 0xC0, 0xE0, 0x20, 0x20, 0x70, 0x60, 0x04, 0x04, 0xFF, 0xFF, 0x04, 0x04, 0x04, 0x00, 0x10, 0x08, 0x1F, 0x3F, 0x18, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 102
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF0, 0xF0, 0x08, 0x08, 0x08, 0x0C, 0x0C, 0xF8, 0xF0, 0x10, 0x10, 0x10, 0x1F, 0x3F, 0x38, 0x10, 0x10, 0x10, 0x08, 0x7F, 0xFF, 0x00, 0x00, 0x00, 0x40, 0x20, 0x20, 0x60, 0xE0, 0xC0, 0x40, 0x30, 0x00, 0x00, // 103
    0x00, 0x40, 0xE0, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x10, 0x10, 0x10, 0x08, 0x1C, 0xFC, 0xF8, 0x10, 0x10, 0x10, 0x1F, 0x3F, 0x30, 0x10, 0x00, 0x00, 0xC0, 0x3F, 0x1F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0x80, 0x00, 0x00, // 104
    0x00, 0x20, 0x70, 0x60, 0x40, 0x00, 0x08, 0x08, 0xFC, 0xFC, 0x08, 0x08, 0x00, 0x00, 0x1F, 0x3F, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 105
    0x00, 0x20, 0x70, 0x60, 0x40, 0x00, 0x10, 0x18, 0xFC, 0xFC, 0x18, 0x10, 0x00, 0x00, 0x1F, 0x3F, 0xC0, 0x00, 0x00, 0x80, 0x80, 0x80, 0x70, 0x00, // 106
    0x00, 0x40, 0xE0, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x10, 0x88, 0x88, 0xDC, 0x38, 0x10, 0x00, 0x10, 0x08, 0x1F, 0x3F, 0x19, 0x10, 0x00, 0x03, 0x1F, 0x3C, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 107
    0x00, 0x40, 0xE0, 0xF0, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x10, 0x08, 0x1F, 0x3F, 0x18, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 108
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x08, 0xFC, 0xF8, 0x10, 0x10, 0x10, 0x08, 0x08, 0xFC, 0xF8, 0x10, 0x10, 0x08, 0x08, 0xFC, 0xF8, 0x10, 0x10, 0x10, 0x08, 0x1F, 0x3F, 0x18, 0x10, 0x00, 0x00, 0x10, 0x1F, 0x3F, 0x18, 0x10, 0x00, 0x00, 0x1F, 0x3F, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 109
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x08, 0xFC, 0xF8, 0x10, 0x10, 0x10, 0x08, 0x08, 0xFC, 0xF8, 0x10, 0x10, 0x08, 0x1F, 0x3F, 0x18, 0x10, 0x00, 0x00, 0x00, 0x1F, 0x3F, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 110
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF0, 0xF0, 0x08, 0x08, 0x08, 0x0C, 0x0C, 0xF8, 0xF0, 0x10, 0x10, 0x08, 0x0F, 0x1F, 0x38, 0x30, 0x20, 0x10, 0x10, 0x0F, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 111
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0xF8, 0xF8, 0x10, 0x10, 0x10, 0x08, 0x0C, 0xF8, 0xF8, 0x10, 0x10, 0x10, 0xFF, 0xFF, 0x38, 0x30, 0x20, 0x10, 0x10, 0x0F, 0x0F, 0x00, 0x00, 0x00, 0xF0, 0x70, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 112
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF0, 0xF0, 0x08, 0x08, 0x08, 0x0C, 0x0C, 0xF8, 0xF0, 0x10, 0x10, 0x08, 0x1F, 0x3F, 0x38, 0x10, 0x10, 0x10, 0x08, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x70, 0xF0, 0x00, // 113
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x08, 0xFC, 0xF8, 0x08, 0x08, 0x0C, 0x1C, 0x18, 0x10, 0x08, 0x1F, 0x3F, 0x18, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 114
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF0, 0xF8, 0x88, 0x8C, 0x8C, 0xCC, 0xB8, 0x88, 0x06, 0x02, 0x20, 0x30, 0x19, 0x15, 0x33, 0x31, 0x11, 0x21, 0x1F, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 115
    0x00, 0x40, 0xE0, 0xF0, 0x00, 0x00, 0x04, 0x04, 0xFF, 0xFF, 0x04, 0x04, 0x10, 0x08, 0x1F, 0x3F, 0x18, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 116
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x08, 0xFC, 0xF8, 0x00, 0x00, 0x00, 0x10, 0x18, 0xFC, 0xF8, 0x10, 0x10, 0x08, 0x1F, 0x3F, 0x18, 0x10, 0x10, 0x10, 0x08, 0x1F, 0x3F, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 117
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0xF8, 0xF8, 0x00, 0x00, 0x00, 0x10, 0x18, 0xFC, 0xF8, 0x10, 0x00, 0x0F, 0x1F, 0x38, 0x18, 0x10, 0x10, 0x08, 0x0F, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 118
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0xF8, 0xF8, 0x00, 0x00, 0x00, 0x10, 0x18, 0xFC, 0xF8, 0x10, 0x00, 0x10, 0x18, 0xFC, 0xF8, 0x10, 0x10, 0x00, 0x0F, 0x1F, 0x38, 0x18, 0x10, 0x08, 0x08, 0x0F, 0x1F, 0x38, 0x10, 0x10, 0x08, 0x0F, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 119
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x0C, 0x1C, 0x38, 0xF8, 0xE0, 0xE0, 0x10, 0x0C, 0x18, 0x08, 0x0E, 0x60, 0x10, 0x18, 0x39, 0x19, 0x04, 0x03, 0x0F, 0x1F, 0x39, 0x31, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 120
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x08, 0xFC, 0xF8, 0x00, 0x00, 0x00, 0x10, 0x18, 0xFC, 0xF8, 0x10, 0x10, 0x10, 0x1F, 0x3F, 0x30, 0x10, 0x10, 0x10, 0x08, 0x7F, 0xFF, 0x00, 0x00, 0x00, 0x40, 0x20, 0x20, 0x60, 0xE0, 0xC0, 0x40, 0x30, 0x00, 0x00, // 121
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x18, 0x1C, 0x18, 0x18, 0x98, 0x48, 0x28, 0x18, 0x0C, 0x04, 0x20, 0x38, 0x15, 0x13, 0x11, 0x18, 0x19, 0x19, 0x39, 0x18, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 122
    0x00, 0x78, 0xFC, 0x84, 0x02, 0x40, 0xC0, 0xA1, 0x1F, 0x1E, 0x00, 0xC0, 0xF0, 0x3F, 0x0F, 0x00, 0x30, 0x70, 0x40, 0x80, // 123
    0xFE, 0xFE, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0xF0, // 124
    0x00, 0x02, 0x84, 0xFC, 0x78, 0x1E, 0x1F, 0xA3, 0xC0, 0x40, 0x0F, 0x1F, 0x38, 0xE0, 0xC0, 0x00, 0x80, 0x40, 0x70, 0x30, // 125
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xC0, 0x20, 0x30, 0x30, 0x30, 0x20, 0x60, 0x60, 0xC0, 0xC0, 0x80, 0x80, 0x80, 0x80, 0xF0, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 126
    0xF0, 0xF0, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0xF0, 0xF0, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x3F, 0x3F, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x3F, 0x3F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 // 127
    
};

#endif
