

/*
 *
 * new Font
 *
 * created with FontCreator
 * written by F. Maximilian Thiele
 *
 * http://www.apetech.de/fontCreator
 * me@apetech.de
 *
 * File Name           : new_Font.h
 * Date                : 18.05.2012
 * Font size in bytes  : 17425
 * Font width          : 10
 * Font height         : 17
 * Font first char     : 32
 * Font last char      : 128
 * Font used chars     : 96
 *
 * The font data are defined as
 *
 * struct _FONT_ {
 *     uint16_t   font_Size_in_Bytes_over_all_included_Size_it_self;
 *     uint8_t    font_Width_in_Pixel_for_fixed_drawing;
 *     uint8_t    font_Height_in_Pixel_for_all_characters;
 *     unit8_t    font_First_Char;
 *     uint8_t    font_Char_Count;
 *
 *     uint8_t    font_Char_Widths[font_Last_Char - font_First_Char +1];
 *                  // for each character the separate width in pixels,
 *                  // characters < 128 have an implicit virtual right empty row
 *
 *     uint8_t    font_data[];
 *                  // bit field of all characters
 */

#include <inttypes.h>
#include <avr/pgmspace.h>

#ifndef NEW_FONT_H
#define NEW_FONT_H

#define NEW_FONT_WIDTH 10
#define NEW_FONT_HEIGHT 17

static uint8_t new_Font[] PROGMEM = {
    0x44, 0x11, // size
    0x0A, // width
    0x11, // height
    0x20, // first char
    0x60, // char count
    
    // char widths
    0x00, 0x04, 0x09, 0x08, 0x0A, 0x0D, 0x09, 0x04, 0x06, 0x06, 
    0x07, 0x09, 0x04, 0x08, 0x04, 0x0D, 0x0A, 0x05, 0x0D, 0x0B, 
    0x0C, 0x0C, 0x0B, 0x0C, 0x0A, 0x0A, 0x04, 0x04, 0x08, 0x08, 
    0x08, 0x0D, 0x0C, 0x0E, 0x0D, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 
    0x0D, 0x04, 0x07, 0x0D, 0x0B, 0x11, 0x0D, 0x0C, 0x0D, 0x0C, 
    0x0D, 0x0E, 0x0D, 0x0D, 0x0F, 0x15, 0x10, 0x0E, 0x0D, 0x06, 
    0x0C, 0x06, 0x08, 0x08, 0x04, 0x0E, 0x0D, 0x0C, 0x0C, 0x0C, 
    0x0C, 0x0C, 0x0D, 0x04, 0x07, 0x0D, 0x0B, 0x11, 0x0D, 0x0C, 
    0x0D, 0x0C, 0x0D, 0x0E, 0x0D, 0x0D, 0x0F, 0x15, 0x10, 0x0E, 
    0x0D, 0x06, 0x03, 0x06, 0x09, 0x06, 
    
    // font data
    0xF8, 0xF8, 0xF8, 0xF8, 0x63, 0x63, 0x63, 0x23, 0x00, 0x00, 0x00, 0x00, // 33
    0x18, 0x38, 0x38, 0x10, 0x00, 0x18, 0x38, 0x38, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 34
    0x00, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x00, 0x1B, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x1B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 35
    0xE0, 0xF0, 0xF0, 0x38, 0x38, 0x38, 0x38, 0x30, 0x10, 0x00, 0x20, 0x31, 0x33, 0x73, 0x73, 0x73, 0x33, 0x3F, 0x1E, 0x0C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 36
    0x00, 0x70, 0x70, 0x70, 0x70, 0x00, 0x00, 0x80, 0xC0, 0xE0, 0x38, 0x18, 0x08, 0x40, 0x60, 0x70, 0x38, 0x1C, 0x0E, 0x07, 0x03, 0x01, 0x1C, 0x1C, 0x1C, 0x1C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 37
    0xF0, 0xF0, 0xF0, 0x38, 0x38, 0x38, 0x38, 0x30, 0x10, 0x3F, 0x3F, 0x3F, 0x73, 0x73, 0x73, 0x31, 0x30, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 38
    0x18, 0x38, 0x38, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 39
    0xC0, 0xF0, 0xF0, 0x38, 0x18, 0x18, 0x0F, 0x3F, 0x3F, 0x70, 0x60, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 40
    0x18, 0x18, 0x38, 0xF0, 0xF0, 0xC0, 0x60, 0x60, 0x70, 0x3F, 0x3F, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 41
    0x48, 0x48, 0x78, 0x78, 0x78, 0x48, 0x48, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 42
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x06, 0x1F, 0x1F, 0x1F, 0x06, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 43
    0x00, 0x00, 0x00, 0x00, 0x60, 0xE0, 0xE0, 0x40, 0x00, 0x00, 0x00, 0x00, // 44
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 45
    0x00, 0x00, 0x00, 0x00, 0x60, 0x60, 0x60, 0x60, 0x00, 0x00, 0x00, 0x00, // 46
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0xC0, 0xE0, 0x38, 0x18, 0x08, 0x40, 0x60, 0x70, 0x38, 0x1C, 0x0E, 0x07, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 47
    0xE0, 0xF0, 0xF8, 0x18, 0x18, 0x18, 0x18, 0xF8, 0xF0, 0xE0, 0x1F, 0x3F, 0x7F, 0x60, 0x60, 0x60, 0x60, 0x7F, 0x3F, 0x1F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 48
    0x20, 0x30, 0xF8, 0xF8, 0xF8, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x80, 0x00, // 49
    0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x98, 0xD8, 0xD0, 0x40, 0x00, 0x70, 0x78, 0x7C, 0x7C, 0x6E, 0x66, 0x67, 0x63, 0x63, 0x61, 0x61, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 50
    0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x98, 0xD8, 0xD8, 0x58, 0x10, 0x00, 0x00, 0x40, 0x40, 0x42, 0x43, 0x43, 0x67, 0x7F, 0x3F, 0x3E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 51
    0x00, 0x10, 0xF8, 0xF8, 0xF8, 0x18, 0x00, 0x00, 0xF8, 0xF8, 0xF8, 0xF8, 0x08, 0x0F, 0x0F, 0x07, 0x0C, 0x0C, 0x0C, 0x0C, 0x7F, 0x7F, 0x7F, 0x7F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 52
    0x18, 0x98, 0x98, 0x98, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x08, 0x08, 0x00, 0x13, 0x23, 0x63, 0x63, 0x63, 0x63, 0x63, 0x7F, 0x3F, 0x1E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 53
    0xC0, 0xD0, 0xD8, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x08, 0x08, 0x1F, 0x3F, 0x7F, 0x63, 0x63, 0x63, 0x63, 0x7F, 0x3F, 0x1C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 54
    0x38, 0x18, 0x18, 0x18, 0x18, 0x18, 0x98, 0xD8, 0xD8, 0x58, 0x18, 0x08, 0x00, 0x00, 0x00, 0x00, 0xFE, 0xFF, 0xFF, 0x3F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 55
    0xE0, 0xF0, 0xF8, 0x98, 0x18, 0x18, 0x18, 0xF8, 0xF0, 0xE0, 0x1C, 0x3F, 0x7F, 0x63, 0x63, 0x63, 0x63, 0x7F, 0x3F, 0x1C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 56
    0xE0, 0xF0, 0xF8, 0x18, 0x18, 0x18, 0x18, 0xF8, 0xF0, 0xE0, 0x01, 0x43, 0x43, 0x43, 0x43, 0x23, 0x33, 0x3F, 0x1F, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 57
    0x00, 0x00, 0x00, 0x00, 0x66, 0x66, 0x66, 0x20, 0x00, 0x00, 0x00, 0x00, // 58
    0x00, 0x00, 0x00, 0x00, 0x46, 0xE6, 0xE6, 0x40, 0x00, 0x00, 0x00, 0x00, // 59
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x0E, 0x0E, 0x0E, 0x1B, 0x13, 0x13, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 60
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 61
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x13, 0x13, 0x1B, 0x0E, 0x0E, 0x0E, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 62
    0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x98, 0xF8, 0xF8, 0xF8, 0x30, 0x00, 0x00, 0x00, 0x60, 0x60, 0x62, 0x23, 0x03, 0x03, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 63
    0xC0, 0xF0, 0xF0, 0x38, 0x18, 0x18, 0x18, 0x18, 0x38, 0xF0, 0xF0, 0xE0, 0x0F, 0x3F, 0x3F, 0x70, 0x60, 0x60, 0x63, 0x63, 0x63, 0x43, 0x43, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 64
    0x00, 0x00, 0x80, 0xC0, 0xD0, 0xD0, 0x38, 0x78, 0xF8, 0xF8, 0xE0, 0x00, 0x00, 0x00, 0x60, 0x7C, 0x7F, 0x3F, 0x0F, 0x0C, 0x0C, 0x0C, 0x09, 0x07, 0x3F, 0x7F, 0x78, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 65
    0x18, 0xD8, 0xD8, 0xD8, 0x18, 0x18, 0x18, 0x18, 0x18, 0x38, 0xF8, 0xF8, 0xF0, 0x00, 0x7F, 0x7F, 0x7F, 0x60, 0x60, 0x61, 0x62, 0x62, 0x75, 0x7B, 0x71, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 66
    0xC0, 0xD0, 0xD8, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x38, 0x18, 0x08, 0x07, 0x1F, 0x3F, 0x78, 0x70, 0x60, 0x60, 0x20, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 67
    0x18, 0xD8, 0xD8, 0xD8, 0x18, 0x18, 0x18, 0x18, 0x38, 0xF8, 0xF8, 0xF8, 0x00, 0x7F, 0x7F, 0x7F, 0x60, 0x70, 0x38, 0x1C, 0x0E, 0x07, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 68
    0x18, 0xD8, 0xD8, 0xD8, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x08, 0x08, 0x00, 0x7F, 0x7F, 0x7F, 0x63, 0x63, 0x63, 0x61, 0x60, 0x20, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 69
    0x18, 0xD8, 0xD8, 0xD8, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x08, 0x08, 0x00, 0x7F, 0x7F, 0x7F, 0x03, 0x03, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 70
    0xC0, 0xD0, 0xD8, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x38, 0x18, 0x08, 0x07, 0x1F, 0x3F, 0x78, 0x60, 0x60, 0x60, 0x70, 0x3E, 0x1E, 0x0E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 71
    0x38, 0xF8, 0xF8, 0xF8, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF8, 0xF8, 0xF8, 0xF8, 0x00, 0x7F, 0x7F, 0x7F, 0x00, 0x0C, 0x0C, 0x0C, 0x0C, 0x7F, 0x7F, 0x7F, 0x7F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 72
    0xF8, 0xF8, 0xF8, 0xF8, 0xFF, 0xFF, 0xFF, 0x3F, 0x00, 0x80, 0x00, 0x00, // 73
    0x00, 0x00, 0x00, 0xF8, 0xF8, 0xF8, 0xF8, 0x40, 0x40, 0x30, 0x1F, 0x0F, 0x07, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 74
    0x38, 0xF8, 0xF8, 0xF8, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF8, 0xF8, 0xF8, 0xF8, 0x00, 0x7F, 0x7F, 0x7F, 0x00, 0x10, 0x38, 0x7C, 0x7E, 0x7F, 0x67, 0x43, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 75
    0x18, 0xF8, 0xF8, 0xF8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7F, 0x7F, 0x7F, 0x60, 0x60, 0x60, 0x60, 0x60, 0x20, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 76
    0x18, 0xD8, 0xD8, 0xD8, 0x38, 0xF8, 0xE0, 0x80, 0x00, 0x00, 0x80, 0xC0, 0x90, 0x38, 0xF8, 0xF8, 0xF8, 0x00, 0x7F, 0x7F, 0x7F, 0x00, 0x00, 0x03, 0x0F, 0x3C, 0x3C, 0x0F, 0x03, 0x00, 0x00, 0x7F, 0x7F, 0x7F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 77
    0x18, 0xD8, 0xD8, 0xD8, 0x38, 0xF8, 0xE0, 0x80, 0x00, 0x00, 0xF8, 0xF8, 0xF8, 0x00, 0x7F, 0x7F, 0x7F, 0x00, 0x00, 0x03, 0x0F, 0x3C, 0xF0, 0xFF, 0xFF, 0x7F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00, // 78
    0xC0, 0xF0, 0xF0, 0x38, 0x18, 0x18, 0x18, 0x18, 0x38, 0xF0, 0xF0, 0xC0, 0x0F, 0x3F, 0x3F, 0x70, 0x60, 0x60, 0x60, 0x60, 0x70, 0x3F, 0x3F, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 79
    0x18, 0xD8, 0xD8, 0xD8, 0x18, 0x18, 0x18, 0x18, 0x38, 0xF8, 0xF8, 0xF8, 0xF0, 0x00, 0x7F, 0x7F, 0x7F, 0x00, 0x00, 0x00, 0x08, 0x0E, 0x0F, 0x0F, 0x07, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 80
    0xC0, 0xF0, 0xF0, 0x38, 0x18, 0x18, 0x18, 0x18, 0x38, 0xF0, 0xF0, 0xC0, 0x0F, 0x3F, 0x3F, 0x70, 0x60, 0x60, 0x60, 0x60, 0x00, 0xFF, 0xFF, 0x7F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00, // 81
    0x18, 0xD8, 0xD8, 0xD8, 0x18, 0x18, 0x18, 0x18, 0x38, 0xF8, 0xF8, 0xF8, 0xF0, 0x00, 0x7F, 0x7F, 0x7F, 0x00, 0x00, 0x10, 0x38, 0x7E, 0x7F, 0x7F, 0x67, 0x41, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 82
    0x00, 0x10, 0x58, 0xD8, 0xD8, 0x98, 0x18, 0x18, 0x18, 0x18, 0x18, 0x38, 0x18, 0x08, 0x60, 0x70, 0x60, 0x60, 0x61, 0x61, 0x63, 0x67, 0x6E, 0x7C, 0x78, 0x70, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 83
    0x38, 0x18, 0x18, 0x18, 0xD8, 0xD8, 0xD8, 0xD8, 0x18, 0x18, 0x18, 0x18, 0x08, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0x3F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 84
    0x38, 0xF8, 0xF8, 0xF8, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF8, 0xF8, 0xF8, 0xF8, 0x00, 0x0F, 0x3F, 0x3F, 0x70, 0x60, 0x60, 0x60, 0x60, 0x7F, 0x3F, 0x3F, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 85
    0x10, 0x30, 0x70, 0xF8, 0xF0, 0xC0, 0x00, 0x00, 0x00, 0x00, 0xC0, 0xF0, 0xF8, 0x38, 0x08, 0x00, 0x00, 0x00, 0x00, 0x03, 0x0F, 0x3F, 0xFC, 0xFC, 0x3F, 0x0F, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 86
    0x10, 0x30, 0x70, 0xF8, 0xF0, 0xC0, 0x00, 0x00, 0x00, 0x00, 0xC0, 0xF0, 0xF8, 0x38, 0x08, 0x00, 0xC0, 0xF0, 0xF8, 0x38, 0x08, 0x00, 0x00, 0x00, 0x00, 0x03, 0x0F, 0x3F, 0xFC, 0xFC, 0x3F, 0x0F, 0x23, 0x70, 0xF0, 0xFC, 0x3F, 0x0F, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 87
    0x10, 0x30, 0x30, 0x78, 0x70, 0xE0, 0xC0, 0x80, 0x80, 0xC0, 0x60, 0x30, 0x18, 0x08, 0x00, 0x00, 0x00, 0x00, 0x40, 0x60, 0x38, 0x1C, 0x0F, 0x07, 0x07, 0x0C, 0x18, 0x78, 0x70, 0x30, 0x20, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 88
    0x10, 0x10, 0x30, 0x38, 0x70, 0xE0, 0xC0, 0x80, 0x80, 0xC0, 0xE0, 0x70, 0x38, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0x3F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 89
    0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x98, 0x98, 0xD8, 0xD8, 0x58, 0x18, 0x00, 0x70, 0x78, 0x7C, 0x7E, 0x6E, 0x67, 0x63, 0x61, 0x60, 0x60, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 90
    0xD8, 0xD8, 0xD8, 0x18, 0x18, 0x18, 0x7F, 0x7F, 0x7F, 0x60, 0x60, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 91
    0x08, 0x18, 0x70, 0xE0, 0xC0, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x03, 0x07, 0x0E, 0x1C, 0x38, 0x70, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 92
    0x18, 0x18, 0x18, 0xD8, 0xD8, 0xD8, 0x60, 0x60, 0x60, 0x7F, 0x7F, 0x7F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 93
    0x40, 0x60, 0x70, 0x38, 0x18, 0x38, 0x70, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 94
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 95
    0x08, 0x18, 0x38, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 96
    0x00, 0x00, 0x80, 0xC0, 0xD0, 0xD0, 0x38, 0x78, 0xF8, 0xF8, 0xE0, 0x00, 0x00, 0x00, 0x60, 0x7C, 0x7F, 0x3F, 0x0F, 0x0C, 0x0C, 0x0C, 0x09, 0x07, 0x3F, 0x7F, 0x78, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 97
    0x18, 0xD8, 0xD8, 0xD8, 0x18, 0x18, 0x18, 0x18, 0x18, 0x38, 0xF8, 0xF8, 0xF0, 0x00, 0x7F, 0x7F, 0x7F, 0x60, 0x60, 0x61, 0x62, 0x62, 0x75, 0x7B, 0x71, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 98
    0xC0, 0xD0, 0xD8, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x38, 0x18, 0x08, 0x07, 0x1F, 0x3F, 0x78, 0x70, 0x60, 0x60, 0x20, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 99
    0x18, 0xD8, 0xD8, 0xD8, 0x18, 0x18, 0x18, 0x18, 0x38, 0xF8, 0xF8, 0xF8, 0x00, 0x7F, 0x7F, 0x7F, 0x60, 0x70, 0x38, 0x1C, 0x0E, 0x07, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 100
    0x18, 0xD8, 0xD8, 0xD8, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x08, 0x08, 0x00, 0x7F, 0x7F, 0x7F, 0x63, 0x63, 0x63, 0x61, 0x60, 0x20, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 101
    0x18, 0xD8, 0xD8, 0xD8, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x08, 0x08, 0x00, 0x7F, 0x7F, 0x7F, 0x03, 0x03, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 102
    0xC0, 0xD0, 0xD8, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x38, 0x18, 0x08, 0x07, 0x1F, 0x3F, 0x78, 0x60, 0x60, 0x60, 0x70, 0x3E, 0x1E, 0x0E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 103
    0x38, 0xF8, 0xF8, 0xF8, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF8, 0xF8, 0xF8, 0xF8, 0x00, 0x7F, 0x7F, 0x7F, 0x00, 0x0C, 0x0C, 0x0C, 0x0C, 0x7F, 0x7F, 0x7F, 0x7F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 104
    0xF8, 0xF8, 0xF8, 0xF8, 0xFF, 0xFF, 0xFF, 0x3F, 0x00, 0x80, 0x00, 0x00, // 105
    0x00, 0x00, 0x00, 0xF8, 0xF8, 0xF8, 0xF8, 0x40, 0x40, 0x30, 0x1F, 0x0F, 0x07, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 106
    0x38, 0xF8, 0xF8, 0xF8, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF8, 0xF8, 0xF8, 0xF8, 0x00, 0x7F, 0x7F, 0x7F, 0x00, 0x10, 0x38, 0x7C, 0x7E, 0x7F, 0x67, 0x43, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 107
    0x18, 0xF8, 0xF8, 0xF8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7F, 0x7F, 0x7F, 0x60, 0x60, 0x60, 0x60, 0x60, 0x20, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 108
    0x18, 0xD8, 0xD8, 0xD8, 0x38, 0xF8, 0xE0, 0x80, 0x00, 0x00, 0x80, 0xC0, 0x90, 0x38, 0xF8, 0xF8, 0xF8, 0x00, 0x7F, 0x7F, 0x7F, 0x00, 0x00, 0x03, 0x0F, 0x3C, 0x3C, 0x0F, 0x03, 0x00, 0x00, 0x7F, 0x7F, 0x7F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 109
    0x18, 0xD8, 0xD8, 0xD8, 0x38, 0xF8, 0xE0, 0x80, 0x00, 0x00, 0xF8, 0xF8, 0xF8, 0x00, 0x7F, 0x7F, 0x7F, 0x00, 0x00, 0x03, 0x0F, 0x3C, 0xF0, 0xFF, 0xFF, 0x7F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00, // 110
    0xC0, 0xF0, 0xF0, 0x38, 0x18, 0x18, 0x18, 0x18, 0x38, 0xF0, 0xF0, 0xC0, 0x0F, 0x3F, 0x3F, 0x70, 0x60, 0x60, 0x60, 0x60, 0x70, 0x3F, 0x3F, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 111
    0x18, 0xD8, 0xD8, 0xD8, 0x18, 0x18, 0x18, 0x18, 0x38, 0xF8, 0xF8, 0xF8, 0xF0, 0x00, 0x7F, 0x7F, 0x7F, 0x00, 0x00, 0x00, 0x08, 0x0E, 0x0F, 0x0F, 0x07, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 112
    0xC0, 0xF0, 0xF0, 0x38, 0x18, 0x18, 0x18, 0x18, 0x38, 0xF0, 0xF0, 0xC0, 0x0F, 0x3F, 0x3F, 0x70, 0x60, 0x60, 0x60, 0x60, 0x00, 0xFF, 0xFF, 0x7F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00, // 113
    0x18, 0xD8, 0xD8, 0xD8, 0x18, 0x18, 0x18, 0x18, 0x38, 0xF8, 0xF8, 0xF8, 0xF0, 0x00, 0x7F, 0x7F, 0x7F, 0x00, 0x00, 0x10, 0x38, 0x7E, 0x7F, 0x7F, 0x67, 0x41, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 114
    0x00, 0x10, 0x58, 0xD8, 0xD8, 0x98, 0x18, 0x18, 0x18, 0x18, 0x18, 0x38, 0x18, 0x08, 0x60, 0x70, 0x60, 0x60, 0x61, 0x61, 0x63, 0x67, 0x6E, 0x7C, 0x78, 0x70, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 115
    0x38, 0x18, 0x18, 0x18, 0xD8, 0xD8, 0xD8, 0xD8, 0x18, 0x18, 0x18, 0x18, 0x08, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0x3F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 116
    0x38, 0xF8, 0xF8, 0xF8, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF8, 0xF8, 0xF8, 0xF8, 0x00, 0x0F, 0x3F, 0x3F, 0x70, 0x60, 0x60, 0x60, 0x60, 0x7F, 0x3F, 0x3F, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 117
    0x10, 0x30, 0x70, 0xF8, 0xF0, 0xC0, 0x00, 0x00, 0x00, 0x00, 0xC0, 0xF0, 0xF8, 0x38, 0x08, 0x00, 0x00, 0x00, 0x00, 0x03, 0x0F, 0x3F, 0xFC, 0xFC, 0x3F, 0x0F, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 118
    0x10, 0x30, 0x70, 0xF8, 0xF0, 0xC0, 0x00, 0x00, 0x00, 0x00, 0xC0, 0xF0, 0xF8, 0x38, 0x08, 0x00, 0xC0, 0xF0, 0xF8, 0x38, 0x08, 0x00, 0x00, 0x00, 0x00, 0x03, 0x0F, 0x3F, 0xFC, 0xFC, 0x3F, 0x0F, 0x23, 0x70, 0xF0, 0xFC, 0x3F, 0x0F, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 119
    0x10, 0x30, 0x30, 0x78, 0x70, 0xE0, 0xC0, 0x80, 0x80, 0xC0, 0x60, 0x30, 0x18, 0x08, 0x00, 0x00, 0x00, 0x00, 0x40, 0x60, 0x38, 0x1C, 0x0F, 0x07, 0x07, 0x0C, 0x18, 0x78, 0x70, 0x30, 0x20, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 120
    0x10, 0x10, 0x30, 0x38, 0x70, 0xE0, 0xC0, 0x80, 0x80, 0xC0, 0xE0, 0x70, 0x38, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0x3F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 121
    0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x98, 0x98, 0xD8, 0xD8, 0x58, 0x18, 0x00, 0x70, 0x78, 0x7C, 0x7E, 0x6E, 0x67, 0x63, 0x61, 0x60, 0x60, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 122
    0xD8, 0xD8, 0xD8, 0x18, 0x18, 0x18, 0x7F, 0x7F, 0x7F, 0x60, 0x60, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 123
    0xF8, 0xF8, 0xF8, 0xFF, 0xFF, 0xFF, 0x80, 0x80, 0x80, // 124
    0x18, 0x18, 0x18, 0xD8, 0xD8, 0xD8, 0x60, 0x60, 0x60, 0x7F, 0x7F, 0x7F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 125
    0x60, 0x70, 0x30, 0x30, 0x20, 0x60, 0x60, 0x78, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 126
    0xFF, 0x03, 0x03, 0x03, 0x03, 0xFF, 0x7F, 0x60, 0x60, 0x60, 0x60, 0x7F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 // 127
    
};

#endif
