//ATmega8 8 MHz
#include <mega8.h>
#include <1wire.h>
#include <ds18b20.h>
#include <delay.h>
#define ADC_VREF_TYPE 0x40

#define ACCOUT  PORTD.5
#define PRF     PORTB.0
#define PSU     PORTD.7
#define AUX     PORTD.6
#define HEATER  PORTB.1
#define ACC     ~PIND.3
#define ATX     ~PIND.2
#define P1      ~PINC.4
#define P2      ~PINC.5
#define SW      PORTC.3
#define MN      PORTC.2
#define HTRflag PINB.1

unsigned char i=0;
char mode=0;                            // 
eeprom char zero=255;                   //     
unsigned char buffer[16];                // 

unsigned char control=0;                //   

unsigned char devices;                  //  
signed char temp=0;                     //
float temp0=0;
bit temp_ok=0;
int temp_sec=0;
bit temp_countover=0;                   //,      

unsigned int CS_count=0;
bit uart_idle=1;
unsigned char uart_time=0;

//  :
eeprom signed char temp_s=1;            // 
eeprom char temp_ign=1;                 // 
eeprom unsigned char temp_timer=1;      //  .  0 -  
bit volt_ok=1;                          //  
unsigned char volt=0;                   // 
unsigned char volt_sec=0;               //   
//  :
eeprom unsigned char volt_set=1;        // 
eeprom unsigned int volt_timer=1;       //  .

//eeprom
eeprom unsigned char turnon_timer=1;
eeprom unsigned char turnoff_timer=1;
eeprom unsigned char ign_timer=1;
eeprom unsigned char outset[6];         //  

unsigned char ignofftime=0;
unsigned char waitatx_on=0;
unsigned char waitatx_off=0;

bit prfon=0;
unsigned char prfcount=0;
bit auxon=0;
unsigned char auxcount=0;

unsigned char p1count=0;
unsigned char p2count=0;


#define RX_BUFFER_SIZE 16
char rx_buffer[RX_BUFFER_SIZE];
unsigned char rx_counter;
//unsigned char rx_wr_index,rx_rd_index,rx_counter;
//bit rx_buffer_overflow;

interrupt [USART_RXC] void usart_rx_isr(void)
{
  char status,data;
  status=UCSRA;
  data=UDR;
  if ((status & 0x1C)==0)
  {
    if(data==0x55)rx_counter=0;
    rx_buffer[rx_counter++]=data;
    uart_idle=0;
    uart_time=0; 
    /*
    rx_buffer[rx_wr_index++]=data;
    if (rx_wr_index == RX_BUFFER_SIZE) rx_wr_index=0;
    if (++rx_counter == RX_BUFFER_SIZE)
    {
      rx_counter=0;
      rx_buffer_overflow=1;
    }
    */
  }
}

/*
#ifndef _DEBUG_TERMINAL_IO_
#define _ALTERNATE_GETCHAR_
#pragma used+
char getchar(void)
{
char data;
while (rx_counter==0);
data=rx_buffer[rx_rd_index++];
#if RX_BUFFER_SIZE != 256
if (rx_rd_index == RX_BUFFER_SIZE) rx_rd_index=0;
#endif
#asm("cli")
--rx_counter;
#asm("sei")
return data;
}
#pragma used-
#endif
*/
#include <stdio.h>

interrupt [EXT_INT1] void ext_int1_isr(void)
{

}

unsigned int read_adc(unsigned char adc_input)
{
ADMUX=adc_input | (ADC_VREF_TYPE & 0xff);
delay_us(10);
ADCSRA|=0x40;
while ((ADCSRA & 0x10)==0);
ADCSRA|=0x10;
return ADCW;
}

void sleep()
{
  #asm("cli")
  mode=0;     //  
  temp_ok=0;  // 
  volt_ok=0; 
  volt_sec=0; 
  rx_counter=0;
  waitatx_on=0;
  waitatx_off=0;
  ignofftime=0;
  auxcount=0;
  prfcount=0;
  temp_sec=0;
  GICR|=0x80;
  MCUCR=0xA0;
  GIFR=0x80;
  #asm("sei")
  #asm("sleep")
  #asm("cli")
  GICR=0x00;
  TCNT1H=0x00;
  TCNT1L=0x00;
  MCUCR=0x00;
  GIFR=0x00;
  #asm("sei")
}

void all_off()
{
  PSU=0;      // 
  ACCOUT=0;
  AUX=0;
  PRF=0;
  HEATER=0;
  SW=0;
  MN=0;
  //PORTC.0=0;
  mode=0; 
  sleep();
}

void swblink()
{
  SW=1;
  delay_ms((outset[2]>>2)*100);
  SW=0; 
}

void mnblink()
{
  MN=1;
  delay_ms((outset[3]>>2)*100);
  MN=0;
}

interrupt [TIM1_COMPA] void timer1_compa_isr(void)
{
  TCNT1H=0x00;
  TCNT1L=0x00;
  //PORTC.0=~PINC.0;
  if(!volt_ok)// 
  {
    volt_sec++;
    if(volt_sec>=volt_timer)//     
    {
      ACCOUT=0;
      if((outset[2]&0x03)==1)swblink();
      mode=4;  
    }
  }
  if(!ACC)
  {
    ignofftime++;
    if(ignofftime>ign_timer)
    {
      ACCOUT=0;
      if((outset[2]&0x03)==1 && mode!=4)swblink();
      mode=4;
    }
  }
  if(temp_timer!=0 && HTRflag && !temp_countover) //  ,  ,   
  {
    temp_sec++;//   
    if(temp_sec>=temp_timer) //   
    { 
      temp_sec=0;// 
      temp_ok=1;//  .      
      HEATER=0;// 
      temp_countover=1;// 
    }
  }
  if(mode==2 && !ATX)
  {
    waitatx_on++;
    if(waitatx_on>turnon_timer)
    {
      PSU=0;
      ACCOUT=0;
      if((outset[2]&0x03)==1)swblink();
      waitatx_on=0;
      mode=4;
    }
  }
  if(mode==4 && ATX)
  {
    waitatx_off++;
    if(waitatx_off>turnoff_timer)
    {
      all_off();
      waitatx_off=0;
    }
  }
  if(prfon && PINB.0==0)
  {
    prfcount++;
    if(prfcount>=(outset[0]>>2))
    {
      PRF=1;
      prfon=0;
      prfcount=0;
    }
  }
  if(auxon && PIND.6==0)
  {
    auxcount++;
    if(auxcount>=(outset[1]>>2))
    {
      AUX=1;
      auxon=0;
      auxcount=0;
    }
  } 
  
  if(P1 && (outset[4]&0x03)==1)
  {
    p1count++;
    if(p1count>=(outset[4]>>2))
    {
      p1count=0; 
      if((outset[4]&0x03)==1)
      {
        ACCOUT=0;
        if((outset[2]&0x03)==1)swblink();
        mode=4;
      }
    } 
  }
  
  if(P2 && (outset[5]&0x03)==1)
  {
    p2count++;
    if(p2count>=(outset[5]>>2))
    {
      p2count=0; 
      if((outset[5]&0x03)==1)
      {
        ACCOUT=0;
        if((outset[2]&0x03)==1)swblink();
        mode=4;
      }
    } 
  }
  
  if(!uart_idle)
  {
    uart_time++;
    if(uart_time>30)
    {
      uart_time=0;
      uart_idle=1;
    }
  } 
}

void voltmeter()
{
   unsigned int u=0;
   u=read_adc(1);       //   
   volt=u/4.35;        //  
   if(volt<volt_set)    // 
   {
     volt_ok=0;         //   
   }
   else                 // 
   {
     volt_sec=0;        //   
     volt_ok=1;         // 
   }
   //printf("adc: %i ",u);
   //printf("volt: %i ",volt);
   //putchar(10);
   
}

void send_data(unsigned char m) //  
{
  int i=0;
  unsigned int CS_send=0;
  buffer[0]=0x55;
  buffer[1]=0xFF;
  buffer[2]=m;
  if(m==0xC7)  // 
  {
    buffer[3]=volt;
    buffer[4]=temp+40;
    buffer[5]=control;
    buffer[6]=(volt_ok<<7)|(temp_ok<<6)|devices;
    buffer[7]=mode;
  }
  if(m==0xF8) // 
  {
    buffer[3]=volt_set;
    buffer[4]=(temp_ign<<7)|((temp_s+40)&0x7f);
    buffer[5]=temp_timer;
    buffer[6]=volt_timer;
    buffer[7]=ign_timer;
    buffer[8]=turnon_timer;
    buffer[9]=turnoff_timer;
  }
  if(m==0xBA) //  
  {
    for(i=0;i<6;i++)
    {
      buffer[i+3]=outset[i];
    }
  }
  for(i=0;i<11;i++)
  {
     CS_send = CS_send + buffer[i];//  
  }
  CS_send= CS_send & 0xFF;
  buffer[11]=CS_send;//checksum
  for(i=0;i<12;i++)
  {
    putchar(buffer[i]); //
  }
}

void main(void)
{ 
PORTB=0x00;
DDRB=0x03;
PORTC=0x30;
DDRC=0x0C;
PORTD=0x0C;
DDRD=0xE0;

TCCR0=0x00;
TCNT0=0x00;
TCCR1A=0x00;
TCCR1B=0x04;
TCNT1H=0x00;
TCNT1L=0x00;
ICR1H=0x00;
ICR1L=0x00;
OCR1AH=0x7A;
OCR1AL=0x12;
OCR1BH=0x00;
OCR1BL=0x00;
ASSR=0x00;
TCCR2=0x00;
TCNT2=0x00;
OCR2=0x00;

//GICR|=0x80;
MCUCR=0x00;
//GIFR=0x80;

TIMSK=0x10;
//TIMSK=0x00;

UCSRA=0x00;
UCSRB=0x98;
UCSRC=0x86;
UBRRH=0x00;
UBRRL=0x33;
ACSR=0x80;
SFIOR=0x00;
ADMUX=ADC_VREF_TYPE & 0xff;
ADCSRA=0x84;
SPCR=0x00;
TWCR=0x00;
w1_init();
devices=(ds18b20_init(0,20,30,DS18B20_9BIT_RES));// 
#asm("sei")

while (1)
      {
        control=((PIND&0x60)<<1)|(~PINC&0x30)|(~PIND&0x0C)|(PINB&0x03);//   /
        voltmeter();                            //  
        //delay_ms(1000);
         
                                                                   
        if(mode<4)                              //  ,   
        {
          temp0=ds18b20_temperature(0);         // 
          if(temp0!=200)temp=temp0;             //  ,  
          if((outset[4]&0x03)==2)AUX=!P1;       // ,       
          if((outset[4]&0x03)==3)PRF=!P1;
          if((outset[5]&0x03)==2)AUX=!P2;
          if((outset[5]&0x03)==3)PRF=!P2;
        }
        
        if(ACC)                                 // ACC
        {
          ignofftime=0;                         // 
          if(mode==0 && volt_ok)                //       
          {
            PSU=1;                              //  
            if((outset[0]&0x03)==1)prfon=1;     // ,  PRF
            if((outset[1]&0x03)==1)auxon=1;     // ,  AUX
            if((outset[2]&0x03)==2)swblink();
            if((outset[3]&0x03)==2)mnblink();
            mode=1;
            temp_ok=0;                             //   
          }
        }
        switch(mode)
        {
          case 1:                               // 
            if (temp_ign==0)                    //  
            {
              if(devices>0)                     // 
              {
                if(temp<temp_s && !temp_ok)     //   ,    
                {
                  temp_ok=0;
                  HEATER=1;                     // 
                }
                else                            // 
                {
                  HEATER=0;                     // 
                  temp_ok=1;                    //  
                  temp_sec=0;                   // 
                }
              }
              else                              // 
              {
                temp_ok=1;                      //,   ,  
                HEATER=0;                       // 
              }
            }
            else 
            {
              temp_ok=1;                        // ,  ,   
              HEATER=0;                         // 
            }
            if(volt_ok==1 && temp_ok==1)       //  ,    
            {
               if((outset[2]&0x03)==0)ACCOUT=1;//      
               if((outset[2]&0x03)==1)swblink();
               if((outset[3]&0x03)==1)mnblink();
               if((outset[0]&0x03)==2)prfon=1; // ,  PRF
               if((outset[1]&0x03)==2)auxon=1; // ,  AUX
               mode=2;                         //     
            }
          break;
          case 2:                               //   
             if(ATX)                            //    
             {
               waitatx_on=0;                    //  
               if((outset[0]&0x03)==3)prfon=1;  // ,  PRF
               if((outset[1]&0x03)==3)auxon=1;  // ,  AUX
               if((outset[2]&0x03)==3)swblink(); 
               if((outset[3]&0x03)==3)mnblink();
               mode=3;                          //   
             }
          break;
          case 3:                               // .   ,    ,      
            if(!ATX)                            //   atx,   
            {
              all_off();
            }
          break;
          case 4:                                           //  
            if(!ATX)                                        //   ATX
            {
              waitatx_off=0;                                //   
              all_off();
            }
          break;
        }
        
        if(rx_counter>11)
        {
          rx_counter=0;                                     // 
          CS_count=0;                                       //    

          for(i=0;i<11;i++)
          {
             CS_count = CS_count + rx_buffer[i];            //  
          } 
          CS_count= CS_count & 0xFF;
          if(CS_count==rx_buffer[11])                       // 
          {
            if(rx_buffer[0]==0x55 && rx_buffer[1]==0xFF)    //  
            {
              if(rx_buffer[2]==0xC6)                        //  
              {
                send_data(0xC7);                            //
              }
              else if(rx_buffer[2]==0x78)                   //  
              {
                send_data(0xF8);                            //
              }
              else if(rx_buffer[2]==0xDC)                   // c
              {
                volt_set=rx_buffer[3];
                temp_s=(rx_buffer[4]&0x7F)-40;
                temp_ign=(rx_buffer[4]>>7)&0x01;
                temp_timer=rx_buffer[5];
                ign_timer=rx_buffer[6];
                volt_timer=rx_buffer[7];
                turnoff_timer=rx_buffer[8];
                turnon_timer=rx_buffer[9];                  // 
                send_data(0xF8);                            //
              }
              else if(rx_buffer[2]==0x5D)                   //  
              {
                send_data(0xBA);                            //
              }
              else if(rx_buffer[2]==0xA3)                   //  
              {
                for(i=0;i<6;i++)
                {
                  outset[i]=rx_buffer[i+3];                 //  
                }
                send_data(0xBA);                            //
              } 
            }
          }
        } 
        
      }
}
