
;CodeVisionAVR C Compiler V2.05.3 Standard
;(C) Copyright 1998-2011 Pavel Haiduc, HP InfoTech s.r.l.
;http://www.hpinfotech.com

;Chip type                : ATmega8
;Program type             : Application
;Clock frequency          : 8,000000 MHz
;Memory model             : Small
;Optimize for             : Size
;(s)printf features       : int, width
;(s)scanf features        : int, width
;External RAM size        : 0
;Data Stack size          : 256 byte(s)
;Heap size                : 0 byte(s)
;Promote 'char' to 'int'  : Yes
;'char' is unsigned       : Yes
;8 bit enums              : Yes
;Global 'const' stored in FLASH     : No
;Enhanced function parameter passing: Yes
;Enhanced core instructions         : On
;Smart register allocation          : On
;Automatic register allocation      : On

	#pragma AVRPART ADMIN PART_NAME ATmega8
	#pragma AVRPART MEMORY PROG_FLASH 8192
	#pragma AVRPART MEMORY EEPROM 512
	#pragma AVRPART MEMORY INT_SRAM SIZE 1119
	#pragma AVRPART MEMORY INT_SRAM START_ADDR 0x60

	.LISTMAC
	.EQU UDRE=0x5
	.EQU RXC=0x7
	.EQU USR=0xB
	.EQU UDR=0xC
	.EQU SPSR=0xE
	.EQU SPDR=0xF
	.EQU EERE=0x0
	.EQU EEWE=0x1
	.EQU EEMWE=0x2
	.EQU EECR=0x1C
	.EQU EEDR=0x1D
	.EQU EEARL=0x1E
	.EQU EEARH=0x1F
	.EQU WDTCR=0x21
	.EQU MCUCR=0x35
	.EQU GICR=0x3B
	.EQU SPL=0x3D
	.EQU SPH=0x3E
	.EQU SREG=0x3F

	.DEF R0X0=R0
	.DEF R0X1=R1
	.DEF R0X2=R2
	.DEF R0X3=R3
	.DEF R0X4=R4
	.DEF R0X5=R5
	.DEF R0X6=R6
	.DEF R0X7=R7
	.DEF R0X8=R8
	.DEF R0X9=R9
	.DEF R0XA=R10
	.DEF R0XB=R11
	.DEF R0XC=R12
	.DEF R0XD=R13
	.DEF R0XE=R14
	.DEF R0XF=R15
	.DEF R0X10=R16
	.DEF R0X11=R17
	.DEF R0X12=R18
	.DEF R0X13=R19
	.DEF R0X14=R20
	.DEF R0X15=R21
	.DEF R0X16=R22
	.DEF R0X17=R23
	.DEF R0X18=R24
	.DEF R0X19=R25
	.DEF R0X1A=R26
	.DEF R0X1B=R27
	.DEF R0X1C=R28
	.DEF R0X1D=R29
	.DEF R0X1E=R30
	.DEF R0X1F=R31

	.EQU __SRAM_START=0x0060
	.EQU __SRAM_END=0x045F
	.EQU __DSTACK_SIZE=0x0100
	.EQU __HEAP_SIZE=0x0000
	.EQU __CLEAR_SRAM_SIZE=__SRAM_END-__SRAM_START+1

	.MACRO __CPD1N
	CPI  R30,LOW(@0)
	LDI  R26,HIGH(@0)
	CPC  R31,R26
	LDI  R26,BYTE3(@0)
	CPC  R22,R26
	LDI  R26,BYTE4(@0)
	CPC  R23,R26
	.ENDM

	.MACRO __CPD2N
	CPI  R26,LOW(@0)
	LDI  R30,HIGH(@0)
	CPC  R27,R30
	LDI  R30,BYTE3(@0)
	CPC  R24,R30
	LDI  R30,BYTE4(@0)
	CPC  R25,R30
	.ENDM

	.MACRO __CPWRR
	CP   R@0,R@2
	CPC  R@1,R@3
	.ENDM

	.MACRO __CPWRN
	CPI  R@0,LOW(@2)
	LDI  R30,HIGH(@2)
	CPC  R@1,R30
	.ENDM

	.MACRO __ADDB1MN
	SUBI R30,LOW(-@0-(@1))
	.ENDM

	.MACRO __ADDB2MN
	SUBI R26,LOW(-@0-(@1))
	.ENDM

	.MACRO __ADDW1MN
	SUBI R30,LOW(-@0-(@1))
	SBCI R31,HIGH(-@0-(@1))
	.ENDM

	.MACRO __ADDW2MN
	SUBI R26,LOW(-@0-(@1))
	SBCI R27,HIGH(-@0-(@1))
	.ENDM

	.MACRO __ADDW1FN
	SUBI R30,LOW(-2*@0-(@1))
	SBCI R31,HIGH(-2*@0-(@1))
	.ENDM

	.MACRO __ADDD1FN
	SUBI R30,LOW(-2*@0-(@1))
	SBCI R31,HIGH(-2*@0-(@1))
	SBCI R22,BYTE3(-2*@0-(@1))
	.ENDM

	.MACRO __ADDD1N
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	SBCI R22,BYTE3(-@0)
	SBCI R23,BYTE4(-@0)
	.ENDM

	.MACRO __ADDD2N
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	SBCI R24,BYTE3(-@0)
	SBCI R25,BYTE4(-@0)
	.ENDM

	.MACRO __SUBD1N
	SUBI R30,LOW(@0)
	SBCI R31,HIGH(@0)
	SBCI R22,BYTE3(@0)
	SBCI R23,BYTE4(@0)
	.ENDM

	.MACRO __SUBD2N
	SUBI R26,LOW(@0)
	SBCI R27,HIGH(@0)
	SBCI R24,BYTE3(@0)
	SBCI R25,BYTE4(@0)
	.ENDM

	.MACRO __ANDBMNN
	LDS  R30,@0+(@1)
	ANDI R30,LOW(@2)
	STS  @0+(@1),R30
	.ENDM

	.MACRO __ANDWMNN
	LDS  R30,@0+(@1)
	ANDI R30,LOW(@2)
	STS  @0+(@1),R30
	LDS  R30,@0+(@1)+1
	ANDI R30,HIGH(@2)
	STS  @0+(@1)+1,R30
	.ENDM

	.MACRO __ANDD1N
	ANDI R30,LOW(@0)
	ANDI R31,HIGH(@0)
	ANDI R22,BYTE3(@0)
	ANDI R23,BYTE4(@0)
	.ENDM

	.MACRO __ANDD2N
	ANDI R26,LOW(@0)
	ANDI R27,HIGH(@0)
	ANDI R24,BYTE3(@0)
	ANDI R25,BYTE4(@0)
	.ENDM

	.MACRO __ORBMNN
	LDS  R30,@0+(@1)
	ORI  R30,LOW(@2)
	STS  @0+(@1),R30
	.ENDM

	.MACRO __ORWMNN
	LDS  R30,@0+(@1)
	ORI  R30,LOW(@2)
	STS  @0+(@1),R30
	LDS  R30,@0+(@1)+1
	ORI  R30,HIGH(@2)
	STS  @0+(@1)+1,R30
	.ENDM

	.MACRO __ORD1N
	ORI  R30,LOW(@0)
	ORI  R31,HIGH(@0)
	ORI  R22,BYTE3(@0)
	ORI  R23,BYTE4(@0)
	.ENDM

	.MACRO __ORD2N
	ORI  R26,LOW(@0)
	ORI  R27,HIGH(@0)
	ORI  R24,BYTE3(@0)
	ORI  R25,BYTE4(@0)
	.ENDM

	.MACRO __DELAY_USB
	LDI  R24,LOW(@0)
__DELAY_USB_LOOP:
	DEC  R24
	BRNE __DELAY_USB_LOOP
	.ENDM

	.MACRO __DELAY_USW
	LDI  R24,LOW(@0)
	LDI  R25,HIGH(@0)
__DELAY_USW_LOOP:
	SBIW R24,1
	BRNE __DELAY_USW_LOOP
	.ENDM

	.MACRO __GETD1S
	LDD  R30,Y+@0
	LDD  R31,Y+@0+1
	LDD  R22,Y+@0+2
	LDD  R23,Y+@0+3
	.ENDM

	.MACRO __GETD2S
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	LDD  R24,Y+@0+2
	LDD  R25,Y+@0+3
	.ENDM

	.MACRO __PUTD1S
	STD  Y+@0,R30
	STD  Y+@0+1,R31
	STD  Y+@0+2,R22
	STD  Y+@0+3,R23
	.ENDM

	.MACRO __PUTD2S
	STD  Y+@0,R26
	STD  Y+@0+1,R27
	STD  Y+@0+2,R24
	STD  Y+@0+3,R25
	.ENDM

	.MACRO __PUTDZ2
	STD  Z+@0,R26
	STD  Z+@0+1,R27
	STD  Z+@0+2,R24
	STD  Z+@0+3,R25
	.ENDM

	.MACRO __CLRD1S
	STD  Y+@0,R30
	STD  Y+@0+1,R30
	STD  Y+@0+2,R30
	STD  Y+@0+3,R30
	.ENDM

	.MACRO __POINTB1MN
	LDI  R30,LOW(@0+(@1))
	.ENDM

	.MACRO __POINTW1MN
	LDI  R30,LOW(@0+(@1))
	LDI  R31,HIGH(@0+(@1))
	.ENDM

	.MACRO __POINTD1M
	LDI  R30,LOW(@0)
	LDI  R31,HIGH(@0)
	LDI  R22,BYTE3(@0)
	LDI  R23,BYTE4(@0)
	.ENDM

	.MACRO __POINTW1FN
	LDI  R30,LOW(2*@0+(@1))
	LDI  R31,HIGH(2*@0+(@1))
	.ENDM

	.MACRO __POINTD1FN
	LDI  R30,LOW(2*@0+(@1))
	LDI  R31,HIGH(2*@0+(@1))
	LDI  R22,BYTE3(2*@0+(@1))
	LDI  R23,BYTE4(2*@0+(@1))
	.ENDM

	.MACRO __POINTB2MN
	LDI  R26,LOW(@0+(@1))
	.ENDM

	.MACRO __POINTW2MN
	LDI  R26,LOW(@0+(@1))
	LDI  R27,HIGH(@0+(@1))
	.ENDM

	.MACRO __POINTW2FN
	LDI  R26,LOW(2*@0+(@1))
	LDI  R27,HIGH(2*@0+(@1))
	.ENDM

	.MACRO __POINTD2FN
	LDI  R26,LOW(2*@0+(@1))
	LDI  R27,HIGH(2*@0+(@1))
	LDI  R24,BYTE3(2*@0+(@1))
	LDI  R25,BYTE4(2*@0+(@1))
	.ENDM

	.MACRO __POINTBRM
	LDI  R@0,LOW(@1)
	.ENDM

	.MACRO __POINTWRM
	LDI  R@0,LOW(@2)
	LDI  R@1,HIGH(@2)
	.ENDM

	.MACRO __POINTBRMN
	LDI  R@0,LOW(@1+(@2))
	.ENDM

	.MACRO __POINTWRMN
	LDI  R@0,LOW(@2+(@3))
	LDI  R@1,HIGH(@2+(@3))
	.ENDM

	.MACRO __POINTWRFN
	LDI  R@0,LOW(@2*2+(@3))
	LDI  R@1,HIGH(@2*2+(@3))
	.ENDM

	.MACRO __GETD1N
	LDI  R30,LOW(@0)
	LDI  R31,HIGH(@0)
	LDI  R22,BYTE3(@0)
	LDI  R23,BYTE4(@0)
	.ENDM

	.MACRO __GETD2N
	LDI  R26,LOW(@0)
	LDI  R27,HIGH(@0)
	LDI  R24,BYTE3(@0)
	LDI  R25,BYTE4(@0)
	.ENDM

	.MACRO __GETB1MN
	LDS  R30,@0+(@1)
	.ENDM

	.MACRO __GETB1HMN
	LDS  R31,@0+(@1)
	.ENDM

	.MACRO __GETW1MN
	LDS  R30,@0+(@1)
	LDS  R31,@0+(@1)+1
	.ENDM

	.MACRO __GETD1MN
	LDS  R30,@0+(@1)
	LDS  R31,@0+(@1)+1
	LDS  R22,@0+(@1)+2
	LDS  R23,@0+(@1)+3
	.ENDM

	.MACRO __GETBRMN
	LDS  R@0,@1+(@2)
	.ENDM

	.MACRO __GETWRMN
	LDS  R@0,@2+(@3)
	LDS  R@1,@2+(@3)+1
	.ENDM

	.MACRO __GETWRZ
	LDD  R@0,Z+@2
	LDD  R@1,Z+@2+1
	.ENDM

	.MACRO __GETD2Z
	LDD  R26,Z+@0
	LDD  R27,Z+@0+1
	LDD  R24,Z+@0+2
	LDD  R25,Z+@0+3
	.ENDM

	.MACRO __GETB2MN
	LDS  R26,@0+(@1)
	.ENDM

	.MACRO __GETW2MN
	LDS  R26,@0+(@1)
	LDS  R27,@0+(@1)+1
	.ENDM

	.MACRO __GETD2MN
	LDS  R26,@0+(@1)
	LDS  R27,@0+(@1)+1
	LDS  R24,@0+(@1)+2
	LDS  R25,@0+(@1)+3
	.ENDM

	.MACRO __PUTB1MN
	STS  @0+(@1),R30
	.ENDM

	.MACRO __PUTW1MN
	STS  @0+(@1),R30
	STS  @0+(@1)+1,R31
	.ENDM

	.MACRO __PUTD1MN
	STS  @0+(@1),R30
	STS  @0+(@1)+1,R31
	STS  @0+(@1)+2,R22
	STS  @0+(@1)+3,R23
	.ENDM

	.MACRO __PUTB1EN
	LDI  R26,LOW(@0+(@1))
	LDI  R27,HIGH(@0+(@1))
	RCALL __EEPROMWRB
	.ENDM

	.MACRO __PUTW1EN
	LDI  R26,LOW(@0+(@1))
	LDI  R27,HIGH(@0+(@1))
	RCALL __EEPROMWRW
	.ENDM

	.MACRO __PUTD1EN
	LDI  R26,LOW(@0+(@1))
	LDI  R27,HIGH(@0+(@1))
	RCALL __EEPROMWRD
	.ENDM

	.MACRO __PUTBR0MN
	STS  @0+(@1),R0
	.ENDM

	.MACRO __PUTBMRN
	STS  @0+(@1),R@2
	.ENDM

	.MACRO __PUTWMRN
	STS  @0+(@1),R@2
	STS  @0+(@1)+1,R@3
	.ENDM

	.MACRO __PUTBZR
	STD  Z+@1,R@0
	.ENDM

	.MACRO __PUTWZR
	STD  Z+@2,R@0
	STD  Z+@2+1,R@1
	.ENDM

	.MACRO __GETW1R
	MOV  R30,R@0
	MOV  R31,R@1
	.ENDM

	.MACRO __GETW2R
	MOV  R26,R@0
	MOV  R27,R@1
	.ENDM

	.MACRO __GETWRN
	LDI  R@0,LOW(@2)
	LDI  R@1,HIGH(@2)
	.ENDM

	.MACRO __PUTW1R
	MOV  R@0,R30
	MOV  R@1,R31
	.ENDM

	.MACRO __PUTW2R
	MOV  R@0,R26
	MOV  R@1,R27
	.ENDM

	.MACRO __ADDWRN
	SUBI R@0,LOW(-@2)
	SBCI R@1,HIGH(-@2)
	.ENDM

	.MACRO __ADDWRR
	ADD  R@0,R@2
	ADC  R@1,R@3
	.ENDM

	.MACRO __SUBWRN
	SUBI R@0,LOW(@2)
	SBCI R@1,HIGH(@2)
	.ENDM

	.MACRO __SUBWRR
	SUB  R@0,R@2
	SBC  R@1,R@3
	.ENDM

	.MACRO __ANDWRN
	ANDI R@0,LOW(@2)
	ANDI R@1,HIGH(@2)
	.ENDM

	.MACRO __ANDWRR
	AND  R@0,R@2
	AND  R@1,R@3
	.ENDM

	.MACRO __ORWRN
	ORI  R@0,LOW(@2)
	ORI  R@1,HIGH(@2)
	.ENDM

	.MACRO __ORWRR
	OR   R@0,R@2
	OR   R@1,R@3
	.ENDM

	.MACRO __EORWRR
	EOR  R@0,R@2
	EOR  R@1,R@3
	.ENDM

	.MACRO __GETWRS
	LDD  R@0,Y+@2
	LDD  R@1,Y+@2+1
	.ENDM

	.MACRO __PUTBSR
	STD  Y+@1,R@0
	.ENDM

	.MACRO __PUTWSR
	STD  Y+@2,R@0
	STD  Y+@2+1,R@1
	.ENDM

	.MACRO __MOVEWRR
	MOV  R@0,R@2
	MOV  R@1,R@3
	.ENDM

	.MACRO __INWR
	IN   R@0,@2
	IN   R@1,@2+1
	.ENDM

	.MACRO __OUTWR
	OUT  @2+1,R@1
	OUT  @2,R@0
	.ENDM

	.MACRO __CALL1MN
	LDS  R30,@0+(@1)
	LDS  R31,@0+(@1)+1
	ICALL
	.ENDM

	.MACRO __CALL1FN
	LDI  R30,LOW(2*@0+(@1))
	LDI  R31,HIGH(2*@0+(@1))
	RCALL __GETW1PF
	ICALL
	.ENDM

	.MACRO __CALL2EN
	LDI  R26,LOW(@0+(@1))
	LDI  R27,HIGH(@0+(@1))
	RCALL __EEPROMRDW
	ICALL
	.ENDM

	.MACRO __GETW1STACK
	IN   R26,SPL
	IN   R27,SPH
	ADIW R26,@0+1
	LD   R30,X+
	LD   R31,X
	.ENDM

	.MACRO __GETD1STACK
	IN   R26,SPL
	IN   R27,SPH
	ADIW R26,@0+1
	LD   R30,X+
	LD   R31,X+
	LD   R22,X
	.ENDM

	.MACRO __NBST
	BST  R@0,@1
	IN   R30,SREG
	LDI  R31,0x40
	EOR  R30,R31
	OUT  SREG,R30
	.ENDM


	.MACRO __PUTB1SN
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X,R30
	.ENDM

	.MACRO __PUTW1SN
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1SN
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	RCALL __PUTDP1
	.ENDM

	.MACRO __PUTB1SNS
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	ADIW R26,@1
	ST   X,R30
	.ENDM

	.MACRO __PUTW1SNS
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	ADIW R26,@1
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1SNS
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	ADIW R26,@1
	RCALL __PUTDP1
	.ENDM

	.MACRO __PUTB1PMN
	LDS  R26,@0
	LDS  R27,@0+1
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X,R30
	.ENDM

	.MACRO __PUTW1PMN
	LDS  R26,@0
	LDS  R27,@0+1
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1PMN
	LDS  R26,@0
	LDS  R27,@0+1
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	RCALL __PUTDP1
	.ENDM

	.MACRO __PUTB1PMNS
	LDS  R26,@0
	LDS  R27,@0+1
	ADIW R26,@1
	ST   X,R30
	.ENDM

	.MACRO __PUTW1PMNS
	LDS  R26,@0
	LDS  R27,@0+1
	ADIW R26,@1
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1PMNS
	LDS  R26,@0
	LDS  R27,@0+1
	ADIW R26,@1
	RCALL __PUTDP1
	.ENDM

	.MACRO __PUTB1RN
	MOVW R26,R@0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X,R30
	.ENDM

	.MACRO __PUTW1RN
	MOVW R26,R@0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1RN
	MOVW R26,R@0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	RCALL __PUTDP1
	.ENDM

	.MACRO __PUTB1RNS
	MOVW R26,R@0
	ADIW R26,@1
	ST   X,R30
	.ENDM

	.MACRO __PUTW1RNS
	MOVW R26,R@0
	ADIW R26,@1
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1RNS
	MOVW R26,R@0
	ADIW R26,@1
	RCALL __PUTDP1
	.ENDM

	.MACRO __PUTB1RON
	MOV  R26,R@0
	MOV  R27,R@1
	SUBI R26,LOW(-@2)
	SBCI R27,HIGH(-@2)
	ST   X,R30
	.ENDM

	.MACRO __PUTW1RON
	MOV  R26,R@0
	MOV  R27,R@1
	SUBI R26,LOW(-@2)
	SBCI R27,HIGH(-@2)
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1RON
	MOV  R26,R@0
	MOV  R27,R@1
	SUBI R26,LOW(-@2)
	SBCI R27,HIGH(-@2)
	RCALL __PUTDP1
	.ENDM

	.MACRO __PUTB1RONS
	MOV  R26,R@0
	MOV  R27,R@1
	ADIW R26,@2
	ST   X,R30
	.ENDM

	.MACRO __PUTW1RONS
	MOV  R26,R@0
	MOV  R27,R@1
	ADIW R26,@2
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1RONS
	MOV  R26,R@0
	MOV  R27,R@1
	ADIW R26,@2
	RCALL __PUTDP1
	.ENDM


	.MACRO __GETB1SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	LD   R30,Z
	.ENDM

	.MACRO __GETB1HSX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	LD   R31,Z
	.ENDM

	.MACRO __GETW1SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	LD   R0,Z+
	LD   R31,Z
	MOV  R30,R0
	.ENDM

	.MACRO __GETD1SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	LD   R0,Z+
	LD   R1,Z+
	LD   R22,Z+
	LD   R23,Z
	MOVW R30,R0
	.ENDM

	.MACRO __GETB2SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R26,X
	.ENDM

	.MACRO __GETW2SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R0,X+
	LD   R27,X
	MOV  R26,R0
	.ENDM

	.MACRO __GETD2SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R0,X+
	LD   R1,X+
	LD   R24,X+
	LD   R25,X
	MOVW R26,R0
	.ENDM

	.MACRO __GETBRSX
	MOVW R30,R28
	SUBI R30,LOW(-@1)
	SBCI R31,HIGH(-@1)
	LD   R@0,Z
	.ENDM

	.MACRO __GETWRSX
	MOVW R30,R28
	SUBI R30,LOW(-@2)
	SBCI R31,HIGH(-@2)
	LD   R@0,Z+
	LD   R@1,Z
	.ENDM

	.MACRO __GETBRSX2
	MOVW R26,R28
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	LD   R@0,X
	.ENDM

	.MACRO __GETWRSX2
	MOVW R26,R28
	SUBI R26,LOW(-@2)
	SBCI R27,HIGH(-@2)
	LD   R@0,X+
	LD   R@1,X
	.ENDM

	.MACRO __LSLW8SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	LD   R31,Z
	CLR  R30
	.ENDM

	.MACRO __PUTB1SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	ST   X,R30
	.ENDM

	.MACRO __PUTW1SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	ST   X+,R30
	ST   X+,R31
	ST   X+,R22
	ST   X,R23
	.ENDM

	.MACRO __CLRW1SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	ST   X+,R30
	ST   X,R30
	.ENDM

	.MACRO __CLRD1SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	ST   X+,R30
	ST   X+,R30
	ST   X+,R30
	ST   X,R30
	.ENDM

	.MACRO __PUTB2SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	ST   Z,R26
	.ENDM

	.MACRO __PUTW2SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	ST   Z+,R26
	ST   Z,R27
	.ENDM

	.MACRO __PUTD2SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	ST   Z+,R26
	ST   Z+,R27
	ST   Z+,R24
	ST   Z,R25
	.ENDM

	.MACRO __PUTBSRX
	MOVW R30,R28
	SUBI R30,LOW(-@1)
	SBCI R31,HIGH(-@1)
	ST   Z,R@0
	.ENDM

	.MACRO __PUTWSRX
	MOVW R30,R28
	SUBI R30,LOW(-@2)
	SBCI R31,HIGH(-@2)
	ST   Z+,R@0
	ST   Z,R@1
	.ENDM

	.MACRO __PUTB1SNX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R0,X+
	LD   R27,X
	MOV  R26,R0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X,R30
	.ENDM

	.MACRO __PUTW1SNX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R0,X+
	LD   R27,X
	MOV  R26,R0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1SNX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R0,X+
	LD   R27,X
	MOV  R26,R0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X+,R30
	ST   X+,R31
	ST   X+,R22
	ST   X,R23
	.ENDM

	.MACRO __MULBRR
	MULS R@0,R@1
	MOVW R30,R0
	.ENDM

	.MACRO __MULBRRU
	MUL  R@0,R@1
	MOVW R30,R0
	.ENDM

	.MACRO __MULBRR0
	MULS R@0,R@1
	.ENDM

	.MACRO __MULBRRU0
	MUL  R@0,R@1
	.ENDM

	.MACRO __MULBNWRU
	LDI  R26,@2
	MUL  R26,R@0
	MOVW R30,R0
	MUL  R26,R@1
	ADD  R31,R0
	.ENDM

;NAME DEFINITIONS FOR GLOBAL VARIABLES ALLOCATED TO REGISTERS
	.DEF _i=R5
	.DEF _mode=R4
	.DEF _control=R7
	.DEF _devices=R6
	.DEF _temp=R9
	.DEF _temp_sec=R10
	.DEF _CS_count=R12
	.DEF _uart_time=R8

	.CSEG
	.ORG 0x00

;START OF CODE MARKER
__START_OF_CODE:

;INTERRUPT VECTORS
	RJMP __RESET
	RJMP 0x00
	RJMP _ext_int1_isr
	RJMP 0x00
	RJMP 0x00
	RJMP 0x00
	RJMP _timer1_compa_isr
	RJMP 0x00
	RJMP 0x00
	RJMP 0x00
	RJMP 0x00
	RJMP _usart_rx_isr
	RJMP 0x00
	RJMP 0x00
	RJMP 0x00
	RJMP 0x00
	RJMP 0x00
	RJMP 0x00
	RJMP 0x00

_conv_delay_G100:
	.DB  0x64,0x0,0xC8,0x0,0x90,0x1,0x20,0x3
_bit_mask_G100:
	.DB  0xF8,0xFF,0xFC,0xFF,0xFE,0xFF,0xFF,0xFF
_tbl10_G101:
	.DB  0x10,0x27,0xE8,0x3,0x64,0x0,0xA,0x0
	.DB  0x1,0x0
_tbl16_G101:
	.DB  0x0,0x10,0x0,0x1,0x10,0x0,0x1,0x0

;REGISTER BIT VARIABLES INITIALIZATION
__REG_BIT_VARS:
	.DW  0x000C

_0xC4:
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0

__GLOBAL_INI_TBL:
	.DW  0x01
	.DW  0x02
	.DW  __REG_BIT_VARS*2

	.DW  0x0A
	.DW  0x04
	.DW  _0xC4*2

_0xFFFFFFFF:
	.DW  0

__RESET:
	CLI
	CLR  R30
	OUT  EECR,R30

;INTERRUPT VECTORS ARE PLACED
;AT THE START OF FLASH
	LDI  R31,1
	OUT  GICR,R31
	OUT  GICR,R30
	OUT  MCUCR,R30

;DISABLE WATCHDOG
	LDI  R31,0x18
	OUT  WDTCR,R31
	OUT  WDTCR,R30

;CLEAR R2-R14
	LDI  R24,(14-2)+1
	LDI  R26,2
	CLR  R27
__CLEAR_REG:
	ST   X+,R30
	DEC  R24
	BRNE __CLEAR_REG

;CLEAR SRAM
	LDI  R24,LOW(__CLEAR_SRAM_SIZE)
	LDI  R25,HIGH(__CLEAR_SRAM_SIZE)
	LDI  R26,__SRAM_START
__CLEAR_SRAM:
	ST   X+,R30
	SBIW R24,1
	BRNE __CLEAR_SRAM

;GLOBAL VARIABLES INITIALIZATION
	LDI  R30,LOW(__GLOBAL_INI_TBL*2)
	LDI  R31,HIGH(__GLOBAL_INI_TBL*2)
__GLOBAL_INI_NEXT:
	LPM  R24,Z+
	LPM  R25,Z+
	SBIW R24,0
	BREQ __GLOBAL_INI_END
	LPM  R26,Z+
	LPM  R27,Z+
	LPM  R0,Z+
	LPM  R1,Z+
	MOVW R22,R30
	MOVW R30,R0
__GLOBAL_INI_LOOP:
	LPM  R0,Z+
	ST   X+,R0
	SBIW R24,1
	BRNE __GLOBAL_INI_LOOP
	MOVW R30,R22
	RJMP __GLOBAL_INI_NEXT
__GLOBAL_INI_END:

;HARDWARE STACK POINTER INITIALIZATION
	LDI  R30,LOW(__SRAM_END-__HEAP_SIZE)
	OUT  SPL,R30
	LDI  R30,HIGH(__SRAM_END-__HEAP_SIZE)
	OUT  SPH,R30

;DATA STACK POINTER INITIALIZATION
	LDI  R28,LOW(__SRAM_START+__DSTACK_SIZE)
	LDI  R29,HIGH(__SRAM_START+__DSTACK_SIZE)

	RJMP _main

	.ESEG
	.ORG 0

	.DSEG
	.ORG 0x160

	.CSEG
;//ATmega8 8 MHz
;#include <mega8.h>
	#ifndef __SLEEP_DEFINED__
	#define __SLEEP_DEFINED__
	.EQU __se_bit=0x80
	.EQU __sm_mask=0x70
	.EQU __sm_powerdown=0x20
	.EQU __sm_powersave=0x30
	.EQU __sm_standby=0x60
	.EQU __sm_ext_standby=0x70
	.EQU __sm_adc_noise_red=0x10
	.SET power_ctrl_reg=mcucr
	#endif
;#include <1wire.h>
;#include <ds18b20.h>
;#include <delay.h>
;#define ADC_VREF_TYPE 0x40
;
;#define ACCOUT  PORTD.5
;#define PRF     PORTB.0
;#define PSU     PORTD.7
;#define AUX     PORTD.6
;#define HEATER  PORTB.1
;#define ACC     ~PIND.3
;#define ATX     ~PIND.2
;#define P1      ~PINC.4
;#define P2      ~PINC.5
;#define SW      PORTC.3
;#define MN      PORTC.2
;#define HTRflag PINB.1
;
;unsigned char i=0;
;char mode=0;                            // 
;eeprom char zero=255;                   //     
;unsigned char buffer[16];                // 
;
;unsigned char control=0;                //   
;
;unsigned char devices;                  //  
;signed char temp=0;                     //
;float temp0=0;
;bit temp_ok=0;
;int temp_sec=0;
;bit temp_countover=0;                   //,      
;
;unsigned int CS_count=0;
;bit uart_idle=1;
;unsigned char uart_time=0;
;
;//  :
;eeprom signed char temp_s=1;            // 
;eeprom char temp_ign=1;                 // 
;eeprom unsigned char temp_timer=1;      //  .  0 -  
;bit volt_ok=1;                          //  
;unsigned char volt=0;                   //
;unsigned char volt_sec=0;               //   
;//  :
;eeprom unsigned char volt_set=1;        // 
;eeprom unsigned int volt_timer=1;       //  .
;
;//eeprom
;eeprom unsigned char turnon_timer=1;
;eeprom unsigned char turnoff_timer=1;
;eeprom unsigned char ign_timer=1;
;eeprom unsigned char outset[6];         //  
;
;unsigned char ignofftime=0;
;unsigned char waitatx_on=0;
;unsigned char waitatx_off=0;
;
;bit prfon=0;
;unsigned char prfcount=0;
;bit auxon=0;
;unsigned char auxcount=0;
;
;unsigned char p1count=0;
;unsigned char p2count=0;
;
;
;#define RX_BUFFER_SIZE 16
;char rx_buffer[RX_BUFFER_SIZE];
;unsigned char rx_counter;
;//unsigned char rx_wr_index,rx_rd_index,rx_counter;
;//bit rx_buffer_overflow;
;
;interrupt [USART_RXC] void usart_rx_isr(void)
; 0000 004C {

	.CSEG
_usart_rx_isr:
	ST   -Y,R30
	ST   -Y,R31
	IN   R30,SREG
	ST   -Y,R30
; 0000 004D   char status,data;
; 0000 004E   status=UCSRA;
	RCALL __SAVELOCR2
;	status -> R17
;	data -> R16
	IN   R17,11
; 0000 004F   data=UDR;
	IN   R16,12
; 0000 0050   if ((status & 0x1C)==0)
	MOV  R30,R17
	ANDI R30,LOW(0x1C)
	BRNE _0x3
; 0000 0051   {
; 0000 0052     if(data==0x55)rx_counter=0;
	CPI  R16,85
	BRNE _0x4
	RCALL SUBOPT_0x0
; 0000 0053     rx_buffer[rx_counter++]=data;
_0x4:
	LDS  R30,_rx_counter
	SUBI R30,-LOW(1)
	STS  _rx_counter,R30
	SUBI R30,LOW(1)
	RCALL SUBOPT_0x1
	SUBI R30,LOW(-_rx_buffer)
	SBCI R31,HIGH(-_rx_buffer)
	ST   Z,R16
; 0000 0054     uart_idle=0;
	CLT
	BLD  R2,2
; 0000 0055     uart_time=0;
	CLR  R8
; 0000 0056     /*
; 0000 0057     rx_buffer[rx_wr_index++]=data;
; 0000 0058     if (rx_wr_index == RX_BUFFER_SIZE) rx_wr_index=0;
; 0000 0059     if (++rx_counter == RX_BUFFER_SIZE)
; 0000 005A     {
; 0000 005B       rx_counter=0;
; 0000 005C       rx_buffer_overflow=1;
; 0000 005D     }
; 0000 005E     */
; 0000 005F   }
; 0000 0060 }
_0x3:
	RCALL __LOADLOCR2P
	LD   R30,Y+
	OUT  SREG,R30
	LD   R31,Y+
	LD   R30,Y+
	RETI
;
;/*
;#ifndef _DEBUG_TERMINAL_IO_
;#define _ALTERNATE_GETCHAR_
;#pragma used+
;char getchar(void)
;{
;char data;
;while (rx_counter==0);
;data=rx_buffer[rx_rd_index++];
;#if RX_BUFFER_SIZE != 256
;if (rx_rd_index == RX_BUFFER_SIZE) rx_rd_index=0;
;#endif
;#asm("cli")
;--rx_counter;
;#asm("sei")
;return data;
;}
;#pragma used-
;#endif
;*/
;#include <stdio.h>
;
;interrupt [EXT_INT1] void ext_int1_isr(void)
; 0000 0079 {
_ext_int1_isr:
; 0000 007A 
; 0000 007B }
	RETI
;
;unsigned int read_adc(unsigned char adc_input)
; 0000 007E {
_read_adc:
; 0000 007F ADMUX=adc_input | (ADC_VREF_TYPE & 0xff);
	ST   -Y,R26
;	adc_input -> Y+0
	LD   R30,Y
	ORI  R30,0x40
	OUT  0x7,R30
; 0000 0080 delay_us(10);
	__DELAY_USB 27
; 0000 0081 ADCSRA|=0x40;
	SBI  0x6,6
; 0000 0082 while ((ADCSRA & 0x10)==0);
_0x5:
	SBIS 0x6,4
	RJMP _0x5
; 0000 0083 ADCSRA|=0x10;
	SBI  0x6,4
; 0000 0084 return ADCW;
	IN   R30,0x4
	IN   R31,0x4+1
	RJMP _0x2080001
; 0000 0085 }
;
;void sleep()
; 0000 0088 {
_sleep:
; 0000 0089   #asm("cli")
	cli
; 0000 008A   mode=0;     //  
	CLR  R4
; 0000 008B   temp_ok=0;  // 
	CLT
	BLD  R2,0
; 0000 008C   volt_ok=0;
	BLD  R2,3
; 0000 008D   volt_sec=0;
	LDI  R30,LOW(0)
	STS  _volt_sec,R30
; 0000 008E   rx_counter=0;
	RCALL SUBOPT_0x0
; 0000 008F   waitatx_on=0;
	RCALL SUBOPT_0x2
; 0000 0090   waitatx_off=0;
	RCALL SUBOPT_0x3
; 0000 0091   ignofftime=0;
	RCALL SUBOPT_0x4
; 0000 0092   auxcount=0;
	STS  _auxcount,R30
; 0000 0093   prfcount=0;
	LDI  R30,LOW(0)
	STS  _prfcount,R30
; 0000 0094   temp_sec=0;
	CLR  R10
	CLR  R11
; 0000 0095   GICR|=0x80;
	IN   R30,0x3B
	ORI  R30,0x80
	OUT  0x3B,R30
; 0000 0096   MCUCR=0xA0;
	LDI  R30,LOW(160)
	OUT  0x35,R30
; 0000 0097   GIFR=0x80;
	LDI  R30,LOW(128)
	OUT  0x3A,R30
; 0000 0098   #asm("sei")
	sei
; 0000 0099   #asm("sleep")
	sleep
; 0000 009A   #asm("cli")
	cli
; 0000 009B   GICR=0x00;
	LDI  R30,LOW(0)
	OUT  0x3B,R30
; 0000 009C   TCNT1H=0x00;
	RCALL SUBOPT_0x5
; 0000 009D   TCNT1L=0x00;
; 0000 009E   MCUCR=0x00;
	LDI  R30,LOW(0)
	OUT  0x35,R30
; 0000 009F   GIFR=0x00;
	OUT  0x3A,R30
; 0000 00A0   #asm("sei")
	sei
; 0000 00A1 }
	RET
;
;void all_off()
; 0000 00A4 {
_all_off:
; 0000 00A5   PSU=0;      // 
	CBI  0x12,7
; 0000 00A6   ACCOUT=0;
	CBI  0x12,5
; 0000 00A7   AUX=0;
	CBI  0x12,6
; 0000 00A8   PRF=0;
	CBI  0x18,0
; 0000 00A9   HEATER=0;
	CBI  0x18,1
; 0000 00AA   SW=0;
	CBI  0x15,3
; 0000 00AB   MN=0;
	CBI  0x15,2
; 0000 00AC   //PORTC.0=0;
; 0000 00AD   mode=0;
	CLR  R4
; 0000 00AE   sleep();
	RCALL _sleep
; 0000 00AF }
	RET
;
;void swblink()
; 0000 00B2 {
_swblink:
; 0000 00B3   SW=1;
	SBI  0x15,3
; 0000 00B4   delay_ms((outset[2]>>2)*100);
	RCALL SUBOPT_0x6
	RCALL SUBOPT_0x7
; 0000 00B5   SW=0;
	CBI  0x15,3
; 0000 00B6 }
	RET
;
;void mnblink()
; 0000 00B9 {
_mnblink:
; 0000 00BA   MN=1;
	SBI  0x15,2
; 0000 00BB   delay_ms((outset[3]>>2)*100);
	RCALL SUBOPT_0x8
	RCALL SUBOPT_0x7
; 0000 00BC   MN=0;
	CBI  0x15,2
; 0000 00BD }
	RET
;
;interrupt [TIM1_COMPA] void timer1_compa_isr(void)
; 0000 00C0 {
_timer1_compa_isr:
	ST   -Y,R0
	ST   -Y,R1
	ST   -Y,R15
	ST   -Y,R22
	ST   -Y,R23
	ST   -Y,R24
	ST   -Y,R25
	ST   -Y,R26
	ST   -Y,R27
	ST   -Y,R30
	ST   -Y,R31
	IN   R30,SREG
	ST   -Y,R30
; 0000 00C1   TCNT1H=0x00;
	RCALL SUBOPT_0x5
; 0000 00C2   TCNT1L=0x00;
; 0000 00C3   //PORTC.0=~PINC.0;
; 0000 00C4   if(!volt_ok)// 
	SBRC R2,3
	RJMP _0x1E
; 0000 00C5   {
; 0000 00C6     volt_sec++;
	LDS  R30,_volt_sec
	SUBI R30,-LOW(1)
	STS  _volt_sec,R30
; 0000 00C7     if(volt_sec>=volt_timer)//     
	LDI  R26,LOW(_volt_timer)
	LDI  R27,HIGH(_volt_timer)
	RCALL __EEPROMRDW
	LDS  R26,_volt_sec
	RCALL SUBOPT_0x9
	BRLO _0x1F
; 0000 00C8     {
; 0000 00C9       ACCOUT=0;
	RCALL SUBOPT_0xA
; 0000 00CA       if((outset[2]&0x03)==1)swblink();
	RCALL SUBOPT_0xB
	BRNE _0x22
	RCALL _swblink
; 0000 00CB       mode=4;
_0x22:
	RCALL SUBOPT_0xC
; 0000 00CC     }
; 0000 00CD   }
_0x1F:
; 0000 00CE   if(!ACC)
_0x1E:
	SBIS 0x10,3
	RJMP _0x23
; 0000 00CF   {
; 0000 00D0     ignofftime++;
	LDS  R30,_ignofftime
	SUBI R30,-LOW(1)
	STS  _ignofftime,R30
; 0000 00D1     if(ignofftime>ign_timer)
	LDI  R26,LOW(_ign_timer)
	LDI  R27,HIGH(_ign_timer)
	RCALL __EEPROMRDB
	LDS  R26,_ignofftime
	CP   R30,R26
	BRSH _0x24
; 0000 00D2     {
; 0000 00D3       ACCOUT=0;
	RCALL SUBOPT_0xA
; 0000 00D4       if((outset[2]&0x03)==1 && mode!=4)swblink();
	RCALL SUBOPT_0xB
	BRNE _0x28
	LDI  R30,LOW(4)
	CP   R30,R4
	BRNE _0x29
_0x28:
	RJMP _0x27
_0x29:
	RCALL _swblink
; 0000 00D5       mode=4;
_0x27:
	RCALL SUBOPT_0xC
; 0000 00D6     }
; 0000 00D7   }
_0x24:
; 0000 00D8   if(temp_timer!=0 && HTRflag && !temp_countover) //  ,  ,   
_0x23:
	RCALL SUBOPT_0xD
	CPI  R30,0
	BREQ _0x2B
	SBIS 0x16,1
	RJMP _0x2B
	SBRS R2,1
	RJMP _0x2C
_0x2B:
	RJMP _0x2A
_0x2C:
; 0000 00D9   {
; 0000 00DA     temp_sec++;//   
	MOVW R30,R10
	ADIW R30,1
	MOVW R10,R30
; 0000 00DB     if(temp_sec>=temp_timer) //   
	RCALL SUBOPT_0xD
	MOVW R26,R10
	RCALL SUBOPT_0x1
	CP   R26,R30
	CPC  R27,R31
	BRLT _0x2D
; 0000 00DC     {
; 0000 00DD       temp_sec=0;// 
	CLR  R10
	CLR  R11
; 0000 00DE       temp_ok=1;//  .      
	RCALL SUBOPT_0xE
; 0000 00DF       HEATER=0;// 
	CBI  0x18,1
; 0000 00E0       temp_countover=1;// 
	SET
	BLD  R2,1
; 0000 00E1     }
; 0000 00E2   }
_0x2D:
; 0000 00E3   if(mode==2 && !ATX)
_0x2A:
	LDI  R30,LOW(2)
	CP   R30,R4
	BRNE _0x31
	SBIC 0x10,2
	RJMP _0x32
_0x31:
	RJMP _0x30
_0x32:
; 0000 00E4   {
; 0000 00E5     waitatx_on++;
	LDS  R30,_waitatx_on
	SUBI R30,-LOW(1)
	STS  _waitatx_on,R30
; 0000 00E6     if(waitatx_on>turnon_timer)
	LDI  R26,LOW(_turnon_timer)
	LDI  R27,HIGH(_turnon_timer)
	RCALL __EEPROMRDB
	LDS  R26,_waitatx_on
	CP   R30,R26
	BRSH _0x33
; 0000 00E7     {
; 0000 00E8       PSU=0;
	CBI  0x12,7
; 0000 00E9       ACCOUT=0;
	RCALL SUBOPT_0xA
; 0000 00EA       if((outset[2]&0x03)==1)swblink();
	RCALL SUBOPT_0xB
	BRNE _0x38
	RCALL _swblink
; 0000 00EB       waitatx_on=0;
_0x38:
	RCALL SUBOPT_0x2
; 0000 00EC       mode=4;
	RCALL SUBOPT_0xC
; 0000 00ED     }
; 0000 00EE   }
_0x33:
; 0000 00EF   if(mode==4 && ATX)
_0x30:
	LDI  R30,LOW(4)
	CP   R30,R4
	BRNE _0x3A
	SBIS 0x10,2
	RJMP _0x3B
_0x3A:
	RJMP _0x39
_0x3B:
; 0000 00F0   {
; 0000 00F1     waitatx_off++;
	LDS  R30,_waitatx_off
	SUBI R30,-LOW(1)
	STS  _waitatx_off,R30
; 0000 00F2     if(waitatx_off>turnoff_timer)
	LDI  R26,LOW(_turnoff_timer)
	LDI  R27,HIGH(_turnoff_timer)
	RCALL __EEPROMRDB
	LDS  R26,_waitatx_off
	CP   R30,R26
	BRSH _0x3C
; 0000 00F3     {
; 0000 00F4       all_off();
	RCALL _all_off
; 0000 00F5       waitatx_off=0;
	RCALL SUBOPT_0x3
; 0000 00F6     }
; 0000 00F7   }
_0x3C:
; 0000 00F8   if(prfon && PINB.0==0)
_0x39:
	SBRS R2,4
	RJMP _0x3E
	LDI  R26,0
	SBIC 0x16,0
	LDI  R26,1
	CPI  R26,LOW(0x0)
	BREQ _0x3F
_0x3E:
	RJMP _0x3D
_0x3F:
; 0000 00F9   {
; 0000 00FA     prfcount++;
	LDS  R30,_prfcount
	SUBI R30,-LOW(1)
	STS  _prfcount,R30
; 0000 00FB     if(prfcount>=(outset[0]>>2))
	RCALL SUBOPT_0xF
	RCALL SUBOPT_0x10
	LDS  R26,_prfcount
	RCALL SUBOPT_0x9
	BRLT _0x40
; 0000 00FC     {
; 0000 00FD       PRF=1;
	SBI  0x18,0
; 0000 00FE       prfon=0;
	CLT
	BLD  R2,4
; 0000 00FF       prfcount=0;
	LDI  R30,LOW(0)
	STS  _prfcount,R30
; 0000 0100     }
; 0000 0101   }
_0x40:
; 0000 0102   if(auxon && PIND.6==0)
_0x3D:
	SBRS R2,5
	RJMP _0x44
	LDI  R26,0
	SBIC 0x10,6
	LDI  R26,1
	CPI  R26,LOW(0x0)
	BREQ _0x45
_0x44:
	RJMP _0x43
_0x45:
; 0000 0103   {
; 0000 0104     auxcount++;
	LDS  R30,_auxcount
	SUBI R30,-LOW(1)
	STS  _auxcount,R30
; 0000 0105     if(auxcount>=(outset[1]>>2))
	RCALL SUBOPT_0x11
	RCALL SUBOPT_0x10
	LDS  R26,_auxcount
	RCALL SUBOPT_0x9
	BRLT _0x46
; 0000 0106     {
; 0000 0107       AUX=1;
	SBI  0x12,6
; 0000 0108       auxon=0;
	CLT
	BLD  R2,5
; 0000 0109       auxcount=0;
	LDI  R30,LOW(0)
	STS  _auxcount,R30
; 0000 010A     }
; 0000 010B   }
_0x46:
; 0000 010C 
; 0000 010D   if(P1 && (outset[4]&0x03)==1)
_0x43:
	SBIC 0x13,4
	RJMP _0x4A
	RCALL SUBOPT_0x12
	RCALL SUBOPT_0x13
	BREQ _0x4B
_0x4A:
	RJMP _0x49
_0x4B:
; 0000 010E   {
; 0000 010F     p1count++;
	LDS  R30,_p1count
	SUBI R30,-LOW(1)
	STS  _p1count,R30
; 0000 0110     if(p1count>=(outset[4]>>2))
	RCALL SUBOPT_0x12
	RCALL SUBOPT_0x10
	LDS  R26,_p1count
	RCALL SUBOPT_0x9
	BRLT _0x4C
; 0000 0111     {
; 0000 0112       p1count=0;
	LDI  R30,LOW(0)
	STS  _p1count,R30
; 0000 0113       if((outset[4]&0x03)==1)
	RCALL SUBOPT_0x12
	RCALL SUBOPT_0x13
	BRNE _0x4D
; 0000 0114       {
; 0000 0115         ACCOUT=0;
	RCALL SUBOPT_0xA
; 0000 0116         if((outset[2]&0x03)==1)swblink();
	RCALL SUBOPT_0xB
	BRNE _0x50
	RCALL _swblink
; 0000 0117         mode=4;
_0x50:
	RCALL SUBOPT_0xC
; 0000 0118       }
; 0000 0119     }
_0x4D:
; 0000 011A   }
_0x4C:
; 0000 011B 
; 0000 011C   if(P2 && (outset[5]&0x03)==1)
_0x49:
	SBIC 0x13,5
	RJMP _0x52
	RCALL SUBOPT_0x14
	RCALL SUBOPT_0x13
	BREQ _0x53
_0x52:
	RJMP _0x51
_0x53:
; 0000 011D   {
; 0000 011E     p2count++;
	LDS  R30,_p2count
	SUBI R30,-LOW(1)
	STS  _p2count,R30
; 0000 011F     if(p2count>=(outset[5]>>2))
	RCALL SUBOPT_0x14
	RCALL SUBOPT_0x10
	LDS  R26,_p2count
	RCALL SUBOPT_0x9
	BRLT _0x54
; 0000 0120     {
; 0000 0121       p2count=0;
	LDI  R30,LOW(0)
	STS  _p2count,R30
; 0000 0122       if((outset[5]&0x03)==1)
	RCALL SUBOPT_0x14
	RCALL SUBOPT_0x13
	BRNE _0x55
; 0000 0123       {
; 0000 0124         ACCOUT=0;
	RCALL SUBOPT_0xA
; 0000 0125         if((outset[2]&0x03)==1)swblink();
	RCALL SUBOPT_0xB
	BRNE _0x58
	RCALL _swblink
; 0000 0126         mode=4;
_0x58:
	RCALL SUBOPT_0xC
; 0000 0127       }
; 0000 0128     }
_0x55:
; 0000 0129   }
_0x54:
; 0000 012A 
; 0000 012B   if(!uart_idle)
_0x51:
	SBRC R2,2
	RJMP _0x59
; 0000 012C   {
; 0000 012D     uart_time++;
	INC  R8
; 0000 012E     if(uart_time>30)
	LDI  R30,LOW(30)
	CP   R30,R8
	BRSH _0x5A
; 0000 012F     {
; 0000 0130       uart_time=0;
	CLR  R8
; 0000 0131       uart_idle=1;
	SET
	BLD  R2,2
; 0000 0132     }
; 0000 0133   }
_0x5A:
; 0000 0134 }
_0x59:
	LD   R30,Y+
	OUT  SREG,R30
	LD   R31,Y+
	LD   R30,Y+
	LD   R27,Y+
	LD   R26,Y+
	LD   R25,Y+
	LD   R24,Y+
	LD   R23,Y+
	LD   R22,Y+
	LD   R15,Y+
	LD   R1,Y+
	LD   R0,Y+
	RETI
;
;void voltmeter()
; 0000 0137 {
_voltmeter:
; 0000 0138    unsigned int u=0;
; 0000 0139    u=read_adc(1);       //   
	RCALL __SAVELOCR2
;	u -> R16,R17
	RCALL SUBOPT_0x15
	LDI  R26,LOW(1)
	RCALL _read_adc
	MOVW R16,R30
; 0000 013A    volt=u/4.35;        // 
	MOVW R30,R16
	CLR  R22
	CLR  R23
	RCALL __CDF1
	MOVW R26,R30
	MOVW R24,R22
	__GETD1N 0x408B3333
	RCALL __DIVF21
	LDI  R26,LOW(_volt)
	LDI  R27,HIGH(_volt)
	RCALL __CFD1U
	ST   X,R30
; 0000 013B    if(volt<volt_set)    // 
	LDI  R26,LOW(_volt_set)
	LDI  R27,HIGH(_volt_set)
	RCALL __EEPROMRDB
	LDS  R26,_volt
	CP   R26,R30
	BRSH _0x5B
; 0000 013C    {
; 0000 013D      volt_ok=0;         //  
	CLT
	RJMP _0xC1
; 0000 013E    }
; 0000 013F    else                 // 
_0x5B:
; 0000 0140    {
; 0000 0141      volt_sec=0;        //   
	LDI  R30,LOW(0)
	STS  _volt_sec,R30
; 0000 0142      volt_ok=1;         // 
	SET
_0xC1:
	BLD  R2,3
; 0000 0143    }
; 0000 0144    //printf("adc: %i ",u);
; 0000 0145    //printf("volt: %i ",volt);
; 0000 0146    //putchar(10);
; 0000 0147 
; 0000 0148 }
	RCALL __LOADLOCR2P
	RET
;
;void send_data(unsigned char m) //  
; 0000 014B {
_send_data:
; 0000 014C   int i=0;
; 0000 014D   unsigned int CS_send=0;
; 0000 014E   buffer[0]=0x55;
	ST   -Y,R26
	RCALL __SAVELOCR4
;	m -> Y+4
;	i -> R16,R17
;	CS_send -> R18,R19
	RCALL SUBOPT_0x15
	__GETWRN 18,19,0
	LDI  R30,LOW(85)
	STS  _buffer,R30
; 0000 014F   buffer[1]=0xFF;
	LDI  R30,LOW(255)
	__PUTB1MN _buffer,1
; 0000 0150   buffer[2]=m;
	LDD  R30,Y+4
	__PUTB1MN _buffer,2
; 0000 0151   if(m==0xC7)  // 
	LDD  R26,Y+4
	CPI  R26,LOW(0xC7)
	BRNE _0x5D
; 0000 0152   {
; 0000 0153     buffer[3]=volt;
	LDS  R30,_volt
	__PUTB1MN _buffer,3
; 0000 0154     buffer[4]=temp+40;
	MOV  R30,R9
	SUBI R30,-LOW(40)
	__PUTB1MN _buffer,4
; 0000 0155     buffer[5]=control;
	__PUTBMRN _buffer,5,7
; 0000 0156     buffer[6]=(volt_ok<<7)|(temp_ok<<6)|devices;
	LDI  R26,0
	SBRC R2,3
	LDI  R26,1
	MOV  R30,R26
	RCALL SUBOPT_0x16
	LDI  R26,0
	SBRC R2,0
	LDI  R26,1
	MOV  R30,R26
	SWAP R30
	ANDI R30,0xF0
	LSL  R30
	LSL  R30
	OR   R30,R0
	OR   R30,R6
	__PUTB1MN _buffer,6
; 0000 0157     buffer[7]=mode;
	__PUTBMRN _buffer,7,4
; 0000 0158   }
; 0000 0159   if(m==0xF8) // 
_0x5D:
	LDD  R26,Y+4
	CPI  R26,LOW(0xF8)
	BRNE _0x5E
; 0000 015A   {
; 0000 015B     buffer[3]=volt_set;
	LDI  R26,LOW(_volt_set)
	LDI  R27,HIGH(_volt_set)
	RCALL __EEPROMRDB
	__PUTB1MN _buffer,3
; 0000 015C     buffer[4]=(temp_ign<<7)|((temp_s+40)&0x7f);
	LDI  R26,LOW(_temp_ign)
	LDI  R27,HIGH(_temp_ign)
	RCALL __EEPROMRDB
	RCALL SUBOPT_0x16
	LDI  R26,LOW(_temp_s)
	LDI  R27,HIGH(_temp_s)
	RCALL __EEPROMRDB
	SUBI R30,-LOW(40)
	ANDI R30,0x7F
	OR   R30,R0
	__PUTB1MN _buffer,4
; 0000 015D     buffer[5]=temp_timer;
	RCALL SUBOPT_0xD
	__PUTB1MN _buffer,5
; 0000 015E     buffer[6]=volt_timer;
	LDI  R26,LOW(_volt_timer)
	LDI  R27,HIGH(_volt_timer)
	RCALL __EEPROMRDB
	__PUTB1MN _buffer,6
; 0000 015F     buffer[7]=ign_timer;
	LDI  R26,LOW(_ign_timer)
	LDI  R27,HIGH(_ign_timer)
	RCALL __EEPROMRDB
	__PUTB1MN _buffer,7
; 0000 0160     buffer[8]=turnon_timer;
	LDI  R26,LOW(_turnon_timer)
	LDI  R27,HIGH(_turnon_timer)
	RCALL __EEPROMRDB
	__PUTB1MN _buffer,8
; 0000 0161     buffer[9]=turnoff_timer;
	LDI  R26,LOW(_turnoff_timer)
	LDI  R27,HIGH(_turnoff_timer)
	RCALL __EEPROMRDB
	__PUTB1MN _buffer,9
; 0000 0162   }
; 0000 0163   if(m==0xBA) //  
_0x5E:
	LDD  R26,Y+4
	CPI  R26,LOW(0xBA)
	BRNE _0x5F
; 0000 0164   {
; 0000 0165     for(i=0;i<6;i++)
	RCALL SUBOPT_0x15
_0x61:
	__CPWRN 16,17,6
	BRGE _0x62
; 0000 0166     {
; 0000 0167       buffer[i+3]=outset[i];
	MOVW R30,R16
	__ADDW1MN _buffer,3
	MOVW R0,R30
	RCALL SUBOPT_0xF
	ADD  R26,R16
	ADC  R27,R17
	RCALL __EEPROMRDB
	MOVW R26,R0
	ST   X,R30
; 0000 0168     }
	__ADDWRN 16,17,1
	RJMP _0x61
_0x62:
; 0000 0169   }
; 0000 016A   for(i=0;i<11;i++)
_0x5F:
	RCALL SUBOPT_0x15
_0x64:
	__CPWRN 16,17,11
	BRGE _0x65
; 0000 016B   {
; 0000 016C      CS_send = CS_send + buffer[i];//  
	RCALL SUBOPT_0x17
	LD   R30,X
	RCALL SUBOPT_0x1
	__ADDWRR 18,19,30,31
; 0000 016D   }
	__ADDWRN 16,17,1
	RJMP _0x64
_0x65:
; 0000 016E   CS_send= CS_send & 0xFF;
	ANDI R19,HIGH(255)
; 0000 016F   buffer[11]=CS_send;//checksum
	__PUTBMRN _buffer,11,18
; 0000 0170   for(i=0;i<12;i++)
	RCALL SUBOPT_0x15
_0x67:
	__CPWRN 16,17,12
	BRGE _0x68
; 0000 0171   {
; 0000 0172     putchar(buffer[i]); //
	RCALL SUBOPT_0x17
	LD   R26,X
	RCALL _putchar
; 0000 0173   }
	__ADDWRN 16,17,1
	RJMP _0x67
_0x68:
; 0000 0174 }
	RCALL __LOADLOCR4
	RJMP _0x2080002
;
;void main(void)
; 0000 0177 {
_main:
; 0000 0178 PORTB=0x00;
	LDI  R30,LOW(0)
	OUT  0x18,R30
; 0000 0179 DDRB=0x03;
	LDI  R30,LOW(3)
	OUT  0x17,R30
; 0000 017A PORTC=0x30;
	LDI  R30,LOW(48)
	OUT  0x15,R30
; 0000 017B DDRC=0x0C;
	LDI  R30,LOW(12)
	OUT  0x14,R30
; 0000 017C PORTD=0x0C;
	OUT  0x12,R30
; 0000 017D DDRD=0xE0;
	LDI  R30,LOW(224)
	OUT  0x11,R30
; 0000 017E 
; 0000 017F TCCR0=0x00;
	LDI  R30,LOW(0)
	OUT  0x33,R30
; 0000 0180 TCNT0=0x00;
	OUT  0x32,R30
; 0000 0181 TCCR1A=0x00;
	OUT  0x2F,R30
; 0000 0182 TCCR1B=0x04;
	LDI  R30,LOW(4)
	OUT  0x2E,R30
; 0000 0183 TCNT1H=0x00;
	RCALL SUBOPT_0x5
; 0000 0184 TCNT1L=0x00;
; 0000 0185 ICR1H=0x00;
	LDI  R30,LOW(0)
	OUT  0x27,R30
; 0000 0186 ICR1L=0x00;
	OUT  0x26,R30
; 0000 0187 OCR1AH=0x7A;
	LDI  R30,LOW(122)
	OUT  0x2B,R30
; 0000 0188 OCR1AL=0x12;
	LDI  R30,LOW(18)
	OUT  0x2A,R30
; 0000 0189 OCR1BH=0x00;
	LDI  R30,LOW(0)
	OUT  0x29,R30
; 0000 018A OCR1BL=0x00;
	OUT  0x28,R30
; 0000 018B ASSR=0x00;
	OUT  0x22,R30
; 0000 018C TCCR2=0x00;
	OUT  0x25,R30
; 0000 018D TCNT2=0x00;
	OUT  0x24,R30
; 0000 018E OCR2=0x00;
	OUT  0x23,R30
; 0000 018F 
; 0000 0190 //GICR|=0x80;
; 0000 0191 MCUCR=0x00;
	OUT  0x35,R30
; 0000 0192 //GIFR=0x80;
; 0000 0193 
; 0000 0194 TIMSK=0x10;
	LDI  R30,LOW(16)
	OUT  0x39,R30
; 0000 0195 //TIMSK=0x00;
; 0000 0196 
; 0000 0197 UCSRA=0x00;
	LDI  R30,LOW(0)
	OUT  0xB,R30
; 0000 0198 UCSRB=0x98;
	LDI  R30,LOW(152)
	OUT  0xA,R30
; 0000 0199 UCSRC=0x86;
	LDI  R30,LOW(134)
	OUT  0x20,R30
; 0000 019A UBRRH=0x00;
	LDI  R30,LOW(0)
	OUT  0x20,R30
; 0000 019B UBRRL=0x33;
	LDI  R30,LOW(51)
	OUT  0x9,R30
; 0000 019C ACSR=0x80;
	LDI  R30,LOW(128)
	OUT  0x8,R30
; 0000 019D SFIOR=0x00;
	LDI  R30,LOW(0)
	OUT  0x30,R30
; 0000 019E ADMUX=ADC_VREF_TYPE & 0xff;
	LDI  R30,LOW(64)
	OUT  0x7,R30
; 0000 019F ADCSRA=0x84;
	LDI  R30,LOW(132)
	OUT  0x6,R30
; 0000 01A0 SPCR=0x00;
	LDI  R30,LOW(0)
	OUT  0xD,R30
; 0000 01A1 TWCR=0x00;
	OUT  0x36,R30
; 0000 01A2 w1_init();
	RCALL _w1_init
; 0000 01A3 devices=(ds18b20_init(0,20,30,DS18B20_9BIT_RES));// 
	LDI  R30,LOW(0)
	LDI  R31,HIGH(0)
	ST   -Y,R31
	ST   -Y,R30
	LDI  R30,LOW(20)
	ST   -Y,R30
	LDI  R30,LOW(30)
	ST   -Y,R30
	LDI  R26,LOW(0)
	RCALL _ds18b20_init
	MOV  R6,R30
; 0000 01A4 #asm("sei")
	sei
; 0000 01A5 
; 0000 01A6 while (1)
_0x69:
; 0000 01A7       {
; 0000 01A8         control=((PIND&0x60)<<1)|(~PINC&0x30)|(~PIND&0x0C)|(PINB&0x03);//   /
	IN   R30,0x10
	ANDI R30,LOW(0x60)
	LSL  R30
	MOV  R26,R30
	IN   R30,0x13
	COM  R30
	ANDI R30,LOW(0x30)
	OR   R30,R26
	MOV  R26,R30
	IN   R30,0x10
	COM  R30
	ANDI R30,LOW(0xC)
	OR   R30,R26
	MOV  R26,R30
	IN   R30,0x16
	ANDI R30,LOW(0x3)
	OR   R30,R26
	MOV  R7,R30
; 0000 01A9         voltmeter();                            // 
	RCALL _voltmeter
; 0000 01AA         //delay_ms(1000);
; 0000 01AB 
; 0000 01AC 
; 0000 01AD         if(mode<4)                              //  ,   
	LDI  R30,LOW(4)
	CP   R4,R30
	BRLO PC+2
	RJMP _0x6C
; 0000 01AE         {
; 0000 01AF           temp0=ds18b20_temperature(0);         // 
	LDI  R26,LOW(0)
	RCALL SUBOPT_0x18
	RCALL _ds18b20_temperature
	STS  _temp0,R30
	STS  _temp0+1,R31
	STS  _temp0+2,R22
	STS  _temp0+3,R23
; 0000 01B0           if(temp0!=200)temp=temp0;             //  ,  
	LDS  R26,_temp0
	LDS  R27,_temp0+1
	LDS  R24,_temp0+2
	LDS  R25,_temp0+3
	__CPD2N 0x43480000
	BREQ _0x6D
	LDS  R30,_temp0
	LDS  R31,_temp0+1
	LDS  R22,_temp0+2
	LDS  R23,_temp0+3
	RCALL __CFD1
	MOV  R9,R30
; 0000 01B1           if((outset[4]&0x03)==2)AUX=!P1;       // ,       
_0x6D:
	RCALL SUBOPT_0x12
	RCALL SUBOPT_0x19
	CPI  R30,LOW(0x2)
	BRNE _0x6E
	RCALL SUBOPT_0x1A
	BREQ _0x6F
	CBI  0x12,6
	RJMP _0x70
_0x6F:
	SBI  0x12,6
_0x70:
; 0000 01B2           if((outset[4]&0x03)==3)PRF=!P1;
_0x6E:
	RCALL SUBOPT_0x12
	RCALL SUBOPT_0x19
	CPI  R30,LOW(0x3)
	BRNE _0x71
	RCALL SUBOPT_0x1A
	BREQ _0x72
	CBI  0x18,0
	RJMP _0x73
_0x72:
	SBI  0x18,0
_0x73:
; 0000 01B3           if((outset[5]&0x03)==2)AUX=!P2;
_0x71:
	RCALL SUBOPT_0x14
	RCALL SUBOPT_0x19
	CPI  R30,LOW(0x2)
	BRNE _0x74
	RCALL SUBOPT_0x1B
	BREQ _0x75
	CBI  0x12,6
	RJMP _0x76
_0x75:
	SBI  0x12,6
_0x76:
; 0000 01B4           if((outset[5]&0x03)==3)PRF=!P2;
_0x74:
	RCALL SUBOPT_0x14
	RCALL SUBOPT_0x19
	CPI  R30,LOW(0x3)
	BRNE _0x77
	RCALL SUBOPT_0x1B
	BREQ _0x78
	CBI  0x18,0
	RJMP _0x79
_0x78:
	SBI  0x18,0
_0x79:
; 0000 01B5         }
_0x77:
; 0000 01B6 
; 0000 01B7         if(ACC)                                 // ACC
_0x6C:
	SBIC 0x10,3
	RJMP _0x7A
; 0000 01B8         {
; 0000 01B9           ignofftime=0;                         // 
	RCALL SUBOPT_0x4
; 0000 01BA           if(mode==0 && volt_ok)                //       
	CP   R30,R4
	BRNE _0x7C
	SBRC R2,3
	RJMP _0x7D
_0x7C:
	RJMP _0x7B
_0x7D:
; 0000 01BB           {
; 0000 01BC             PSU=1;                              //  
	SBI  0x12,7
; 0000 01BD             if((outset[0]&0x03)==1)prfon=1;     // ,  PRF
	RCALL SUBOPT_0xF
	RCALL SUBOPT_0x13
	BRNE _0x80
	SET
	BLD  R2,4
; 0000 01BE             if((outset[1]&0x03)==1)auxon=1;     // ,  AUX
_0x80:
	RCALL SUBOPT_0x11
	RCALL SUBOPT_0x13
	BRNE _0x81
	SET
	BLD  R2,5
; 0000 01BF             if((outset[2]&0x03)==2)swblink();
_0x81:
	RCALL SUBOPT_0x6
	ANDI R30,LOW(0x3)
	CPI  R30,LOW(0x2)
	BRNE _0x82
	RCALL _swblink
; 0000 01C0             if((outset[3]&0x03)==2)mnblink();
_0x82:
	RCALL SUBOPT_0x8
	ANDI R30,LOW(0x3)
	CPI  R30,LOW(0x2)
	BRNE _0x83
	RCALL _mnblink
; 0000 01C1             mode=1;
_0x83:
	LDI  R30,LOW(1)
	MOV  R4,R30
; 0000 01C2             temp_ok=0;                             //   
	CLT
	BLD  R2,0
; 0000 01C3           }
; 0000 01C4         }
_0x7B:
; 0000 01C5         switch(mode)
_0x7A:
	MOV  R30,R4
	RCALL SUBOPT_0x1
; 0000 01C6         {
; 0000 01C7           case 1:                               // 
	CPI  R30,LOW(0x1)
	LDI  R26,HIGH(0x1)
	CPC  R31,R26
	BRNE _0x87
; 0000 01C8             if (temp_ign==0)                    //  
	LDI  R26,LOW(_temp_ign)
	LDI  R27,HIGH(_temp_ign)
	RCALL __EEPROMRDB
	CPI  R30,0
	BRNE _0x88
; 0000 01C9             {
; 0000 01CA               if(devices>0)                     // 
	LDI  R30,LOW(0)
	CP   R30,R6
	BRSH _0x89
; 0000 01CB               {
; 0000 01CC                 if(temp<temp_s && !temp_ok)     //   ,    
	LDI  R26,LOW(_temp_s)
	LDI  R27,HIGH(_temp_s)
	RCALL __EEPROMRDB
	CP   R9,R30
	BRGE _0x8B
	SBRS R2,0
	RJMP _0x8C
_0x8B:
	RJMP _0x8A
_0x8C:
; 0000 01CD                 {
; 0000 01CE                   temp_ok=0;
	CLT
	BLD  R2,0
; 0000 01CF                   HEATER=1;                     // 
	SBI  0x18,1
; 0000 01D0                 }
; 0000 01D1                 else                            // 
	RJMP _0x8F
_0x8A:
; 0000 01D2                 {
; 0000 01D3                   HEATER=0;                     // 
	CBI  0x18,1
; 0000 01D4                   temp_ok=1;                    //  
	RCALL SUBOPT_0xE
; 0000 01D5                   temp_sec=0;                   // 
	CLR  R10
	CLR  R11
; 0000 01D6                 }
_0x8F:
; 0000 01D7               }
; 0000 01D8               else                              // 
	RJMP _0x92
_0x89:
; 0000 01D9               {
; 0000 01DA                 temp_ok=1;                      //,   ,  
	RCALL SUBOPT_0xE
; 0000 01DB                 HEATER=0;                       // 
	CBI  0x18,1
; 0000 01DC               }
_0x92:
; 0000 01DD             }
; 0000 01DE             else
	RJMP _0x95
_0x88:
; 0000 01DF             {
; 0000 01E0               temp_ok=1;                        // ,  ,   
	RCALL SUBOPT_0xE
; 0000 01E1               HEATER=0;                         // 
	CBI  0x18,1
; 0000 01E2             }
_0x95:
; 0000 01E3             if(volt_ok==1 && temp_ok==1)       //  ,    
	SBRS R2,3
	RJMP _0x99
	SBRC R2,0
	RJMP _0x9A
_0x99:
	RJMP _0x98
_0x9A:
; 0000 01E4             {
; 0000 01E5                if((outset[2]&0x03)==0)ACCOUT=1;//      
	RCALL SUBOPT_0x6
	ANDI R30,LOW(0x3)
	BRNE _0x9B
	SBI  0x12,5
; 0000 01E6                if((outset[2]&0x03)==1)swblink();
_0x9B:
	RCALL SUBOPT_0x6
	RCALL SUBOPT_0xB
	BRNE _0x9E
	RCALL _swblink
; 0000 01E7                if((outset[3]&0x03)==1)mnblink();
_0x9E:
	RCALL SUBOPT_0x8
	RCALL SUBOPT_0xB
	BRNE _0x9F
	RCALL _mnblink
; 0000 01E8                if((outset[0]&0x03)==2)prfon=1; // ,  PRF
_0x9F:
	RCALL SUBOPT_0xF
	RCALL SUBOPT_0x19
	CPI  R30,LOW(0x2)
	BRNE _0xA0
	SET
	BLD  R2,4
; 0000 01E9                if((outset[1]&0x03)==2)auxon=1; // ,  AUX
_0xA0:
	RCALL SUBOPT_0x11
	RCALL SUBOPT_0x19
	CPI  R30,LOW(0x2)
	BRNE _0xA1
	SET
	BLD  R2,5
; 0000 01EA                mode=2;                         //     
_0xA1:
	LDI  R30,LOW(2)
	MOV  R4,R30
; 0000 01EB             }
; 0000 01EC           break;
_0x98:
	RJMP _0x86
; 0000 01ED           case 2:                               //   
_0x87:
	CPI  R30,LOW(0x2)
	LDI  R26,HIGH(0x2)
	CPC  R31,R26
	BRNE _0xA2
; 0000 01EE              if(ATX)                            //    
	SBIC 0x10,2
	RJMP _0xA3
; 0000 01EF              {
; 0000 01F0                waitatx_on=0;                    //  
	RCALL SUBOPT_0x2
; 0000 01F1                if((outset[0]&0x03)==3)prfon=1;  // ,  PRF
	RCALL SUBOPT_0xF
	RCALL SUBOPT_0x19
	CPI  R30,LOW(0x3)
	BRNE _0xA4
	SET
	BLD  R2,4
; 0000 01F2                if((outset[1]&0x03)==3)auxon=1;  // ,  AUX
_0xA4:
	RCALL SUBOPT_0x11
	RCALL SUBOPT_0x19
	CPI  R30,LOW(0x3)
	BRNE _0xA5
	SET
	BLD  R2,5
; 0000 01F3                if((outset[2]&0x03)==3)swblink();
_0xA5:
	RCALL SUBOPT_0x6
	ANDI R30,LOW(0x3)
	CPI  R30,LOW(0x3)
	BRNE _0xA6
	RCALL _swblink
; 0000 01F4                if((outset[3]&0x03)==3)mnblink();
_0xA6:
	RCALL SUBOPT_0x8
	ANDI R30,LOW(0x3)
	CPI  R30,LOW(0x3)
	BRNE _0xA7
	RCALL _mnblink
; 0000 01F5                mode=3;                          //   
_0xA7:
	LDI  R30,LOW(3)
	MOV  R4,R30
; 0000 01F6              }
; 0000 01F7           break;
_0xA3:
	RJMP _0x86
; 0000 01F8           case 3:                               // .   ,    ,      
_0xA2:
	CPI  R30,LOW(0x3)
	LDI  R26,HIGH(0x3)
	CPC  R31,R26
	BRNE _0xA8
; 0000 01F9             if(!ATX)                            //   atx,  
	SBIC 0x10,2
; 0000 01FA             {
; 0000 01FB               all_off();
	RCALL _all_off
; 0000 01FC             }
; 0000 01FD           break;
	RJMP _0x86
; 0000 01FE           case 4:                                           //  
_0xA8:
	CPI  R30,LOW(0x4)
	LDI  R26,HIGH(0x4)
	CPC  R31,R26
	BRNE _0x86
; 0000 01FF             if(!ATX)                                        //   ATX
	SBIS 0x10,2
	RJMP _0xAB
; 0000 0200             {
; 0000 0201               waitatx_off=0;                                //   
	RCALL SUBOPT_0x3
; 0000 0202               all_off();
	RCALL _all_off
; 0000 0203             }
; 0000 0204           break;
_0xAB:
; 0000 0205         }
_0x86:
; 0000 0206 
; 0000 0207         if(rx_counter>11)
	LDS  R26,_rx_counter
	CPI  R26,LOW(0xC)
	BRSH PC+2
	RJMP _0xAC
; 0000 0208         {
; 0000 0209           rx_counter=0;                                     // 
	RCALL SUBOPT_0x0
; 0000 020A           CS_count=0;                                       // 
	CLR  R12
	CLR  R13
; 0000 020B 
; 0000 020C           for(i=0;i<11;i++)
	CLR  R5
_0xAE:
	LDI  R30,LOW(11)
	CP   R5,R30
	BRSH _0xAF
; 0000 020D           {
; 0000 020E              CS_count = CS_count + rx_buffer[i];            //  
	MOV  R30,R5
	RCALL SUBOPT_0x1
	SUBI R30,LOW(-_rx_buffer)
	SBCI R31,HIGH(-_rx_buffer)
	LD   R30,Z
	RCALL SUBOPT_0x1
	__ADDWRR 12,13,30,31
; 0000 020F           }
	INC  R5
	RJMP _0xAE
_0xAF:
; 0000 0210           CS_count= CS_count & 0xFF;
	LDI  R30,LOW(0)
	AND  R13,R30
; 0000 0211           if(CS_count==rx_buffer[11])                       // 
	__GETB1MN _rx_buffer,11
	MOVW R26,R12
	RCALL SUBOPT_0x1
	CP   R30,R26
	CPC  R31,R27
	BREQ PC+2
	RJMP _0xB0
; 0000 0212           {
; 0000 0213             if(rx_buffer[0]==0x55 && rx_buffer[1]==0xFF)    //  
	LDS  R26,_rx_buffer
	CPI  R26,LOW(0x55)
	BRNE _0xB2
	__GETB2MN _rx_buffer,1
	CPI  R26,LOW(0xFF)
	BREQ _0xB3
_0xB2:
	RJMP _0xB1
_0xB3:
; 0000 0214             {
; 0000 0215               if(rx_buffer[2]==0xC6)                        //  
	RCALL SUBOPT_0x1C
	CPI  R26,LOW(0xC6)
	BRNE _0xB4
; 0000 0216               {
; 0000 0217                 send_data(0xC7);                            //
	LDI  R26,LOW(199)
	RJMP _0xC2
; 0000 0218               }
; 0000 0219               else if(rx_buffer[2]==0x78)                   //  
_0xB4:
	RCALL SUBOPT_0x1C
	CPI  R26,LOW(0x78)
	BRNE _0xB6
; 0000 021A               {
; 0000 021B                 send_data(0xF8);                            //
	LDI  R26,LOW(248)
	RJMP _0xC2
; 0000 021C               }
; 0000 021D               else if(rx_buffer[2]==0xDC)                   // c
_0xB6:
	RCALL SUBOPT_0x1C
	CPI  R26,LOW(0xDC)
	BRNE _0xB8
; 0000 021E               {
; 0000 021F                 volt_set=rx_buffer[3];
	__GETB1MN _rx_buffer,3
	LDI  R26,LOW(_volt_set)
	LDI  R27,HIGH(_volt_set)
	RCALL __EEPROMWRB
; 0000 0220                 temp_s=(rx_buffer[4]&0x7F)-40;
	__GETB1MN _rx_buffer,4
	ANDI R30,0x7F
	SUBI R30,LOW(40)
	LDI  R26,LOW(_temp_s)
	LDI  R27,HIGH(_temp_s)
	RCALL __EEPROMWRB
; 0000 0221                 temp_ign=(rx_buffer[4]>>7)&0x01;
	__GETB1MN _rx_buffer,4
	ROL  R30
	LDI  R30,0
	ROL  R30
	ANDI R30,LOW(0x1)
	LDI  R26,LOW(_temp_ign)
	LDI  R27,HIGH(_temp_ign)
	RCALL __EEPROMWRB
; 0000 0222                 temp_timer=rx_buffer[5];
	__GETB1MN _rx_buffer,5
	LDI  R26,LOW(_temp_timer)
	LDI  R27,HIGH(_temp_timer)
	RCALL __EEPROMWRB
; 0000 0223                 ign_timer=rx_buffer[6];
	__GETB1MN _rx_buffer,6
	LDI  R26,LOW(_ign_timer)
	LDI  R27,HIGH(_ign_timer)
	RCALL __EEPROMWRB
; 0000 0224                 volt_timer=rx_buffer[7];
	__GETB1MN _rx_buffer,7
	LDI  R26,LOW(_volt_timer)
	LDI  R27,HIGH(_volt_timer)
	RCALL SUBOPT_0x1
	RCALL __EEPROMWRW
; 0000 0225                 turnoff_timer=rx_buffer[8];
	__GETB1MN _rx_buffer,8
	LDI  R26,LOW(_turnoff_timer)
	LDI  R27,HIGH(_turnoff_timer)
	RCALL __EEPROMWRB
; 0000 0226                 turnon_timer=rx_buffer[9];                  // 
	__GETB1MN _rx_buffer,9
	LDI  R26,LOW(_turnon_timer)
	LDI  R27,HIGH(_turnon_timer)
	RCALL __EEPROMWRB
; 0000 0227                 send_data(0xF8);                            //
	LDI  R26,LOW(248)
	RJMP _0xC2
; 0000 0228               }
; 0000 0229               else if(rx_buffer[2]==0x5D)                   //  
_0xB8:
	RCALL SUBOPT_0x1C
	CPI  R26,LOW(0x5D)
	BREQ _0xC3
; 0000 022A               {
; 0000 022B                 send_data(0xBA);                            //
; 0000 022C               }
; 0000 022D               else if(rx_buffer[2]==0xA3)                   //  
	RCALL SUBOPT_0x1C
	CPI  R26,LOW(0xA3)
	BRNE _0xBC
; 0000 022E               {
; 0000 022F                 for(i=0;i<6;i++)
	CLR  R5
_0xBE:
	LDI  R30,LOW(6)
	CP   R5,R30
	BRSH _0xBF
; 0000 0230                 {
; 0000 0231                   outset[i]=rx_buffer[i+3];                 //  
	MOV  R26,R5
	RCALL SUBOPT_0x18
	SUBI R26,LOW(-_outset)
	SBCI R27,HIGH(-_outset)
	MOV  R30,R5
	RCALL SUBOPT_0x1
	__ADDW1MN _rx_buffer,3
	LD   R30,Z
	RCALL __EEPROMWRB
; 0000 0232                 }
	INC  R5
	RJMP _0xBE
_0xBF:
; 0000 0233                 send_data(0xBA);                            //
_0xC3:
	LDI  R26,LOW(186)
_0xC2:
	RCALL _send_data
; 0000 0234               }
; 0000 0235             }
_0xBC:
; 0000 0236           }
_0xB1:
; 0000 0237         }
_0xB0:
; 0000 0238 
; 0000 0239       }
_0xAC:
	RJMP _0x69
; 0000 023A }
_0xC0:
	RJMP _0xC0

	.CSEG
_ds18b20_select:
	ST   -Y,R27
	ST   -Y,R26
	ST   -Y,R17
	RCALL _w1_init
	CPI  R30,0
	BRNE _0x2000003
	LDI  R30,LOW(0)
	RJMP _0x2080003
_0x2000003:
	LDD  R30,Y+1
	LDD  R31,Y+1+1
	SBIW R30,0
	BREQ _0x2000004
	LDI  R26,LOW(85)
	RCALL _w1_write
	LDI  R17,LOW(0)
_0x2000006:
	RCALL SUBOPT_0x1D
	LD   R30,X+
	STD  Y+1,R26
	STD  Y+1+1,R27
	MOV  R26,R30
	RCALL _w1_write
	SUBI R17,-LOW(1)
	CPI  R17,8
	BRLO _0x2000006
	RJMP _0x2000008
_0x2000004:
	LDI  R26,LOW(204)
	RCALL _w1_write
_0x2000008:
	LDI  R30,LOW(1)
	RJMP _0x2080003
_ds18b20_read_spd:
	ST   -Y,R27
	ST   -Y,R26
	RCALL __SAVELOCR4
	LDD  R26,Y+4
	LDD  R27,Y+4+1
	RCALL SUBOPT_0x1E
	BRNE _0x2000009
	LDI  R30,LOW(0)
	RJMP _0x2080004
_0x2000009:
	LDI  R26,LOW(190)
	RCALL _w1_write
	LDI  R17,LOW(0)
	__POINTWRM 18,19,___ds18b20_scratch_pad
_0x200000B:
	PUSH R19
	PUSH R18
	__ADDWRN 18,19,1
	RCALL _w1_read
	POP  R26
	POP  R27
	ST   X,R30
	SUBI R17,-LOW(1)
	CPI  R17,9
	BRLO _0x200000B
	LDI  R30,LOW(___ds18b20_scratch_pad)
	LDI  R31,HIGH(___ds18b20_scratch_pad)
	ST   -Y,R31
	ST   -Y,R30
	LDI  R26,LOW(9)
	RCALL _w1_dow_crc8
	RCALL __LNEGB1
_0x2080004:
	RCALL __LOADLOCR4
	ADIW R28,6
	RET
_ds18b20_temperature:
	ST   -Y,R27
	ST   -Y,R26
	ST   -Y,R17
	RCALL SUBOPT_0x1D
	RCALL _ds18b20_read_spd
	CPI  R30,0
	BRNE _0x200000D
	RCALL SUBOPT_0x1F
	RJMP _0x2080003
_0x200000D:
	__GETB1MN ___ds18b20_scratch_pad,4
	SWAP R30
	ANDI R30,0xF
	LSR  R30
	ANDI R30,LOW(0x3)
	MOV  R17,R30
	RCALL SUBOPT_0x1D
	RCALL SUBOPT_0x1E
	BRNE _0x200000E
	RCALL SUBOPT_0x1F
	RJMP _0x2080003
_0x200000E:
	LDI  R26,LOW(68)
	RCALL _w1_write
	MOV  R30,R17
	LDI  R26,LOW(_conv_delay_G100*2)
	LDI  R27,HIGH(_conv_delay_G100*2)
	RCALL SUBOPT_0x20
	RCALL __GETW2PF
	RCALL _delay_ms
	RCALL SUBOPT_0x1D
	RCALL _ds18b20_read_spd
	CPI  R30,0
	BRNE _0x200000F
	RCALL SUBOPT_0x1F
	RJMP _0x2080003
_0x200000F:
	RCALL _w1_init
	MOV  R30,R17
	LDI  R26,LOW(_bit_mask_G100*2)
	LDI  R27,HIGH(_bit_mask_G100*2)
	RCALL SUBOPT_0x20
	RCALL __GETW1PF
	LDS  R26,___ds18b20_scratch_pad
	LDS  R27,___ds18b20_scratch_pad+1
	AND  R30,R26
	AND  R31,R27
	RCALL __CWD1
	RCALL __CDF1
	__GETD2N 0x3D800000
	RCALL __MULF12
_0x2080003:
	LDD  R17,Y+0
	ADIW R28,3
	RET
_ds18b20_init:
	ST   -Y,R26
	LDD  R26,Y+3
	LDD  R27,Y+3+1
	RCALL SUBOPT_0x1E
	BRNE _0x2000010
	LDI  R30,LOW(0)
	RJMP _0x2080002
_0x2000010:
	LD   R30,Y
	SWAP R30
	ANDI R30,0xF0
	LSL  R30
	ORI  R30,LOW(0x1F)
	ST   Y,R30
	LDI  R26,LOW(78)
	RCALL _w1_write
	LDD  R26,Y+1
	RCALL _w1_write
	LDD  R26,Y+2
	RCALL _w1_write
	LD   R26,Y
	RCALL _w1_write
	LDD  R26,Y+3
	LDD  R27,Y+3+1
	RCALL _ds18b20_read_spd
	CPI  R30,0
	BRNE _0x2000011
	LDI  R30,LOW(0)
	RJMP _0x2080002
_0x2000011:
	__GETB2MN ___ds18b20_scratch_pad,3
	LDD  R30,Y+2
	CP   R30,R26
	BRNE _0x2000013
	__GETB2MN ___ds18b20_scratch_pad,2
	LDD  R30,Y+1
	CP   R30,R26
	BRNE _0x2000013
	__GETB2MN ___ds18b20_scratch_pad,4
	LD   R30,Y
	CP   R30,R26
	BREQ _0x2000012
_0x2000013:
	LDI  R30,LOW(0)
	RJMP _0x2080002
_0x2000012:
	LDD  R26,Y+3
	LDD  R27,Y+3+1
	RCALL SUBOPT_0x1E
	BRNE _0x2000015
	LDI  R30,LOW(0)
	RJMP _0x2080002
_0x2000015:
	LDI  R26,LOW(72)
	RCALL _w1_write
	LDI  R26,LOW(15)
	RCALL SUBOPT_0x18
	RCALL _delay_ms
	RCALL _w1_init
_0x2080002:
	ADIW R28,5
	RET
	#ifndef __SLEEP_DEFINED__
	#define __SLEEP_DEFINED__
	.EQU __se_bit=0x80
	.EQU __sm_mask=0x70
	.EQU __sm_powerdown=0x20
	.EQU __sm_powersave=0x30
	.EQU __sm_standby=0x60
	.EQU __sm_ext_standby=0x70
	.EQU __sm_adc_noise_red=0x10
	.SET power_ctrl_reg=mcucr
	#endif

	.CSEG
_putchar:
	ST   -Y,R26
putchar0:
     sbis usr,udre
     rjmp putchar0
     ld   r30,y
     out  udr,r30
_0x2080001:
	ADIW R28,1
	RET

	.CSEG

	.CSEG

	.DSEG
___ds18b20_scratch_pad:
	.BYTE 0x9
_buffer:
	.BYTE 0x10
_temp0:
	.BYTE 0x4

	.ESEG
_temp_s:
	.DB  0x1
_temp_ign:
	.DB  0x1
_temp_timer:
	.DB  0x1

	.DSEG
_volt:
	.BYTE 0x1
_volt_sec:
	.BYTE 0x1

	.ESEG
_volt_set:
	.DB  0x1
_volt_timer:
	.DB  0x1,0x0
_turnon_timer:
	.DB  0x1
_turnoff_timer:
	.DB  0x1
_ign_timer:
	.DB  0x1
_outset:
	.BYTE 0x6

	.DSEG
_ignofftime:
	.BYTE 0x1
_waitatx_on:
	.BYTE 0x1
_waitatx_off:
	.BYTE 0x1
_prfcount:
	.BYTE 0x1
_auxcount:
	.BYTE 0x1
_p1count:
	.BYTE 0x1
_p2count:
	.BYTE 0x1
_rx_buffer:
	.BYTE 0x10
_rx_counter:
	.BYTE 0x1

	.CSEG
;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES, CODE SIZE REDUCTION:2 WORDS
SUBOPT_0x0:
	LDI  R30,LOW(0)
	STS  _rx_counter,R30
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 17 TIMES, CODE SIZE REDUCTION:30 WORDS
SUBOPT_0x1:
	LDI  R31,0
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES, CODE SIZE REDUCTION:2 WORDS
SUBOPT_0x2:
	LDI  R30,LOW(0)
	STS  _waitatx_on,R30
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES, CODE SIZE REDUCTION:2 WORDS
SUBOPT_0x3:
	LDI  R30,LOW(0)
	STS  _waitatx_off,R30
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0x4:
	LDI  R30,LOW(0)
	STS  _ignofftime,R30
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES, CODE SIZE REDUCTION:4 WORDS
SUBOPT_0x5:
	LDI  R30,LOW(0)
	OUT  0x2D,R30
	OUT  0x2C,R30
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 10 TIMES, CODE SIZE REDUCTION:16 WORDS
SUBOPT_0x6:
	__POINTW2MN _outset,2
	RCALL __EEPROMRDB
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:4 WORDS
SUBOPT_0x7:
	RCALL SUBOPT_0x1
	RCALL __ASRW2
	LDI  R26,LOW(100)
	LDI  R27,HIGH(100)
	RCALL __MULW12
	MOVW R26,R30
	RJMP _delay_ms

;OPTIMIZER ADDED SUBROUTINE, CALLED 4 TIMES, CODE SIZE REDUCTION:4 WORDS
SUBOPT_0x8:
	__POINTW2MN _outset,3
	RCALL __EEPROMRDB
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 5 TIMES, CODE SIZE REDUCTION:14 WORDS
SUBOPT_0x9:
	LDI  R27,0
	CP   R26,R30
	CPC  R27,R31
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 5 TIMES, CODE SIZE REDUCTION:2 WORDS
SUBOPT_0xA:
	CBI  0x12,5
	RJMP SUBOPT_0x6

;OPTIMIZER ADDED SUBROUTINE, CALLED 13 TIMES, CODE SIZE REDUCTION:10 WORDS
SUBOPT_0xB:
	ANDI R30,LOW(0x3)
	CPI  R30,LOW(0x1)
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 5 TIMES, CODE SIZE REDUCTION:2 WORDS
SUBOPT_0xC:
	LDI  R30,LOW(4)
	MOV  R4,R30
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES, CODE SIZE REDUCTION:2 WORDS
SUBOPT_0xD:
	LDI  R26,LOW(_temp_timer)
	LDI  R27,HIGH(_temp_timer)
	RCALL __EEPROMRDB
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 4 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0xE:
	SET
	BLD  R2,0
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 5 TIMES, CODE SIZE REDUCTION:2 WORDS
SUBOPT_0xF:
	LDI  R26,LOW(_outset)
	LDI  R27,HIGH(_outset)
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 4 TIMES, CODE SIZE REDUCTION:4 WORDS
SUBOPT_0x10:
	RCALL __EEPROMRDB
	RCALL SUBOPT_0x1
	RCALL __ASRW2
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 4 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0x11:
	__POINTW2MN _outset,1
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 5 TIMES, CODE SIZE REDUCTION:2 WORDS
SUBOPT_0x12:
	__POINTW2MN _outset,4
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 6 TIMES, CODE SIZE REDUCTION:3 WORDS
SUBOPT_0x13:
	RCALL __EEPROMRDB
	RJMP SUBOPT_0xB

;OPTIMIZER ADDED SUBROUTINE, CALLED 5 TIMES, CODE SIZE REDUCTION:2 WORDS
SUBOPT_0x14:
	__POINTW2MN _outset,5
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 5 TIMES, CODE SIZE REDUCTION:2 WORDS
SUBOPT_0x15:
	__GETWRN 16,17,0
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0x16:
	ROR  R30
	LDI  R30,0
	ROR  R30
	MOV  R0,R30
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0x17:
	LDI  R26,LOW(_buffer)
	LDI  R27,HIGH(_buffer)
	ADD  R26,R16
	ADC  R27,R17
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES, CODE SIZE REDUCTION:2 WORDS
SUBOPT_0x18:
	LDI  R27,0
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 8 TIMES, CODE SIZE REDUCTION:5 WORDS
SUBOPT_0x19:
	RCALL __EEPROMRDB
	ANDI R30,LOW(0x3)
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0x1A:
	LDI  R30,0
	SBIS 0x13,4
	LDI  R30,1
	CPI  R30,0
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0x1B:
	LDI  R30,0
	SBIS 0x13,5
	LDI  R30,1
	CPI  R30,0
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 5 TIMES, CODE SIZE REDUCTION:2 WORDS
SUBOPT_0x1C:
	__GETB2MN _rx_buffer,2
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 4 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0x1D:
	LDD  R26,Y+1
	LDD  R27,Y+1+1
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 4 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0x1E:
	RCALL _ds18b20_select
	CPI  R30,0
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES, CODE SIZE REDUCTION:4 WORDS
SUBOPT_0x1F:
	__GETD1N 0x43480000
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:2 WORDS
SUBOPT_0x20:
	RCALL SUBOPT_0x1
	LSL  R30
	ROL  R31
	ADD  R30,R26
	ADC  R31,R27
	RET


	.CSEG
_delay_ms:
	adiw r26,0
	breq __delay_ms1
__delay_ms0:
	__DELAY_USW 0x7D0
	wdr
	sbiw r26,1
	brne __delay_ms0
__delay_ms1:
	ret

	.equ __w1_port=0x12
	.equ __w1_bit=0x04

_w1_init:
	clr  r30
	cbi  __w1_port,__w1_bit
	sbi  __w1_port-1,__w1_bit
	__DELAY_USW 0x3C0
	cbi  __w1_port-1,__w1_bit
	__DELAY_USB 0x25
	sbis __w1_port-2,__w1_bit
	ret
	__DELAY_USB 0xCB
	sbis __w1_port-2,__w1_bit
	ldi  r30,1
	__DELAY_USW 0x30C
	ret

__w1_read_bit:
	sbi  __w1_port-1,__w1_bit
	__DELAY_USB 0x5
	cbi  __w1_port-1,__w1_bit
	__DELAY_USB 0x1D
	clc
	sbic __w1_port-2,__w1_bit
	sec
	ror  r30
	__DELAY_USB 0xD5
	ret

__w1_write_bit:
	clt
	sbi  __w1_port-1,__w1_bit
	__DELAY_USB 0x5
	sbrc r23,0
	cbi  __w1_port-1,__w1_bit
	__DELAY_USB 0x23
	sbic __w1_port-2,__w1_bit
	rjmp __w1_write_bit0
	sbrs r23,0
	rjmp __w1_write_bit1
	ret
__w1_write_bit0:
	sbrs r23,0
	ret
__w1_write_bit1:
	__DELAY_USB 0xC8
	cbi  __w1_port-1,__w1_bit
	__DELAY_USB 0xD
	set
	ret

_w1_read:
	ldi  r22,8
	__w1_read0:
	rcall __w1_read_bit
	dec  r22
	brne __w1_read0
	ret

_w1_write:
	mov  r23,r26
	ldi  r22,8
	clr  r30
__w1_write0:
	rcall __w1_write_bit
	brtc __w1_write1
	ror  r23
	dec  r22
	brne __w1_write0
	inc  r30
__w1_write1:
	ret

_w1_dow_crc8:
	clr  r30
	tst  r26
	breq __w1_dow_crc83
	mov  r24,r26
	ldi  r22,0x18
	ld   r26,y
	ldd  r27,y+1
__w1_dow_crc80:
	ldi  r25,8
	ld   r31,x+
__w1_dow_crc81:
	mov  r23,r31
	eor  r23,r30
	ror  r23
	brcc __w1_dow_crc82
	eor  r30,r22
__w1_dow_crc82:
	ror  r30
	lsr  r31
	dec  r25
	brne __w1_dow_crc81
	dec  r24
	brne __w1_dow_crc80
__w1_dow_crc83:
	adiw r28,2
	ret

__ROUND_REPACK:
	TST  R21
	BRPL __REPACK
	CPI  R21,0x80
	BRNE __ROUND_REPACK0
	SBRS R30,0
	RJMP __REPACK
__ROUND_REPACK0:
	ADIW R30,1
	ADC  R22,R25
	ADC  R23,R25
	BRVS __REPACK1

__REPACK:
	LDI  R21,0x80
	EOR  R21,R23
	BRNE __REPACK0
	PUSH R21
	RJMP __ZERORES
__REPACK0:
	CPI  R21,0xFF
	BREQ __REPACK1
	LSL  R22
	LSL  R0
	ROR  R21
	ROR  R22
	MOV  R23,R21
	RET
__REPACK1:
	PUSH R21
	TST  R0
	BRMI __REPACK2
	RJMP __MAXRES
__REPACK2:
	RJMP __MINRES

__UNPACK:
	LDI  R21,0x80
	MOV  R1,R25
	AND  R1,R21
	LSL  R24
	ROL  R25
	EOR  R25,R21
	LSL  R21
	ROR  R24

__UNPACK1:
	LDI  R21,0x80
	MOV  R0,R23
	AND  R0,R21
	LSL  R22
	ROL  R23
	EOR  R23,R21
	LSL  R21
	ROR  R22
	RET

__CFD1U:
	SET
	RJMP __CFD1U0
__CFD1:
	CLT
__CFD1U0:
	PUSH R21
	RCALL __UNPACK1
	CPI  R23,0x80
	BRLO __CFD10
	CPI  R23,0xFF
	BRCC __CFD10
	RJMP __ZERORES
__CFD10:
	LDI  R21,22
	SUB  R21,R23
	BRPL __CFD11
	NEG  R21
	CPI  R21,8
	BRTC __CFD19
	CPI  R21,9
__CFD19:
	BRLO __CFD17
	SER  R30
	SER  R31
	SER  R22
	LDI  R23,0x7F
	BLD  R23,7
	RJMP __CFD15
__CFD17:
	CLR  R23
	TST  R21
	BREQ __CFD15
__CFD18:
	LSL  R30
	ROL  R31
	ROL  R22
	ROL  R23
	DEC  R21
	BRNE __CFD18
	RJMP __CFD15
__CFD11:
	CLR  R23
__CFD12:
	CPI  R21,8
	BRLO __CFD13
	MOV  R30,R31
	MOV  R31,R22
	MOV  R22,R23
	SUBI R21,8
	RJMP __CFD12
__CFD13:
	TST  R21
	BREQ __CFD15
__CFD14:
	LSR  R23
	ROR  R22
	ROR  R31
	ROR  R30
	DEC  R21
	BRNE __CFD14
__CFD15:
	TST  R0
	BRPL __CFD16
	RCALL __ANEGD1
__CFD16:
	POP  R21
	RET

__CDF1U:
	SET
	RJMP __CDF1U0
__CDF1:
	CLT
__CDF1U0:
	SBIW R30,0
	SBCI R22,0
	SBCI R23,0
	BREQ __CDF10
	CLR  R0
	BRTS __CDF11
	TST  R23
	BRPL __CDF11
	COM  R0
	RCALL __ANEGD1
__CDF11:
	MOV  R1,R23
	LDI  R23,30
	TST  R1
__CDF12:
	BRMI __CDF13
	DEC  R23
	LSL  R30
	ROL  R31
	ROL  R22
	ROL  R1
	RJMP __CDF12
__CDF13:
	MOV  R30,R31
	MOV  R31,R22
	MOV  R22,R1
	PUSH R21
	RCALL __REPACK
	POP  R21
__CDF10:
	RET

__ZERORES:
	CLR  R30
	CLR  R31
	CLR  R22
	CLR  R23
	POP  R21
	RET

__MINRES:
	SER  R30
	SER  R31
	LDI  R22,0x7F
	SER  R23
	POP  R21
	RET

__MAXRES:
	SER  R30
	SER  R31
	LDI  R22,0x7F
	LDI  R23,0x7F
	POP  R21
	RET

__MULF12:
	PUSH R21
	RCALL __UNPACK
	CPI  R23,0x80
	BREQ __ZERORES
	CPI  R25,0x80
	BREQ __ZERORES
	EOR  R0,R1
	SEC
	ADC  R23,R25
	BRVC __MULF124
	BRLT __ZERORES
__MULF125:
	TST  R0
	BRMI __MINRES
	RJMP __MAXRES
__MULF124:
	PUSH R0
	PUSH R17
	PUSH R18
	PUSH R19
	PUSH R20
	CLR  R17
	CLR  R18
	CLR  R25
	MUL  R22,R24
	MOVW R20,R0
	MUL  R24,R31
	MOV  R19,R0
	ADD  R20,R1
	ADC  R21,R25
	MUL  R22,R27
	ADD  R19,R0
	ADC  R20,R1
	ADC  R21,R25
	MUL  R24,R30
	RCALL __MULF126
	MUL  R27,R31
	RCALL __MULF126
	MUL  R22,R26
	RCALL __MULF126
	MUL  R27,R30
	RCALL __MULF127
	MUL  R26,R31
	RCALL __MULF127
	MUL  R26,R30
	ADD  R17,R1
	ADC  R18,R25
	ADC  R19,R25
	ADC  R20,R25
	ADC  R21,R25
	MOV  R30,R19
	MOV  R31,R20
	MOV  R22,R21
	MOV  R21,R18
	POP  R20
	POP  R19
	POP  R18
	POP  R17
	POP  R0
	TST  R22
	BRMI __MULF122
	LSL  R21
	ROL  R30
	ROL  R31
	ROL  R22
	RJMP __MULF123
__MULF122:
	INC  R23
	BRVS __MULF125
__MULF123:
	RCALL __ROUND_REPACK
	POP  R21
	RET

__MULF127:
	ADD  R17,R0
	ADC  R18,R1
	ADC  R19,R25
	RJMP __MULF128
__MULF126:
	ADD  R18,R0
	ADC  R19,R1
__MULF128:
	ADC  R20,R25
	ADC  R21,R25
	RET

__DIVF21:
	PUSH R21
	RCALL __UNPACK
	CPI  R23,0x80
	BRNE __DIVF210
	TST  R1
__DIVF211:
	BRPL __DIVF219
	RJMP __MINRES
__DIVF219:
	RJMP __MAXRES
__DIVF210:
	CPI  R25,0x80
	BRNE __DIVF218
__DIVF217:
	RJMP __ZERORES
__DIVF218:
	EOR  R0,R1
	SEC
	SBC  R25,R23
	BRVC __DIVF216
	BRLT __DIVF217
	TST  R0
	RJMP __DIVF211
__DIVF216:
	MOV  R23,R25
	PUSH R17
	PUSH R18
	PUSH R19
	PUSH R20
	CLR  R1
	CLR  R17
	CLR  R18
	CLR  R19
	CLR  R20
	CLR  R21
	LDI  R25,32
__DIVF212:
	CP   R26,R30
	CPC  R27,R31
	CPC  R24,R22
	CPC  R20,R17
	BRLO __DIVF213
	SUB  R26,R30
	SBC  R27,R31
	SBC  R24,R22
	SBC  R20,R17
	SEC
	RJMP __DIVF214
__DIVF213:
	CLC
__DIVF214:
	ROL  R21
	ROL  R18
	ROL  R19
	ROL  R1
	ROL  R26
	ROL  R27
	ROL  R24
	ROL  R20
	DEC  R25
	BRNE __DIVF212
	MOVW R30,R18
	MOV  R22,R1
	POP  R20
	POP  R19
	POP  R18
	POP  R17
	TST  R22
	BRMI __DIVF215
	LSL  R21
	ROL  R30
	ROL  R31
	ROL  R22
	DEC  R23
	BRVS __DIVF217
__DIVF215:
	RCALL __ROUND_REPACK
	POP  R21
	RET

__ANEGW1:
	NEG  R31
	NEG  R30
	SBCI R31,0
	RET

__ANEGD1:
	COM  R31
	COM  R22
	COM  R23
	NEG  R30
	SBCI R31,-1
	SBCI R22,-1
	SBCI R23,-1
	RET

__ASRW2:
	ASR  R31
	ROR  R30
	ASR  R31
	ROR  R30
	RET

__CWD1:
	MOV  R22,R31
	ADD  R22,R22
	SBC  R22,R22
	MOV  R23,R22
	RET

__LNEGB1:
	TST  R30
	LDI  R30,1
	BREQ __LNEGB1F
	CLR  R30
__LNEGB1F:
	RET

__MULW12U:
	MUL  R31,R26
	MOV  R31,R0
	MUL  R30,R27
	ADD  R31,R0
	MUL  R30,R26
	MOV  R30,R0
	ADD  R31,R1
	RET

__MULW12:
	RCALL __CHKSIGNW
	RCALL __MULW12U
	BRTC __MULW121
	RCALL __ANEGW1
__MULW121:
	RET

__CHKSIGNW:
	CLT
	SBRS R31,7
	RJMP __CHKSW1
	RCALL __ANEGW1
	SET
__CHKSW1:
	SBRS R27,7
	RJMP __CHKSW2
	COM  R26
	COM  R27
	ADIW R26,1
	BLD  R0,0
	INC  R0
	BST  R0,0
__CHKSW2:
	RET

__GETW1PF:
	LPM  R0,Z+
	LPM  R31,Z
	MOV  R30,R0
	RET

__GETW2PF:
	LPM  R26,Z+
	LPM  R27,Z
	RET

__EEPROMRDW:
	ADIW R26,1
	RCALL __EEPROMRDB
	MOV  R31,R30
	SBIW R26,1

__EEPROMRDB:
	SBIC EECR,EEWE
	RJMP __EEPROMRDB
	PUSH R31
	IN   R31,SREG
	CLI
	OUT  EEARL,R26
	OUT  EEARH,R27
	SBI  EECR,EERE
	IN   R30,EEDR
	OUT  SREG,R31
	POP  R31
	RET

__EEPROMWRW:
	RCALL __EEPROMWRB
	ADIW R26,1
	PUSH R30
	MOV  R30,R31
	RCALL __EEPROMWRB
	POP  R30
	SBIW R26,1
	RET

__EEPROMWRB:
	SBIS EECR,EEWE
	RJMP __EEPROMWRB1
	WDR
	RJMP __EEPROMWRB
__EEPROMWRB1:
	IN   R25,SREG
	CLI
	OUT  EEARL,R26
	OUT  EEARH,R27
	SBI  EECR,EERE
	IN   R24,EEDR
	CP   R30,R24
	BREQ __EEPROMWRB0
	OUT  EEDR,R30
	SBI  EECR,EEMWE
	SBI  EECR,EEWE
__EEPROMWRB0:
	OUT  SREG,R25
	RET

__SAVELOCR4:
	ST   -Y,R19
__SAVELOCR3:
	ST   -Y,R18
__SAVELOCR2:
	ST   -Y,R17
	ST   -Y,R16
	RET

__LOADLOCR4:
	LDD  R19,Y+3
__LOADLOCR3:
	LDD  R18,Y+2
__LOADLOCR2:
	LDD  R17,Y+1
	LD   R16,Y
	RET

__LOADLOCR2P:
	LD   R16,Y+
	LD   R17,Y+
	RET

;END OF CODE MARKER
__END_OF_CODE:
