/*
 Автоматическое включение камеры по сигналу с фонаря ЗХ
 Управление AzFM
 */

#define AVCLAN_VERSION "24032016_1030"

        
#include <EEPROM.h>
#include <AVCLanDrv.h>
#include <AVCLanDVDch.h>
#include <BuffSerial.h>
#include <config.h>

byte readSeq = 0;
byte s_len   = 0;
byte s_dig   = 0;
byte s_c[2];
byte data_tmp[32];
byte i;


AvcOutMessage CmdPlayOk1_0       PROGMEM =  {AVC_MSG_BROADCAST,  0x06, {0x45, 0x12, 0x50, 0x13, 0x04, 0x01}}; // Play begin message 1
AvcOutMessage CmdStopOk2_0       PROGMEM =  {AVC_MSG_BROADCAST,  0x0B, {0x45, 0x12, 0x51, 0x13, 0x04, 0x00}}; // Stop ok message 2
AvcOutMessage CmdInit_01         PROGMEM =  {AVC_MSG_BROADCAST,  0x05, {0x01, 0x11, 0x13, 0x24, 0x45}};
AvcOutMessage CmdAM_01           PROGMEM =  {AVC_MSG_BROADCAST,  0x05, {0x00, 0x25, 0x32, 0x80, 0x06}}; // Нужно подкорректировать под кнопку и возможно директ?

// адреса eeprom
#define E_MASTER1	0  // адрес головы, старший байт
#define E_MASTER2	1  // адрес головы, младший байт
#define E_READONLY      2  // режим "только чтение", если 1, то устройств не регистрируем, только слушаем шину
#define E_INIT		3  // признак инициализации EEPROM

#define LED_ON	sbi(LED_PORT, LED_OUT);
#define LED_OFF	cbi(LED_PORT, LED_OUT);



void setup(){
	// setup led
	sbi(LED_DDR,  LED_OUT);
	cbi(LED_PORT, LED_OUT);
        
       
        
        
        pinMode(12, INPUT); // конфигурим D12 порт на ввод для лампы заднего хода
        digitalWrite (12, HIGH); //подтягиваем порт к земле 
        pinMode(11, OUTPUT); // конфигурим D11 порт на вывод - управление реле
        digitalWrite (11, LOW); // выключаем реле
        
	bSerial.begin(115200); // конфигурим последовательный порт на 115200
	avclan.begin();
	avclanDevice.begin();
	EERPOM_read_config();
	bSerial.println();
        bSerial.print_p(PSTR("AVCLan Harrier 1998 "));
	bSerial.println();
}

void loop(){

	if (INPUT_IS_SET){
		LED_ON;
		byte res = avclan.readMessage();

// проверка на задний ход
if (digitalRead(12)&& !digitalRead(11)){
bSerial.println("L:OFF Cam:OFF");
};

if (!digitalRead(12) && !digitalRead(11)){
bSerial.println("L:ON Cam:OFF");
avclan.sendMessage(&CmdInit_01); //включаем монитор для камеры заднего вида
avclan.sendMessage(&CmdPlayOk1_0);
digitalWrite(11, HIGH);
};

if (!digitalRead(12) && digitalRead(11)){ //для контроля
bSerial.println("L:ON Cam:ON");
};

if (digitalRead(12) && digitalRead(11)){
bSerial.println("L:OFF Cam:ON");
avclan.sendMessage(&CmdStopOk2_0); //выключаем монитор
digitalWrite(11, LOW);
};

if (digitalRead(12) && !digitalRead(11)){ //для контроля
bSerial.println("L:ON Cam:ON");

};

		LED_OFF;
		if (!res){
			if (!avclan.readonly) avclanDevice.getActionID();
			if (avclan.actionID != ACT_NONE) {
				avclanDevice.processAction((AvcActionID)avclan.actionID);
			}
		}
	}

	if (avclan.event != EV_NONE){
		avclanDevice.processEvent((AvcEventID)avclan.event);
		avclan.event = EV_NONE;
	}



	if (bSerial.rxEnabled()) {
		uint8_t readkey = bSerial.rxRead();

		switch (readkey){
		case 'P':                                  // print config
			bSerial.println();
                        bSerial.print_p(PSTR("head="));
			bSerial.printHex8(avclan.headAddress >> 8);
			bSerial.printHex8(avclan.headAddress);
			bSerial.print_p(PSTR(", eeprom="));
			bSerial.printHex8(EEPROM.read(E_MASTER1));
			bSerial.printHex8(EEPROM.read(E_MASTER2));
			bSerial.println();
			bSerial.print_p(PSTR("device="));
			bSerial.printHex8(avclan.deviceAddress >> 8);
			bSerial.printHex8(avclan.deviceAddress);
			bSerial.println();
			bSerial.print_p(PSTR("readonly="));
			bSerial.printHex8(avclan.readonly);
			bSerial.println();
			bSerial.print_p(PSTR("TX Overflow: "));
			bSerial.printHex8(bSerial.txOverflow >> 8);
			bSerial.printHex8(bSerial.txOverflow);
			bSerial.println();
			break;
		case 'T':  //send test message
			bSerial.println();
                        bSerial.println("Test_message  ");
			sendMessBROADCAST();
                        bSerial.println();
			break;		
                case 'L':  //send test message
			bSerial.println();
                        bSerial.println("Test_message  ");
			sendMessDIRECT();
                        bSerial.println();
			break;
                case 'D':  //Manual DVD on
			bSerial.println();
                        bSerial.println("DVD On");
                        avclan.sendMessage(&CmdPlayOk1_0);
			bSerial.println();
                        break;                   
		case 'O':  //Manual DVD off
			bSerial.println();
                        bSerial.println("DVD Off");
                        avclan.sendMessage(&CmdStopOk2_0);
                        bSerial.println();
			break;                
		case 'I':  //Manual init of DVD changer
			bSerial.println();
                        bSerial.println("Init");
                        avclan.sendMessage(&CmdInit_01);
                        bSerial.println();			
                        break;                
		case 'A':  //Test AM on/off
			bSerial.println();
                        bSerial.println("AM press");
                        avclan.sendMessage(&CmdAM_01);
                        bSerial.println();			
                        break;           
                case 'o':  //D11 on
			bSerial.println();
                        bSerial.println("Output_D11");
                        digitalWrite(11,HIGH);
                        bSerial.printHex8(digitalRead(11));
                        bSerial.println();
                        break;   
		case 'v':  //D11 off
			bSerial.println();
                        bSerial.println("Output_D11");
                        digitalWrite(11,LOW);
                        bSerial.printHex8(digitalRead(11));
                        bSerial.println();
                        break;   
		case 'M':  //readonly mode on/off
			avclan.readonly ^= (1 << 0);
			EEPROM.write(E_READONLY, avclan.readonly);
			break;
		case 'h':  // set hi level 
			bSerial.println("H set");
			AVC_OUT_EN;
			OUTPUT_SET_1;
			break;
		case 'l':  // set low level
			bSerial.println("L set");
			AVC_OUT_EN;
			OUTPUT_SET_0;
			break;
		case 'i': // output disable. Input mode on
			bSerial.println("Out dis");
			AVC_OUT_DIS;
			break;
		case 'V':                      // version
			bSerial.print_p  (PSTR("AVCLan Harrier 1998 v"));
			bSerial.println_p(PSTR(AVCLAN_VERSION));
			bSerial.print_p  (PSTR(" Driver type: "));
			bSerial.println_p(PSTR(AVCLANDRIVER_TYPE));
			bSerial.print_p  (PSTR(" BuffServial v"));
			bSerial.println_p(PSTR(BUFFSERIAL_VERSION));
			bSerial.print_p  (PSTR(" AVCLanDrv v"));
			bSerial.println_p(PSTR(AVCLANDRV_VERSION));
			bSerial.print_p  (PSTR(AVCLANDEVICE_NAME));
			bSerial.print_p  (PSTR(". v"));
			bSerial.println_p(PSTR(AVCLANDEVICE_VERSION));
			break;		
		case 'S':	                   // start command
			readSeq = 1;       
			s_len=0;
			s_dig=0;
			s_c[0] = s_c[1] = 0;
			break;
		case 'W':                      // end of direct command
			readSeq=0;                     
			avclan.dataSize      = s_len;
			avclan.broadcast     = AVC_MSG_DIRECT;
			avclan.masterAddress = avclan.deviceAddress;
			avclan.slaveAddress  = avclan.headAddress;
			for (i=0; i<s_len; i++)
				avclan.message[i]=data_tmp[i];
			avclan.sendMessage();
			break;
		case 'Q' :                     // end of broadcast command
			readSeq=0;                     
			avclan.dataSize      = s_len;
			avclan.broadcast     = AVC_MSG_BROADCAST;
			avclan.masterAddress = avclan.deviceAddress;
			avclan.slaveAddress  = 0x01FF;
			for (i=0; i<s_len; i++)
				avclan.message[i]=data_tmp[i];
			avclan.sendMessage();
			break;
		case 'H' :                     // end of set Head Unid ID 
			readSeq=0;
			avclan.headAddress = (data_tmp[0] << 8) + data_tmp[1];
			EEPROM.write(E_MASTER1, data_tmp[0]);
			EEPROM.write(E_MASTER2, data_tmp[1]);
			break;
                 case '?':
			bSerial.println_p(PSTR("P - print config\r\nV - version\r\nS - start command\r\nW - end direct command\r\nQ - end broadcast command\r\n? - help info\r\n"));
			delay(500); 
                        bSerial.println_p(PSTR("H - end of set HU Address, S0000H - auto\r\nT - send test message\r\n"));
                        delay(500); 
                        bSerial.println_p(PSTR("h - Output mode. Set Hi level\r\nl - Output mode. Set Low level\r\ni - Out disable, only Input mode\r\nM - readonly mode on/off\r\n"));
                        delay(500); 
                        bSerial.println_p(PSTR("D - Manual DVD on\r\nO - Manual DVD off\r\nI - Manual init of DVD\r\no - D11 pin On\r\nv - D11 pin off"));          
                        break;
		default :
			if (readSeq==1) {
				if (readkey!=' ') {
					s_c[s_dig]=readkey;
	 				s_dig++;
	  				if (s_dig==2) {
						if (s_c[0]<':'){
							s_c[0] -= 48;
						}else{
							s_c[0] -= 55;
						}
						data_tmp[s_len] = 16 * s_c[0];
						if (s_c[1]<':'){
							s_c[1] -= 48;
						}else{
							s_c[1] -= 55;
						}
						data_tmp[s_len] += s_c[1];
						s_len++;
						s_dig=0;
						s_c[0]=s_c[1]=0;
					}
				}
			}
		}
	}
}

void sendMessBROADCAST(){
	//Заготовка для тестовой BROADCAST команды
        avclan.broadcast = AVC_MSG_BROADCAST;
        avclan.masterAddress = 0x0208;
        avclan.slaveAddress  = 0x01FF;
        avclan.dataSize      = 0x05;
	avclan.message[0]    = 0x00;
	avclan.message[1]    = 0x01;
	avclan.message[2]    = 0x12;
	avclan.message[3]    = 0x10;
	avclan.message[4]    = 0x43;
        byte res = avclan.sendMessage();
}
void sendMessDIRECT(){	
        //Заготовка для тестовой DIRECT команды
	avclan.masterAddress = 0x0208;
        avclan.slaveAddress  = 0x0190;
        avclan.broadcast = AVC_MSG_DIRECT;
        avclan.dataSize      = 0x05;
	avclan.message[0]    = 0x00;
	avclan.message[1]    = 0x01;
	avclan.message[2]    = 0x12;
	avclan.message[3]    = 0x10;
	avclan.message[4]    = 0x43;
        byte res = avclan.sendMessage();
}

// Чтение конфигурации из EEPROM
void EERPOM_read_config(){
	if (EEPROM.read(E_INIT) != 'T'){
		EEPROM.write(E_MASTER1, 0x01);
		EEPROM.write(E_MASTER2, 0x90);
		EEPROM.write(E_READONLY, 0);
		EEPROM.write(E_INIT, 'T');
	}else{
		avclan.headAddress = (EEPROM.read(E_MASTER1) << 8) + EEPROM.read(E_MASTER2);
		avclan.readonly    = EEPROM.read(E_READONLY);
	}
}


