/*
  Copyright (C) 2006 Marcin Slonicki <marcin@softservice.com.pl>.

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software Foundation,
  Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.


	This file is part of
	TOYOTA AVC-Lan CD-Changer Emulator
*/


#ifndef __AVCLANDRV_H
#define __AVCLANDRV_H
//------------------------------------------------------------------------------
#include "main.h"
#include "const.h"


#define MAXMSGLEN	32

// Head Unid ID
#define HU_ID_1	0x01
#define HU_ID_2	0x90

// CD Changer ID
#define CD_ID_1	0x02
#define CD_ID_2	0x40

#define cmNull		0
#define cmStatus1	1
#define cmStatus2	2
#define cmStatus3	3
#define cmStatus4	4

#define cmPlayReq1	5
#define cmPlayReq2	6
#define cmPlayReq3	7
#define cmStopReq	8
#define cmStopReq2	9

#define cmRegister		100
#define cmInit			101
#define cmCheck			102
#define cmPlayIt		103
#define cmBeep			110

typedef enum { stStop, stPlay } cd_modes;
cd_modes CD_Mode;


u08 broadcast;
u08 master1;
u08 master2;
u08 slave1;
u08 slave2;
u08 message_len;
u08 message[MAXMSGLEN];

u08 data_control;
u08 data_len;
u08 data[MAXMSGLEN];

u08 AVCLan_Read_Message();
void AVCLan_Send_Status();

void AVCLan_Init();
u08 AVCLan_SendData();
u08 AVCLan_SendAnswer();
u08 AVCLan_SendDataBroadcast();

u08 HexInc(u08 data);
u08 HexDec(u08 data);



u08 cd_Disc;
u08 cd_Track;
u08 cd_Time_Min;
u08 cd_Time_Sec;

//------------------------------------------------------------------------------
u08 answerReq;
//------------------------------------------------------------------------------
#endif
