/*
  Copyright (C) 2006 Marcin Slonicki <marcin@softservice.com.pl>.


  Some parts modify from original file
  written by:	Vitaliy Koutchaev <vitat@mail.spbnit.ru>
  - part of the IP-Bus emu system.


  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software Foundation,
  Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.


	This file is part of
	TOYOTA AVC-Lan CD-Changer Emulator
*/

#include "stm32f1xx_hal.h"

#include "avclandrv.h"
#include "const.h"
//------------------------------------------------------------------------------

u08 parity_bit;

u08 repeatMode;
u08 randomMode;
u08 scanMode;
u08 playMode;


// commands
const u08 stat1[]		= { 0x4,	0x00, 0x00, 0x01, 0x0A };
const u08 stat2[]		= { 0x4,	0x00, 0x00, 0x01, 0x08 };
const u08 stat3[]		= { 0x4,	0x00, 0x00, 0x01, 0x0D };
const u08 stat4[] 		= { 0x4,	0x00, 0x00, 0x01, 0x0C };
const u08 play_req1[]	= { 0x4,	0x00, 0x25, 0x63, 0x80 };
const u08 play_req2[]	= { 0x6,	0x00, 0x11, 0x63, 0x42, 0x00, 0x00 };
const u08 play_req3[]	= { 0x6,	0x00, 0x11, 0x63, 0x42, 0x41, 0x00 };
const u08 stop_req[]	= { 0x5,	0x00, 0x11, 0x63, 0x43, 0x00 };
const u08 stop_req2[]	= { 0x6,	0x00, 0x11, 0x63, 0x43, 0x00, 0x00 };

const u08 next_track[]	= { 0x4,	0x00, 0x25, 0x63, 0x94 };
const u08 prev_track[]	= { 0x4,	0x00, 0x25, 0x63, 0x95 };

const u08 next_cd[]		= { 0x4,	0x00, 0x25, 0x63, 0x90 };
const u08 prev_cd[]		= { 0x4,	0x00, 0x25, 0x63, 0x91 };

const u08 fast_forward[]= { 0x4,	0x00, 0x25, 0x63, 0x98 };
const u08 fast_back[]	= { 0x4,	0x00, 0x25, 0x63, 0x99 };

const u08 scan_on[]		= { 0x4,	0x00, 0x25, 0x63, 0xA6 };
const u08 scan_off[]	= { 0x4,	0x00, 0x25, 0x63, 0xA7 };
const u08 scan_d_on[]	= { 0x4,	0x00, 0x25, 0x63, 0xA9 };
const u08 scan_d_off[]	= { 0x4,	0x00, 0x25, 0x63, 0xAA };

const u08 repeat_on[]	= { 0x4,	0x00, 0x25, 0x63, 0xA0 };
const u08 repeat_off[]	= { 0x4,	0x00, 0x25, 0x63, 0xA1 };
const u08 repeat_d_on[]	= { 0x4,	0x00, 0x25, 0x63, 0xA3 };
const u08 repeat_d_off[]= { 0x4,	0x00, 0x25, 0x63, 0xA4 };

const u08 random_on[]	= { 0x4,	0x00, 0x25, 0x63, 0xB0 };
const u08 random_off[]	= { 0x4,	0x00, 0x25, 0x63, 0xB1 };
const u08 random_d_on[]	= { 0x4,	0x00, 0x25, 0x63, 0xB3 };
const u08 random_d_off[]= { 0x4,	0x00, 0x25, 0x63, 0xB4 };

// broadcast
const u08 lan_stat1[]	= { 0x3,	0x00, 0x01, 0x0A };
const u08 lan_reg[]			= { 0x3,	0x11, 0x01, 0x00 };
const u08 lan_init[]		= { 0x3,	0x11, 0x01, 0x01 };
const u08 lan_check[]		= { 0x4,	0x11, 0x01, 0x20, 0x00 };
const u08 lan_check_CD_CH[]	= { 0x5,	0x00, 0x11, 0x01, 0x20, 0x00 };
const u08 lan_playit[]		= { 0x5,	0x11, 0x01, 0x45, 0x63, 0x00 };

// answers
const u08	CMD_REGISTER[]	= {0x1,		0x05,	0x00, 0x01,	0x11, 0x10, 0x63 };
const u08	CMD_STATUS1[]	= {0x1,		0x04,	0x00, 0x01, 0x00, 0x1A };
const u08	CMD_STATUS2[]	= {0x1,		0x04,	0x00, 0x01, 0x00, 0x18 };
const u08	CMD_STATUS3[]	= {0x1,		0x04,	0x00, 0x01, 0x00, 0x1D };
const u08	CMD_STATUS4[]	= {0x1,		0x05,	0x00, 0x01, 0x00, 0x1C, 0x00 };
u08			CMD_CHECK[]		= {0x1,		0x06,	0x00, 0x01, 0x11, 0x30, 0x00, 0x00 };
const u08	CMD_PLAY_OK1[]	= {0x1,		0x05,	0x00, 0x63, 0x11, 0x50, 0x01 };
const u08	CMD_PLAY_OK2[]	= {0x1,		0x05,	0x00, 0x63, 0x11, 0x52, 0x01 };
const u08	CMD_PLAY_OK3[]	= {0x0,		0x0B,	0x63, 0x31, 0xF1, 0x01, 0x00, 0x01, 0xFF, 0xFF, 0xFF, 0x00, 0x80 };
u08			CMD_PLAY_OK4[]	= {0x0,		0x0B,	0x63, 0x31, 0xF1, 0x01, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80 };

const u08	CMD_STOP1[]		= {0x1,		0x05,	0x00, 0x63, 0x11, 0x53, 0x01 };
u08			CMD_STOP2[]		= {0x0,		0x0B,	0x63, 0x31, 0xF1, 0x00, 0x30, 0x00, 0x00,0x00, 0x00, 0x00, 0x80 };

const u08	CMD_BEEP[]		= {0x1,		0x05,	0x00, 0x63, 0x29, 0x60, 0x02 };

//------------------------------------------------------------------------------
void AVCLan_Init()
{
 message_len = 0;
 answerReq   = cmNull;
 cd_Disc     = 1;
 cd_Track    = 1;
 cd_Time_Min = 0;
 cd_Time_Sec = 0;
 repeatMode	 = 0;
 randomMode	 = 0;
 playMode	 = 0;
 CD_Mode	 = stStop;
}
//------------------------------------------------------------------------------
u08 AVCLan_Read_Byte(u08 length)
{
 u08 byte = 0;
 u08 wT;
 
 while (1) {
   while (INPUT_IS_CLEAR);
   TIM4->CNT = 0;
   while (INPUT_IS_SET);
   wT = TIM4->CNT;
   if (wT<8) { 
      byte++;
	  parity_bit++;
   }
   length--;
   if (!length) return byte;
   byte = byte << 1;
 } 
}
//------------------------------------------------------------------------------
u08 AVCLan_Send_StartBit()
{
 cbi(DATAOUT_PORT, DATAOUT);	// DATA_OUT pin set to output and this be = 1 on IP-Bus
 delay1(166);					// 141-192
 //cbi(UCSRB, RXCIE);				// disable RX complete interrupt
 sbi(DATAOUT_PORT, DATAOUT);	// DATA_OUT pin set to input
 delay1(30);					// 02-57

 return 1;
}
//------------------------------------------------------------------------------
void AVCLan_Send_Bit1()
{
 cbi(DATAOUT_PORT, DATAOUT);	// DATA_OUT pin set to output and this be = 1 on IP-Bus
 delay1(20);					// 17-23

 sbi(DATAOUT_PORT, DATAOUT);	// DATA_OUT pin set to input
 delay1(16);					// 12-21
}
//------------------------------------------------------------------------------
void AVCLan_Send_Bit0()
{
 cbi(DATAOUT_PORT, DATAOUT);	// DATA_OUT pin set to output and this be = 1 on IP-Bus
 delay1(32);					// 28-37

 sbi(DATAOUT_PORT, DATAOUT);	// DATA_OUT pin set to input
 delay1(4);						// 00-09
}
//------------------------------------------------------------------------------
u08 AVCLan_Read_ACK()
{
 u08 time = 0;
 cbi(DATAOUT_PORT, DATAOUT);		// DATA_OUT pin set to output and this be = 1 on IP-Bus
 delay1(19);
 sbi(DATAOUT_PORT, DATAOUT);		// DATA_OUT pin set to input
 //timer0_source(CK64);
 TIM4->CNT = 0;
 while(1) {
	time = TIM4->CNT;
	if (INPUT_IS_SET && (time > 1)) break;
	if (time > 5) return 1;
 }
	
 while(INPUT_IS_SET);
 return 0;
}
//------------------------------------------------------------------------------
u08 AVCLan_Send_ACK()
{
 //timer0_source(CK64);				//update every 1us
 TIM4->CNT = 0;
 while (INPUT_IS_CLEAR)	{
 	if (TIM4->CNT >= 25) return 0;	// max wait time
 }
 cbi(DATAOUT_PORT, DATAOUT);		// DATA_OUT pin set to output and this be = 1 on IP-Bus
 delay1(32);						//28-37
 sbi(DATAOUT_PORT, DATAOUT);		// DATA_OUT pin set to input
 delay1(4);							//00-09
 return 1;
}
u08 AVCLan_Send_Byte(u08 byte, u08 len)
{
 u08 b;
 if (len==8) {
 	b = byte;
 } else {
    b = byte << (8-len);
 }

 while (1) {
   if ( b & 128 ) {
     AVCLan_Send_Bit1();
	 parity_bit++;
   } else { 
   	 AVCLan_Send_Bit0();
   }
   len--;
   if (!len) { 
     return 1;
   }
   b = b << 1;
 } 

}
//------------------------------------------------------------------------------
u08 AVCLan_Send_ParityBit()
{
 if ( parity_bit & 1 ) {
     AVCLan_Send_Bit1();
	 parity_bit++;
 } else {
   	 AVCLan_Send_Bit0();
 }
 parity_bit=0;
 return 1;
}
//------------------------------------------------------------------------------
u08 CheckCmd(u08 *cmd)
{
 u08 i;
 u08 *c;
 u08 l;

 c = cmd;
 l = *c++;

 for (i=0; i<l; i++) {
 	if (message[i] != *c) return 0;
	c++;
 }
 return 1;
}
//------------------------------------------------------------------------------
u08 AVCLan_Read_Message()
{
 STOPEvent;					// disable timer1 interrupt

 u16 T = 0;

 u08 i;
 u08 for_me = 0;

 //timer0_source(CK64);

 // check start bit
 TIM4->CNT = 0;
 while (INPUT_IS_SET) { 
 	T = TIM4->CNT;
	if (T>400) {
		STARTEvent;
		return 0;
	}
 }
 if (T<20) {
 	STARTEvent;
	return 0;
 }

 broadcast = AVCLan_Read_Byte(1);

 parity_bit = 0;
 master1 = AVCLan_Read_Byte(4);
 master2 = AVCLan_Read_Byte(8);
 if ((parity_bit&1)!=AVCLan_Read_Byte(1)) {
	STARTEvent;
	return 0;
 }

 parity_bit = 0;
 slave1 = AVCLan_Read_Byte(4);
 slave2 = AVCLan_Read_Byte(8);
 if ((parity_bit&1)!=AVCLan_Read_Byte(1)) {
	STARTEvent;
	return 0;
 }
 // is this command for me ?
 if ((slave1==CD_ID_1)&&(slave2==CD_ID_2)) {
 	for_me=1;
 }

 if (for_me) AVCLan_Send_ACK();
 		else AVCLan_Read_Byte(1);

 parity_bit = 0;
 AVCLan_Read_Byte(4);	// control - always 0xF
 if ((parity_bit&1)!=AVCLan_Read_Byte(1)) {
	STARTEvent;
	return 0;
 }
 if (for_me) AVCLan_Send_ACK();
 		else AVCLan_Read_Byte(1);

 parity_bit = 0;
 message_len = AVCLan_Read_Byte(8);
 if ((parity_bit&1)!=AVCLan_Read_Byte(1)) {
	STARTEvent;
	return 0;
 }
 if (for_me) AVCLan_Send_ACK();
 		else AVCLan_Read_Byte(1);

 if (message_len > MAXMSGLEN) {
	STARTEvent;
	return 0;
 }

 for (i=0; i<message_len; i++) {
	parity_bit = 0;
 	message[i] = AVCLan_Read_Byte(8);
	if ((parity_bit&1)!=AVCLan_Read_Byte(1)) {
		STARTEvent;
		return 0;
 	}
	if (for_me) {
		AVCLan_Send_ACK();
 	} else {
		AVCLan_Read_Byte(1);
	}
 }


 STARTEvent;


 if (for_me) {
 	
//	if (CheckCmd((u08*)next_track))		{ RS232_Print("N_TR\n"); return 1; }
//	if (CheckCmd((u08*)prev_track))		{ RS232_Print("P_TR\n"); return 1; }
//	if (CheckCmd((u08*)next_cd))		{ RS232_Print("N_CD\n"); return 1; }
//	if (CheckCmd((u08*)prev_cd))		{ RS232_Print("P_CD\n"); return 1; }
//	if (CheckCmd((u08*)fast_forward))	{ RS232_Print("P_FF\n"); return 1; }
//	if (CheckCmd((u08*)fast_back))		{ RS232_Print("P_FB\n"); return 1; }
//	if (CheckCmd((u08*)repeat_on))		{ repeatMode = 1; RS232_Print("REP1\n"); return 1; }
//	if (CheckCmd((u08*)repeat_off))		{ repeatMode = 0; RS232_Print("REP0\n"); return 1; }
//	if (CheckCmd((u08*)repeat_d_on))	{ repeatMode = 2; RS232_Print("REP2\n"); return 1; }
//	if (CheckCmd((u08*)repeat_d_off))	{ repeatMode = 0; RS232_Print("REP0\n"); return 1; }
//	if (CheckCmd((u08*)random_on))		{ randomMode = 1; RS232_Print("RND1\n"); return 1; }
//	if (CheckCmd((u08*)random_off))		{ randomMode = 0; RS232_Print("RND0\n"); return 1; }
//	if (CheckCmd((u08*)random_d_on))	{ randomMode = 2; RS232_Print("RND2\n"); return 1; }
//	if (CheckCmd((u08*)random_d_off))	{ randomMode = 0; RS232_Print("RND0\n"); return 1; }
//	if (CheckCmd((u08*)scan_on))		{ scanMode = 1;	  RS232_Print("SCN1\n"); return 1; }
//	if (CheckCmd((u08*)scan_off))		{ scanMode = 0;   RS232_Print("SCN0\n"); return 1; }
//	if (CheckCmd((u08*)scan_d_on))		{ scanMode = 2;	  RS232_Print("SCN2\n"); return 1; }
//	if (CheckCmd((u08*)scan_d_off))		{ scanMode = 0;   RS232_Print("SCN0\n"); return 1; }

	if (CheckCmd((u08*)stat1)) { answerReq = cmStatus1; return 1; }
	if (CheckCmd((u08*)stat2)) { answerReq = cmStatus2; return 1; }
	if (CheckCmd((u08*)stat3)) { answerReq = cmStatus3; return 1; }
	if (CheckCmd((u08*)stat4)) { answerReq = cmStatus4; return 1; }

	if (CheckCmd((u08*)play_req1)) { answerReq = cmPlayReq1; return 1; }
	if (CheckCmd((u08*)play_req2)) { answerReq = cmPlayReq2; return 1; }
	if (CheckCmd((u08*)stop_req))  { answerReq = cmStopReq;  return 1; }

    } else { // broadcast check

	if (CheckCmd((u08*)lan_playit))	{ answerReq = cmPlayIt;	return 1; }
	if (CheckCmd((u08*)lan_check))	{ 
			answerReq = cmCheck;
			CMD_CHECK[6]=message[3];
			return 1; 
	}
	if (CheckCmd((u08*)lan_check_CD_CH)) {
			answerReq = cmCheck;
			CMD_CHECK[6]=message[3];
			return 1;
	}
	if (CheckCmd((u08*)lan_reg))	{ answerReq = cmRegister;	return 1; }
	if (CheckCmd((u08*)lan_init))	{ answerReq = cmInit;		return 1; }
	if (CheckCmd((u08*)lan_stat1))	{ answerReq = cmStatus1;	return 1; }

 }
 answerReq = cmNull;
 return 1;
}
//------------------------------------------------------------------------------
u08 AVCLan_SendData()
{
 u08 i;
 
 STOPEvent;

 // wait for free line
 u08 T=0;
 u08 line_busy = 1;

 //timer0_source(CK64);
 TIM4->CNT = 0;
 do {
 	while (INPUT_IS_CLEAR) {
		T = TIM4->CNT;
		if (T >= 25) break;
 	}
 	if (T > 24) line_busy=0;
 } while (line_busy);


 AVCLan_Send_StartBit();
 AVCLan_Send_Byte(0x1,  1);		// regular communication

 parity_bit = 0;
 AVCLan_Send_Byte(CD_ID_1, 4);	// CD Changer ID as master
 AVCLan_Send_Byte(CD_ID_2, 8);
 AVCLan_Send_ParityBit();

 AVCLan_Send_Byte(HU_ID_1, 4);	// HeadUnit ID as slave
 AVCLan_Send_Byte(HU_ID_2, 8);
 AVCLan_Send_ParityBit();
 if (AVCLan_Read_ACK()) {
	 STARTEvent;
	 return 1;
 }

 AVCLan_Send_Byte(0xF, 4);		// 0xf - control -> COMMAND WRITE
 AVCLan_Send_ParityBit();
 if (AVCLan_Read_ACK()) {
	 STARTEvent;
	 return 2;
 }

 AVCLan_Send_Byte(data_len,  8);// data lenght
 AVCLan_Send_ParityBit();
 if (AVCLan_Read_ACK()) {
	 STARTEvent;
	 return 3;
 }

 for (i=0;i<data_len;i++) {
	AVCLan_Send_Byte(data[i], 8);// data byte
 	AVCLan_Send_ParityBit();
 	if (AVCLan_Read_ACK()) {
		 STARTEvent;
		 return 4;
 	}
 }

 STARTEvent;
 return 0;
}
//------------------------------------------------------------------------------
u08 AVCLan_SendDataBroadcast()
{
 u08 i;
 

 STOPEvent;

 // wait for free line
 u08 T=0;
 u08 line_busy = 1;

 //timer0_source(CK64);
 TIM4->CNT = 0;
 do {
 	while (INPUT_IS_CLEAR) {
		T = TIM4->CNT;
		if (T >= 25) break;
 	}
 	if (T > 24) line_busy=0;
 } while (line_busy);


 AVCLan_Send_StartBit();
 AVCLan_Send_Byte(0x0,  1);		// broadcast

 parity_bit = 0;
 AVCLan_Send_Byte(CD_ID_1, 4);	// CD Changer ID as master
 AVCLan_Send_Byte(CD_ID_2, 8);
 AVCLan_Send_ParityBit();

 AVCLan_Send_Byte(0x1, 4);		// all audio devices
 AVCLan_Send_Byte(0xFF, 8);
 AVCLan_Send_ParityBit();
 AVCLan_Send_Bit1();

 AVCLan_Send_Byte(0xF, 4);		// 0xf - control -> COMMAND WRITE
 AVCLan_Send_ParityBit();
 AVCLan_Send_Bit1();
 
 AVCLan_Send_Byte(data_len,  8);	// data lenght
 AVCLan_Send_ParityBit();
 AVCLan_Send_Bit1();

 for (i=0;i<data_len;i++) {
	AVCLan_Send_Byte(data[i], 8); // data byte
 	AVCLan_Send_ParityBit();
	AVCLan_Send_Bit1();
 }

 STARTEvent;
 return 0;
}
//------------------------------------------------------------------------------
u08 AVCLan_SendAnswerFrame(u08 *cmd)
{
 u08 i;
 u08 *c;
 u08 b;

 c = cmd;
 
 b = *c++;
 data_control = 0xF;
 data_len	 = *c++;
 for (i=0; i<data_len; i++) {
 	data[i]= *c++;
 }
 if (b)
 	return AVCLan_SendData();
 else 
 	return AVCLan_SendDataBroadcast();
}
//------------------------------------------------------------------------------
u08 AVCLan_SendInitCommands()
{
 u08 r;
 const u08 c1[] = { 0x0, 0x0B,		0x63, 0x31, 0xF1, 0x00, 0x80, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x80 };
 const u08 c2[] = { 0x0, 0x0A,		0x63, 0x31, 0xF3, 0x00, 0x3F, 0x00, 0x00, 0x00, 0x00, 0x02 };
 const u08 c3[] = { 0x0, 0x0A,		0x63, 0x31, 0xF3, 0x00, 0x3F, 0x00, 0x01, 0x00, 0x01, 0x02 };
 const u08 c4[] = { 0x0, 0x0A,		0x63, 0x31, 0xF3, 0x00, 0x3D, 0x00, 0x01, 0x00, 0x01, 0x02 };
 const u08 c5[] = { 0x0, 0x0A,		0x63, 0x31, 0xF3, 0x00, 0x39, 0x00, 0x01, 0x00, 0x01, 0x02 };
 const u08 c6[] = { 0x0, 0x0A,		0x63, 0x31, 0xF3, 0x00, 0x31, 0x00, 0x01, 0x00, 0x01, 0x02 };
 const u08 c7[] = { 0x0, 0x0A,		0x63, 0x31, 0xF3, 0x00, 0x21, 0x00, 0x01, 0x00, 0x01, 0x02 };
 const u08 c8[] = { 0x0, 0x0B,		0x63, 0x31, 0xF1, 0x00, 0x90, 0x01, 0xFF, 0xFF, 0xFF, 0x00, 0x80 };
 const u08 c9[] = { 0x0, 0x0A,		0x63, 0x31, 0xF3, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x02 };
 const u08 cA[] = { 0x0, 0x0B,		0x63, 0x31, 0xF1, 0x00, 0x30, 0x01, 0xFF, 0xFF, 0xFF, 0x00, 0x80 };

 r = AVCLan_SendAnswerFrame((u08*)c1);
 if (!r) r = AVCLan_SendAnswerFrame((u08*)c2);
 if (!r) r = AVCLan_SendAnswerFrame((u08*)c3);
 if (!r) r = AVCLan_SendAnswerFrame((u08*)c4);
 if (!r) r = AVCLan_SendAnswerFrame((u08*)c5);
 if (!r) r = AVCLan_SendAnswerFrame((u08*)c6);
 if (!r) r = AVCLan_SendAnswerFrame((u08*)c7);
 if (!r) r = AVCLan_SendAnswerFrame((u08*)c8);
 if (!r) r = AVCLan_SendAnswerFrame((u08*)c9);
 if (!r) r = AVCLan_SendAnswerFrame((u08*)cA);
 return r;
}
//------------------------------------------------------------------------------
void AVCLan_Send_Status()
{
//                                                        disc  track t_min t_sec
 u08 STATUS[] = {0x0, 0x0B, 0x63, 0x31, 0xF1, 0x01, 0x10, 0x01, 0x01, 0x00, 0x00, 0x00, 0x80 };

 STATUS[7] = cd_Disc;
 STATUS[8] = cd_Track;
 STATUS[9] = cd_Time_Min;
 STATUS[10] = cd_Time_Sec;

 STATUS[11] = 0;

 switch (repeatMode) {
	case 1:	STATUS[11] |= 0x10; break;
	case 2:	STATUS[11] |= 0x08; break;
 }
 switch (randomMode) {
 	case 1:	STATUS[11] |= 0x04; break;
	case 2:	STATUS[11] |= 0x02; break;
 }
 switch (scanMode) {
 	case 1:	STATUS[11] |= 0x40; break;
	case 2:	STATUS[11] |= 0x20; break;
 }

 switch (playMode) {
	case 0: STATUS[6] = 0x03; break;
	case 1:	STATUS[6] = 0x10; break;
 }

 AVCLan_SendAnswerFrame((u08*)STATUS);
}
//------------------------------------------------------------------------------

//------------------------------------------------------------------------------
u08 AVCLan_SendAnswer()
{
 u08 r = 0 ;
 
 switch (answerReq) {
 	case cmStatus1:		r = AVCLan_SendAnswerFrame((u08*)CMD_STATUS1); 
						break;
 	case cmStatus2:		r = AVCLan_SendAnswerFrame((u08*)CMD_STATUS2); 
						break;
 	case cmStatus3:		r = AVCLan_SendAnswerFrame((u08*)CMD_STATUS3); 
						break;
 	case cmStatus4:		r = AVCLan_SendAnswerFrame((u08*)CMD_STATUS4); 
						break;
 	case cmRegister:	r = AVCLan_SendAnswerFrame((u08*)CMD_REGISTER); 
						break;
 	case cmInit:		r = AVCLan_SendInitCommands(); 
						break;
 	case cmCheck:		r = AVCLan_SendAnswerFrame((u08*)CMD_CHECK); 
						break;
 	case cmPlayReq1:	playMode = 0;
						r = AVCLan_SendAnswerFrame((u08*)CMD_PLAY_OK1); 
						break;
 	case cmPlayReq2:
 	case cmPlayReq3:	playMode = 0;
						r = AVCLan_SendAnswerFrame((u08*)CMD_PLAY_OK2); 
						if (!r) r = AVCLan_SendAnswerFrame((u08*)CMD_PLAY_OK3);
						CD_Mode = stPlay;
						break;
	case cmPlayIt:		playMode = 1;
						CMD_PLAY_OK4[7]=cd_Disc;
						CMD_PLAY_OK4[8]=cd_Track;
						CMD_PLAY_OK4[9]=cd_Time_Min;
						CMD_PLAY_OK4[10]=cd_Time_Sec;
						r = AVCLan_SendAnswerFrame((u08*)CMD_PLAY_OK4); 
						if (!r) AVCLan_Send_Status();
						CD_Mode = stPlay;
						break;
	case cmStopReq:		
	case cmStopReq2:	CD_Mode = stStop;
						playMode = 0;
						cd_Time_Min = 0;
						cd_Time_Sec = 0;
						r = AVCLan_SendAnswerFrame((u08*)CMD_STOP1); 
						CMD_STOP2[7]=cd_Disc;
						CMD_STOP2[8]=cd_Track;
						CMD_STOP2[9]=cd_Time_Min;
						CMD_STOP2[10]=cd_Time_Sec;
						r = AVCLan_SendAnswerFrame((u08*)CMD_STOP2); 
						break;
	case cmBeep:		AVCLan_SendAnswerFrame((u08*)CMD_BEEP);
						break;
 }

 answerReq = cmNull;
 return r;
}
//------------------------------------------------------------------------------
u08 HexInc(u08 data)
{
 if ((data & 0x9)==0x9) 
 	return (data + 7);
 
 return (data+1);
}
//------------------------------------------------------------------------------
u08 HexDec(u08 data)
{
 if ((data & 0xF)==0) 
 	return (data - 7);
 
 return (data-1);
}
//------------------------------------------------------------------------------
