/*
  Copyright (C) 2006 Marcin Slonicki <marcin@softservice.com.pl>.

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software Foundation,
  Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.


	This file is part of
	TOYOTA AVC-Lan CD-Changer Emulator
*/

#include "io_board.h"

#ifndef __CONTS_H
#define __CONST_H
//------------------------------------------------------------------------------

//------------------------------------------------------------------------------
#define u08	unsigned char
#define u16 unsigned short
#define u32 unsigned int
//------------------------------------------------------------------------------
#define DATAOUT_PORT	AVCLAN_TX_PORT
#define DATAOUT			AVCLAN_TX_PIN

#define DATAIN_PORT		AVCLAN_RX_PORT
#define DATAIN			AVCLAN_RX_PIN

#define INPUT_IS_SET            HAL_GPIO_ReadPin(AVCLAN_RX_PORT, AVCLAN_RX_PIN) == 1
#define INPUT_IS_CLEAR			HAL_GPIO_ReadPin(AVCLAN_RX_PORT, AVCLAN_RX_PIN) == 0

// status event every 1 sec 
#define TI1_H	(((u16)-(F_CPU / 1024)) >> 8)
#define TI1_L	(((u16)-(F_CPU / 1024)) & 0xff )


#define STOPEvent  HAL_NVIC_DisableIRQ(TIM3_IRQn)
#define STARTEvent HAL_NVIC_EnableIRQ(TIM3_IRQn)

#define cbi(DATAOUT_PORT, DATAOUT)	HAL_GPIO_WritePin(DATAOUT_PORT, DATAOUT, GPIO_PIN_RESET)
#define sbi(DATAOUT_PORT, DATAOUT)	HAL_GPIO_WritePin(DATAOUT_PORT, DATAOUT, GPIO_PIN_SET)

u08 Event;

#define EV_NOTHING	0
#define EV_DISPLAY	1
#define EV_STATUS	4

//------------------------------------------------------------------------------
#endif
