/*
 * main.c
 *
 *  Created on: 12 . 2021 .
 *      Author: ZavyalovRA
 */

#include "main.h"

int main(void)
{
  uint8_t j = 5;     // registration attempt count
  HAL_Init();
  SystemClock_Config();
  GPIO_Config();
  TIM3_Config();
  TIM4_Config();

  delay1(255);
  delay1(255);
  delay1(255);
  delay1(255);
  delay1(255);

  Event = EV_NOTHING;
  AVCLan_Init();

  //     
  while (j > 0){
		answerReq = cmRegister;
		if (AVCLan_SendAnswer() == 0){
			j = 0;
		} else {
			j--;
			delay1(250);
		}
  }

  while (1) {

		if (INPUT_IS_SET) {	 // if message from some device on AVCLan begin
		  HAL_GPIO_WritePin(LED1_PORT, LED1_PIN, GPIO_PIN_SET);					//  LED1
	  	  AVCLan_Read_Message();
	  	  HAL_GPIO_WritePin(LED1_PORT, LED1_PIN, GPIO_PIN_RESET);				//  LED1
		} else {

			// check command from HU
			if (answerReq != 0)
				AVCLan_SendAnswer();

	    }


		// HandleEvent
		switch (Event) {
		  case EV_STATUS:	Event &= ~EV_STATUS;
							AVCLan_Send_Status();
							break;
		}

  }
}

void delay1(uint8_t us)
{
	TIM4->CNT= 0; while(TIM4->CNT < us) {}
}

void TIM3_IRQHandler(void)
{
	if (CD_Mode==stPlay) {
		cd_Time_Sec=HexInc(cd_Time_Sec);
		if (cd_Time_Sec==0x60) {
			cd_Time_Sec = 0;
			cd_Time_Min=HexInc(cd_Time_Min);
			if (cd_Time_Min==0xA0) {
				cd_Time_Min=0x0;
			}
		}
		Event |= EV_STATUS;
	}

	HAL_TIM_IRQHandler(&htim3);
}

void TIM4_IRQHandler(void)
{
	HAL_TIM_IRQHandler(&htim4);
}

void HAL_TIM_PeriodElapsedCallback(TIM_HandleTypeDef *htim)
{
  if (htim->Instance == TIM1) {
    HAL_IncTick();
  }
}

void Error_Handler(void)
{

}

#ifdef  USE_FULL_ASSERT

void assert_failed(uint8_t *file, uint32_t line)
{ 

}
#endif
