#include "globals.h"
#include "avclan.h"
#include "buttons.h"

/*
// commands
const uint8_t stat1[]       = { 0x4, 0x00, 0x00, 0x01, 0x0A };
const uint8_t stat2[]       = { 0x4, 0x00, 0x00, 0x01, 0x08 };
const uint8_t stat3[]       = { 0x4, 0x00, 0x00, 0x01, 0x0D };
const uint8_t stat4[]       = { 0x4, 0x00, 0x00, 0x01, 0x0C };
const uint8_t play_req1[]   = { 0x4, 0x00, 0x25, 0x63, 0x80 };
const uint8_t play_req2[]   = { 0x6, 0x00, 0x12, 0x63, 0x42, 0x01, 0x00 };
const uint8_t play_req3[]   = { 0x6, 0x00, 0x12, 0x63, 0x42, 0x41, 0x00 };
const uint8_t stop_req[]    = { 0x5, 0x00, 0x12, 0x63, 0x43, 0x01 };
const uint8_t stop_req2[]   = { 0x5, 0x00, 0x12, 0x63, 0x43, 0x41 };

const uint8_t next_track[]	= { 0x4, 0x00, 0x25, 0x63, 0x94 };
const uint8_t prev_track[]	= { 0x4, 0x00, 0x25, 0x63, 0x95 };

const uint8_t next_cd[]		  = { 0x4, 0x00, 0x25, 0x63, 0x90 };
const uint8_t prev_cd[]		  = { 0x4, 0x00, 0x25, 0x63, 0x91 };

const uint8_t fast_forward[]= { 0x4, 0x00, 0x25, 0x63, 0x98 };
const uint8_t fast_back[]	  = { 0x4, 0x00, 0x25, 0x63, 0x99 };

const uint8_t scan_on[]		  = { 0x4, 0x00, 0x25, 0x63, 0xA6 };
const uint8_t scan_off[]	  = { 0x4, 0x00, 0x25, 0x63, 0xA7 };
const uint8_t scan_d_on[]	  = { 0x4, 0x00, 0x25, 0x63, 0xA9 };
const uint8_t scan_d_off[]	= { 0x4, 0x00, 0x25, 0x63, 0xAA };

const uint8_t repeat_on[]	  = { 0x4, 0x00, 0x25, 0x63, 0xA0 };
const uint8_t repeat_off[]	= { 0x4, 0x00, 0x25, 0x63, 0xA1 };
const uint8_t repeat_d_on[]	= { 0x4, 0x00, 0x25, 0x63, 0xA3 };
const uint8_t repeat_d_off[]= { 0x4, 0x00, 0x25, 0x63, 0xA4 };

const uint8_t random_on[]	=   { 0x4, 0x00, 0x25, 0x63, 0xB0 };
const uint8_t random_off[]	= { 0x4, 0x00, 0x25, 0x63, 0xB1 };
const uint8_t random_d_on[]	= { 0x4, 0x00, 0x25, 0x63, 0xB3 };
const uint8_t random_d_off[]= { 0x4, 0x00, 0x25, 0x63, 0xB4 };

// broadcast
const uint8_t lan_stat1[]  = { 0x3,	0x00, 0x01, 0x0A };
const uint8_t lan_reg[]    = { 0x3,	0x12, 0x01, 0x00 };
const uint8_t lan_init[]   = { 0x3,	0x12, 0x01, 0x01 };
const uint8_t lan_check[]  = { 0x3,	0x12, 0x01, 0x20 };
const uint8_t lan_playit[] = { 0x4,	0x12, 0x01, 0x45, 0x63 };

// answers
const uint8_t	CMD_REGISTER[]  = {0x1, 0x05,	0x00, 0x01,	0x12, 0x10, 0x63};
const uint8_t	CMD_STATUS1[]	  = {0x1, 0x04,	0x00, 0x01, 0x00, 0x1A};
const uint8_t	CMD_STATUS2[]	  = {0x1, 0x04,	0x00, 0x01, 0x00, 0x18};
const uint8_t	CMD_STATUS3[]   = {0x1,	0x04,	0x00, 0x01, 0x00, 0x1D};
const uint8_t	CMD_STATUS4[]   = {0x1,	0x05,	0x00, 0x01, 0x00, 0x1C, 0x00};
uint8_t       CMD_CHECK[]	    = {0x1,	0x06,	0x00, 0x01, 0x12, 0x30, 0x00, 0x00};
const uint8_t CMD_PLAY_OK1[]	= {0x1,	0x05,	0x00, 0x63, 0x12, 0x50, 0x01};
const uint8_t	CMD_PLAY_OK2[]	= {0x1,	0x05,	0x00, 0x63, 0x12, 0x52, 0x01};
const uint8_t	CMD_PLAY_OK3[]	= {0x0,	0x0B,	0x63, 0x31, 0xF1, 0x01, 0x00, 0x01, 0xFF, 0xFF, 0xFF, 0x00, 0x80};
uint8_t	      CMD_PLAY_OK4[]	= {0x0,	0x0B,	0x63, 0x31, 0xF1, 0x01, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80};

const uint8_t	CMD_STOP1[]		= {0x1,		0x05,	0x00, 0x63, 0x12, 0x53, 0x01 };
uint8_t	      CMD_STOP2[]		= {0x0,		0x0B,	0x63, 0x31, 0xF1, 0x00, 0x30, 0x00, 0x00,0x00, 0x00, 0x00, 0x80 };

const uint8_t	CMD_BEEP[]		= {0x1,		0x05,	0x00, 0x63, 0x29, 0x60, 0x02 };
*/



// all 12 to 11
// commands
const uint8_t stat1[]       = { 0x4, 0x00, 0x00, 0x01, 0x0A };
const uint8_t stat2[]       = { 0x4, 0x00, 0x00, 0x01, 0x08 };
const uint8_t stat3[]       = { 0x4, 0x00, 0x00, 0x01, 0x0D };
const uint8_t stat4[]       = { 0x4, 0x00, 0x00, 0x01, 0x0C };
const uint8_t play_req1[]   = { 0x4, 0x00, 0x25, 0x63, 0x80 };
const uint8_t play_req2[]   = { 0x6, 0x00, 0x11, 0x63, 0x42, 0x01, 0x00 };
const uint8_t play_req3[]   = { 0x6, 0x00, 0x11, 0x63, 0x42, 0x41, 0x00 };
const uint8_t stop_req[]    = { 0x5, 0x00, 0x11, 0x63, 0x43, 0x01 };
const uint8_t stop_req2[]   = { 0x5, 0x00, 0x11, 0x63, 0x43, 0x41 };
const uint8_t ilum_req[]   	= { 0x6, 0x00, 0x11, 0x63, 0x42, 0xC1, 0x00 };

const uint8_t next_track[]	= { 0x4, 0x00, 0x25, 0x63, 0x94 };
const uint8_t prev_track[]	= { 0x4, 0x00, 0x25, 0x63, 0x95 };

const uint8_t next_cd[]		  = { 0x4, 0x00, 0x25, 0x63, 0x90 };
const uint8_t prev_cd[]		  = { 0x4, 0x00, 0x25, 0x63, 0x91 };

const uint8_t fast_forward[]= { 0x4, 0x00, 0x25, 0x63, 0x98 };
const uint8_t fast_back[]	  = { 0x4, 0x00, 0x25, 0x63, 0x99 };

const uint8_t scan_on[]		  = { 0x4, 0x00, 0x25, 0x63, 0xA6 };
const uint8_t scan_off[]	  = { 0x4, 0x00, 0x25, 0x63, 0xA7 };
const uint8_t scan_d_on[]	  = { 0x4, 0x00, 0x25, 0x63, 0xA9 };
const uint8_t scan_d_off[]	= { 0x4, 0x00, 0x25, 0x63, 0xAA };

const uint8_t repeat_on[]	  = { 0x4, 0x00, 0x25, 0x63, 0xA0 };
const uint8_t repeat_off[]	= { 0x4, 0x00, 0x25, 0x63, 0xA1 };
const uint8_t repeat_d_on[]	= { 0x4, 0x00, 0x25, 0x63, 0xA3 };
const uint8_t repeat_d_off[]= { 0x4, 0x00, 0x25, 0x63, 0xA4 };

const uint8_t random_on[]	=   { 0x4, 0x00, 0x25, 0x63, 0xB0 };
const uint8_t random_off[]	= { 0x4, 0x00, 0x25, 0x63, 0xB1 };
const uint8_t random_d_on[]	= { 0x4, 0x00, 0x25, 0x63, 0xB3 };
const uint8_t random_d_off[]= { 0x4, 0x00, 0x25, 0x63, 0xB4 };

// broadcast
const uint8_t lan_stat1[]  = { 0x3,	0x00, 0x01, 0x0A };
const uint8_t lan_reg[]    = { 0x3,	0x11, 0x01, 0x00 };
const uint8_t lan_init[]   = { 0x3,	0x11, 0x01, 0x01 };
const uint8_t lan_check[]  = { 0x3,	0x11, 0x01, 0x20 };
const uint8_t lan_playit[] = { 0x4,	0x11, 0x01, 0x45, 0x63 };

// answers
const uint8_t	CMD_REGISTER[]  = {0x1, 0x05,	0x00, 0x01,	0x11, 0x10, 0x63};
const uint8_t	CMD_STATUS1[]	  = {0x1, 0x04,	0x00, 0x01, 0x00, 0x1A};
const uint8_t	CMD_STATUS2[]	  = {0x1, 0x04,	0x00, 0x01, 0x00, 0x18};
const uint8_t	CMD_STATUS3[]   = {0x1,	0x04,	0x00, 0x01, 0x00, 0x1D};
const uint8_t	CMD_STATUS4[]   = {0x1,	0x05,	0x00, 0x01, 0x00, 0x1C, 0x00};
uint8_t       CMD_CHECK[]	    = {0x1,	0x06,	0x00, 0x01, 0x11, 0x30, 0x00, 0x00};
const uint8_t CMD_PLAY_OK1[]	= {0x1,	0x05,	0x00, 0x63, 0x11, 0x50, 0x01};
const uint8_t	CMD_PLAY_OK2[]	= {0x1,	0x05,	0x00, 0x63, 0x11, 0x52, 0x01};
const uint8_t	CMD_PLAY_OK3[]	= {0x0,	0x0B,	0x63, 0x31, 0xF1, 0x01, 0x00, 0x01, 0xFF, 0xFF, 0xFF, 0x00, 0x80};
uint8_t	      CMD_PLAY_OK4[]	= {0x0,	0x0B,	0x63, 0x31, 0xF1, 0x01, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80};

const uint8_t	CMD_STOP1[]		= {0x1,		0x05,	0x00, 0x63, 0x11, 0x53, 0x01 };
uint8_t	      CMD_STOP2[]		= {0x0,		0x0B,	0x63, 0x31, 0xF1, 0x00, 0x30, 0x00, 0x00,0x00, 0x00, 0x00, 0x80 };

const uint8_t	CMD_BEEP[]		= {0x1,		0x05,	0x00, 0x63, 0x29, 0x60, 0x02 };
const uint8_t	CMD_ILUM[]		= {0x1, 	0x05, 	0x00, 0x63, 0x11, 0x52, 0x01 };


uint8_t cd_Disc;
uint8_t cd_Track;
uint8_t cd_Time_Min;
uint8_t cd_Time_Sec;

uint32_t pin_state;

uint8_t parity_bit;

uint8_t broadcast;
uint8_t master1;
uint8_t master2;
uint8_t slave1;
uint8_t slave2;
uint8_t message_len;
uint8_t message[MAXMSGLEN];

uint8_t answerReq;

uint8_t data_control;
uint8_t data_len;
uint8_t data[MAXMSGLEN];

uint8_t repeatMode;
uint8_t randomMode;
uint8_t scanMode;
uint8_t playMode;

cd_modes CD_Mode;

uint8_t Event;

uint16_t wwTtemp;
uint8_t parityTmp;
uint8_t parity2Tmp;
uint8_t controlTst;
uint8_t ackTmp;

uint8_t val_Min;
uint8_t val_Sec;

//------------------------------------------------------------------------------
uint8_t AVCLan_Send_StartBit() {
	SND_BIT_HI;
  delay_us(168);					// 141-192
  SND_BIT_LO;
  delay_us(20);					// 02-57

 return 1;
}

//------------------------------------------------------------------------------
void AVCLan_Send_Bit1() {
	SND_BIT_HI;
  delay_us(19);					// 17-23
	SND_BIT_LO;
  delay_us(18);					// 17-23
}
//------------------------------------------------------------------------------
void AVCLan_Send_Bit0() {
	SND_BIT_HI;
  delay_us(32);					// 17-23
	SND_BIT_LO;
  delay_us(5);					// 17-23
}

//------------------------------------------------------------------------------
uint8_t AVCLan_Send_Byte(uint8_t byte, uint8_t len) {
  uint8_t b;
  if(len == 8) {
    b = byte;
  } else {
    b = byte << (8 - len);
  }

  while(1) {
    if(b & 128) {
      AVCLan_Send_Bit1();
	    parity_bit++;
    } else { 
   	  AVCLan_Send_Bit0();
    }
    len--;
    if(!len) { return 1; }
    b = b << 1;
  } 
}

//------------------------------------------------------------------------------
uint8_t AVCLan_Send_ParityBit() {
  if(parity_bit & 1) {
    AVCLan_Send_Bit1();
//    parity_bit++;
  } else {
    AVCLan_Send_Bit0();
  }
  parity_bit = 0;
  return 1;
}

//------------------------------------------------------------------------------
uint8_t CheckCmd(uint8_t *cmd) {
  uint8_t i;
  uint8_t *c;
  uint8_t l;

  c = cmd;
  l = *c++;

  for (i=0; i<l; i++) {
 	  if (message[i] != *c) return 0;
	  c++;
  }
  return 1;
}

//------------------------------------------------------------------------------
uint8_t AVCLan_Read_ACK() {
  uint8_t time = 0;
 	SND_BIT_HI;
  delay_us(19);					// 17-23
	SND_BIT_LO;
  tim_init(20);
  while(1) {
    time = check_tim();
    if (RCV_BIT && (time > 1)) break;
    if (time > 7) return 1;
  }
	
  while( RCV_BIT ) ;
  return 0;
}

//------------------------------------------------------------------------------
uint8_t AVCLan_Send_ACK() {
  uint8_t T = 0;
  tim_init(35);
  // ждем начала следующего импульса
  while( (RCV_BIT) == 0 )	{
		T = check_tim();//++;
    if(T >= 27) return 0;	// max wait time
  }
	AVCLan_Send_Bit0();
  return 1;
}

//------------------------------------------------------------------------------
uint8_t AVCLan_Read_Byte(uint8_t length) {
  uint8_t byte = 0;
  uint16_t wT;

  while (1) {
    while ( (RCV_BIT) == 0 ) ; // ждем пока пройдет 0
    wT = 0;
    wwTtemp = 0;
    tim_init(138);
		while (RCV_BIT) { // ждем длительность единицы
      //delay_us(1);
      //wT = check_tim(); //++;
      //pin_state = RCV__BIT;
      } // 4 шага, 24 мгц 4 шага, 0.5 мкс 69 - 8mks
    wT = check_tim();
    wwTtemp = wT;
    if (wT < 25) { 
      byte++;
	    parity_bit++;
    }
    length--;
		
    if (length == 0) return byte;
    byte = byte << 1;
  }
}

uint8_t checkParity() {
  parity2Tmp = parity_bit;
  parityTmp = AVCLan_Read_Byte(1);
  return ((parity2Tmp & 1) == parityTmp);
}

//------------------------------------------------------------------------------
uint8_t AVCLan_Read_Message() {
  //STOPEvent;					// disable timer1 interrupt
  uint32_t T = 0;
  uint8_t i; //, tst1;
  uint8_t for_me = 0;

	// проверим, что это стартовый бит 
  T = 0;
  tim_init(300);
  while (RCV_BIT) {
    //delay_us(1);    
    T = check_tim();
    if(T > 400) return 0;
  }

  if(T < 60) {
      //STARTEvent;
      return 0;
	}
  parity_bit = 0;
  // тип передачи 0 – широковещательная передача 1-передача конкретному устройству
  broadcast = AVCLan_Read_Byte(1);

  // Адрес передающего устройства (ведомого)
  parity_bit = 0;
  master1 = AVCLan_Read_Byte(4);
  master2 = AVCLan_Read_Byte(8);
//  parity2Tmp = parity_bit;
//  parityTmp = AVCLan_Read_Byte(1);
  if(!checkParity()) {
	  //STARTEvent;
	  return 0;
  }

  // Адрес приемного устройства (ведущего)
  parity_bit = 0;
  slave1 = AVCLan_Read_Byte(4);
  slave2 = AVCLan_Read_Byte(8);
  if(!checkParity()) {
	  //STARTEvent;
	  return 0;
  }
    
  // is this command for me ?
  if((slave1 == CD_ID_1) && (slave2 == CD_ID_2)) {
 	  for_me = 1;
  }
  // Ответ приемника о получении данных 	ACK – 0, NOACK – 1
  if(for_me) AVCLan_Send_ACK(); else AVCLan_Read_Byte(1);

  parity_bit = 0;
  controlTst = AVCLan_Read_Byte(4);	// control - always 0xF
  if(controlTst != 0x0f) {
    return controlTst;
  }
  if(!checkParity()) {
	  //STARTEvent;
	  return 0;
  }
  // Ответ приемника о получении данных 	ACK – 0, NOACK – 1
  if(for_me) AVCLan_Send_ACK(); else AVCLan_Read_Byte(1);

  parity_bit = 0;
  message_len = AVCLan_Read_Byte(8);
  if(!checkParity()) {
	  //STARTEvent;
	  return 0;
  }
  if(for_me) AVCLan_Send_ACK(); else AVCLan_Read_Byte(1);

  if (message_len > MAXMSGLEN) {
    //STARTEvent;
	  return 0;
  }

  for(i=0; i<message_len; i++) {
    parity_bit = 0;
 	  message[i] = AVCLan_Read_Byte(8);
    if(!checkParity()) {
      //STARTEvent;
      return 0;
 	  }
    if(for_me) {
      AVCLan_Send_ACK();
    } else {
      AVCLan_Read_Byte(1);
    }
  }

  //STARTEvent;

  if(for_me) {
    if (CheckCmd((uint8_t*)next_track))   { answerReq = cmNextTrack; return 1; }
    if (CheckCmd((uint8_t*)prev_track))   { answerReq = cmPrevTrack; return 1; }
    if (CheckCmd((uint8_t*)next_cd))      { answerReq = cmNextDisc;  return 1; }
    if (CheckCmd((uint8_t*)prev_cd))      { answerReq = cmPrevDisc;  return 1; }

    if (CheckCmd((uint8_t*) stat1)) { answerReq = cmStatus1; return 1; }
    if (CheckCmd((uint8_t*) stat2)) { answerReq = cmStatus2; return 1; }
    if (CheckCmd((uint8_t*) stat3)) { answerReq = cmStatus3; return 1; }
    if (CheckCmd((uint8_t*) stat4)) { answerReq = cmStatus4; return 1; }

    if (CheckCmd((uint8_t*)random_on))		{ randomMode = 1; return 1; }
    if (CheckCmd((uint8_t*)random_off))		{ randomMode = 0; return 1; }
    if (CheckCmd((uint8_t*)random_d_on))	{ randomMode = 1; return 1; }
    if (CheckCmd((uint8_t*)random_d_off))	{ randomMode = 0; return 1; }

    if (CheckCmd((uint8_t*) play_req1)) { answerReq = cmPlayReq1; return 1; }
    if (CheckCmd((uint8_t*) play_req2)) { answerReq = cmPlayReq2; return 1; }
    if (CheckCmd((uint8_t*) stop_req))  { answerReq = cmStopReq; return 1; }

    if (CheckCmd((uint8_t*) ilum_req))  { answerReq = cmIlumReq; return 1; }
  } else { // broadcast check
    if (CheckCmd((uint8_t*) lan_playit)) { answerReq = cmPlayIt; return 1; }
    
    if (CheckCmd((uint8_t*) lan_check))	{ 
      answerReq = cmCheck;
      CMD_CHECK[6] = message[3];
      return 1; 
    }
    
    if (CheckCmd((uint8_t*)lan_reg)) { answerReq = cmRegister; return 1; }
    if (CheckCmd((uint8_t*)lan_init)) { answerReq = cmInit; return 1; }
    if (CheckCmd((uint8_t*)lan_stat1)) { answerReq = cmStatus1; return 1; }
  }
  answerReq = cmNull;
  return 1;
}

//------------------------------------------------------------------------------
uint8_t AVCLan_SendData() {
  uint8_t i;
 
  //STOPEvent;

  // wait for free line
  uint8_t T = 0;
  uint8_t line_busy = 1;

  tim_init(100);
  do {
 	  while( (RCV_BIT) == 0 ) {
		  T = check_tim();
		  if(T >= 25) break;
 	  }
 	  if(T > 24) line_busy = 0;
  } while (line_busy);

  AVCLan_Send_StartBit();
  AVCLan_Send_Byte(0x1, 1);		// regular communication

  parity_bit = 0;
  AVCLan_Send_Byte(CD_ID_1, 4);	// CD Changer ID as master
  AVCLan_Send_Byte(CD_ID_2, 8);
  AVCLan_Send_ParityBit();

  AVCLan_Send_Byte(HU_ID_1, 4);	// HeadUnit ID as slave
  AVCLan_Send_Byte(HU_ID_2, 8);
  AVCLan_Send_ParityBit();
  ackTmp = AVCLan_Read_ACK();
  if(ackTmp) {
	  //STARTEvent;
	  return 1;
  }

  AVCLan_Send_Byte(0xF, 4);		// 0xf - control -> COMMAND WRITE
  AVCLan_Send_ParityBit();
  ackTmp = AVCLan_Read_ACK();
  if(ackTmp) {
	  //STARTEvent;
	  return 2;
  }

  AVCLan_Send_Byte(data_len,  8);// data lenght
  AVCLan_Send_ParityBit();
  ackTmp = AVCLan_Read_ACK();
  if(ackTmp) {
	  //STARTEvent;
	  return 3;
  }

  for (i=0; i < data_len ; i++) {
	  AVCLan_Send_Byte(data[i], 8);// data byte
 	  AVCLan_Send_ParityBit();
    ackTmp = AVCLan_Read_ACK();
 	  if(ackTmp) {
		  //STARTEvent;
		  return 4;
 	  }
  }

//	SEL_BIT_LO; // переключаемся на прием
  //STARTEvent;
  return 0;
}

//------------------------------------------------------------------------------
uint8_t AVCLan_SendDataBroadcast() {
  uint8_t i;
  //STOPEvent;

  // wait for free line
  uint8_t T = 0;
  uint8_t line_busy = 1;

  T = 0;
  tim_init(40);
  do {
 	  while ( (RCV_BIT) == 0 ) {
		  //delay_us(1);
      T = check_tim();
		  if (T >= 25) break;
 	  }
 	  if (T > 24) line_busy=0;
  } while (line_busy);

  AVCLan_Send_StartBit();
  AVCLan_Send_Byte(0x0,  1);		// broadcast

  parity_bit = 0;
  AVCLan_Send_Byte(CD_ID_1, 4);	// CD Changer ID as master
  AVCLan_Send_Byte(CD_ID_2, 8);
  AVCLan_Send_ParityBit();
  
  AVCLan_Send_Byte(0x1, 4);		// all audio devices
  AVCLan_Send_Byte(0xFF, 8);
  AVCLan_Send_ParityBit();
  AVCLan_Send_Bit1();

  AVCLan_Send_Byte(0xF, 4);		// 0xf - control -> COMMAND WRITE
  AVCLan_Send_ParityBit();
  AVCLan_Send_Bit1();
 
  AVCLan_Send_Byte(data_len,  8);	// data lenght
  AVCLan_Send_ParityBit();
  AVCLan_Send_Bit1();

  for (i=0;i<data_len;i++) {
	  AVCLan_Send_Byte(data[i], 8); // data byte
 	  AVCLan_Send_ParityBit();
	  AVCLan_Send_Bit1();
  }

  return 0;
}

//------------------------------------------------------------------------------
uint8_t AVCLan_SendAnswerFrame(uint8_t *cmd) {
  uint8_t i;
  uint8_t *c;
  uint8_t b;

  c = cmd;
 
  b = *c++;
  data_control = 0xF;
  data_len = *c++;
  for(i=0; i<data_len; i++) {
 	  data[i]= *c++;
  }
  if(b)
 	  return AVCLan_SendData();
  else 
 	  return AVCLan_SendDataBroadcast();
}

//------------------------------------------------------------------------------
uint8_t AVCLan_SendInitCommands() {
  uint8_t r;
  const uint8_t c1[] = { 0x0, 0x0B,		0x63, 0x31, 0xF1, 0x00, 0x80, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x80 };
  const uint8_t c2[] = { 0x0, 0x0A,		0x63, 0x31, 0xF3, 0x00, 0x3F, 0x00, 0x00, 0x00, 0x00, 0x02 };
  const uint8_t c3[] = { 0x0, 0x0A,		0x63, 0x31, 0xF3, 0x00, 0x3F, 0x00, 0x01, 0x00, 0x01, 0x02 };
  const uint8_t c4[] = { 0x0, 0x0A,		0x63, 0x31, 0xF3, 0x00, 0x3D, 0x00, 0x01, 0x00, 0x01, 0x02 };
  const uint8_t c5[] = { 0x0, 0x0A,		0x63, 0x31, 0xF3, 0x00, 0x39, 0x00, 0x01, 0x00, 0x01, 0x02 };
  const uint8_t c6[] = { 0x0, 0x0A,		0x63, 0x31, 0xF3, 0x00, 0x31, 0x00, 0x01, 0x00, 0x01, 0x02 };
  const uint8_t c7[] = { 0x0, 0x0A,		0x63, 0x31, 0xF3, 0x00, 0x21, 0x00, 0x01, 0x00, 0x01, 0x02 };
  const uint8_t c8[] = { 0x0, 0x0B,		0x63, 0x31, 0xF1, 0x00, 0x90, 0x01, 0xFF, 0xFF, 0xFF, 0x00, 0x80 };
  const uint8_t c9[] = { 0x0, 0x0A,		0x63, 0x31, 0xF3, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x02 };
  const uint8_t cA[] = { 0x0, 0x0B,		0x63, 0x31, 0xF1, 0x00, 0x30, 0x01, 0xFF, 0xFF, 0xFF, 0x00, 0x80 };

 // init
  r = AVCLan_SendAnswerFrame((uint8_t*)c1);
  if (!r) r = AVCLan_SendAnswerFrame((uint8_t*)c2);
  if (!r) r = AVCLan_SendAnswerFrame((uint8_t*)c3);
  if (!r) r = AVCLan_SendAnswerFrame((uint8_t*)c4);
  if (!r) r = AVCLan_SendAnswerFrame((uint8_t*)c5);
  if (!r) r = AVCLan_SendAnswerFrame((uint8_t*)c6);
  if (!r) r = AVCLan_SendAnswerFrame((uint8_t*)c7);
  if (!r) r = AVCLan_SendAnswerFrame((uint8_t*)c8);
  if (!r) r = AVCLan_SendAnswerFrame((uint8_t*)c9);
  if (!r) r = AVCLan_SendAnswerFrame((uint8_t*)cA);
  return r;
}

//------------------------------------------------------------------------------
uint8_t AVCLan_Send_Status() {
  //                                                        disc  track t_min t_sec
  uint8_t STATUS[] = {0x0, 0x0B, 0x63, 0x31, 0xF1, 0x01, 0x10, 0x01, 0x01, 0x00, 0x00, 0x00, 0x80 };

  STATUS[7] = cd_Disc;
  STATUS[8] = cd_Track;
  STATUS[9] = cd_Time_Min;
  STATUS[10] = cd_Time_Sec;

  STATUS[11] = 0;

  switch (repeatMode) {
    case 1:	STATUS[11] |= 0x10; break;
    case 2:	STATUS[11] |= 0x08; break;
  }
  switch (randomMode) {
    case 1:	STATUS[11] |= 0x04; break;
    case 2:	STATUS[11] |= 0x02; break;
 }
 switch (scanMode) {
 	case 1:	STATUS[11] |= 0x40; break;
	case 2:	STATUS[11] |= 0x20; break;
 }

 switch (playMode) {
	case 0: STATUS[6] = 0x03; break;
	case 1:	STATUS[6] = 0x10; break;
 }

 return AVCLan_SendAnswerFrame((uint8_t*)STATUS);
}
//------------------------------------------------------------------------------

uint8_t doRegister() {
  uint8_t i, r;
  //     ,      
  for(i=0; i<5; i++) {
    r = AVCLan_SendAnswerFrame((uint8_t*)CMD_REGISTER);
    if(r == 0) break;
    delay_ms(400);
  }
  return r;  
}

//------------------------------------------------------------------------------
uint8_t AVCLan_SendAnswer() {
  uint8_t r = 0, x;
 
  switch (answerReq) {
 	  case cmStatus1:
            r = AVCLan_SendAnswerFrame((uint8_t*)CMD_STATUS1); 
						break;
 	  case cmStatus2:
            r = AVCLan_SendAnswerFrame((uint8_t*)CMD_STATUS2); 
						break;
 	  case cmStatus3:
            r = AVCLan_SendAnswerFrame((uint8_t*)CMD_STATUS3); 
						break;
 	  case cmStatus4:
            r = AVCLan_SendAnswerFrame((uint8_t*)CMD_STATUS4); 
						break;
 	  case cmRegister:
            r = doRegister();
            break;
 	  case cmInit:
            r = AVCLan_SendInitCommands(); 
			break;
 	  case cmIlumReq:
            r = AVCLan_SendAnswerFrame((uint8_t*)CMD_ILUM);
			break;
    case cmCheck:	
            for(x=0; x<5; x++) {
              r = AVCLan_SendAnswerFrame((uint8_t*)CMD_CHECK); 
              if(r == 0) break;
              delay_ms(100);
            }
			break;
    case cmPlayReq1:
            playMode = 0;
						r = AVCLan_SendAnswerFrame((uint8_t*)CMD_PLAY_OK1); 
            //setVolUpFlag();
            break;

    case cmPlayReq2:
 	  case cmPlayReq3:
            playMode = 0;
						r = AVCLan_SendAnswerFrame((uint8_t*)CMD_PLAY_OK2); 
						if (!r) r = AVCLan_SendAnswerFrame((uint8_t*)CMD_PLAY_OK3);
						CD_Mode = stPlay;
						break;
	case cmPlayIt:
            playMode = 1;
						CMD_PLAY_OK4[7]=cd_Disc;
						CMD_PLAY_OK4[8]=cd_Track;
						CMD_PLAY_OK4[9]=cd_Time_Min;
						CMD_PLAY_OK4[10]=cd_Time_Sec;
            for(x=0; x<5; x++) {
              r = AVCLan_SendAnswerFrame((uint8_t*)CMD_PLAY_OK4); 
              if(r == 0) break;
              delay_ms(100);
            }
						//if (!r) r = AVCLan_SendAnswerFrame((uint8_t*)CMD_PLAY_OK4);
            //r = AVCLan_Send_Status();
            //if (!r) AVCLan_Send_Status();
            for(x=0; x<5; x++) {
              r = AVCLan_Send_Status();
              if(r == 0) break;
              delay_ms(100);
            }
						CD_Mode = stPlay;
						break;
	case cmStopReq:		
	case cmStopReq2:
            CD_Mode = stStop;
						playMode = 0;
						cd_Time_Min = 0;
						cd_Time_Sec = 0;
						r = AVCLan_SendAnswerFrame((uint8_t*)CMD_STOP1); 
						CMD_STOP2[7]=cd_Disc;
						CMD_STOP2[8]=cd_Track;
						CMD_STOP2[9]=cd_Time_Min;
						CMD_STOP2[10]=cd_Time_Sec;
						r = AVCLan_SendAnswerFrame((uint8_t*)CMD_STOP2); 
						break;
	case cmBeep:
            AVCLan_SendAnswerFrame((uint8_t*)CMD_BEEP);
						break;
 }

 answerReq = cmNull;
 return r;
}

uint8_t HexInc(uint8_t data) {
  if ((data & 0x9) == 0x9) return (data + 7);
  return (data + 1);
}

uint8_t HexDec(uint8_t data) {
  if ((data & 0xF) == 0) return (data - 7);
  return (data-1);
}

void initAVCLAN() {
  SND_BIT_LO; //  

  message_len = 0;
  answerReq   = cmNull;
  cd_Disc     = 1;
  cd_Track    = 1;
  cd_Time_Min = 0;
  cd_Time_Sec = 0;
  repeatMode	= 0;
  randomMode	= 0;
  playMode	  = 0;
  CD_Mode	    = stStop;
}
