#include "buttons.h"
#include "avclan.h"

uint8_t flg_ButtonNext = 0;

uint8_t flg_ButtonPrev = 0;

void checkResVolUpFlag(void);

void initButtons() {
  flg_ButtonNext = 0;
  flg_ButtonPrev = 0;
  
  tmp_VolIncFlag = 0;
  
  BUTT_POWER_OFF;
  BUTT1_PREV_DN;
  BUTT1_NEXT_DN;
  BUTT1_MODE_DN;
  BUTT1_REPT_DN;
}

void clickButtonPrev() {
  checkResVolUpFlag();
  BUTT1_PREV_UP;
  delay_ms(200);
  BUTT1_PREV_DN;  
  delay_ms(300);
}

void clickButtonNext() {
  checkResVolUpFlag();
  BUTT1_NEXT_UP;
  delay_ms(200);
  BUTT1_NEXT_DN;  
  delay_ms(300);
}

void setPowerOn() {
  BUTT_POWER_ON;
  cd_Time_Min = 0;
  cd_Time_Sec = 0;
  cd_Track = 1;
  cd_Disc = 1;
  setVolUpFlag();
}

void setPowerOff() {
  BUTT_POWER_OFF;
}

void setNextTrack() {
  flg_ButtonNext++;
  if(randomMode) flg_ButtonNext = random;
  cd_Time_Min = 0;
  cd_Time_Sec = 0;
  
  while(flg_ButtonNext) {
    clickButtonNext();
    flg_ButtonNext--;
    cd_Track = HexInc(cd_Track);
  }
}

void setPrevTrack() {
  flg_ButtonPrev++;
  if(randomMode) flg_ButtonPrev = random;
  cd_Time_Min = 0;
  cd_Time_Sec = 0;
  // обработчик кнопок
  while(flg_ButtonPrev) {
    clickButtonPrev();
    flg_ButtonPrev--;
    if(cd_Track > 1) cd_Track = HexDec(cd_Track);
  }
}

void checkResVolUpFlag() {
  if(tmp_VolIncFlag) {
    tmp_VolIncFlag = 0;
    BUTT1_PREV_DN;  
    delay_ms(300);
  }
}

void setVolUpFlag() {
  tmp_VolIncFlag = 1;
  tmp_VolIncCounter = 6000000;
}
