#include "delays.h"

uint32_t counter1 = F_APB1/1000000 - 1;

void delay_ms(unsigned int delay) {
     TIM4->PSC = F_APB1/1000 + 1; // 
     TIM4->ARR = delay; //   ,         
     TIM4->EGR |= TIM_EGR_UG; //     1   PSC  ARR
     TIM4->CR1 |= TIM_CR1_CEN|TIM_CR1_OPM; //    CEN        OPM
     while ((TIM4->CR1 & TIM_CR1_CEN) != 0);
}

void delay_us(unsigned int delay) {
  TIM4->CR1 &=~ TIM_CR1_CEN;
  TIM4->CNT = 0;
  TIM4->PSC = counter1; ///1000000 - 1; // 
  TIM4->ARR = delay; //   ,         
  TIM4->EGR |= TIM_EGR_UG; //        PSC  ARR
  TIM4->CR1 |= TIM_CR1_CEN|TIM_CR1_OPM; //    CEN        OPM
  while ((TIM4->CR1 & TIM_CR1_CEN) != 0);
}

void tim_init(unsigned int maxdelay) {
  TIM4->CR1 &=~ TIM_CR1_CEN;
  TIM4->CNT = 0;
  TIM4->PSC = counter1; // 
  TIM4->ARR = maxdelay; //   ,         
  TIM4->EGR |= TIM_EGR_UG; //        PSC  ARR
  TIM4->CR1 |= TIM_CR1_CEN|TIM_CR1_OPM; //    CEN        OPM
}

int check_tim() {
  if((TIM4->CR1 & TIM_CR1_CEN) != 0) return TIM4->CNT;
  return 1001;
}

void clear_tim() {
  TIM4->CR1 &=~ TIM_CR1_CEN;
  TIM4->CNT = 0;
}
