#ifndef __AVCLAN_H
#define __AVCLAN_H

  #include "io_board.h"
  #include "globals.h"
  #include "delays.h"

  // correct
  #define SND_BIT_LO          HAL_GPIO_WritePin(AVCLAN_TX_PORT, AVCLAN_TX_PIN, GPIO_PIN_SET)
  #define SND_BIT_HI          HAL_GPIO_WritePin(AVCLAN_TX_PORT, AVCLAN_TX_PIN, GPIO_PIN_RESET)

  #define RCV_BIT             HAL_GPIO_ReadPin(AVCLAN_RX_PORT, AVCLAN_RX_PIN)

  // Head Unid ID
  #define HU_ID_1	0x01
  #define HU_ID_2	0x90

  // CD Changer ID
  #define CD_ID_1	 0x03
  #define CD_ID_2	 0x60

  #define MAXMSGLEN	32

  #define cmNull		0
  #define cmStatus1	1
  #define cmStatus2	2
  #define cmStatus3	3
  #define cmStatus4	4

  #define cmPlayReq1	5
  #define cmPlayReq2	6
  #define cmPlayReq3	7
  #define cmStopReq		8
  #define cmStopReq2	9
  #define cmIlumReq		10

  #define cmRegister		100
  #define cmInit			101
  #define cmCheck			102
  #define cmPlayIt		103
  #define cmBeep			110

  #define EV_NOTHING	0
  #define EV_DISPLAY	1
  #define EV_STATUS	4

  #define cmNextTrack		120
  #define cmPrevTrack		121
  #define cmNextDisc		122
  #define cmPrevDisc		123

  typedef enum { stStop, stPlay } cd_modes;
  
  extern cd_modes CD_Mode;

  extern uint8_t answerReq;
  
  extern uint8_t Event;
  
  extern uint8_t AVCLan_SendInitCommands(void);

  extern uint8_t AVCLan_Read_Message(void);
  
  extern uint8_t AVCLan_SendAnswer(void);
  
  extern uint8_t AVCLan_Send_Status(void);
  
  extern void initAVCLAN(void);
  
  extern uint8_t doRegister(void);
  
  extern uint8_t HexInc(uint8_t data);
  extern uint8_t HexDec(uint8_t data);
  
  extern uint8_t cd_Disc;
  extern uint8_t cd_Track;
  extern uint8_t cd_Time_Min;
  extern uint8_t cd_Time_Sec;
  
  extern uint8_t repeatMode;
  extern uint8_t randomMode;

#endif
