#include <e32base.h>

_LIT(KBayanServerName,"BayanICQServer");

enum BayanCommand
{
	EGetUserCount = 0x10,
	EGetUserNameLen,
	EGetProfileName,
	EGetUserType,
	EUserIsConnected,
	EUserIsOnline,
	EShowPopupWindow,
	EGetUserParam,
	ESetUserParam,
	ESetTextParam,
	EHaveUserMessages,
	EGetAppPath,
	EGetLangFileName
};

enum ICQParams
{
	EStatus = 0x4,
	EXStatus,
	EStatusText,
	EXStatusText
};

enum ICQStatus
{
	EOnline			= 0x08,
	EAway			= 0x11,
	ENA				= 0x13,
	EBusy			= 0x0F,
	EDND			= 0x10,
	EFreeForChat	= 0x09,
	EEvil			= 0x0C,
	EDepression		= 0x0D,
	EHome			= 0x0A,
	EWork			= 0x0B,
	EInvisible		= 0x0E,
	EEating			= 0x12,
	EOffline		= 0x15,
	EConnecting		= 0x16
};

enum ICQXStatus
{
	EXStatus_None = -1,
	EXStatus_Angry,
	EXStatus_Duck,
	EXStatus_Tired,
	EXStatus_Party,
	EXStatus_Beer,
	EXStatus_Thinking,
	EXStatus_Eating,
	EXStatus_TV,
	EXStatus_Coffee,
	EXStatus_Music,
	EXStatus_Camera,
	EXStatus_Funny,
	EXStatus_Phone,
	EXStatus_Games,
	EXStatus_College,
	EXStatus_Shopping,
	EXStatus_Sick,
	EXStatus_Sleeping,
	EXStatus_Surfing,
	EXStatus_Internet,
	EXStatus_Engineering,
	EXStatus_Typing,
	EXStatus_WC,
	EXStatus_Love,
	EXStatus_Friends,
	EXStatus_Picnic,
	EXStatus_Mobile,
	EXStatus_Smoking,
	EXStatus_ZZZ,
	EXStatus_Question,
	EXStatus_RedIron,
	EXStatus_Journal,
	EXStatus_Business,
	EXStatus_PSP,
	EXStatus_RuLove,
	EXStatus_Sex,
	EXStatus_Search
};

enum BayanUserType
{
	EICQUser = 0x3006,
	EJabberUser = 0x2411
};

#define CURR_MAJOR_VER 0x01
#define CURR_MINOR_VER 0x00
#define CURR_BUILD_VER 0x01