#include "bayanLibs.h"
#include "BayanConst.h"

_LIT(BayanServ,"bayanICQServer");

EXPORT_C CBayanSession* NewSession()
{
	return new CBayanSession();
}

EXPORT_C TInt CBayanSession::Connect()
{
	iConnected = CreateSession(KBayanServerName,TVersion(CURR_MAJOR_VER,CURR_MINOR_VER,CURR_BUILD_VER));
	return iConnected;
}

EXPORT_C TBool CBayanSession::IsConnected()
{
	return (iConnected == KErrNone);
}

EXPORT_C TInt CBayanSession::UserCount()
{
	TInt ret = 0;
	TPckgBuf<TInt> pg;
	///
	TIpcArgs args(&pg);
	SendReceive(EGetUserCount,args);
	///
	ret = pg();
	return ret;
}

EXPORT_C HBufC* CBayanSession::GetProfileNameL(TInt aIndex)
{
	TPckgBuf<TInt> pckg;
	TIpcArgs args(&pckg,aIndex);
	SendReceive(EGetUserNameLen,args);
	///
	HBufC* ret = HBufC::New(pckg());
	TPtr pRet(ret->Des());
	SendReceive(EGetProfileName,TIpcArgs(&pRet,aIndex));
	return ret;
}

EXPORT_C TInt CBayanSession::UserType(TInt aIndex)
{
	TPckgBuf<TInt> pckg;
	TIpcArgs args(&pckg,aIndex);
	SendReceive(EGetUserType,args);
	TInt ret = pckg();
	return ret;
}

EXPORT_C TInt CBayanSession::UserConnected(TInt aIndex)
{
	TPckgBuf<TInt> pckg;
	TIpcArgs args(&pckg,aIndex);
	SendReceive(EUserIsConnected,args);
	TInt ret = pckg();
	return ret;
}

EXPORT_C TInt CBayanSession::UserIsOnline(TInt aIndex)
{
	TPckgBuf<TInt> pckg;
	TIpcArgs args(&pckg,aIndex);
	SendReceive(EUserIsOnline,args);
	TInt ret = pckg();
	return ret;
}

EXPORT_C void CBayanSession::ShowPopupWindow(const TDesC &aMessage)
{
	SendReceive(EShowPopupWindow,TIpcArgs(&aMessage));
}

EXPORT_C TInt CBayanSession::GetUserParam(TInt aIndex, TInt aParam)
{
	TPckgBuf<TInt> pckg;
	TIpcArgs args(&pckg,aIndex,aParam);
	SendReceive(EGetUserParam,args);
	TInt ret = pckg();
	return ret;
}

EXPORT_C void CBayanSession ::SetUserParam(TInt aCommand, TInt aIndex, TInt aValue)
{
	TIpcArgs args(aCommand,aIndex,aValue);
	SendReceive(ESetUserParam,args);
}

EXPORT_C void CBayanSession::SetTextParam(TInt aCommand, TInt aIndex, const TDesC &aMessage)
{
	TIpcArgs args(aCommand,aIndex,&aMessage);
	SendReceive(ESetTextParam,args);
}

EXPORT_C TInt CBayanSession::UnreadedMessages(TInt aUserIndex)
{
	TPckgBuf<TInt> pckg;
	TIpcArgs args(&pckg,aUserIndex);
	SendReceive(EHaveUserMessages,args);
	TInt ret = pckg();
	return ret;
}

EXPORT_C HBufC* CBayanSession::GetProgramPath()
{
	TFileName AppPath;
	TIpcArgs args(&AppPath);
	SendReceive(EGetAppPath,args);
	return AppPath.Alloc();
}

EXPORT_C HBufC* CBayanSession::GetLangName()
{
	TBuf<50> iFileName;
	TIpcArgs args(&iFileName);
	SendReceive(EGetLangFileName,args);
	return iFileName.Alloc();
}

EXPORT_C void CBayanSession::Reserved_1()
{
	return;
}

EXPORT_C void CBayanSession::Reserved_2()
{
	return;
}

EXPORT_C void CBayanSession::Reserved_3()
{
	return;
}

EXPORT_C void CBayanSession::Reserved_4()
{
	return;
}

EXPORT_C void CBayanSession::Reserved_5()
{
	return;
}

EXPORT_C void CBayanSession::Reserved_6()
{
	return;
}

EXPORT_C void CBayanSession::Reserved_7()
{
	return;
}

EXPORT_C void CBayanSession::Reserved_8()
{
	return;
}

EXPORT_C void CBayanSession::Reserved_9()
{
	return;
}

EXPORT_C void CBayanSession::Reserved_10()
{
	return;
}