#include <avr/io.h>
#include "enum.h"

//  2.3 (  ULN2003       SOT223
//  2.3    4.608 
//   16    4.608 .   .   6 .

/*2.      :     , 
   ,    .   
  11-15.     0,    
 " ".

5.  ,     ,    - .
    20  21.     MASK_EVT_XXX. 
*/

#define BUTTON		((PINB&8)==0)	//   	( =  = )

// 2.3.1    2.2
//   .    
#define INPUT3		((PIND&128)==0)//(PIND&128)	
#define INPUT4		((PIND&64)==0)//(PIND&64)	//   ( =  =    ULN2003 = )
#define INPUT5		((PIND&32)==0)//(PIND&32)	//   ( =  =    ULN2003 = ) 
#define INPUT6		((PIND&8)==0)//(PIND&16)	//  	( =  =    ULN2003 = )
#define INPUT7		((PIND&16)==0)//(PIND&8)	// 
#define INPUT8		((PIND&4)==0)//(PIND&4)	// 

//   PINC   , /*   ,  .*/
//#define NOPOWER		((PINC&128)==0)	// 		( =  =  )
// 8.8B = 0xa4
#define NOPOWER		((ADCH < 0x80))	// 		(   =  =  )

// 
#define OUT1_ON()	{PORTC|=0x20;}  //C5
#define OUT1_OFF()	{PORTC&=(0xff-0x20);} 

#define OUT2_ON()	{PORTC|=0x10;} // C4
#define OUT2_OFF()	{PORTC&=(0xff-0x10);}
#define OUT2_IS_OFF ((PINC&0x10) == 0)   //  ,     2

#define OUT3_ON()	{PORTC|=0x08;} // C3
#define OUT3_OFF()	{PORTC&=(0xff-0x08);}
#define OUT3_IS_OFF ((PINC&0x08) == 0) 


extern volatile unsigned int led;
extern volatile unsigned int tick;

extern void hard_init(void);
extern void phone_handler(void);
extern void put_message(unsigned char m);
extern void flush_messages(void);


unsigned char emerg;
unsigned char fire;
unsigned char door;
unsigned char power;
unsigned char btn;
unsigned char window; 
unsigned char move; 
unsigned char aux; 

unsigned char btn_cnt;
unsigned char power_cnt;
unsigned char fire_cnt;
unsigned char emerg_cnt;
unsigned char door_cnt;
unsigned char window_cnt; 
unsigned char move_cnt; 
unsigned char aux_cnt; 

extern unsigned int settings1;
extern unsigned int settings2;
extern unsigned int settings3;
extern unsigned int settings4;
extern unsigned int settings5;

//     ,    .
// ,       ,
//       .
extern unsigned int actions_sms; //  20
extern unsigned int actions_call; //  21

// BOOL    ,      .
unsigned char WillCall, WillSMS;

//     20 (SMS)  21 (Dial).   ,   .
#define MASK_EVT_DONOTHING	0x1 //    ,   , 
//     ,      1 .
//   0 -  ..  atoi().
#define MASK_EVT_NOPOWER	0x2
#define MASK_EVT_ARMED		0x4
#define MASK_EVT_DISARMED	0x8
#define MASK_EVT_DOOR		0x10
#define MASK_EVT_FIRE		0x20
#define MASK_EVT_WINDOW		0x40
#define MASK_EVT_MOVE		0x80
#define MASK_EVT_AUX		0x100
#define MASK_EVT_CHANGEOUT	0x200

//         .
void GetAllowedActions(unsigned int mask)
{
	if(actions_sms & mask) 
		WillSMS = 1; 
	else WillSMS = 0;

	if(actions_call & mask) 
		WillCall = 1; 
	else WillCall = 0;
}

//   ,  atoi()      
//   .     ,  
//  .

void check_settings_validity()
{
	if(settings1 == 0)
		settings1 = 0xffff;
	if(settings2 == 0)
		settings2 = 0xffff;
	if(settings3 == 0)
		settings3 = 0xffff;
	if(settings4 == 0)
		settings4 = 0xffff;
	if(settings5 == 0)
		settings5 = 0xffff;

	if(actions_sms == 0)
		actions_sms = 0xffff;
	if(actions_call == 0)
		actions_call = 0xffff;
}


void input_handler(void)
{
	if (NOPOWER) {if (power_cnt<=2) {power_cnt++;} if(power_cnt==2) {power=1; emerg=0; fire=0; door=0; }}
	else
	{
		power_cnt=0;
		if (INPUT4)  	{ if (door_cnt<=2) {door_cnt++;} if(door_cnt==2) {door=1;} }
		else  		{ door_cnt=0; }
		if (INPUT5)  	{ if (fire_cnt<=2) {fire_cnt++;} if(fire_cnt==2) {fire=1;} }
		else  		{ fire_cnt=0; }
		if (INPUT6)  	{ if (emerg_cnt<=2) {emerg_cnt++;} if(emerg_cnt==2) {emerg=1;} }
		else  		{ emerg_cnt=0; }
		
		if (INPUT3)  	{ if (window_cnt<=2) {window_cnt++;} if(window_cnt==2) {window=1;} }
		else  		{ window_cnt=0; }
		if (INPUT7)  	{ if (move_cnt<=2) {move_cnt++;} if(move_cnt==2) {move=1;} }
		else  		{ move_cnt=0; }
		if (INPUT8)  	{ if (aux_cnt<=2) {aux_cnt++;} if(aux_cnt==2) {aux=1;} }
		else  		{ aux_cnt=0; }
	}
	if(BUTTON) 	{ if(btn_cnt<=15) {btn_cnt++;} if(btn_cnt==15) {btn=2;} }
	else		{ if((btn_cnt>2)&&(btn_cnt<15)) {btn=1;} btn_cnt=0; }
}

extern unsigned char	temp[20];

extern unsigned int	delay1;
extern unsigned int	delay2;
extern unsigned int	delay3;

extern unsigned char	num1[15];
extern unsigned char	num2[15];
extern unsigned char	num3[15];
extern unsigned char	num4[15];
extern unsigned char	num5[15];

extern unsigned char tone;

//    3
extern unsigned int	PulseLen2;
//    3
extern unsigned int	PulseLen3;

// ,       2  3
unsigned int PulseTimer2 = 0;
unsigned int PulseTimer3 = 0;

extern unsigned char	sms;   // SMS_OUT2ON...


void alarm_handler(void)
{
static unsigned char s=STARTING1;
static unsigned char sPrev = STARTING1; 
static unsigned long timer;

	if(timer) timer--;

	//   PulseTimer,    , 
	//    .
	if(PulseTimer2 == 1) {OUT2_OFF(); PulseTimer2 = 0;}
	if(PulseTimer3 == 1) {OUT3_OFF(); PulseTimer3 = 0;}

	if(PulseTimer2)
		PulseTimer2--;
	if(PulseTimer3)
		PulseTimer3--;

	if (delay1>600) delay1=600;
	if (delay2>600) delay2=600;
	if (delay3>600) delay3=600;

	//  
	if (PulseLen2>1800) PulseLen2=1800;
	if (PulseLen3>1800) PulseLen3=1800;

	if(s != STARTING1 && s != STARTING2)
	{
		if(sms==SMS_OUT2ON)      {sms=0; OUT2_ON(); if(PulseLen2) PulseTimer2 = (unsigned long)PulseLen2*10ul; } // turn on
		if(sms==SMS_OUT2OFF)      {sms=0; OUT2_OFF(); PulseTimer2 = 0; }
		if(sms==SMS_OUT3ON)      {sms=0; OUT3_ON(); if(PulseLen3) PulseTimer3 = (unsigned long)PulseLen3*10ul; } // turn on
		if(sms==SMS_OUT3OFF)      {sms=0; OUT3_OFF(); PulseTimer3 = 0; }
		if(sms==SMS_SENDSTATE)	
		{
			sms=0;
			//      ..
			if(s == DISARMED)
			{
				if(OUT2_IS_OFF && OUT3_IS_OFF)
					put_message(MSG_SMS_1_STATE000);
				if(OUT2_IS_OFF && (!OUT3_IS_OFF))
					put_message(MSG_SMS_1_STATE001);
				if((!OUT2_IS_OFF) && OUT3_IS_OFF)
					put_message(MSG_SMS_1_STATE010);
				if((!OUT2_IS_OFF) && (!OUT3_IS_OFF))
					put_message(MSG_SMS_1_STATE011);
			}
			else // ARMED
			{
				if(OUT2_IS_OFF && OUT3_IS_OFF)
					put_message(MSG_SMS_1_STATE100);
				if(OUT2_IS_OFF && (!OUT3_IS_OFF))
					put_message(MSG_SMS_1_STATE101);
				if((!OUT2_IS_OFF) && OUT3_IS_OFF)
					put_message(MSG_SMS_1_STATE110);
				if((!OUT2_IS_OFF) && (!OUT3_IS_OFF))
					put_message(MSG_SMS_1_STATE111);
			}
		}
		//    ,   , ..  ?
		if(sPrev == ARMED && s == DISARMED)
		{
			GetAllowedActions(MASK_EVT_DISARMED);
			 if(WillSMS) put_message(MSG_SMS_1_DISARMED); if(WillCall) put_message(MSG_DIAL_1);
			 if(WillSMS) put_message(MSG_SMS_2_DISARMED); if(WillCall) put_message(MSG_DIAL_2);
			 if(WillSMS) put_message(MSG_SMS_3_DISARMED); if(WillCall) put_message(MSG_DIAL_3);
			 if(WillSMS) put_message(MSG_SMS_4_DISARMED); if(WillCall) put_message(MSG_DIAL_4);
			 if(WillSMS) put_message(MSG_SMS_5_DISARMED); if(WillCall) put_message(MSG_DIAL_5); 
		}
	}
	sPrev = s;

	switch(s)
	{
	case STARTING1:
		flush_messages();
		put_message(MSG_GETNUM1);

		timer=600;
		led=0x5555;
		s=STARTING2;
		break;

	case STARTING2:
		if (timer==0) {s=STARTING1; break;}
		if (num1[0]!=0)
		{
			put_message(MSG_GETNUM2);  put_message(MSG_GETNUM3);
			put_message(MSG_GETNUM4);  put_message(MSG_GETNUM5);
			put_message(MSG_GETNUM11);  put_message(MSG_GETNUM12);
			put_message(MSG_GETNUM13);  put_message(MSG_GETNUM14);
			put_message(MSG_GETNUM15);  
			put_message(MSG_GETNUM20);  put_message(MSG_GETNUM21);
			put_message(MSG_GETNUM30); put_message(MSG_GETNUM31); // arm/disarm
			put_message(MSG_GETNUM32); put_message(MSG_GETNUM33); // out2 on/off
			put_message(MSG_GETNUM34); // out2 pulse length
			put_message(MSG_GETNUM35); put_message(MSG_GETNUM36); // out3 on/off
			put_message(MSG_GETNUM37); //out3 pulse length
			put_message(MSG_GETNUM38); //get state

			put_message(MSG_GETNUM40); put_message(MSG_GETNUM41);
			put_message(MSG_GETNUM42); 

			led=0x0001;
			s=DISARMED;
			sms=SMS_NONE; 
			break;
		}
		break;
		
	case DISARMED:
		tone=0;
		if(sms==SMS_ARM)	{sms=0; timer=(unsigned long)delay1*10ul; led=0x5555; s=WAIT_ARMED; break;} 
		if(sms==SMS_DISARM) {sms=0; } //      

		if(btn==1)	{btn=0; timer=(unsigned long)delay1*10ul; led=0x5555; s=WAIT_ARMED; break;}

		if(btn==2)	{btn=0;
				 put_message(MSG_SMS_1_5); put_message(MSG_DIAL_1);
				 put_message(MSG_SMS_2_5); put_message(MSG_DIAL_2);
				 put_message(MSG_SMS_3_5); put_message(MSG_DIAL_3);
				 put_message(MSG_SMS_4_5); put_message(MSG_DIAL_4);
				 put_message(MSG_SMS_5_5); put_message(MSG_DIAL_5); 
				 break;}

		if(power)	{power=0;
				GetAllowedActions(MASK_EVT_NOPOWER);
				 if(WillSMS) put_message(MSG_SMS_1_1); if(WillCall) put_message(MSG_DIAL_1);
				 if(WillSMS) put_message(MSG_SMS_2_1); if(WillCall) put_message(MSG_DIAL_2);
				 if(WillSMS) put_message(MSG_SMS_3_1); if(WillCall) put_message(MSG_DIAL_3);
				 if(WillSMS) put_message(MSG_SMS_4_1); if(WillCall) put_message(MSG_DIAL_4);
				 if(WillSMS) put_message(MSG_SMS_5_1); if(WillCall) put_message(MSG_DIAL_5); 
				 break;}

		if(emerg)	{emerg=0;
				 put_message(MSG_SMS_1_4); put_message(MSG_DIAL_1);
				 put_message(MSG_SMS_2_4); put_message(MSG_DIAL_2);
				 put_message(MSG_SMS_3_4); put_message(MSG_DIAL_3);
				 put_message(MSG_SMS_4_4); put_message(MSG_DIAL_4);
				 put_message(MSG_SMS_5_4); put_message(MSG_DIAL_5); 
				 break;}

		break;

	case WAIT_ARMED:
		if(btn==1)	{btn=0; flush_messages(); led=0x0001; s=DISARMED; break;}
		if(sms==SMS_DISARM)	{sms=0; flush_messages(); led=0x0001; s=DISARMED; break;}
		if(sms==SMS_ARM) {sms=0; } //      


		if(timer==0)    
		{
			if((door_cnt==0) && (fire_cnt==0) 
				&& (window_cnt == 0) && (move_cnt == 0) && (aux_cnt == 0)
				)
			{
				power=0; door=0; fire=0; emerg=0; led=0x0005; s=ARMED;
				window = 0; move = 0; aux = 0; 
				GetAllowedActions(MASK_EVT_ARMED);//"  "

				if(WillSMS) put_message(MSG_SMS_1_6); if(WillCall) put_message(MSG_DIAL_1);
				if(WillSMS) put_message(MSG_SMS_2_6); if(WillCall) put_message(MSG_DIAL_2);
				if(WillSMS) put_message(MSG_SMS_3_6); if(WillCall) put_message(MSG_DIAL_3);
				if(WillSMS) put_message(MSG_SMS_4_6); if(WillCall) put_message(MSG_DIAL_4);
				if(WillSMS) put_message(MSG_SMS_5_6); if(WillCall) put_message(MSG_DIAL_5);
			}
			else
			{
				s=WAIT_INPUTS;
				if(door_cnt!=0)
				{
					put_message(MSG_SMS_1_7); put_message(MSG_DIAL_1);
					put_message(MSG_SMS_2_7); put_message(MSG_DIAL_2);
					put_message(MSG_SMS_3_7); put_message(MSG_DIAL_3);
					put_message(MSG_SMS_4_7); put_message(MSG_DIAL_4);
					put_message(MSG_SMS_5_7); put_message(MSG_DIAL_5);
				}
				
				if(fire_cnt!=0)
				{
					put_message(MSG_SMS_1_8); put_message(MSG_DIAL_1);
					put_message(MSG_SMS_2_8); put_message(MSG_DIAL_2);
					put_message(MSG_SMS_3_8); put_message(MSG_DIAL_3);
					put_message(MSG_SMS_4_8); put_message(MSG_DIAL_4);
					put_message(MSG_SMS_5_8); put_message(MSG_DIAL_5);
				}

				if(window_cnt!=0)
				{
					put_message(MSG_SMS_1_ERR_WINDOW); put_message(MSG_DIAL_1);
					put_message(MSG_SMS_2_ERR_WINDOW); put_message(MSG_DIAL_2);
					put_message(MSG_SMS_3_ERR_WINDOW); put_message(MSG_DIAL_3);
					put_message(MSG_SMS_4_ERR_WINDOW); put_message(MSG_DIAL_4);
					put_message(MSG_SMS_5_ERR_WINDOW); put_message(MSG_DIAL_5);
				}
				if(move_cnt!=0)
				{
					put_message(MSG_SMS_1_ERR_MOVEMENT); put_message(MSG_DIAL_1);
					put_message(MSG_SMS_2_ERR_MOVEMENT); put_message(MSG_DIAL_2);
					put_message(MSG_SMS_3_ERR_MOVEMENT); put_message(MSG_DIAL_3);
					put_message(MSG_SMS_4_ERR_MOVEMENT); put_message(MSG_DIAL_4);
					put_message(MSG_SMS_5_ERR_MOVEMENT); put_message(MSG_DIAL_5);
				}
				if(aux_cnt!=0)
				{
					put_message(MSG_SMS_1_ERR_AUX); put_message(MSG_DIAL_1);
					put_message(MSG_SMS_2_ERR_AUX); put_message(MSG_DIAL_2);
					put_message(MSG_SMS_3_ERR_AUX); put_message(MSG_DIAL_3);
					put_message(MSG_SMS_4_ERR_AUX); put_message(MSG_DIAL_4);
					put_message(MSG_SMS_5_ERR_AUX); put_message(MSG_DIAL_5);
				}
			}
			break;
		}
		
		if(btn==2)	{btn=0;
				 put_message(MSG_SMS_1_5); put_message(MSG_DIAL_1);
				 put_message(MSG_SMS_2_5); put_message(MSG_DIAL_2);
				 put_message(MSG_SMS_3_5); put_message(MSG_DIAL_3);
				 put_message(MSG_SMS_4_5); put_message(MSG_DIAL_4);
				 put_message(MSG_SMS_5_5); put_message(MSG_DIAL_5); 
				 break;}

		if(power)	{power=0;
				GetAllowedActions(MASK_EVT_NOPOWER);
				 if(WillSMS) put_message(MSG_SMS_1_1); if(WillCall) put_message(MSG_DIAL_1);
				 if(WillSMS) put_message(MSG_SMS_2_1); if(WillCall) put_message(MSG_DIAL_2);
				 if(WillSMS) put_message(MSG_SMS_3_1); if(WillCall) put_message(MSG_DIAL_3);
				 if(WillSMS) put_message(MSG_SMS_4_1); if(WillCall) put_message(MSG_DIAL_4);
				 if(WillSMS) put_message(MSG_SMS_5_1); if(WillCall) put_message(MSG_DIAL_5); 
				 break;}

		if(emerg)	{emerg=0;
				 put_message(MSG_SMS_1_4); put_message(MSG_DIAL_1);
				 put_message(MSG_SMS_2_4); put_message(MSG_DIAL_2);
				 put_message(MSG_SMS_3_4); put_message(MSG_DIAL_3);
				 put_message(MSG_SMS_4_4); put_message(MSG_DIAL_4);
				 put_message(MSG_SMS_5_4); put_message(MSG_DIAL_5); 
				 break;}

		break;

	case WAIT_INPUTS:
		if(btn==1)	{btn=0; flush_messages(); led=0x0001; s=DISARMED; break;}
		if(sms==SMS_DISARM)	{sms=0; flush_messages(); led=0x0001; s=DISARMED; break;}

		if((door_cnt==0) && (fire_cnt==0)
				&& (window_cnt == 0) && (move_cnt == 0) && (aux_cnt == 0)
			)
				{door=0; fire=0; window = 0; move = 0; aux = 0; led=0x0005; s=ARMED;
				GetAllowedActions(MASK_EVT_ARMED);//"  "
				 if(WillSMS) put_message(MSG_SMS_1_6); if(WillCall) put_message(MSG_DIAL_1);
				 if(WillSMS) put_message(MSG_SMS_2_6); if(WillCall) put_message(MSG_DIAL_2);
				 if(WillSMS) put_message(MSG_SMS_3_6); if(WillCall) put_message(MSG_DIAL_3);
				 if(WillSMS) put_message(MSG_SMS_4_6); if(WillCall) put_message(MSG_DIAL_4);
				 if(WillSMS) put_message(MSG_SMS_5_6); if(WillCall) put_message(MSG_DIAL_5); break;}
		if(btn==2)	{btn=0;
				 put_message(MSG_SMS_1_5); put_message(MSG_DIAL_1);
				 put_message(MSG_SMS_2_5); put_message(MSG_DIAL_2);
				 put_message(MSG_SMS_3_5); put_message(MSG_DIAL_3);
				 put_message(MSG_SMS_4_5); put_message(MSG_DIAL_4);
				 put_message(MSG_SMS_5_5); put_message(MSG_DIAL_5); break;}

		if(power)	{power=0;
				GetAllowedActions(MASK_EVT_NOPOWER);//" "
				 if(WillSMS) put_message(MSG_SMS_1_1); if(WillCall) put_message(MSG_DIAL_1);
				 if(WillSMS) put_message(MSG_SMS_2_1); if(WillCall) put_message(MSG_DIAL_2);
				 if(WillSMS) put_message(MSG_SMS_3_1); if(WillCall) put_message(MSG_DIAL_3);
				 if(WillSMS) put_message(MSG_SMS_4_1); if(WillCall) put_message(MSG_DIAL_4);
				 if(WillSMS) put_message(MSG_SMS_5_1); if(WillCall) put_message(MSG_DIAL_5); break;}

		if(emerg)	{emerg=0;
				 put_message(MSG_SMS_1_4); put_message(MSG_DIAL_1);
				 put_message(MSG_SMS_2_4); put_message(MSG_DIAL_2);
				 put_message(MSG_SMS_3_4); put_message(MSG_DIAL_3);
				 put_message(MSG_SMS_4_4); put_message(MSG_DIAL_4);
				 put_message(MSG_SMS_5_4); put_message(MSG_DIAL_5); break;}

		break;

	case ARMED:
		tone=1;

		if(btn==1)	{btn=0; flush_messages(); led=0x0001; s=DISARMED; break;}
		if(sms==SMS_DISARM)	{sms=0; flush_messages(); led=0x0001; s=DISARMED; break;}


		if(fire)	{fire=0; timer=(unsigned long)delay3*10ul; led=0x5555; s=WAIT_ALARM_FIRE;
				GetAllowedActions(MASK_EVT_FIRE);//""
				 if(WillSMS) put_message(MSG_SMS_1_2); if(WillCall) put_message(MSG_DIAL_1);
				 if(WillSMS) put_message(MSG_SMS_2_2); if(WillCall) put_message(MSG_DIAL_2);
				 if(WillSMS) put_message(MSG_SMS_3_2); if(WillCall) put_message(MSG_DIAL_3);
				 if(WillSMS) put_message(MSG_SMS_4_2); if(WillCall) put_message(MSG_DIAL_4);
				 if(WillSMS) put_message(MSG_SMS_5_2); if(WillCall) put_message(MSG_DIAL_5); break;}

		if(door)	{door=0; timer=(unsigned long)delay2*10ul; led=0x0505; s=WAIT_BUTTON; break;}

		
		if(window)	{window=0; timer=(unsigned long)delay3*10ul; led=0x5555; s=WAIT_ALARM_WINDOW;
				GetAllowedActions(MASK_EVT_WINDOW);
				 if(WillSMS) put_message(MSG_SMS_1_WINDOW); if(WillCall) put_message(MSG_DIAL_1);
				 if(WillSMS) put_message(MSG_SMS_2_WINDOW); if(WillCall) put_message(MSG_DIAL_2);
				 if(WillSMS) put_message(MSG_SMS_3_WINDOW); if(WillCall) put_message(MSG_DIAL_3);
				 if(WillSMS) put_message(MSG_SMS_4_WINDOW); if(WillCall) put_message(MSG_DIAL_4);
				 if(WillSMS) put_message(MSG_SMS_5_WINDOW); if(WillCall) put_message(MSG_DIAL_5); break;}
		if(move)	{move=0; timer=(unsigned long)delay3*10ul; led=0x5555; s=WAIT_ALARM_MOVEMENT;
				GetAllowedActions(MASK_EVT_MOVE);
				 if(WillSMS) put_message(MSG_SMS_1_MOVEMENT); if(WillCall) put_message(MSG_DIAL_1);
				 if(WillSMS) put_message(MSG_SMS_2_MOVEMENT); if(WillCall) put_message(MSG_DIAL_2);
				 if(WillSMS) put_message(MSG_SMS_3_MOVEMENT); if(WillCall) put_message(MSG_DIAL_3);
				 if(WillSMS) put_message(MSG_SMS_4_MOVEMENT); if(WillCall) put_message(MSG_DIAL_4);
				 if(WillSMS) put_message(MSG_SMS_5_MOVEMENT); if(WillCall) put_message(MSG_DIAL_5); break;}
		if(aux)	{aux=0; timer=(unsigned long)delay3*10ul; led=0x5555; s=WAIT_ALARM_AUX;
				GetAllowedActions(MASK_EVT_AUX);
				 if(WillSMS) put_message(MSG_SMS_1_AUX); if(WillCall) put_message(MSG_DIAL_1);
				 if(WillSMS) put_message(MSG_SMS_2_AUX); if(WillCall) put_message(MSG_DIAL_2);
				 if(WillSMS) put_message(MSG_SMS_3_AUX); if(WillCall) put_message(MSG_DIAL_3);
				 if(WillSMS) put_message(MSG_SMS_4_AUX); if(WillCall) put_message(MSG_DIAL_4);
				 if(WillSMS) put_message(MSG_SMS_5_AUX); if(WillCall) put_message(MSG_DIAL_5); break;}

		
		if(btn==2)	{btn=0;
				 put_message(MSG_SMS_1_5); put_message(MSG_DIAL_1);
				 put_message(MSG_SMS_2_5); put_message(MSG_DIAL_2);
				 put_message(MSG_SMS_3_5); put_message(MSG_DIAL_3);
				 put_message(MSG_SMS_4_5); put_message(MSG_DIAL_4);
				 put_message(MSG_SMS_5_5); put_message(MSG_DIAL_5); break;}

		if(power)	{power=0; timer=(unsigned long)delay3*10ul; led=0x5555; s=WAIT_ALARM_POWER; 
				GetAllowedActions(MASK_EVT_NOPOWER);//""
				 if(WillSMS) put_message(MSG_SMS_1_1); if(WillCall) put_message(MSG_DIAL_1);
				 if(WillSMS) put_message(MSG_SMS_2_1); if(WillCall) put_message(MSG_DIAL_2);
				 if(WillSMS) put_message(MSG_SMS_3_1); if(WillCall) put_message(MSG_DIAL_3);
				 if(WillSMS) put_message(MSG_SMS_4_1); if(WillCall) put_message(MSG_DIAL_4);
				 if(WillSMS) put_message(MSG_SMS_5_1); if(WillCall) put_message(MSG_DIAL_5); break;}

		if(emerg)	{emerg=0; timer=(unsigned long)delay3*10ul; led=0x5555; s=WAIT_ALARM_EMERG;
				 put_message(MSG_SMS_1_4); put_message(MSG_DIAL_1);
				 put_message(MSG_SMS_2_4); put_message(MSG_DIAL_2);
				 put_message(MSG_SMS_3_4); put_message(MSG_DIAL_3);
				 put_message(MSG_SMS_4_4); put_message(MSG_DIAL_4);
				 put_message(MSG_SMS_5_4); put_message(MSG_DIAL_5); break;}
		break;

	case WAIT_BUTTON:

		if(btn==1)	{btn=0; flush_messages(); led=0x0001; s=DISARMED; break;}
		if(sms==SMS_DISARM)	{sms=0; flush_messages(); led=0x0001; s=DISARMED; break;}

		if(timer==0)	{timer=(unsigned long)delay3*10ul; led=0x5555; s=WAIT_ALARM_DOOR; 
				GetAllowedActions(MASK_EVT_DOOR);
				 if(WillSMS) put_message(MSG_SMS_1_3); if(WillCall) put_message(MSG_DIAL_1);
				 if(WillSMS) put_message(MSG_SMS_2_3); if(WillCall) put_message(MSG_DIAL_2);
				 if(WillSMS) put_message(MSG_SMS_3_3); if(WillCall) put_message(MSG_DIAL_3);
				 if(WillSMS) put_message(MSG_SMS_4_3); if(WillCall) put_message(MSG_DIAL_4);
				 if(WillSMS) put_message(MSG_SMS_5_3); if(WillCall) put_message(MSG_DIAL_5); break;}
		break;

	case WAIT_ALARM_DOOR:
		door=0;
		OUT1_ON();
		if(btn==1)	{ btn=0; flush_messages(); OUT1_OFF(); led=0x0001; s=DISARMED; break;}
		if(sms==SMS_DISARM)	{sms=0; flush_messages(); OUT1_OFF(); led=0x0001; s=DISARMED; break;} 
		if(timer==0)	{ OUT1_OFF(); led=0x0005; s=ARMED; break;}
		break;

	case WAIT_ALARM_EMERG:
		emerg=0;
		OUT1_ON();
		if(btn==1)	{ btn=0; flush_messages(); OUT1_OFF(); led=0x0001; s=DISARMED; break;}
		if(sms==SMS_DISARM)	{sms=0; flush_messages(); OUT1_OFF(); led=0x0001; s=DISARMED; break;} 
		if(timer==0)	{ OUT1_OFF(); led=0x0005; s=ARMED; break;}
		break;

	case WAIT_ALARM_FIRE:
		fire=0;
		OUT1_ON();
		if(btn==1)	{ btn=0; flush_messages(); OUT1_OFF(); led=0x0001; s=DISARMED; break;}
		if(sms==SMS_DISARM)	{sms=0; flush_messages(); OUT1_OFF(); led=0x0001; s=DISARMED; break;} 
		if(timer==0)	{ OUT1_OFF(); led=0x0005; s=ARMED; break;}
		break;

	case WAIT_ALARM_POWER:
		power=0;
		OUT1_ON();
		if(btn==1)	{ btn=0; flush_messages(); OUT1_OFF(); led=0x0001; s=DISARMED; break;}
		if(sms==SMS_DISARM)	{sms=0; flush_messages(); OUT1_OFF(); led=0x0001; s=DISARMED; break;} 
		if(timer==0)	{ OUT1_OFF(); led=0x0005; s=ARMED; break;}
		break;

	
	case WAIT_ALARM_WINDOW:
		window=0;
		OUT1_ON();
		if(btn==1)	{ btn=0; flush_messages(); OUT1_OFF(); led=0x0001; s=DISARMED; break;}
		if(sms==SMS_DISARM)	{sms=0; flush_messages(); OUT1_OFF(); led=0x0001; s=DISARMED; break;} 
		if(timer==0)	{ OUT1_OFF(); led=0x0005; s=ARMED; break;}
		break;
	case WAIT_ALARM_MOVEMENT:
		move=0;
		OUT1_ON();
		if(btn==1)	{ btn=0; flush_messages(); OUT1_OFF(); led=0x0001; s=DISARMED; break;}
		if(sms==SMS_DISARM)	{sms=0; flush_messages(); OUT1_OFF(); led=0x0001; s=DISARMED; break;} 
		if(timer==0)	{ OUT1_OFF(); led=0x0005; s=ARMED; break;}
		break;
	case WAIT_ALARM_AUX:
		aux=0;
		OUT1_ON();
		if(btn==1)	{ btn=0; flush_messages(); OUT1_OFF(); led=0x0001; s=DISARMED; break;}
		if(sms==SMS_DISARM)	{sms=0; flush_messages(); OUT1_OFF(); led=0x0001; s=DISARMED; break;} 
		if(timer==0)	{ OUT1_OFF(); led=0x0005; s=ARMED; break;}
		break;

	default:
		break;
	}
}

int main(void)
{
	hard_init();
	flush_messages();
//	led=0xFFFF;

	delay1 = 15;
	delay2 = 10;
	delay3 = 60;
	PulseLen2 = 0;
	PulseLen3 = 0;

	//        phone.c!

	//    .     11-15.
	// &1:      
	// &2:     
	// &4:           
	settings1 = 0xffff;
	settings2 = 0xffff;
	settings3 = 0xffff;
	settings4 = 0xffff;
	settings5 = 0xffff;

	actions_sms = 0xffff;
	actions_call = 0xffff;

	while(1)
	{
		while(tick==0); tick=0;
		check_settings_validity();
		input_handler();
		phone_handler();
		alarm_handler();
	}

	return 1;
}
