/*

	new "GREEN" board !!! WITHOUT voice !!!

	Pins are:

	B5,B4	- scl,sda   (inputs, ext pullups, reserved)
	B1	- sound out (reserved)
	ADC6	- sound in  (reserved)

	B0,B2 	- LED (dual) 	
	B3	- Button to GND		(DDRB=5 PORTB=8)


	D0	- RX
	D1	- TX

	D2 	- In6
	D3 	- In5
	D4 	- In4
	D5 	- IN1 (POWER MONITOR)
	D6 	- In2
	D7 	- In3			(DDRD=2 PORTD=3)

	C0	- Out6 (CHARGER CONTROL)
	C1	- Out5
	C2	- Out4
	C3	- Out3
	C4	- Out2
	C5	- Out1			(DDRC=0x3F PORTC=0)


*/

#include <avr/io.h>
#include <avr/pgmspace.h>
#include <avr/interrupt.h>
#include <avr/pgmspace.h>
#include <string.h>
#include <stdlib.h>
#include "boot.h"
#include "enum.h"


/*************************************************/
/**		CODE SETTINGS			**/
/*************************************************/


//#define LED_DBG		1 // (!!! DEBUG PURPOSE !!!)	If defined, LED is controlled 
			  //				by phone_handler not by alarm handler

//#define VOICE 		1 // Voice playback support
#define SMS_SND		1 // Send SMS support
#define SMS_RCV		1 // Receive SMS support (If defined, then at least one of ENC_xxx must be defined)
#define ENC_GSM		1 // Decode for GSM SMS
#define ENC_UCS		1 // Decode for UCS SMS
#define ENC_ASC		1 // Decode for ASC SMS
//#define BOOTHOOK	1 // Jump to bootloader from anywhere


/*************************************************/


#define cbi(a,b)	{(a)&=255-(1<<(b));}
#define sbi(a,b)	{(a)|=(1<<(b));}

#define LED_RED()	{sbi(PORTB,0);cbi(PORTB,2);}
#define LED_GRN()	{cbi(PORTB,0);sbi(PORTB,2);}
#define LED_OFF()       {cbi(PORTB,0);cbi(PORTB,2);}

#define CHARGER_ON()	{sbi(PORTC,0);}
#define CHARGER_OFF()   {cbi(PORTC,0);}

#define BUTTON		((PINB&8)==0)
#define INPUT6		((PIND&4)==0)
#define INPUT5		((PIND&8)==0)
#define INPUT4		((PIND&16)==0)
#define INPUT2		((PIND&64)==0)
#define INPUT3		((PIND&128)==0)
//#define NOPOWER		((PIND&32)==0)

#define OUT1_ON()	{PORTC|=0x20;}
#define OUT1_OFF()	{PORTC&=(0xff-0x20);}
#define OUT2_ON()	{PORTC|=0x10;}
#define OUT2_OFF()	{PORTC&=(0xff-0x10);}
#define OUT3_ON()	{PORTC|=0x08;}
#define OUT3_OFF()	{PORTC&=(0xff-0x08);}
//#define OUT4_ON()	{PORTC|=0x04;}
//#define OUT4_OFF()	{PORTC&=(0xff-0x04);}
//#define OUT5_ON()	{PORTC|=0x02;}
//#define OUT5_OFF()	{PORTC&=(0xff-0x02);}

#define CAN_SEND_SMS1 ((settings1&1))
#define CAN_SEND_SMS2 ((settings2&1))
#define CAN_SEND_SMS3 ((settings3&1))
#define CAN_SEND_SMS4 ((settings4&1))
#define CAN_SEND_SMS5 ((settings5&1))

#define CAN_DIAL1 ((settings1&2))
#define CAN_DIAL2 ((settings2&2))
#define CAN_DIAL3 ((settings3&2))
#define CAN_DIAL4 ((settings4&2))
#define CAN_DIAL5 ((settings5&2))

#define CAN_DIAL_IN1 ((settings1&4))
#define CAN_DIAL_IN2 ((settings2&4))
#define CAN_DIAL_IN3 ((settings3&4))
#define CAN_DIAL_IN4 ((settings4&4))
#define CAN_DIAL_IN5 ((settings5&4))

unsigned int	settings1 = 0xffff;
unsigned int	settings2 = 0xffff;
unsigned int	settings3 = 0xffff;
unsigned int	settings4 = 0xffff;
unsigned int	settings5 = 0xffff;

unsigned int actions_sms; //  20,   main.c
unsigned int actions_call; //  21



#define XTAL		4608000 // 2.3.2
#define GOTO_BOOT()	{asm("rjmp 0x1F80");}  // mega168

#define BAUD_19200	(((XTAL/19200)/8)-1)
#define BAUD_38400	(((XTAL/38400)/8)-1)
#define BAUD_57600	(((XTAL/57600)/8)-1)

unsigned char sbuf[360];
unsigned char rbuf[180];
volatile unsigned char flags=0;
volatile unsigned char battery;

#define OK	1
#define ERROR	2
#define NUMBER	4
#define SMS	8
#define PROMPT	16
#define NOCONN	32
#define BATT	64
#define TIMEOUT	128


void hard_init(void);
void ADC_init(void); //v.2.3.1
void StartEEread(unsigned int addr);
void Say(unsigned char addr, unsigned char len);
void uart(unsigned char b);
void at(PGM_P cmd);
void dial(unsigned char *num);
unsigned char hex2bin(unsigned char c);
unsigned char bin2hex(unsigned char n);
unsigned int win2uni(unsigned char c);
unsigned char create_pdu_mem(const unsigned char *num, const unsigned char *msg/*, unsigned char mem*/);
void parse(unsigned char c);
void phone_handler(void);


//==========================================
//
//	On-chip peripheral init

void hard_init(void)
{
//v.2.3.1
	DDRB=5;
	PORTB=8; //  MOSI - 
	DDRD=2;
	PORTD=0xff; //  -  
	DDRC=0x3F;
	PORTC=0;
//v.2.3.1 end changes

	uart(BAUD_19200);
	
	ADC_init();//v.2.3.1

#ifdef VOICE

	TCNT1H = 0;		// Clear timer
	TCNT1L = 0;
	OCR1AH = 0;		// Clear output compare register
	OCR1AL = 0xFF;		// !!! TEST TEST TEST !!!
	TCCR1A = 0x81;		// OC1A - PWM output, Fast PWM mode.
	TCCR1B = 0x09;		// Fast 8-bit PWM, clk = XTAL, RUN!

#endif

// 2.3.2	TCCR0B=3;		// Prescaler = 64
	TCCR0B=2;		// 2.3.2 Prescaler = 8
	TIMSK0=1;		// Enable Timer0 overflow interrupt
	TIFR0=1;		// Clear interrupt flag
// 2.3.2	TCNT0=256-5;		// Reset Timer0
	TCNT0=256-44; //2.3.2		// Reset Timer0

	sei();
}

void ADC_init(void)
{
	// PRR &= ~(1<<PRADC); // enable ADC in power reduction- this register is iniitially 0

	ADMUX = (1<<REFS1) | (1<<REFS0) | (1<<ADLAR) | // internal 1.1V, left-adjusted, 
		(0<<MUX3) | (1<<MUX2) | (1<<MUX1) | (1<<MUX0); // channel ADC7
	
	ADCSRB = 0;  // free running ADC

	ADCSRA = (1<<ADEN) | (1<<ADSC) | (1<<ADATE) | // ADC enable, start, cyclic conversion
		(1<<ADPS2) | (1<<ADPS1) | (1<<ADPS0); // CLK/128 (8000/128 = 62 kHz is inside (50-150) khz interval)
	
}

//	On-chip peripheral init
//
//==========================================


#ifdef VOICE

//=================================
//
// Software-driven I2C

extern char i2c_start_wr(char b);
extern char i2c_wr(char b);
extern char i2c_rd_seq(void);
extern char i2c_rd_stop(void);
extern void i2c_stop(void);

extern char i2c_rd_0(void);
extern char i2c_rd_1(void);
extern char i2c_rd_2(void);

// EEPROM related

void StartEEread(unsigned int addr)
{
        i2c_start_wr(0xA0);
        i2c_wr(addr/256);
        i2c_wr(addr&255);
        i2c_stop();
        i2c_start_wr(0xA1);
}

volatile unsigned char sound_value=128;
volatile unsigned char sound_step=1;
volatile unsigned int sound_length = 0;
volatile unsigned int sound_counter = 0;
extern unsigned char sound_decode(unsigned char input);

void Say(unsigned char addr, unsigned char len)
{
	StartEEread(addr<<8);
	sound_value=128; 
	sound_step=1;
	sound_length = len<<8;
}

// Software-driven I2C
//
//=================================

#endif

//==========================================
//
//	SERIAL INTERFACE


SIGNAL(SIG_USART_RECV)                  	
{
	parse(UDR0);
}
volatile unsigned char * sendptr;

SIGNAL(SIG_USART_DATA)
{
unsigned char c;
	if (sendptr==NULL) {cbi(UCSR0B,UDRIE0); return; }	// Disable this interrupt
	c=*sendptr; 
	if(c) { UDR0=c; sendptr++; }
	else  {cbi(UCSR0B,UDRIE0);}	// Disable this interrupt
}

static void Send(unsigned char *str)
{
	if (str==NULL) return;
	if (*str==0)   return;
	sendptr=str;
	UDR0=*sendptr++;
	sbi(UCSR0B,UDRIE0);
}

SIGNAL(SIG_USART_TRANS) { sendptr=NULL; }


void uart(unsigned char b)
{
	UCSR0B = 0x00;		// Default (Disable ALL)
	UCSR0A = 0x42;		// Default
	UCSR0B = 0xD8;		// RXIE, TXcompleteIE,TXEN,RXEN
	UCSR0C = 0x86;		// Default
	UBRR0L = b;		// Baud rate
	UBRR0H = 0;
}

//
//	SERIAL INTERFACE
//==========================================


//==========================================
//
//	TIMER routine

volatile unsigned int prescaler=1440;
volatile unsigned int timer=1;
volatile unsigned int led=0;
volatile unsigned int tick=0;

SIGNAL(SIG_OVERFLOW0)
{

// 2.3.2	TCNT0=256-11;			// Fovf = 8000000/64/11 = 11363 Hz
	TCNT0=256-44; //2.3.2			// Fovf = 4000000/8/44 = 11363 Hz

	prescaler--;
	if(prescaler==0)
	{
		prescaler=1136;		// Ftime = 10 Hz
		if(tick<255) tick++;
#ifndef LED_DBG
		if (led&1) {LED_RED(); led>>=1; led|=32768;} 
		else 	   {LED_OFF(); led>>=1;}
#endif
		if(timer)  {timer--; if(!timer) flags|=TIMEOUT;}
	}
}

//	TIMER routine
//
//==========================================


//==========================================
//
//	PHONE INTERFACE

void at(PGM_P cmd)
{
	strcpy_P(sbuf,cmd);
	timer=20;		// 2 seconds
	flags=0;
	Send(sbuf);
}

void getnum(unsigned char num)	//!!! BCD !!!
{
	sbuf[0]='A'; sbuf[1]='T'; sbuf[2]='+';
	sbuf[3]='C'; sbuf[4]='P'; sbuf[5]='B'; 
	sbuf[6]='R'; sbuf[7]='=';
	if (num&0xF0)
	{
		sbuf[8]=(num>>4)+'0';
		sbuf[9]=(num&15)+'0';
		sbuf[10]='\r';
		sbuf[11]=0;
	}
	else
	{
		sbuf[8]=(num&15)+'0';
		sbuf[9]='\r';
		sbuf[10]=0;
	}
	timer=20;		// 2 seconds
	flags=0;
	Send(sbuf);
}

unsigned char numcmp(unsigned char* n1,unsigned char* n2)
{
unsigned char i;
	for(i=0;i<15;i++) { if (n1[i]==0) {n1+=i; break;} }
	for(i=0;i<15;i++) { if (n2[i]==0) {n2+=i; break;} }
	for(i=7;i>0;i--) { if (*(n1-i)!=*(n2-i)) return 1;}
	return 0;
}

void dial(unsigned char *num)
{
unsigned char c;
	sbuf[0]='A'; sbuf[1]='T'; sbuf[2]='D';
	strcpy(sbuf+3,num);
	c=strlen(sbuf);
	sbuf[c]=';'; sbuf[c+1]=13; sbuf[c+2]=0;
	timer=200;		// 20 seconds
	flags=0;
	Send(sbuf);
}

unsigned char hex2bin(unsigned char c)  
{
	return( (((c)&0x4F)&0x40) ? (((c)&0x4F)-0x37) : ((c)&0x4F) );
}

unsigned char bin2hex(unsigned char n)
{
	n=n&0x0F; if(n>9) return n-10+'A'; else return n+'0';
}

unsigned int win2uni(unsigned char c)
{
	if (c<128) return c;
	if (c>=0xC0) return 0x410+c-0xC0;	// (cyrillic main alphabet)
	return '.';
}

#ifdef SMS_SND
unsigned char create_pdu_mem(const unsigned char *num, const unsigned char *msg)
{
unsigned char i;
unsigned char j;
unsigned char n;
unsigned int u;

	for (i=0;i<7;i++) sbuf[i]='0'; 		// Make pattern
	sbuf[3]='1'; 
	sbuf[9]='1';

	if (num[0]=='+') {sbuf[8]='9'; i=1;} 	// If the number is international
	else {sbuf[8]='8'; i=0;}
	j=11; n=0;
	while((num[i]<='9')&&(num[i]>='0'))	// Number
	{
		sbuf[j]=num[i++]; 
		n++;
		if(j&1) j--; else j+=3;		
	}
	if(n&1) {sbuf[j]='F'; j+=2;} else j-=1;	// align to byte boundary

	sbuf[7]=bin2hex(n);			// length of number
	sbuf[6]=bin2hex(n>>4);

	sbuf[j++]='0'; 				// Protocol Phone-to-phone, Operator specific
	sbuf[j++]='0'; 
	sbuf[j++]='0'; 				// Charset UNICODE
	sbuf[j++]='8';

	n=j; j+=2; i=0;				// Encode the message
    while((u=win2uni(pgm_read_byte(msg+i)))!=0)
    {
        sbuf[j++] = bin2hex(u>>12);
        sbuf[j++] = bin2hex(u>>8);
        sbuf[j++] = bin2hex(u>>4);
        sbuf[j++] = bin2hex(u);
        i++;
    }
	i<<=1; 					// Length of message (UNICODE is twice longer)
	sbuf[n++]=bin2hex(i>>4);
	sbuf[n++]=bin2hex(i);
	sbuf[j]=0x1A;				// End of pdu
	sbuf[j+1]=13;				// End of the string
	sbuf[j+2]=0;				// End of the string
	return ((j>>1)-1);			// Length of pdu for +CMGS command
}

unsigned char tbuf[15];

void send_sms_1(const unsigned char *num, const unsigned char *msg)
{
unsigned char l;
	l=create_pdu_mem(num,msg);
	tbuf[0]='A'; tbuf[1]='T'; tbuf[2]='+';
	tbuf[3]='C'; tbuf[4]='M'; tbuf[5]='G'; tbuf[6]='S'; tbuf[7]='=';
	if(l<100){tbuf[8]=(l/10)+'0'; tbuf[9]=(l-(l/10)*10)+'0'; tbuf[10]=13; tbuf[11]=0;}
	else
	{
		tbuf[8]=(l/100)+'0'; 
		l -= (l/100)*100;
		tbuf[9]=(l/10)+'0'; 
		l -= (l/10)*10;
		tbuf[10]= l + '0'; 
		tbuf[11]=13; 
		tbuf[12]=0;
	}
	timer=30; flags=0; Send(tbuf);
}
void send_sms_2(void)
{
	timer=250; flags=0; Send(sbuf);
}

#endif

void parse(unsigned char c)
{
static unsigned char n=0;
static unsigned char s=0;

	if (UBRR0L==BAUD_57600)
	{
		
		if ((n==4)&&(c==6)) { flags|=OK; return; }
#ifdef BOOTHOOK
		if ((n==0x1C)&&(c==0x1C)) { BootEntry(); return; }
#endif
		s=0; n=c; return;
	}
	else
	{
#ifdef BOOTHOOK
		if (c==0xAD) { BootEntry(); return; }
#endif
		if ((c=='\r')||(c=='\n'))
		{
			if(s>=15)
			{
				rbuf[n]=0; n=0; flags|=SMS;
			}
			s=0; return;
		}
	}

	switch(s)
	{
	case 0:						// New Line
		if(c=='O') {flags|=OK; s=7; break;}	// OK
		if(c=='E') {flags|=ERROR; s=7; break;}	// Error
		if(c=='N') {flags|=NOCONN; s=7; break;}	// NO (answer,connect,carrier)
		if(c=='+') {s=1; break;}                // BATT
#ifdef SMS_RCV
		if(c=='0') {s=12; break;}		// For SMS reading/receiving
#endif
		if(c=='>') {flags|=PROMPT; break;}	// For SMS sending
		s=7; break;
	case 1:						// Plus		
		s++; break;
	case 2:						// PlusC
		if(c=='B') {n=3; s++; break;}
		if(c=='L') {n=4; s=10; break;}		// +CLIP: (OLD 35 support)
#ifdef SMS_RCV
		if(c=='M') {flags|=SMS; s=7; break;} // +CMTI: new SMS arrived
#endif
		s=8; break;
	case 3:						// SkipN
		n--; if(n==0) {s++; break;}
                break;
	case 4:						// BATT
		if(c=='1') {battery=0; flags|=BATT; s++; break;}
		if(c=='0') {battery=0; flags&=(255^BATT); s++; break;}
		s=7; break;
	case 5:
		s++; break;
	case 6:
		if((c>='0')&&(c<='9')) {battery*=10; battery+=(c-'0'); break;}
		s++; break;
	default:
	case 7:						// Skip All
		break;
	case 8:						// Wait Quote
		if(c=='"') {n=0; s=9; break;}
		break;
	case 9:						// Number
		if(c=='"') {rbuf[n]=0; n=0; flags|=NUMBER; s=7; break;}
		if(c==',') {rbuf[n]=0; n=0; flags|=NUMBER; s=7; break;}
		rbuf[n]=c; n++; break;	
	case 10:					// Number
		n--; if(n==0) {s++; break;}
                break;
	case 11:					// Number
		if(c=='+') {n=0; s=9; rbuf[n]=c; n++; break;}
		if(c=='"') {n=0; s=9; break;}
		break;


// SMS //===================================================================
#ifdef SMS_RCV
static unsigned char a=0;
static unsigned char b=0;

	case 12:					// PDU
		c=hex2bin(c); n=c*2+3; s++;
		break;
	case 13:					// SkipN
		n--; if(n==0) {s++; break;}
                break;
	case 14:					// PDU1
		c=hex2bin(c); if(c&1) c++; n=c+5; s++;
                break;
	case 15:					// SkipN		
		n--; if(n==0) {s++; break;}
                break;
	case 16:					// PDU2
		n=16;
#ifdef ENC_GSM
		if(c=='0') {s=17; break;}
#endif
#ifdef ENC_UCS
		if(c=='8') {s=32; break;}
#endif
#ifdef ENC_ASC
		if(c=='4') {s=38; break;}
#endif
		s=7; break;
// GSM //===================================================================
#ifdef ENC_GSM
	case 17:					// GSM
		n--; if(n==0) {s++; break;}
                break;

	case 18:					// GSM1
		c=hex2bin(c);
		if (c&8) b=1; else b=0;
		a=(c<<4); a&=0x7f;
		s++; break;
	case 19:					// GSM2
		c=hex2bin(c);
		a+=c; 
		rbuf[n]=a; n++; a=b;
		s++; break;
	case 20:					// GSM3
		c=hex2bin(c);
		b=c>>2; a+=c<<5; a&=0x7f; 
		s++; break;
	case 21:					// GSM4
		c=hex2bin(c);
		a+=c<<1;
		rbuf[n]=a; n++; a=b;
		s++; break;
	case 22:					// GSM5
		c=hex2bin(c);
		if (c&1) a+=64;
		b=c>>1;
		s++; break;
	case 23:					// GSM6
		c=hex2bin(c);
		a+=c<<2;
		rbuf[n]=a; n++; a=b;
		s++; break;
	case 24:					// GSM7
		c=hex2bin(c);
		b=c;
		s++; break;
	case 25:					// GSM8
		c=hex2bin(c);
		a+=c<<3;
		rbuf[n]=a; n++; a=b;
		s++; break;
	case 26:					// GSM9
		c=hex2bin(c);
		b=c<<1;
		s++; break;
	case 27:					// GSM10
		c=hex2bin(c);
		if (c&8) b++;
		a+=(c<<4); a&=0x7f;
		rbuf[n]=a; n++; a=b;
		s++; break;
	case 28:					// GSM11
		c=hex2bin(c);
		b=c<<2;
		s++; break;
	case 29:					// GSM12
		c=hex2bin(c);
		b+=(c>>2);
		a+=(c<<5); a&=0x7F;
		rbuf[n]=a; n++; a=b;
		s++; break;
	case 30:					// GSM13
		c=hex2bin(c);
		b=c<<3;
		s++; break;
	case 31:					// GSM14
		c=hex2bin(c);
		if (c&1) a+=64;
		rbuf[n]=a; n++;
		b+=(c>>1);
		rbuf[n]=b; n++;
		s=18; break;
#endif	// SMS_GSM
// UCS //===================================================================
#ifdef ENC_UCS
	case 32:					// UCS
		n--; if(n==0) {s++; break;}
                break;
	case 33:					// UCS0
		s++; break;
	case 34:					// UCS1
		if (c=='4') {s=36; break;}
		s++; break;
	case 35:					// UCS2 (not CYR)
		a=hex2bin(c);
		s=37; break;
	case 36:					// UCS3 (CYR)
		a=hex2bin(c); a=a+11;
		s++; break;
	case 37:					// UCS4
		rbuf[n]=(a<<4)+hex2bin(c); n++;
		s=33; break;
#endif // SMS_UCS
// ASC //===================================================================
#ifdef ENC_ASC
	case 38:					// ASC
		n--; if(n==0) {s++; break;}
                break;
	case 39:					// ASC
		a=hex2bin(c); s++; break;
	case 40:					// ASC
		rbuf[n]=(a<<4)+hex2bin(c); n++;
		s=39; break;
#endif	// SMS_ASC
#endif	// SMS_RCV
	}
}




unsigned char AT[]	PROGMEM = "AT\r"; 		// Check the phone
unsigned char ON[]	PROGMEM = {5,2,7,6,12,0};	// Switch the phone on ( Answer={5,1,4,6} )
unsigned char ATPIN[]	PROGMEM = "AT+CPIN=0000\r";	// Enter pin code

unsigned char ATZ[]	PROGMEM = "AT&F\r";             // Reset settings to default states
unsigned char ATE0[]	PROGMEM = "ATE0\r";             // Echo off
unsigned char ATPBS[]	PROGMEM = "AT+CPBS=\"SM\"\r";   // SIM phonebook
unsigned char ATCSCS[]	PROGMEM = "AT+CSCS=\"UCS2\"\r"; // UCS encoding

//unsigned char ATPBR[]	PROGMEM = "AT+CPBR=";	        // Get number 1

unsigned char ATCBC[]	PROGMEM = "AT+CBC\r";		// Requset for power state

unsigned char ATCOLP[]	PROGMEM = "AT+COLP=1\r";	// Report picking up
unsigned char ATCLIP[]	PROGMEM = "AT+CLIP=1\r";	// Report incoming call
unsigned char ATA[]	PROGMEM = "ATA\r";		// Answer
unsigned char ATH[]	PROGMEM = "ATH\r";		// Hangup

unsigned char ATPMS[]	PROGMEM = "AT+CPMS=\"SM\",\"SM\",\"SM\"\r";	// SIM message store                   
unsigned char ATMGL0[]	PROGMEM = "AT+CMGL=0\r";        		// Get unread messages
unsigned char ATMGD1[]	PROGMEM = "AT+CMGD=1\r";	       		// Erase first message from storage
unsigned char ATNMI[]	PROGMEM = "AT+CNMI=1,1\r";	       		// Report incoming SMS 
//unsigned char ATNMI[]	PROGMEM = "AT+CNMI=1,2\r";	       		// Report incoming SMS with TEXT 

unsigned char ATVTS1[]	PROGMEM = "AT+VTS=1\r";	       		// Report armed 
unsigned char ATVTS2[]	PROGMEM = "AT+VTS=5\r";	       		// Report disarmed
unsigned char ATVTS3[]	PROGMEM = "AT+VTS=9\r";	       		// Report armed 

unsigned char TXT_PWRFAIL[]	PROGMEM = " ";
unsigned char TXT_FIRE[]	PROGMEM = "";
unsigned char TXT_DOOROPEN[]	PROGMEM = "";
unsigned char TXT_MOVEMENT[]	PROGMEM = "  ";//2.3.3
unsigned char TXT_WINDOW[]	PROGMEM = "  ";//2.3.3
unsigned char TXT_AUX[]	PROGMEM = " . ";//2.3.3
unsigned char TXT_ALMBUTTON[]	PROGMEM = "  ";
unsigned char TXT_TEST[]	PROGMEM = "";
unsigned char TXT_ARMED[]	PROGMEM = "  ";
unsigned char TXT_DISARMED[]	PROGMEM = "  ";
unsigned char TXT_ERR_DOOR[]	PROGMEM = "  ";
unsigned char TXT_ERR_FIRE[]	PROGMEM = "  ";
unsigned char TXT_ERR_WINDOW[]	PROGMEM = "  ";//2.3.3
unsigned char TXT_ERR_MOVEMENT[]	PROGMEM = "  ";//2.3.3
unsigned char TXT_ERR_AUX[]	PROGMEM = " . ";//2.3.3

//  : TXT_STAT_abc a=. b=.2 c=..3
unsigned char TXT_STAT_000[]	PROGMEM = "  ., .2 ., .3 .";
unsigned char TXT_STAT_001[]	PROGMEM = "  ., .2 ., .3 .";
unsigned char TXT_STAT_010[]	PROGMEM = "  ., .2 ., .3 .";
unsigned char TXT_STAT_011[]	PROGMEM = "  ., .2 ., .3 .";
unsigned char TXT_STAT_100[]	PROGMEM = " , .2 ., .3 .";
unsigned char TXT_STAT_101[]	PROGMEM = " , .2 ., .3 .";
unsigned char TXT_STAT_110[]	PROGMEM = " , .2 ., .3 .";
unsigned char TXT_STAT_111[]	PROGMEM = " , .2 ., .3 .";


#define MAX_MESSAGES	80

unsigned char message_queue[MAX_MESSAGES];
unsigned char queued_messages=0;

unsigned char get_message(void)
{
unsigned char c;
unsigned char i;
	if(queued_messages==0) return 0;
	c=message_queue[0];
	for(i=0;i<(MAX_MESSAGES-1);i++) 
	  { message_queue[i]=message_queue[i+1]; }
	message_queue[i]=0;
	queued_messages--;
	return c;
}

void put_message(unsigned char m)
{
	while (queued_messages>=MAX_MESSAGES)
	{
		get_message();
	}
	message_queue[queued_messages]=m;
	queued_messages++;
}

void flush_messages(void)
{
unsigned char i;
	for(i=0;i<(MAX_MESSAGES);i++) { message_queue[i]=0; }
	queued_messages=0;
}



unsigned char	num1[15];
unsigned char	num2[15];
unsigned char	num3[15];
unsigned char	num4[15];
unsigned char	num5[15];

//2.3.3
//     
unsigned char	passArm[12];
//     
unsigned char	passDisarm[12];

//     2
unsigned char	passOut2On[12];
//     2
unsigned char	passOut2Off[12];
//     2
unsigned int	PulseLen2;// 0 -   ,     

//     3
unsigned char	passOut3On[12];
//     3
unsigned char	passOut3Off[12];
//     3
unsigned int	PulseLen3;// 0 -   ,     

unsigned char	passState[12]; //    
//end 2.3.3

unsigned char	temp[20];

unsigned int	delay1;
unsigned int	delay2;
unsigned int	delay3;

unsigned char	tone;
unsigned char	sms=0;   // enum SMS

void phone_handler(void)
{
static unsigned char s=0;
static unsigned char ss=0;
static unsigned char n=0;
static void *dest;
	
	switch(s)
	{
	default:
		s=0; break;
// Test if phone is switched on
	case 0:
		uart(BAUD_19200); timer=20; flags=0; s++; break;
	case 1:
		if (flags&TIMEOUT) 	{s++; break;}
		break;
	case 2:
		at(AT); s++; break;

	case 3:
		if(flags&OK) 	  	{s=11; break;}			//!!!
		if(flags&TIMEOUT) 	{uart(BAUD_57600); CHARGER_OFF(); timer=30; flags=0; s++; break;}
		break;

// Switch the phone on
	case 4:
		if (flags&TIMEOUT) 	{CHARGER_ON(); timer=30; flags=0; s++; break;}
		break;
	case 5:
		if (flags&TIMEOUT) 	{s++; break;}
		break;
	case 6:
		at(ON); s++; break;
	case 7:
		if(flags&TIMEOUT) 	{uart(BAUD_19200); timer=50; flags=0; s++; break;}
		break;
	case 8:
		if (flags&TIMEOUT) 	{ss=3; s++; break;}
		break;
	case 9:
		at(ATPIN); timer=100; s++; break;	// 10 seconds
	case 10:
		if(flags&OK) 	 {timer=50; flags=0; s++; break;}
		if(flags&ERROR) 	
		{
			if(--ss) {s--; break;}
			else	 {s=0; break;}
		}
		if(flags&TIMEOUT)
		{
			if(--ss) {s--; break;}
			else	 {timer=50; flags=0; s++; break;}
		}
		break;

// Initialize the phone
	case 11:
		if (flags&TIMEOUT) 	{at(ATZ); s++; break;}
		break;
		
	case 12:
		if(flags&OK)		{s++; break;}
		if(flags&TIMEOUT)	{s=0; break;}
		break;
	case 13:
		at(ATE0); s++; break;
	case 14:
		if(flags&OK)		{s++; break;}
		if(flags&TIMEOUT)	{s=0; break;}
		break;
	case 15:
		at(ATPBS); s++; break;
	case 16:
		if(flags&OK)		{s++; break;}
		if(flags&TIMEOUT)	{s=0; break;}
		break;

// Initialize the message storage
	case 17:
		at(ATPMS); s++; break;
	case 18:
		if(flags&OK)		{s++; break;}
		if(flags&TIMEOUT)	{s=0; break;}
		break;
	case 19:
		at(ATCSCS); s++; break;
	case 20:
		if(flags&OK)		{s++; break;}
		if(flags&TIMEOUT)	{s=0; break;}
		break;
	case 21:
		at(ATMGD1); s++; 
		timer = 30; // DVK 073010    -        
		break;
	case 22:
		if(flags&OK)		{s++; break;}
		if(flags&TIMEOUT)	{s=0; break;}
		break;

// Switch exdended indicators on
	case 23:
		at(ATNMI); s++; break;
	case 24:
		if(flags&(OK|ERROR))	{s++; break;}
		if(flags&TIMEOUT)	{s=0; break;}
		break;
	case 25:
		at(ATCOLP); s++; break;
	case 26:
		if(flags&(OK|ERROR))	{s++; break;}
		if(flags&TIMEOUT)	{s=0; break;}
		break;
	case 27:
		at(ATCLIP); s++; break;
	case 28:
		if(flags&TIMEOUT)	{s=0; break;}
		if(flags&OK)		{CHARGER_ON(); n=60; s=29; timer=100; flags=0; break;} //!!!
		break;

// MAIN LOOP
	
	case 29:	// charger on state (off before cbc)
	case 32:	// charger on state (off before cbc)
	case 36:	// charger off state (before cbc)

		if(flags&SMS)		{ at(ATMGL0); ss=s; s=55; break; }
		if(flags&NUMBER)	
			{ 
				if    (	
					(numcmp(num1,rbuf)==0)||
					(numcmp(num2,rbuf)==0)||
					(numcmp(num3,rbuf)==0)||
					(numcmp(num4,rbuf)==0)||
					(numcmp(num5,rbuf)==0)  )

					{at(ATA); ss=s; s=46; break;}
				else
					{at(ATH); break;}
			}
		if(flags&TIMEOUT) 	{ s++; break; }

		{
		unsigned char* pNum = NULL;
		PGM_P pMsg; //    pNum,    pMsg!

		switch(get_message())
		{
		default:
		case MSG_NULL:
			break;
		case MSG_GETNUM1:
			getnum(0x01); dest=num1; ss=s; s=40; break;
		case MSG_GETNUM2:
			getnum(0x02); dest=num2; ss=s; s=40; break;
		case MSG_GETNUM3:
			getnum(0x03); dest=num3; ss=s; s=40; break;
		case MSG_GETNUM4:
			getnum(0x04); dest=num4; ss=s; s=40; break;
		case MSG_GETNUM5:
			getnum(0x05); dest=num5; ss=s; s=40; break;

		//     11-15
		case MSG_GETNUM11:
			getnum(0x11); dest=&settings1; ss=s; s=41; break; // 41 - decode UINT
		case MSG_GETNUM12:
			getnum(0x12); dest=&settings2; ss=s; s=41; break;
		case MSG_GETNUM13:
			getnum(0x13); dest=&settings3; ss=s; s=41; break;
		case MSG_GETNUM14:
			getnum(0x14); dest=&settings4; ss=s; s=41; break;
		case MSG_GETNUM15:
			getnum(0x15); dest=&settings5; ss=s; s=41; break;

		case MSG_GETNUM20:
			getnum(0x20); dest=&actions_sms; ss=s; s=41; break;
		case MSG_GETNUM21:
			getnum(0x21); dest=&actions_call; ss=s; s=41; break;

		case MSG_GETNUM30:
			getnum(0x30); dest=passArm; ss=s; s=40; break;
		case MSG_GETNUM31:
			getnum(0x31); dest=passDisarm; ss=s; s=40; break;
		case MSG_GETNUM32:
			getnum(0x32); dest=passOut2On; ss=s; s=40; break;
		case MSG_GETNUM33:
			getnum(0x33); dest=passOut2Off; ss=s; s=40; break;
		case MSG_GETNUM34:
			getnum(0x34); dest=&PulseLen2; ss=s; s=41; break;
		case MSG_GETNUM35:
			getnum(0x35); dest=passOut3On; ss=s; s=40; break;
		case MSG_GETNUM36:
			getnum(0x36); dest=passOut3Off; ss=s; s=40; break;
		case MSG_GETNUM37:
			getnum(0x37); dest=&PulseLen3; ss=s; s=41; break;
		case MSG_GETNUM38:
			getnum(0x38); dest=passState; ss=s; s=40; break;

		case MSG_GETNUM40:
			getnum(0x40); dest=&delay1; ss=s; s=41; break;
		case MSG_GETNUM41:
			getnum(0x41); dest=&delay2; ss=s; s=41; break;
		case MSG_GETNUM42:
			getnum(0x42); dest=&delay3; ss=s; s=41; break;


		case MSG_SMS_1_1:
//			if(num1[0]) {send_sms_1(num1,TXT_PWRFAIL); ss=s; s=42; break;} break;
			if(!CAN_SEND_SMS1) break;
			pNum = num1;pMsg = TXT_PWRFAIL; break;
		case MSG_SMS_1_2:
			//if(num1[0]) {send_sms_1(num1,TXT_FIRE); ss=s; s=42; break;} break;
			if(!CAN_SEND_SMS1) break;
			pNum = num1;pMsg = TXT_FIRE; break;
		case MSG_SMS_1_3:
			//if(num1[0]) {send_sms_1(num1,TXT_DOOROPEN); ss=s; s=42; break;} break;
			if(!CAN_SEND_SMS1) break;
			pNum = num1;pMsg = TXT_DOOROPEN; break;
		case MSG_SMS_1_4:
			//if(num1[0]) {send_sms_1(num1,TXT_ALMBUTTON); ss=s; s=42; break;} break;
			if(!CAN_SEND_SMS1) break;
			pNum = num1;pMsg = TXT_ALMBUTTON; break;
		case MSG_SMS_1_5:
			//if(num1[0]) {send_sms_1(num1,TXT_TEST); ss=s; s=42; break;} break;
			if(!CAN_SEND_SMS1) break;
			pNum = num1;pMsg = TXT_TEST; break;
		case MSG_SMS_1_6:
			//if(num1[0]) {send_sms_1(num1,TXT_ARMED); ss=s; s=42; break;} break;
			if(!CAN_SEND_SMS1) break;
			pNum = num1;pMsg = TXT_ARMED; break;
		case MSG_SMS_1_7:
			//if(num1[0]) {send_sms_1(num1,TXT_ERR_DOOR); ss=s; s=42; break;} break;
			if(!CAN_SEND_SMS1) break;
			pNum = num1;pMsg = TXT_ERR_DOOR; break;
		case MSG_SMS_1_8:
			//if(num1[0]) {send_sms_1(num1,TXT_ERR_FIRE); ss=s; s=42; break;} break;
			if(!CAN_SEND_SMS1) break;
			pNum = num1;pMsg = TXT_ERR_FIRE; break;
		case MSG_SMS_1_DISARMED:
			if(!CAN_SEND_SMS1) break;
			pNum = num1;pMsg = TXT_DISARMED; break;
		case MSG_SMS_1_MOVEMENT:
			if(!CAN_SEND_SMS1) break;
			pNum = num1;pMsg = TXT_MOVEMENT; break;
		case MSG_SMS_1_WINDOW:
			if(!CAN_SEND_SMS1) break;
			pNum = num1;pMsg = TXT_WINDOW; break;
		case MSG_SMS_1_AUX:
			if(!CAN_SEND_SMS1) break;
			pNum = num1;pMsg = TXT_AUX; break;
		case MSG_SMS_1_ERR_WINDOW:
			if(!CAN_SEND_SMS1) break;
			pNum = num1;pMsg = TXT_ERR_WINDOW; break;
		case MSG_SMS_1_ERR_MOVEMENT:
			if(!CAN_SEND_SMS1) break;
			pNum = num1;pMsg = TXT_ERR_MOVEMENT; break;
		case MSG_SMS_1_ERR_AUX:
			if(!CAN_SEND_SMS1) break;
			pNum = num1;pMsg = TXT_ERR_AUX; break;

		//2.3.3
		case MSG_SMS_1_STATE000:
			//if(num1[0]) {send_sms_1(num1,TXT_STAT_000); ss=s; s=42; break;} break;
			pNum = num1;pMsg = TXT_STAT_000; break;
		case MSG_SMS_1_STATE001:
			//if(num1[0]) {send_sms_1(num1,TXT_STAT_001); ss=s; s=42; break;} break;
			pNum = num1;pMsg = TXT_STAT_001; break;
		case MSG_SMS_1_STATE010:
			//if(num1[0]) {send_sms_1(num1,TXT_STAT_010); ss=s; s=42; break;} break;
			pNum = num1;pMsg = TXT_STAT_010; break;
		case MSG_SMS_1_STATE011:
			//if(num1[0]) {send_sms_1(num1,TXT_STAT_011); ss=s; s=42; break;} break;
			pNum = num1;pMsg = TXT_STAT_011; break;
		case MSG_SMS_1_STATE100:
			//if(num1[0]) {send_sms_1(num1,TXT_STAT_100); ss=s; s=42; break;} break;
			pNum = num1;pMsg = TXT_STAT_100; break;
		case MSG_SMS_1_STATE101:
			//if(num1[0]) {send_sms_1(num1,TXT_STAT_101); ss=s; s=42; break;} break;
			pNum = num1;pMsg = TXT_STAT_101; break;
		case MSG_SMS_1_STATE110:
			//if(num1[0]) {send_sms_1(num1,TXT_STAT_110); ss=s; s=42; break;} break;
			pNum = num1;pMsg = TXT_STAT_110; break;
		case MSG_SMS_1_STATE111:
			//if(num1[0]) {send_sms_1(num1,TXT_STAT_111); ss=s; s=42; break;} break;
			pNum = num1;pMsg = TXT_STAT_111; break;
		//end 2.3.3

		case MSG_SMS_2_1:
			//if(num2[0]) {send_sms_1(num2,TXT_PWRFAIL); ss=s; s=42; break;} break;
			if(!CAN_SEND_SMS2) break;
			pNum = num2;pMsg = TXT_PWRFAIL; break;
		case MSG_SMS_2_2:
			//if(num2[0]) {send_sms_1(num2,TXT_FIRE); ss=s; s=42; break;} break;
			if(!CAN_SEND_SMS2) break;
			pNum = num2;pMsg = TXT_FIRE; break;
		case MSG_SMS_2_3:
			//if(num2[0]) {send_sms_1(num2,TXT_DOOROPEN); ss=s; s=42; break;} break;
			if(!CAN_SEND_SMS2) break;
			pNum = num2;pMsg = TXT_DOOROPEN; break;
		case MSG_SMS_2_4:
			//if(num2[0]) {send_sms_1(num2,TXT_ALMBUTTON); ss=s; s=42; break;} break;
			if(!CAN_SEND_SMS2) break;
			pNum = num2;pMsg = TXT_ALMBUTTON; break;
		case MSG_SMS_2_5:
			//if(num2[0]) {send_sms_1(num2,TXT_TEST); ss=s; s=42; break;} break;
			if(!CAN_SEND_SMS2) break;
			pNum = num2;pMsg = TXT_TEST; break;
		case MSG_SMS_2_6:
			//if(num2[0]) {send_sms_1(num2,TXT_ARMED); ss=s; s=42; break;} break;
			if(!CAN_SEND_SMS2) break;
			pNum = num2;pMsg = TXT_ARMED; break;
		case MSG_SMS_2_7:
			//if(num2[0]) {send_sms_1(num2,TXT_ERR_DOOR); ss=s; s=42; break;} break;
			if(!CAN_SEND_SMS2) break;
			pNum = num2;pMsg = TXT_ERR_DOOR; break;
		case MSG_SMS_2_8:
			//if(num2[0]) {send_sms_1(num2,TXT_ERR_FIRE); ss=s; s=42; break;} break;
			if(!CAN_SEND_SMS2) break;
			pNum = num2;pMsg = TXT_ERR_FIRE; break;
		case MSG_SMS_2_DISARMED:
			if(!CAN_SEND_SMS2) break;
			pNum = num2;pMsg = TXT_DISARMED; break;
		case MSG_SMS_2_MOVEMENT:
			if(!CAN_SEND_SMS2) break;
			pNum = num2;pMsg = TXT_MOVEMENT; break;
		case MSG_SMS_2_WINDOW:
			if(!CAN_SEND_SMS2) break;
			pNum = num2;pMsg = TXT_WINDOW; break;
		case MSG_SMS_2_AUX:
			if(!CAN_SEND_SMS2) break;
			pNum = num2;pMsg = TXT_AUX; break;
		case MSG_SMS_2_ERR_WINDOW:
			if(!CAN_SEND_SMS2) break;
			pNum = num2;pMsg = TXT_ERR_WINDOW; break;
		case MSG_SMS_2_ERR_MOVEMENT:
			if(!CAN_SEND_SMS2) break;
			pNum = num2;pMsg = TXT_ERR_MOVEMENT; break;
		case MSG_SMS_2_ERR_AUX:
			if(!CAN_SEND_SMS2) break;
			pNum = num2;pMsg = TXT_ERR_AUX; break;

		case MSG_SMS_3_1:
			//if(num3[0]) {send_sms_1(num3,TXT_PWRFAIL); ss=s; s=42; break;} break;
			if(!CAN_SEND_SMS3) break;
			pNum = num3;pMsg = TXT_PWRFAIL; break;
		case MSG_SMS_3_2:
			//if(num3[0]) {send_sms_1(num3,TXT_FIRE); ss=s; s=42; break;} break;
			if(!CAN_SEND_SMS3) break;
			pNum = num3;pMsg = TXT_FIRE; break;
		case MSG_SMS_3_3:
			//if(num3[0]) {send_sms_1(num3,TXT_DOOROPEN); ss=s; s=42; break;} break;
			if(!CAN_SEND_SMS3) break;
			pNum = num3;pMsg = TXT_DOOROPEN; break;
		case MSG_SMS_3_4:
			//if(num3[0]) {send_sms_1(num3,TXT_ALMBUTTON); ss=s; s=42; break;} break;
			if(!CAN_SEND_SMS3) break;
			pNum = num3;pMsg = TXT_ALMBUTTON; break;
		case MSG_SMS_3_5:
			//if(num3[0]) {send_sms_1(num3,TXT_TEST); ss=s; s=42; break;} break;
			if(!CAN_SEND_SMS3) break;
			pNum = num3;pMsg = TXT_TEST; break;
		case MSG_SMS_3_6:
			//if(num3[0]) {send_sms_1(num3,TXT_ARMED); ss=s; s=42; break;} break;
			if(!CAN_SEND_SMS3) break;
			pNum = num3;pMsg = TXT_ARMED; break;
		case MSG_SMS_3_7:
			//if(num3[0]) {send_sms_1(num3,TXT_ERR_DOOR); ss=s; s=42; break;} break;
			if(!CAN_SEND_SMS3) break;
			pNum = num3;pMsg = TXT_ERR_DOOR; break;
		case MSG_SMS_3_8:
			//if(num3[0]) {send_sms_1(num3,TXT_ERR_FIRE); ss=s; s=42; break;} break;
			if(!CAN_SEND_SMS3) break;
			pNum = num3;pMsg = TXT_ERR_FIRE; break;
		case MSG_SMS_3_DISARMED:
			if(!CAN_SEND_SMS3) break;
			pNum = num3;pMsg = TXT_DISARMED; break;
		case MSG_SMS_3_MOVEMENT:
			if(!CAN_SEND_SMS3) break;
			pNum = num3;pMsg = TXT_MOVEMENT; break;
		case MSG_SMS_3_WINDOW:
			if(!CAN_SEND_SMS3) break;
			pNum = num3;pMsg = TXT_WINDOW; break;
		case MSG_SMS_3_AUX:
			if(!CAN_SEND_SMS3) break;
			pNum = num3;pMsg = TXT_AUX; break;
		case MSG_SMS_3_ERR_WINDOW:
			if(!CAN_SEND_SMS3) break;
			pNum = num3;pMsg = TXT_ERR_WINDOW; break;
		case MSG_SMS_3_ERR_MOVEMENT:
			if(!CAN_SEND_SMS3) break;
			pNum = num3;pMsg = TXT_ERR_MOVEMENT; break;
		case MSG_SMS_3_ERR_AUX:
			if(!CAN_SEND_SMS3) break;
			pNum = num3;pMsg = TXT_ERR_AUX; break;


		case MSG_SMS_4_1:
			//if(num4[0]) {send_sms_1(num4,TXT_PWRFAIL); ss=s; s=42; break;} break;
			if(!CAN_SEND_SMS4) break;
			pNum = num4;pMsg = TXT_PWRFAIL; break;
		case MSG_SMS_4_2:
			//if(num4[0]) {send_sms_1(num4,TXT_FIRE); ss=s; s=42; break;} break;
			if(!CAN_SEND_SMS4) break;
			pNum = num4;pMsg = TXT_FIRE; break;
		case MSG_SMS_4_3:
			//if(num4[0]) {send_sms_1(num4,TXT_DOOROPEN); ss=s; s=42; break;} break;
			if(!CAN_SEND_SMS4) break;
			pNum = num4;pMsg = TXT_DOOROPEN; break;
		case MSG_SMS_4_4:
			//if(num4[0]) {send_sms_1(num4,TXT_ALMBUTTON); ss=s; s=42; break;} break;
			if(!CAN_SEND_SMS4) break;
			pNum = num4;pMsg = TXT_ALMBUTTON; break;
		case MSG_SMS_4_5:
			//if(num4[0]) {send_sms_1(num4,TXT_TEST); ss=s; s=42; break;} break;
			if(!CAN_SEND_SMS4) break;
			pNum = num4;pMsg = TXT_TEST; break;
		case MSG_SMS_4_6:
			//if(num4[0]) {send_sms_1(num4,TXT_ARMED); ss=s; s=42; break;} break;
			if(!CAN_SEND_SMS4) break;
			pNum = num4;pMsg = TXT_ARMED; break;
		case MSG_SMS_4_7:
			//if(num4[0]) {send_sms_1(num4,TXT_ERR_DOOR); ss=s; s=42; break;} break;
			if(!CAN_SEND_SMS4) break;
			pNum = num4;pMsg = TXT_ERR_DOOR; break;
		case MSG_SMS_4_8:
			//if(num4[0]) {send_sms_1(num4,TXT_ERR_FIRE); ss=s; s=42; break;} break;
			if(!CAN_SEND_SMS4) break;
			pNum = num4;pMsg = TXT_ERR_FIRE; break;
		case MSG_SMS_4_DISARMED:
			if(!CAN_SEND_SMS4) break;
			pNum = num4;pMsg = TXT_DISARMED; break;
		case MSG_SMS_4_MOVEMENT:
			if(!CAN_SEND_SMS4) break;
			pNum = num4;pMsg = TXT_MOVEMENT; break;
		case MSG_SMS_4_WINDOW:
			if(!CAN_SEND_SMS4) break;
			pNum = num4;pMsg = TXT_WINDOW; break;
		case MSG_SMS_4_AUX:
			if(!CAN_SEND_SMS4) break;
			pNum = num4;pMsg = TXT_AUX; break;
		case MSG_SMS_4_ERR_WINDOW:
			if(!CAN_SEND_SMS4) break;
			pNum = num4;pMsg = TXT_ERR_WINDOW; break;
		case MSG_SMS_4_ERR_MOVEMENT:
			if(!CAN_SEND_SMS4) break;
			pNum = num4;pMsg = TXT_ERR_MOVEMENT; break;
		case MSG_SMS_4_ERR_AUX:
			if(!CAN_SEND_SMS4) break;
			pNum = num4;pMsg = TXT_ERR_AUX; break;

		case MSG_SMS_5_1:
			//if(num5[0]) {send_sms_1(num5,TXT_PWRFAIL); ss=s; s=42; break;} break;
			if(!CAN_SEND_SMS5) break;
			pNum = num5;pMsg = TXT_PWRFAIL; break;
		case MSG_SMS_5_2:
			//if(num5[0]) {send_sms_1(num5,TXT_FIRE); ss=s; s=42; break;} break;
			if(!CAN_SEND_SMS5) break;
			pNum = num5;pMsg = TXT_FIRE; break;
		case MSG_SMS_5_3:
			//if(num5[0]) {send_sms_1(num5,TXT_DOOROPEN); ss=s; s=42; break;} break;
			if(!CAN_SEND_SMS5) break;
			pNum = num5;pMsg = TXT_DOOROPEN; break;
		case MSG_SMS_5_4:
			//if(num5[0]) {send_sms_1(num5,TXT_ALMBUTTON); ss=s; s=42; break;} break;
			if(!CAN_SEND_SMS5) break;
			pNum = num5;pMsg = TXT_ALMBUTTON; break;
		case MSG_SMS_5_5:
			//if(num5[0]) {send_sms_1(num5,TXT_TEST); ss=s; s=42; break;} break;
			if(!CAN_SEND_SMS5) break;
			pNum = num5;pMsg = TXT_TEST; break;
		case MSG_SMS_5_6:
			//if(num5[0]) {send_sms_1(num5,TXT_ARMED); ss=s; s=42; break;} break;
			if(!CAN_SEND_SMS5) break;
			pNum = num5;pMsg = TXT_ARMED; break;
		case MSG_SMS_5_7:
			//if(num5[0]) {send_sms_1(num5,TXT_ERR_DOOR); ss=s; s=42; break;} break;
			if(!CAN_SEND_SMS5) break;
			pNum = num5;pMsg = TXT_ERR_DOOR; break;
		case MSG_SMS_5_8:
			//if(num5[0]) {send_sms_1(num5,TXT_ERR_FIRE); ss=s; s=42; break;} break;
			if(!CAN_SEND_SMS5) break;
			pNum = num5;pMsg = TXT_ERR_FIRE; break;
		case MSG_SMS_5_DISARMED:
			if(!CAN_SEND_SMS5) break;
			pNum = num5;pMsg = TXT_DISARMED; break;
		case MSG_SMS_5_MOVEMENT:
			if(!CAN_SEND_SMS5) break;
			pNum = num5;pMsg = TXT_MOVEMENT; break;
		case MSG_SMS_5_WINDOW:
			if(!CAN_SEND_SMS5) break;
			pNum = num5;pMsg = TXT_WINDOW; break;
		case MSG_SMS_5_AUX:
			if(!CAN_SEND_SMS5) break;
			pNum = num5;pMsg = TXT_AUX; break;
		case MSG_SMS_5_ERR_WINDOW:
			if(!CAN_SEND_SMS5) break;
			pNum = num5;pMsg = TXT_ERR_WINDOW; break;
		case MSG_SMS_5_ERR_MOVEMENT:
			if(!CAN_SEND_SMS5) break;
			pNum = num5;pMsg = TXT_ERR_MOVEMENT; break;
		case MSG_SMS_5_ERR_AUX:
			if(!CAN_SEND_SMS5) break;
			pNum = num5;pMsg = TXT_ERR_AUX; break;

		case MSG_DIAL_1:
			if(!CAN_DIAL1) break;
			if(num1[0]) {dial(num1); ss=s; s=44; break;} break;
		case MSG_DIAL_2:
			if(!CAN_DIAL2) break;
			if(num2[0]) {dial(num2); ss=s; s=44; break;} break;
		case MSG_DIAL_3:
			if(!CAN_DIAL3) break;
			if(num3[0]) {dial(num3); ss=s; s=44; break;} break;
		case MSG_DIAL_4:
			if(!CAN_DIAL4) break;
			if(num4[0]) {dial(num4); ss=s; s=44; break;} break;
		case MSG_DIAL_5:
			if(!CAN_DIAL5) break;
			if(num5[0]) {dial(num5); ss=s; s=44; break;} break;
		}

		if(pNum) //  ,   
		{
			if(pNum[0]) //     (.. )
			{
				send_sms_1(pNum,pMsg); ss=s; s=42; 
			}
		} 
		}
		break;

	case 30:
		if ((--n)==0) { CHARGER_OFF(); n=6; at(AT); s=34; break; }
		else	      { at(AT); s++; break; }

	case 31:
		if(flags&OK) 	  	{ s-=2; timer=100; flags=0; break; }
		if(flags&TIMEOUT) 	{ s=0; break; }
		break;

	case 33:
		if ((--n)==0) { s=35; at(ATCBC); break; }
		else	      { at(AT); s++; break; }
		break;

	case 34:
		if(flags&OK) 	  	{ s-=2; timer=100; flags=0; break; }
		if(flags&TIMEOUT) 	{ s=0; break; }
		break;
	
	case 35:
		if(flags&OK) 	  		
		{
			if(battery>=80)	{CHARGER_OFF(); n=6; s=36; timer=100; flags=0; break;} //!!!
			else		{CHARGER_ON();  n=60; s=29; timer=100; flags=0; break;} //!!!
		}
		if(flags&TIMEOUT) 	{s=0; break;}
		break;

	case 37:
		if ((--n)==0) { s=39; at(ATCBC); break; }
		else	      { at(AT); s++; break; }
		break;

	case 38:
		if(flags&OK) 	  	{ s-=2; timer=100; flags=0; break; }
		if(flags&TIMEOUT) 	{ s=0; break; }
		break;

	case 39:

		if(flags&OK) 	  		
		{
			if(battery<50) 	{CHARGER_ON();  n=60; s=29; timer=100; flags=0; break;} //!!!
			else	 	{CHARGER_OFF(); n=6; s=36; timer=100; flags=0; break;} //!!!
		}
		if(flags&TIMEOUT) 	{s=0; break;}
		break;

// GETNUM -> string
	case 40:
		if(flags&OK)		
		{
			if(flags&NUMBER) {strcpy((unsigned char*)dest,rbuf); s=ss; timer=50; flags=0; break;}
			else             {*((unsigned char*)dest)=0; s=ss; timer=50; flags=0; break;}
		}
		if(flags&TIMEOUT)	{s=0; break;}
		break;

// GETNUM -> unsigned int
	case 41:
		if(flags&OK)		
		{
			if(flags&NUMBER) {*((unsigned int*)dest)=atoi(rbuf); s=ss; timer=50; flags=0; break;}
			else		 {s=ss; timer=50; flags=0; break;}
		}
		if(flags&TIMEOUT)	{s=0; break;}
		break;
// SENDSMS
	case 42:
		if(flags&PROMPT)	{send_sms_2(); s++; break;}
		if(flags&ERROR)		{s=ss; timer=50; flags=0; break;}
		if(flags&TIMEOUT)	{s=0; break;}
		break;
	case 43:
		if(flags&(OK|ERROR))	{s=ss; timer=50; flags=0; break;}
		if(flags&TIMEOUT)	{s=0; break;}
		break;

// SHORTCALL
	case 44:
		if(flags&(NUMBER|NOCONN|ERROR|TIMEOUT))	{at(ATH); s++; break;}
		break;
	case 45:
		if(flags&(OK|TIMEOUT))	{s=ss; timer=50; flags=0; break;}
		break;

// INCOMING CALL (ANSWER WITH DTMF)
	case 46:
		if(flags&OK)		{timer=10; s++; break;}
		if(flags&TIMEOUT)	{s=0; break;}
		break;

	case 47:
		if(flags&NOCONN)	{s++; at(ATH); s=54; break;}
		if(flags&TIMEOUT)	{if(tone) {at(ATVTS1);} else {at(ATVTS2);} timer=8; s++; break;}
		break;
	case 48:
		if(flags&NOCONN)	{s++; at(ATH); s=54; break;}
		if(flags&TIMEOUT)	{if(tone) {at(ATVTS3);} else {at(ATVTS2);} timer=8; s++; break;}
		break;
	case 49:
		if(flags&NOCONN)	{s++; at(ATH); s=54; break;}
		if(flags&TIMEOUT)	{if(tone) {at(ATVTS1);} else {at(ATVTS2);} timer=8; s++; break;}
		break;
	case 50:
		if(flags&NOCONN)	{s++; at(ATH); s=54; break;}
		if(flags&TIMEOUT)	{if(tone) {at(ATVTS3);} else {at(ATVTS2);} timer=8; s++; break;}
		break;
	case 51:
		if(flags&NOCONN)	{s++; at(ATH); s=54; break;}
		if(flags&TIMEOUT)	{if(tone) {at(ATVTS1);} else {at(ATVTS2);} timer=8; s++; break;}
		break;
	case 52:
		if(flags&NOCONN)	{s++; at(ATH); s=54; break;}
		if(flags&TIMEOUT)	{if(tone) {at(ATVTS3);} else {at(ATVTS2);} timer=6000; s++; break;}
		break;
	case 53:
		if(flags&(NOCONN|TIMEOUT))	{at(ATH); s++; break;}
		break;
	case 54:
		if(flags&(OK|TIMEOUT))		{s=ss; timer=50; flags=0; break;}
		break;
// INCOMING SMS
	case 55:
		if(flags&OK)	
		{
			if(flags&SMS)
			{
               	if (rbuf[0]!=0)
				{
					if (strcmp(passArm,rbuf)==0) { sms=SMS_ARM; }  // 2.3.3
					else if (strcmp(passDisarm,rbuf)==0) { sms=SMS_DISARM; } // 2.3.3
	                else if (strcmp(passOut2On,rbuf)==0) { sms=SMS_OUT2ON; } // 2.3.3
	                else if (strcmp(passOut2Off,rbuf)==0) { sms=SMS_OUT2OFF; } // 2.3.3
	                else if (strcmp(passOut3On,rbuf)==0) { sms=SMS_OUT3ON; } // 2.3.3
					else if (strcmp(passOut3Off,rbuf)==0) { sms=SMS_OUT3OFF; } // 2.3.3
					else if (strcmp(passState,rbuf)==0) { sms=SMS_SENDSTATE; } // 2.3.3

					at(ATMGD1); // delete SMS
					timer = 30; // DVK 073010    -        
					s++; break;
				}
			}
			else	{s=ss; timer=50; flags=0; break;}
		}
		if(flags&(ERROR|TIMEOUT))	{s=ss; timer=50; flags=0; break;}
		break;
	case 56:
		if(flags&(ERROR|OK|TIMEOUT))	{s=ss; timer=50; flags=0; break;}
		break;
	}
}
